/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class FileSelector
extends KeyAdapter
implements PropertyChangeListener {
    private JFileChooser chooser;
    private StringBuffer partialName = new StringBuffer();
    private Vector files;
    private boolean resetPartialName = true;
    static /* synthetic */ Class class$javax$swing$JList;

    public FileSelector(JFileChooser jFileChooser) {
        this.chooser = jFileChooser;
        Component component = this.findJList(jFileChooser);
        this.setListDataListener();
        jFileChooser.addPropertyChangeListener(this);
    }

    private void setListDataListener() {
        final BasicDirectoryModel basicDirectoryModel = ((BasicFileChooserUI)this.chooser.getUI()).getModel();
        basicDirectoryModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                Vector<File> vector = basicDirectoryModel.getFiles();
                if (vector.size() > 0) {
                    FileSelector.this.files = vector;
                }
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
    }

    private Component findJList(Component component) {
        if (component.getClass() == (class$javax$swing$JList == null ? (class$javax$swing$JList = FileSelector.class$("javax.swing.JList")) : class$javax$swing$JList)) {
            return component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component component2 = this.findJList(componentArray[n]);
                if (component2 != null) {
                    return component2;
                }
                ++n;
            }
        }
        return null;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && this.chooser.getSelectedFile().isFile()) {
            this.chooser.approveSelection();
        }
        this.partialName.append(keyEvent.getKeyChar());
        String string = this.partialName.toString().toUpperCase();
        int n = 0;
        while (n < this.files.size()) {
            File file = (File)this.files.get(n);
            String string2 = file.getName().toUpperCase();
            if (string2.startsWith(string)) {
                this.resetPartialName = false;
                this.chooser.setSelectedFile(file);
                return;
            }
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            if (this.resetPartialName) {
                this.partialName.setLength(0);
            }
            this.resetPartialName = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

