/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;

class JHelioDBFrame
extends JFrame
implements ActionListener {
    private String _version = "0.5 BETA";
    private JMenuItem goItem;
    private JMenuItem exitItem;
    private JMenuItem aboutItem;
    private JFrame globalFrame;
    private JComboBox IEFunctionSelector;
    private JComboBox tableNames;
    private JComboBox FormatSelector;
    private JTextField fileName;
    private JTextArea result;
    private String outputFileName = "";
    private String directoryPath = "";
    private String I_ESelected = "";
    private String tableSelected = "";
    private String FormatSelected = "";
    private int I_EMaxCount = 2;
    private String I_E_EXPORT = "Export";
    private String I_E_IMPORT = "Import";
    private int tableNamesMaxCount = 3;
    private String TABLE_FOR_TODO = "Todo";
    private String TABLE_FOR_MEMO = "Memo";
    private String TABLE_FOR_PHONEBOOK = "PhoneBook";
    private int FormatSelectorMaxCount = 8;
    private String CSV_FOR_RAW = "CSV Plain (raw)";
    private String CSV_FOR_LOTUS = "CSV for Lotus Organizer";
    private String CSV_FOR_OUTLOOK = "CSV for Outlook";
    private String CSV_FOR_PALM = "CSV for Palm";
    private String CSV_FOR_EUDORA = "Eudora Nicknames";
    private String CSV_FOR_LDIF = "LDIF for Netscape";
    private String CSV_FOR_OPERA = "Opera Contacts";
    private String CSV_FOR_XML = "XML";
    private ProgressMonitor progressDialog;
    private CreatePhoneBookCSV pt = null;
    private CreateMemoCSV mt = null;
    private CreateToDoCSV tt = null;

    public JHelioDBFrame() {
        this.setTitle("JHelioDB " + this._version);
        ((Component)this).setSize(600, 300);
        ((Component)this).setLocation(100, 100);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.goItem = new JMenuItem("Go");
        this.goItem.addActionListener(this);
        jMenu.add(this.goItem);
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.addActionListener(this);
        jMenu.add(this.exitItem);
        JMenu jMenu2 = new JMenu("Help");
        jMenuBar.add(jMenu2);
        this.aboutItem = new JMenuItem("About");
        this.aboutItem.addActionListener(this);
        jMenu2.add(this.aboutItem);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 2.0;
        JLabel jLabel = new JLabel("JHelioDB: Tool for the Helio Desktop PIM");
        jLabel.setForeground(Color.blue);
        jLabel.setFont(new Font("Serif", 0, 22));
        this.add(jLabel, gridBagConstraints, 0, 0, 5, 1);
        JLabel jLabel2 = new JLabel("Function");
        jLabel2.setForeground(Color.black);
        JLabel jLabel3 = new JLabel("Application");
        jLabel3.setForeground(Color.black);
        JLabel jLabel4 = new JLabel("Format Selector");
        jLabel4.setForeground(Color.black);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 0.0;
        this.add(jLabel2, gridBagConstraints, 0, 1, 2, 1);
        this.add(jLabel3, gridBagConstraints, 2, 1, 1, 1);
        this.add(jLabel4, gridBagConstraints, 3, 1, 2, 1);
        this.IEFunctionSelector = new JComboBox();
        this.IEFunctionSelector.setEditable(false);
        this.IEFunctionSelector.addItem(this.I_E_EXPORT);
        this.IEFunctionSelector.addItem(this.I_E_IMPORT);
        this.IEFunctionSelector.addActionListener(this);
        this.tableNames = new JComboBox();
        this.tableNames.setEditable(false);
        this.tableNames.addItem(this.TABLE_FOR_PHONEBOOK);
        this.tableNames.addItem(this.TABLE_FOR_TODO);
        this.tableNames.addItem(this.TABLE_FOR_MEMO);
        this.tableNames.addActionListener(this);
        this.FormatSelector = new JComboBox();
        this.FormatSelector.setEditable(false);
        this.FormatSelector.addItem(this.CSV_FOR_RAW);
        this.FormatSelector.addItem(this.CSV_FOR_LOTUS);
        this.FormatSelector.addItem(this.CSV_FOR_OUTLOOK);
        this.FormatSelector.addItem(this.CSV_FOR_PALM);
        this.FormatSelector.addItem(this.CSV_FOR_EUDORA);
        this.FormatSelector.addItem(this.CSV_FOR_LDIF);
        this.FormatSelector.addItem(this.CSV_FOR_OPERA);
        this.FormatSelector.addItem(this.CSV_FOR_XML);
        this.FormatSelector.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 0.0;
        this.add(this.IEFunctionSelector, gridBagConstraints, 0, 2, 2, 1);
        this.add(this.tableNames, gridBagConstraints, 2, 2, 1, 1);
        this.add(this.FormatSelector, gridBagConstraints, 3, 2, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel5 = new JLabel(" ");
        this.add(jLabel5, gridBagConstraints, 0, 3, 2, 1);
        this.fileName = new JTextField(20);
        this.directoryPath = "C:\\Capitalware\\JHelioDB";
        this.outputFileName = this.directoryPath + "\\helio_raw.csv";
        this.fileName.setText(this.outputFileName);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel6 = new JLabel("Output filename:");
        jLabel6.setForeground(Color.black);
        this.add(jLabel6, gridBagConstraints, 0, 4, 2, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 0.0;
        this.add(this.fileName, gridBagConstraints, 0, 5, 4, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(this);
        this.add(jButton, gridBagConstraints, 4, 5, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 0;
        JButton jButton2 = new JButton("Go");
        jButton2.setBackground(Color.gray);
        jButton2.addActionListener(this);
        this.add(jButton2, gridBagConstraints, 4, 6, 1, 1);
        final JFileChooser jFileChooser = new JFileChooser();
        new FileSelector(jFileChooser);
        jFileChooser.setCurrentDirectory(new File(this.directoryPath));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    JHelioDBFrame.this.outputFileName = jFileChooser.getSelectedFile().getAbsolutePath();
                    JHelioDBFrame.this.fileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }

    private void add(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.outputFileName = this.fileName.getText();
        this.I_ESelected = (String)this.IEFunctionSelector.getSelectedItem();
        this.tableSelected = (String)this.tableNames.getSelectedItem();
        this.FormatSelected = (String)this.FormatSelector.getSelectedItem();
        if (!string.equals("Browse")) {
            if (string.equals("Go")) {
                if (this.I_ESelected.equals(this.I_E_EXPORT)) {
                    if (this.tableSelected.equals(this.TABLE_FOR_PHONEBOOK)) {
                        this.pt = new CreatePhoneBookCSV();
                        this.pt.start();
                    } else if (this.tableSelected.equals(this.TABLE_FOR_MEMO)) {
                        this.mt = new CreateMemoCSV();
                        this.mt.start();
                    } else if (this.tableSelected.equals(this.TABLE_FOR_TODO)) {
                        this.tt = new CreateToDoCSV();
                        this.tt.start();
                    } else {
                        System.out.println("*** Wierd - matched something other??");
                    }
                } else if (this.I_ESelected.equals(this.I_E_IMPORT)) {
                    JOptionPane.showMessageDialog(null, "The import function is not working - scheduled for a future release.", "Not working yet!", 1);
                } else {
                    System.out.println("Can't Go. Error with Export/Import dropdown.");
                }
            } else if (string.equals("comboBoxChanged")) {
                if (this.I_ESelected.equals(this.I_E_EXPORT)) {
                    if (this.FormatSelected.equals(this.CSV_FOR_EUDORA) || this.FormatSelected.equals(this.CSV_FOR_LDIF) || this.FormatSelected.equals(this.CSV_FOR_OPERA) || this.FormatSelected.equals(this.CSV_FOR_XML)) {
                        if (0 != this.tableNames.getSelectedIndex()) {
                            this.tableNames.setSelectedIndex(0);
                        }
                        this.tableNames.removeItem(this.TABLE_FOR_TODO);
                        this.tableNames.removeItem(this.TABLE_FOR_MEMO);
                    } else if (this.tableNamesMaxCount != this.tableNames.getItemCount()) {
                        if (0 != this.tableNames.getSelectedIndex()) {
                            this.tableNames.setSelectedIndex(0);
                        }
                        this.tableNames.addItem(this.TABLE_FOR_TODO);
                        this.tableNames.addItem(this.TABLE_FOR_MEMO);
                    }
                } else if (this.I_ESelected.equals(this.I_E_IMPORT)) {
                    JOptionPane.showMessageDialog(null, "The import function is not working - scheduled for a future release.", "Not working yet!", 1);
                } else {
                    System.out.println("Error with Export/Import dropdown.");
                }
                if (this.FormatSelected.equals(this.CSV_FOR_LOTUS)) {
                    this.outputFileName = this.directoryPath + "\\helio_lotus.csv";
                } else if (this.FormatSelected.equals(this.CSV_FOR_OUTLOOK)) {
                    this.outputFileName = this.directoryPath + "\\helio_outlook.csv";
                } else if (this.FormatSelected.equals(this.CSV_FOR_PALM)) {
                    this.outputFileName = this.directoryPath + "\\helio_palm.csv";
                } else if (this.FormatSelected.equals(this.CSV_FOR_RAW)) {
                    this.outputFileName = this.directoryPath + "\\helio_raw.csv";
                } else if (this.FormatSelected.equals(this.CSV_FOR_EUDORA)) {
                    this.outputFileName = this.directoryPath + "\\*.txt";
                } else if (this.FormatSelected.equals(this.CSV_FOR_LDIF)) {
                    this.outputFileName = this.directoryPath + "\\helio_ldif.ldif";
                } else if (this.FormatSelected.equals(this.CSV_FOR_OPERA)) {
                    this.outputFileName = this.directoryPath + "\\helio_opera_Contacts.adr";
                } else if (this.FormatSelected.equals(this.CSV_FOR_XML)) {
                    this.outputFileName = this.directoryPath + "\\helio_Contacts.xml";
                }
                this.fileName.setText(this.outputFileName);
            } else if (string.equals("About")) {
                AboutBox aboutBox = new AboutBox(this, "JHelioDB", this._version, "Tool for the Helio Desktop PIM.", "Import and Export data to and from the PIM.", "Freeware", "2002/04/02", "1996-2002", "JHelioDB");
            } else if (string.equals("Exit")) {
                System.exit(0);
            } else {
                System.out.println(string + " - NOT defined!!!");
            }
        }
    }

    public void dispose() {
    }

    class CreateToDoCSV
    extends Thread {
        HelioDB heliodb;
        FileWriter fwriter;
        BufferedWriter bwriter;
        int TotalRows = 0;

        CreateToDoCSV() {
        }

        public void run() {
            try {
                boolean bl = false;
                bl = JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_RAW);
                this.heliodb = new HelioDB();
                this.TotalRows = this.heliodb.CountRows(JHelioDBFrame.this.tableSelected, bl);
                JHelioDBFrame.this.progressDialog = new ProgressMonitor(JHelioDBFrame.this, "processing DB records", "processing 0 of " + this.TotalRows, 0, this.TotalRows);
                JHelioDBFrame.this.progressDialog.setNote("processing 1 of " + this.TotalRows);
                this.heliodb.OpenTable(JHelioDBFrame.this.tableSelected, bl, "Filename");
                this.fwriter = new FileWriter(JHelioDBFrame.this.outputFileName, false);
                this.bwriter = new BufferedWriter(this.fwriter);
                if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_LOTUS)) {
                    this.BuildLotusCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_OUTLOOK)) {
                    this.BuildOutlookCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_PALM)) {
                    this.BuildPalmCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_RAW)) {
                    this.BuildRawCSV();
                } else {
                    System.out.println("*** Error: Invalid selection!");
                }
                this.bwriter.close();
                this.heliodb.CloseTable();
                JHelioDBFrame.this.progressDialog.close();
                JOptionPane.showMessageDialog(null, "ToDo DB records written to the file.", "Done.", 1);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildLotusCSV() {
            try {
                int n = 0;
                String string = null;
                string = "\"CONFIDENTIAL\",\"CATAGORIES\",\"CONTENT\"";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessToDoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    string = string + ",\"" + this.heliodb.GetContent() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildOutlookCSV() {
            try {
                int n = 0;
                String string = null;
                string = "\"Content\",\"Secret\",\"Categories\"";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessToDoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetContent() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildPalmCSV() {
            try {
                int n = 0;
                String string = null;
                while (this.heliodb.ProcessToDoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetContent() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildRawCSV() {
            try {
                int n = 0;
                String string = null;
                string = this.heliodb.BuildColumnLine(JHelioDBFrame.this.tableSelected);
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessToDoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetRecordID() + "\"";
                    string = string + ",\"" + this.heliodb.GetModifyDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetLock() + "\"";
                    string = string + ",\"" + this.heliodb.GetCompleted() + "\"";
                    string = string + ",\"" + this.heliodb.GetAlarmStatus() + "\"";
                    string = string + ",\"" + this.heliodb.GetPriority() + "\"";
                    string = string + ",\"" + this.heliodb.GetContent() + "\"";
                    string = string + ",\"" + this.heliodb.GetToDoDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetAlarmDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetVoiceID() + "\"";
                    string = string + ",\"" + this.heliodb.GetstrToDoDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetAlarmDate() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }
    }

    class CreateMemoCSV
    extends Thread {
        HelioDB heliodb;
        FileWriter fwriter;
        BufferedWriter bwriter;
        int TotalRows = 0;

        CreateMemoCSV() {
        }

        public void run() {
            try {
                boolean bl = false;
                bl = JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_RAW);
                this.heliodb = new HelioDB();
                this.TotalRows = this.heliodb.CountRows(JHelioDBFrame.this.tableSelected, bl);
                JHelioDBFrame.this.progressDialog = new ProgressMonitor(JHelioDBFrame.this, "processing DB records", "processing 0 of " + this.TotalRows, 0, this.TotalRows);
                JHelioDBFrame.this.progressDialog.setNote("processing 1 of " + this.TotalRows);
                this.heliodb.OpenTable(JHelioDBFrame.this.tableSelected, bl, "Filename");
                this.fwriter = new FileWriter(JHelioDBFrame.this.outputFileName, false);
                this.bwriter = new BufferedWriter(this.fwriter);
                if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_LOTUS)) {
                    this.BuildLotusCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_OUTLOOK)) {
                    this.BuildOutlookCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_PALM)) {
                    this.BuildPalmCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_RAW)) {
                    this.BuildRawCSV();
                } else {
                    System.out.println("*** Error: Invalid selection!");
                }
                this.bwriter.close();
                this.heliodb.CloseTable();
                JHelioDBFrame.this.progressDialog.close();
                JOptionPane.showMessageDialog(null, "Memo DB records written to the file.", "Done.", 1);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildLotusCSV() {
            try {
                int n = 0;
                String string = null;
                string = "\"CONFIDENTIAL\",\"CATAGORIES\",\"CONTENT\"";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessMemoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    string = string + ",\"" + this.heliodb.GetContent() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildOutlookCSV() {
            try {
                int n = 0;
                String string = null;
                string = "\"Content\",\"Secret\",\"Categories\"";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessMemoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetContent() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildPalmCSV() {
            try {
                int n = 0;
                String string = null;
                while (this.heliodb.ProcessMemoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetContent() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildRawCSV() {
            try {
                int n = 0;
                String string = null;
                string = this.heliodb.BuildColumnLine(JHelioDBFrame.this.tableSelected);
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessMemoTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetRecordID() + "\"";
                    string = string + ",\"" + this.heliodb.GetModifyDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetLock() + "\"";
                    string = string + ",\"" + this.heliodb.GetContent() + "\"";
                    string = string + ",\"" + this.heliodb.GetMemoDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetFilename() + "\"";
                    string = string + ",\"" + this.heliodb.GetstrMemoDate() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }
    }

    class CreatePhoneBookCSV
    extends Thread {
        HelioDB heliodb;
        FileWriter fwriter;
        BufferedWriter bwriter;
        int TotalRows = 0;

        CreatePhoneBookCSV() {
        }

        public void run() {
            try {
                boolean bl = false;
                bl = JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_RAW);
                this.heliodb = new HelioDB();
                this.TotalRows = this.heliodb.CountRows(JHelioDBFrame.this.tableSelected, bl);
                JHelioDBFrame.this.progressDialog = new ProgressMonitor(JHelioDBFrame.this, "processing DB records", "processing 0 of " + this.TotalRows, 0, this.TotalRows);
                JHelioDBFrame.this.progressDialog.setNote("processing 1 of " + this.TotalRows);
                if (!JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_EUDORA) && !JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_OPERA)) {
                    this.heliodb.OpenTable(JHelioDBFrame.this.tableSelected, bl, "Name1st");
                    this.fwriter = new FileWriter(JHelioDBFrame.this.outputFileName, false);
                    this.bwriter = new BufferedWriter(this.fwriter);
                }
                if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_LOTUS)) {
                    this.BuildLotusCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_OUTLOOK)) {
                    this.BuildOutlookCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_PALM)) {
                    this.BuildPalmCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_RAW)) {
                    this.BuildRawCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_EUDORA)) {
                    this.BuildEudoraCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_LDIF)) {
                    this.BuildLDIFCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_OPERA)) {
                    this.BuildOperaCSV();
                } else if (JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_XML)) {
                    this.BuildXML();
                } else {
                    System.out.println("*** Error: Format Selector is invalid!");
                }
                if (!JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_EUDORA) && !JHelioDBFrame.this.FormatSelected.equals(JHelioDBFrame.this.CSV_FOR_OPERA)) {
                    this.bwriter.close();
                    this.heliodb.CloseTable();
                }
                JHelioDBFrame.this.progressDialog.close();
                JOptionPane.showMessageDialog(null, "Phonebook DB records written to the file.", "Done.", 1);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildEudoraCSV() {
            try {
                int n = 0;
                int n2 = 0;
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                this.heliodb.BuildCategories(JHelioDBFrame.this.tableSelected, "Name1st");
                this.heliodb.EnumCategoryNumber();
                while (this.heliodb.hasMoreCategoryNumbers()) {
                    string4 = (String)this.heliodb.nextCategoryNumber();
                    n2 = this.heliodb.CountRowsOfACategory(JHelioDBFrame.this.tableSelected, string4);
                    if (n2 <= 1) continue;
                    string5 = this.heliodb.GetCategory(string4);
                    string5 = string5.trim();
                    string5 = string5.replace(' ', '_');
                    string6 = JHelioDBFrame.this.directoryPath + "\\" + string5 + ".txt";
                    FileWriter fileWriter = new FileWriter(string6, false);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    this.heliodb.OpenTable(JHelioDBFrame.this.tableSelected, false, "Name1st", string4);
                    while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                        if (!this.heliodb.GetName1st().equals("") && !this.heliodb.GetName2nd().equals("")) {
                            string2 = "alias \"" + this.heliodb.GetName1st() + this.heliodb.GetName2nd() + "\" " + this.heliodb.GetComMail();
                            string3 = "note \"" + this.heliodb.GetName1st() + this.heliodb.GetName2nd() + "\" ";
                            string3 = string3 + "<name:" + this.heliodb.GetName1st() + this.heliodb.GetName2nd() + ">";
                        } else if (this.heliodb.GetName1st().equals("") && !this.heliodb.GetName2nd().equals("")) {
                            string2 = "alias \"" + this.heliodb.GetName2nd() + "\" " + this.heliodb.GetComMail();
                            string3 = "note \"" + this.heliodb.GetName2nd() + "\" ";
                            string3 = string3 + "<name:" + this.heliodb.GetName2nd() + ">";
                        } else if (!this.heliodb.GetName1st().equals("") && this.heliodb.GetName2nd().equals("")) {
                            string2 = "alias \"" + this.heliodb.GetName1st() + "\" " + this.heliodb.GetComMail();
                            string3 = "note \"" + this.heliodb.GetName1st() + "\" ";
                            string3 = string3 + "<name:" + this.heliodb.GetName1st() + ">";
                        } else {
                            string2 = "alias \"" + this.heliodb.GetCompany() + "\" " + this.heliodb.GetComMail();
                            string3 = "note \"" + this.heliodb.GetCompany() + "\" ";
                            string3 = string3 + "<name:" + this.heliodb.GetCompany() + ">";
                        }
                        bufferedWriter.write(string2, 0, string2.length());
                        bufferedWriter.newLine();
                        if (!this.heliodb.GetName1st().equals("")) {
                            string3 = string3 + "<first:" + this.heliodb.GetName1st() + ">";
                        }
                        if (!this.heliodb.GetName2nd().equals("")) {
                            string3 = string3 + "<last:" + this.heliodb.GetName2nd() + ">";
                        }
                        if (!this.heliodb.GetAddress().equals("")) {
                            string3 = string3 + "<address:" + this.heliodb.GetAddress() + ">";
                        }
                        if (!this.heliodb.GetCity().equals("")) {
                            string3 = string3 + "<city:" + this.heliodb.GetCity() + ">";
                        }
                        if (!this.heliodb.GetState().equals("")) {
                            string3 = string3 + "<state:" + this.heliodb.GetState() + ">";
                        }
                        if (!this.heliodb.GetCountry().equals("")) {
                            string3 = string3 + "<country:" + this.heliodb.GetCountry() + ">";
                        }
                        if (!this.heliodb.GetZip().equals("")) {
                            string3 = string3 + "<zip:" + this.heliodb.GetZip() + ">";
                        }
                        if (!this.heliodb.GetTel().equals("")) {
                            string3 = string3 + "<phone:" + this.heliodb.GetTel() + ">";
                        }
                        if (!this.heliodb.GetFax().equals("")) {
                            string3 = string3 + "<fax:" + this.heliodb.GetFax() + ">";
                        }
                        if (!this.heliodb.GetMobile().equals("")) {
                            string3 = string3 + "<mobile:" + this.heliodb.GetMobile() + ">";
                        }
                        if (!this.heliodb.GetComNetAdd().equals("")) {
                            string3 = string3 + "<web:" + this.heliodb.GetComNetAdd() + ">";
                        }
                        if (!this.heliodb.GetTitle().equals("")) {
                            string3 = string3 + "<title:" + this.heliodb.GetTitle() + ">";
                        }
                        if (!this.heliodb.GetCompany().equals("")) {
                            string3 = string3 + "<company:" + this.heliodb.GetCompany() + ">";
                        }
                        if (!this.heliodb.GetComAdd().equals("")) {
                            string3 = string3 + "<address2:" + this.heliodb.GetComAdd() + ">";
                        }
                        if (!this.heliodb.GetComCity().equals("")) {
                            string3 = string3 + "<city2:" + this.heliodb.GetComCity() + ">";
                        }
                        if (!this.heliodb.GetComState().equals("")) {
                            string3 = string3 + "<state2:" + this.heliodb.GetComState() + ">";
                        }
                        if (!this.heliodb.GetComCountry().equals("")) {
                            string3 = string3 + "<country2:" + this.heliodb.GetComCountry() + ">";
                        }
                        if (!this.heliodb.GetComZip().equals("")) {
                            string3 = string3 + "<zip2:" + this.heliodb.GetComZip() + ">";
                        }
                        if (!this.heliodb.GetComTel().equals("")) {
                            string3 = string3 + "<phone2:" + this.heliodb.GetComTel() + ">";
                        }
                        if (!this.heliodb.GetComFax().equals("")) {
                            string3 = string3 + "<fax2:" + this.heliodb.GetComFax() + ">";
                        }
                        if (!this.heliodb.GetNotes().equals("")) {
                            string = this.heliodb.GetNotes();
                            string = string.replace('\r', '\u0003');
                            string3 = string3 + string;
                        }
                        bufferedWriter.write(string3, 0, string3.length());
                        bufferedWriter.newLine();
                        bufferedWriter.flush();
                        JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                        JHelioDBFrame.this.progressDialog.setProgress(n);
                    }
                    this.heliodb.CloseTable();
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildOperaCSV() {
            try {
                int n = 0;
                int n2 = 0;
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                Object var8_9 = null;
                this.fwriter = new FileWriter(JHelioDBFrame.this.outputFileName, false);
                this.bwriter = new BufferedWriter(this.fwriter);
                string = "Opera Hotlist version 2.0";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                string = "Options:encoding=utf8,version=3";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.newLine();
                this.bwriter.flush();
                this.heliodb.BuildCategories(JHelioDBFrame.this.tableSelected, "Name1st");
                this.heliodb.EnumCategoryNumber();
                while (this.heliodb.hasMoreCategoryNumbers()) {
                    string3 = (String)this.heliodb.nextCategoryNumber();
                    n2 = this.heliodb.CountRowsOfACategory(JHelioDBFrame.this.tableSelected, string3);
                    if (n2 <= 1) continue;
                    string4 = this.heliodb.GetCategory(string3);
                    string5 = string4 = string4.trim();
                    string4 = string4.replace(' ', '_');
                    string = "#FOLDER";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "\tNAME=" + string4;
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "\tCREATED=1009340899";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "\tVISITED=0";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "\tORDER=-1";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "\tDESCRIPTION=" + string5;
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "\tSHORT NAME=";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.newLine();
                    this.heliodb.OpenTable(JHelioDBFrame.this.tableSelected, false, "Name1st", string3);
                    while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                        string = "#CONTACT";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tMAIL=" + this.heliodb.GetComMail();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tNAME=" + this.heliodb.GetName1st() + " " + this.heliodb.GetName2nd();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tURL=" + this.heliodb.GetComNetAdd();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tCREATED=1009340899";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tVISITED=0";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tORDER=-1";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tPHONE=" + this.heliodb.GetComTel();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tFAX=" + this.heliodb.GetComFax();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMADDRESS=";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMPROTOCOL=";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMSTATUS=0";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMVISIBILITY=1";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMXPOSITION=-2147483648";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMYPOSITION=-2147483648";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMWIDTH=-2147483648";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMHEIGHT=-2147483648";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tIMMAXIMIZED=0";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tICON=0";
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tPOSTALADDRESS=";
                        if (!this.heliodb.GetComAdd().equals("")) {
                            string = string + this.heliodb.GetComAdd() + "\u0002\u0002";
                        }
                        if (!this.heliodb.GetComCity().equals("")) {
                            string = string + this.heliodb.GetComCity() + "\u0002\u0002";
                        }
                        if (!this.heliodb.GetComState().equals("")) {
                            string = string + this.heliodb.GetComState() + "\u0002\u0002";
                        }
                        if (!this.heliodb.GetComCountry().equals("")) {
                            string = string + this.heliodb.GetComCountry() + "\u0002\u0002";
                        }
                        if (!this.heliodb.GetComZip().equals("")) {
                            string = string + this.heliodb.GetComZip();
                        }
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        if (!this.heliodb.GetNotes().equals("")) {
                            string2 = this.heliodb.GetNotes();
                            string2 = string2.replace('\r', ' ');
                            string = "\tDESCRIPTION=" + string2;
                        } else {
                            string = "\tDESCRIPTION=";
                        }
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        string = "\tSHORT NAME=" + this.heliodb.GetName1st() + this.heliodb.GetName2nd();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                        this.bwriter.newLine();
                        this.bwriter.flush();
                        JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                        JHelioDBFrame.this.progressDialog.setProgress(n);
                    }
                    this.heliodb.CloseTable();
                    string = "-";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                }
                this.bwriter.close();
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildXML() {
            DecimalFormat decimalFormat = new DecimalFormat("###,#00");
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                String string = null;
                String string2 = null;
                String string3 = null;
                Object var12_13 = null;
                string3 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
                this.bwriter.write(string3, 0, string3.length());
                this.bwriter.newLine();
                string3 = "<ContactCardXML>";
                this.bwriter.write(string3, 0, string3.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                    string3 = "<ContactCard Category=\"" + this.CleanXML(this.heliodb.GetCategory()) + "\">";
                    string3 = string3 + "<Name>";
                    if (!this.heliodb.GetName2nd().equals("")) {
                        string3 = string3 + "<Last>" + this.CleanXML(this.heliodb.GetName2nd()) + "</Last>";
                    }
                    if (!this.heliodb.GetName1st().equals("")) {
                        string3 = string3 + "<First>" + this.CleanXML(this.heliodb.GetName1st()) + "</First>";
                    }
                    string3 = string3 + "</Name>";
                    string2 = "<Personal Status=\"Current\">";
                    string = "<Contact>";
                    if (!this.heliodb.GetTel().equals("")) {
                        string = string + "<Telephone>" + this.CleanXML(this.heliodb.GetTel()) + "</Telephone>";
                    }
                    if (!this.heliodb.GetFax().equals("")) {
                        string = string + "<Fax>" + this.CleanXML(this.heliodb.GetFax()) + "</Fax>";
                    }
                    if (!this.heliodb.GetMobile().equals("")) {
                        string = string + "<Mobile>" + this.CleanXML(this.heliodb.GetMobile()) + "</Mobile>";
                    }
                    if (!this.heliodb.GetPager().equals("")) {
                        string = string + "<Pager>" + this.CleanXML(this.heliodb.GetPager()) + "</Pager>";
                    }
                    if (!this.heliodb.GetMail().equals("")) {
                        string = string + "<Email>" + this.CleanXML(this.heliodb.GetMail()) + "</Email>";
                    }
                    string = string + "</Contact>";
                    if (!(this.heliodb.GetTel().equals("") && this.heliodb.GetFax().equals("") && this.heliodb.GetMobile().equals("") && this.heliodb.GetPager().equals("") && this.heliodb.GetMail().equals(""))) {
                        string2 = string2 + string;
                    } else {
                        bl = false;
                    }
                    string = "<Address>";
                    if (!this.heliodb.GetAddress().equals("")) {
                        string = string + "<AddrLine1>" + this.CleanXML(this.heliodb.GetAddress()) + "</AddrLine1>";
                    }
                    if (!this.heliodb.GetCity().equals("")) {
                        string = string + "<City>" + this.CleanXML(this.heliodb.GetCity()) + "</City>";
                    }
                    if (!this.heliodb.GetState().equals("")) {
                        string = string + "<StateProvn>" + this.CleanXML(this.heliodb.GetState()) + "</StateProvn>";
                    }
                    if (!this.heliodb.GetCountry().equals("")) {
                        string = string + "<Country>" + this.CleanXML(this.heliodb.GetCountry()) + "</Country>";
                    }
                    if (!this.heliodb.GetZip().equals("")) {
                        string = string + "<PostalCode>" + this.CleanXML(this.heliodb.GetZip()) + "</PostalCode>";
                    }
                    string = string + "</Address>";
                    if (!(this.heliodb.GetAddress().equals("") && this.heliodb.GetCity().equals("") && this.heliodb.GetState().equals("") && this.heliodb.GetCountry().equals("") && this.heliodb.GetZip().equals(""))) {
                        string2 = string2 + string;
                    } else {
                        bl2 = false;
                    }
                    if (!this.heliodb.GetNotes().equals("")) {
                        string2 = string2 + "<Notes>" + this.CleanXML(this.heliodb.GetNotes()) + "</Notes>";
                    } else {
                        bl3 = false;
                    }
                    string2 = string2 + "</Personal>";
                    if (bl || bl2 || bl3) {
                        string3 = string3 + string2;
                    }
                    string3 = string3 + "<Company Name=\"" + this.CleanXML(this.heliodb.GetCompany()) + "\" Status=\"Current\">";
                    if (!this.heliodb.GetTitle().equals("")) {
                        string3 = string3 + "<OccupationDetails><JobTitle>" + this.CleanXML(this.heliodb.GetTitle()) + "</JobTitle></OccupationDetails>";
                    }
                    string = "<Contact>";
                    if (!this.heliodb.GetComTel().equals("")) {
                        string = string + "<Telephone>" + this.CleanXML(this.heliodb.GetComTel()) + "</Telephone>";
                    }
                    if (!this.heliodb.GetComFax().equals("")) {
                        string = string + "<Fax>" + this.CleanXML(this.heliodb.GetComFax()) + "</Fax>";
                    }
                    if (!this.heliodb.GetComDirect().equals("")) {
                        string = string + "<MainLine>" + this.CleanXML(this.heliodb.GetComDirect()) + "</MainLine>";
                    }
                    if (!this.heliodb.GetComMail().equals("")) {
                        string = string + "<Email>" + this.CleanXML(this.heliodb.GetComMail()) + "</Email>";
                    }
                    string = string + "</Contact>";
                    if (!(this.heliodb.GetComTel().equals("") && this.heliodb.GetComFax().equals("") && this.heliodb.GetComDirect().equals("") && this.heliodb.GetComMail().equals(""))) {
                        string3 = string3 + string;
                    }
                    string = "<Address>";
                    if (!this.heliodb.GetComAdd().equals("")) {
                        string = string + "<AddrLine1>" + this.CleanXML(this.heliodb.GetComAdd()) + "</AddrLine1>";
                    }
                    if (!this.heliodb.GetComCity().equals("")) {
                        string = string + "<City>" + this.CleanXML(this.heliodb.GetComCity()) + "</City>";
                    }
                    if (!this.heliodb.GetComState().equals("")) {
                        string = string + "<StateProvn>" + this.CleanXML(this.heliodb.GetComState()) + "</StateProvn>";
                    }
                    if (!this.heliodb.GetComCountry().equals("")) {
                        string = string + "<Country>" + this.CleanXML(this.heliodb.GetComCountry()) + "</Country>";
                    }
                    if (!this.heliodb.GetComZip().equals("")) {
                        string = string + "<PostalCode>" + this.CleanXML(this.heliodb.GetComZip()) + "</PostalCode>";
                    }
                    if (!this.heliodb.GetComNetAdd().equals("")) {
                        string = string + "<URL>" + this.CleanXML(this.heliodb.GetComNetAdd()) + "</URL>";
                    }
                    string = string + "</Address>";
                    if (!(this.heliodb.GetComAdd().equals("") && this.heliodb.GetComCity().equals("") && this.heliodb.GetComState().equals("") && this.heliodb.GetComCountry().equals("") && this.heliodb.GetComZip().equals("") && this.heliodb.GetComNetAdd().equals(""))) {
                        string3 = string3 + string;
                    }
                    string3 = string3 + "</Company>";
                    string3 = string3 + "<DateTime Type=\"Modified\">";
                    string3 = string3 + "<Year>" + this.CleanXML(this.heliodb.GetModifyDate()).substring(0, 4) + "</Year>";
                    string3 = string3 + "<Month>" + this.CleanXML(this.heliodb.GetModifyDate()).substring(5, 7) + "</Month>";
                    string3 = string3 + "<Day>" + this.CleanXML(this.heliodb.GetModifyDate()).substring(8, 10) + "</Day>";
                    string3 = string3 + "<Hour>" + this.CleanXML(this.heliodb.GetModifyDate()).substring(11, 13) + "</Hour>";
                    string3 = string3 + "<Minute>" + this.CleanXML(this.heliodb.GetModifyDate()).substring(14, 16) + "</Minute>";
                    string3 = string3 + "<Second>" + this.CleanXML(this.heliodb.GetModifyDate()).substring(17, 19) + "</Second>";
                    TimeZone timeZone = TimeZone.getDefault();
                    n2 = timeZone.getRawOffset();
                    n3 = n2 / 1000 / 60 / 60;
                    n4 = 0;
                    if (n2 != n3 * 1000 * 60 * 60) {
                        n4 = Math.abs((n2 - n3 * 1000 * 60 * 60) / 1000 / 60);
                    }
                    string3 = string3 + "<TimeZone>GMT" + decimalFormat.format(n3) + ":" + decimalFormat.format(n4) + "</TimeZone>";
                    string3 = string3 + "</DateTime>";
                    string3 = string3 + "</ContactCard>";
                    this.bwriter.write(string3, 0, string3.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
                string3 = "</ContactCardXML>";
                this.bwriter.write(string3, 0, string3.length());
                this.bwriter.newLine();
                this.bwriter.flush();
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public String CleanXML(String string) {
            if (string.indexOf(60) < 0 && string.indexOf(62) < 0 && string.indexOf(38) < 0 && string.indexOf(39) < 0 && string.indexOf(34) < 0) {
                return string;
            }
            String string2 = "";
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '<': {
                        string2 = string2 + "&lt;";
                        break;
                    }
                    case '>': {
                        string2 = string2 + "&gt;";
                        break;
                    }
                    case '&': {
                        string2 = string2 + "&amp;";
                        break;
                    }
                    case '\'': {
                        string2 = string2 + "&apos;";
                        break;
                    }
                    case '\"': {
                        string2 = string2 + "&quot;";
                        break;
                    }
                    default: {
                        string2 = string2 + c;
                    }
                }
                ++n;
            }
            return string2;
        }

        public String myCleanXML(String string) {
            String string2 = "";
            String string3 = "";
            String[] stringArray = new String[]{"&", "<", ">", "'", "\""};
            String[] stringArray2 = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
            if (string == null) {
                return string3;
            }
            if (string.equals(null)) {
                return string3;
            }
            string2 = string;
            int n = 1;
            while (n < 5) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, stringArray[n], false);
                if (stringTokenizer.countTokens() > 0) {
                    string3 = string3 + stringTokenizer.nextToken() + stringArray2[n];
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken() + stringArray2[n];
                    }
                } else {
                    string3 = string;
                }
                string2 = string3;
                ++n;
            }
            return string3;
        }

        public void BuildLDIFCSV() {
            try {
                int n = 0;
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                    if (!this.heliodb.GetName1st().equals("") || !this.heliodb.GetName2nd().equals("")) {
                        string2 = "";
                        if (!this.heliodb.GetName1st().equals("")) {
                            string2 = this.heliodb.GetName1st() + " ";
                        }
                        if (!this.heliodb.GetName2nd().equals("")) {
                            string2 = string2 + this.heliodb.GetName2nd();
                        }
                        string = !this.heliodb.GetComMail().equals("") ? "dn: cn=" + string2 + ",mail=" + this.heliodb.GetComMail() : "dn: cn=" + string2;
                    } else {
                        string2 = this.heliodb.GetComMail();
                        string = "dn: cn=" + string2 + ",mail=" + this.heliodb.GetComMail();
                    }
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string3 = this.heliodb.GetModifyDate();
                    string4 = string3.substring(0, 4) + string3.substring(5, 7) + string3.substring(8, 10);
                    string5 = string3.substring(11, 13) + string3.substring(14, 16) + string3.substring(17, 19);
                    string = "modifytimestamp: " + string4 + string5 + "Z";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "cn: " + string2;
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    if (!this.heliodb.GetComMail().equals("")) {
                        string = "mail: " + this.heliodb.GetComMail();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    string = "xmozillausehtmlmail: FALSE";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    if (!this.heliodb.GetCompany().equals("")) {
                        string = "o: " + this.heliodb.GetCompany();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComCity().equals("")) {
                        string = "locality: " + this.heliodb.GetComCity();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetName1st().equals("")) {
                        string = "givenname: " + this.heliodb.GetName1st();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetName2nd().equals("")) {
                        string = "sn: " + this.heliodb.GetName2nd();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetTitle().equals("")) {
                        string = "title: " + this.heliodb.GetTitle();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComAdd().equals("")) {
                        string = "streetaddress: " + this.heliodb.GetComAdd();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComState().equals("")) {
                        string = "st: " + this.heliodb.GetComState();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComZip().equals("")) {
                        string = "postalcode:    " + this.heliodb.GetComZip();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComCountry().equals("")) {
                        string = "countryname:   " + this.heliodb.GetComCountry();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComTel().equals("")) {
                        string = "telephonenumber: " + this.heliodb.GetComTel();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetTel().equals("")) {
                        string = "homephone: " + this.heliodb.GetTel();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComFax().equals("")) {
                        string = "facsimiletelephonenumber: " + this.heliodb.GetComFax();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetPager().equals("")) {
                        string = "pagerphone: " + this.heliodb.GetPager();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetMobile().equals("")) {
                        string = "cellphone: " + this.heliodb.GetMobile();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComNetAdd().equals("")) {
                        string = "homeurl: " + this.heliodb.GetComNetAdd();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetComDirect().equals("")) {
                        string = "xmozillaanyphone: " + this.heliodb.GetComDirect();
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    if (!this.heliodb.GetNotes().equals("")) {
                        string3 = this.heliodb.GetNotes();
                        string3 = string3.replace('\r', ' ');
                        string = "description: " + string3;
                        this.bwriter.write(string, 0, string.length());
                        this.bwriter.newLine();
                    }
                    string = "objectclass: top";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    string = "objectclass: person";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildLotusCSV() {
            try {
                int n = 0;
                String string = null;
                string = "\"CONFIDENTIAL\",\"CATAGORIES\",\"FIRSTNAME\",\"LASTNAME\",\"TITLE\",\"JOBTITLE\",\"COMPANY\",\"STREET\",\"CITY\",\"STATE\",\"ZIP\",\"COUNTRY\",\"TEL1\",\"EXT\",\"FAX\",\"EMAIL\",\"TEL2\",\"ASSISTANT\",\"NOTES\",\"SPOUSE\",\"CHILDREN\",\"STREET1\",\"CITY1\",\"STATE1\",\"ZIP1\",\"COUNTRY1\",\"TEL11\",\"TEL21\",\"FAX1\",\"EMAIL1\",\"UNUSED1\",\"UNUSED2\",\"NOTES1\"";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                    string = "0";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    string = string + ",\"" + this.heliodb.GetName1st() + "\"";
                    string = string + ",\"" + this.heliodb.GetName2nd() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetTitle() + "\"";
                    string = string + ",\"" + this.heliodb.GetCompany() + "\"";
                    string = string + ",\"" + this.heliodb.GetComAdd() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetComState() + "\"";
                    string = string + ",\"" + this.heliodb.GetComZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCountry() + "\"";
                    string = string + ",\"" + this.heliodb.GetComTel() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetComFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetComMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetComDirect() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetNotes() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetAddress() + "\"";
                    string = string + ",\"" + this.heliodb.GetCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetState() + "\"";
                    string = string + ",\"" + this.heliodb.GetZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetCountry() + "\"";
                    string = string + ",\"" + this.heliodb.GetTel() + "\"";
                    string = string + ",\"" + this.heliodb.GetMobile() + "\"";
                    string = string + ",\"" + this.heliodb.GetFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetPager() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildOutlookCSV() {
            try {
                int n = 0;
                String string = null;
                string = "\"Title\",\"First Name\",\"Middle Name\",\"Last Name\",\"Suffix\",\"Company\",\"Department\",\"Job Title\",\"Business Street\",\"Business Street 2\",\"Business Street 3\",\"Business City\",\"Business State\",\"Business Postal Code\",\"Business Country\",\"Home Street\",\"Home Street 2\",\"Home Street 3\",\"Home City\",\"Home State\",\"Home Postal Code\",\"Home Country\",\"Other Street\",\"Other Street 2\",\"Other Street 3\",\"Other City\",\"Other State\",\"Other Postal Code\",\"Other Country\",\"Assistant's Phone\",\"Business Fax\",\"Business Phone\",\"Business Phone 2\",\"Callback\",\"Car Phone\",\"Company Main Phone\",\"Home Fax\",\"Home Phone\",\"Home Phone 2\",\"ISDN\",\"Mobile Phone\",\"Other Fax\",\"Other Phone\",\"Pager\",\"Primary Phone\",\"Radio Phone\",\"TTY/TDD Phone\",\"Telex\",\"Account\",\"Anniversary\",\"Assistant's Name\",\"Billing Information\",\"Birthday\",\"Categories\",\"Children\",\"Directory Server\",\"E-mail Address\",\"E-mail Display Name\",";
                string = string + "\"E-mail 2 Address\",\"E-mail 2 Display Name\",\"E-mail 3 Address\",\"E-mail 3 Display Name\",\"Gender\",\"Government ID Number\",\"Hobby\",\"Initials\",\"Internet Free Busy\",\"Keywords\",\"Language\",\"Location\",\"Manager's Name\",\"Mileage\",\"Notes\",\"Office Location\",\"Organizational ID Number\",\"PO Box\",\"Priority\",\"Private\",\"Profession\",\"Referred By\",\"Sensitivity\",\"Spouse\",\"User 1\",\"User 2\",\"User 3\",\"User 4\",\"Web Page\"";
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"\"";
                    string = string + ",\"" + this.heliodb.GetName1st() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetName2nd() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetCompany() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetTitle() + "\"";
                    string = string + ",\"" + this.heliodb.GetComAdd() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetComCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetComState() + "\"";
                    string = string + ",\"" + this.heliodb.GetComZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCountry() + "\"";
                    string = string + ",\"" + this.heliodb.GetAddress() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetState() + "\"";
                    string = string + ",\"" + this.heliodb.GetZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetCountry() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetComFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetComTel() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetComDirect() + "\"";
                    string = string + ",\"" + this.heliodb.GetFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetTel() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetMobile() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetPager() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetComMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetComMail() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetNotes() + "\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"\"";
                    string = string + ",\"" + this.heliodb.GetComNetAdd() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildPalmCSV() {
            try {
                int n = 0;
                String string = null;
                while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetName2nd() + "\"";
                    string = string + ",\"" + this.heliodb.GetName1st() + "\"";
                    string = string + ",\"" + this.heliodb.GetTitle() + "\"";
                    string = string + ",\"" + this.heliodb.GetCompany() + "\"";
                    string = string + ",\"" + this.heliodb.GetComTel() + "\"";
                    string = string + ",\"" + this.heliodb.GetTel() + "\"";
                    string = string + ",\"" + this.heliodb.GetComFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetMobile() + "\"";
                    string = string + ",\"" + this.heliodb.GetComMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetComAdd() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetComState() + "\"";
                    string = string + ",\"" + this.heliodb.GetComZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCountry() + "\"";
                    string = string + ",\"" + this.heliodb.GetAddress() + "\"";
                    string = string + ",\"" + this.heliodb.GetCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetState() + "\"";
                    string = string + ",\"" + this.heliodb.GetZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetNotes() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategory() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void BuildRawCSV() {
            try {
                int n = 0;
                String string = null;
                string = this.heliodb.BuildColumnLine(JHelioDBFrame.this.tableSelected);
                this.bwriter.write(string, 0, string.length());
                this.bwriter.newLine();
                this.bwriter.flush();
                while (this.heliodb.ProcessPhonebookTable(JHelioDBFrame.this.tableSelected)) {
                    string = "\"" + this.heliodb.GetRecordID() + "\"";
                    string = string + ",\"" + this.heliodb.GetModifyDate() + "\"";
                    string = string + ",\"" + this.heliodb.GetCategoryNumber() + "\"";
                    string = string + ",\"" + this.heliodb.GetSecret() + "\"";
                    string = string + ",\"" + this.heliodb.GetLock() + "\"";
                    string = string + ",\"" + this.heliodb.GetName1st() + "\"";
                    string = string + ",\"" + this.heliodb.GetName2nd() + "\"";
                    string = string + ",\"" + this.heliodb.GetNameWhole() + "\"";
                    string = string + ",\"" + this.heliodb.GetCompany() + "\"";
                    string = string + ",\"" + this.heliodb.GetTitle() + "\"";
                    string = string + ",\"" + this.heliodb.GetComTel() + "\"";
                    string = string + ",\"" + this.heliodb.GetComDirect() + "\"";
                    string = string + ",\"" + this.heliodb.GetComFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetComMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetComNetAdd() + "\"";
                    string = string + ",\"" + this.heliodb.GetComAdd() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetComState() + "\"";
                    string = string + ",\"" + this.heliodb.GetComZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetComCountry() + "\"";
                    string = string + ",\"" + this.heliodb.GetTel() + "\"";
                    string = string + ",\"" + this.heliodb.GetFax() + "\"";
                    string = string + ",\"" + this.heliodb.GetAddress() + "\"";
                    string = string + ",\"" + this.heliodb.GetCity() + "\"";
                    string = string + ",\"" + this.heliodb.GetState() + "\"";
                    string = string + ",\"" + this.heliodb.GetZip() + "\"";
                    string = string + ",\"" + this.heliodb.GetCountry() + "\"";
                    string = string + ",\"" + this.heliodb.GetMail() + "\"";
                    string = string + ",\"" + this.heliodb.GetPager() + "\"";
                    string = string + ",\"" + this.heliodb.GetMobile() + "\"";
                    string = string + ",\"" + this.heliodb.GetNotes() + "\"";
                    string = string + ",\"" + this.heliodb.GetMailCategory() + "\"";
                    string = string + ",\"" + this.heliodb.GetShowInList() + "\"";
                    string = string + ",\"" + this.heliodb.GetDisplay() + "\"";
                    string = string + ",\"" + this.heliodb.GetDefaultShow() + "\"";
                    string = string + ",\"" + this.heliodb.GetCompanyLastName() + "\"";
                    string = string + ",\"" + this.heliodb.GetFirstNameLastName() + "\"";
                    this.bwriter.write(string, 0, string.length());
                    this.bwriter.newLine();
                    this.bwriter.flush();
                    JHelioDBFrame.this.progressDialog.setNote("processing " + ++n + " of " + this.TotalRows);
                    JHelioDBFrame.this.progressDialog.setProgress(n);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }
    }
}

