// makehdb.cpp : integrates  makedoc and pdb2hdb
//   mit Setzen des ownerfields
//   V.997
//
// command line version, should compile under Linux


#include "stdafx.h"
#include <dirent.h>
//#include <windows.h>
//#include <commdlg.h>

#include <malloc.h>
#include <memory.h>
#include <string.h>
//#include <shellapi.h>
#include "hdb.h"
#include "pdb.h"

void endian_convert(BYTE *buffer, UWORD buf_len);

//-------------------
//makedoc includes



char  filename[255];
char  exportname[255];
char  recordname[32]="\0";
char  owner[32]="\0";

#ifdef sparc
#	ifndef UNIX
#	define UNIX 1
#	endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//template<class A> A max(const A& a, const A& b) {return (a<b) ? b : a;}
#define max(a,b) ((a>b) ? a : b)

typedef unsigned char byte;
typedef unsigned long DWORD;
typedef unsigned short WORD;
#define DISP_BITS 11
#define COUNT_BITS 3

// all numbers in these structs are big-endian, MAC format
struct tDocHeader {
	char sName[32];		// 32 bytes
	DWORD dwUnknown1;	// 36
	DWORD dwTime1;		// 40
	DWORD dwTime2;		// 44
	DWORD dwTime3;		// 48
	DWORD dwLastSync;	// 52
	DWORD ofsSort;		// 56
	DWORD ofsCatagories;	// 60
	DWORD dwCreator;	// 64
	DWORD dwType;		// 68
	DWORD dwUnknown2;	// 72
	DWORD dwUnknown3;	// 76
	WORD  wNumRecs;		// 78
};

// Some compilers pad structures out to DWORD boundaries so using sizeof()
// doesn't give the intended result.
#define DOCHEADSZ 78

struct tDocRecord0 {
	WORD wVersion;		// 1=plain text, 2=compressed
	WORD wSpare;
	DWORD dwStoryLen;	// in bytes, when decompressed
	WORD wNumRecs; 		// text records only; equals tDocHeader.wNumRecs-1
	WORD wRecSize;		// usually 0x1000
	DWORD dwSpare2;
};

////////////// utilities //////////////////////////////////////

WORD SwapWord21(WORD r)
{
	return (r>>8) + (r<<8);
}
WORD SwapWord12(WORD r)
{
	return r;  
}
DWORD SwapLong4321(DWORD r)
{
	return  ((r>>24) & 0xFF) + (r<<24) + ((r>>8) & 0xFF00) + ((r<<8) & 0xFF0000);
}
DWORD SwapLong1234(DWORD r)
{
	return r;
}

WORD (*SwapWord)(WORD r) = NULL;
DWORD (*SwapLong)(DWORD r) = NULL;

// copy bytes into a word and double word and see how they fall,
// then choose the appropriate swappers to make things come out
// in the right order.
int SwapChoose()
{
  union { char b[2]; WORD w; } w;
  union { char b[4]; DWORD d; } d;

  strncpy(w.b, "\1\2", 2);
  strncpy(d.b, "\1\2\3\4", 4);

  if (w.w == 0x0201)
    SwapWord = SwapWord21;
  else if (w.w == 0x0102)
    SwapWord = SwapWord12;
  else
    return 0;

  if (d.d == 0x04030201)
    SwapLong = SwapLong4321;
  else if (d.d == 0x01020304)
    SwapLong = SwapLong1234;
  else
    return 0;
  
  return 1;
}  

// replacement for strstr() which deals with 0's in the data
byte* memfind(byte* t, int t_len, byte* m, int m_len)
{
	int i;

	for (i = t_len - m_len + 1 ; i>0; i--, t++)
		if (t[0]==m[0] && memcmp(t,m,m_len)==0)
			return t;
	return 0;
}


//----------------------------

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////                                  //////////////////////
/////////////////////      tBuf class                  //////////////////////
/////////////////////                                  //////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


struct tBuf {
	byte* buf;
	unsigned len;

	tBuf() {buf = new byte[len = 6000];};
	~tBuf() {	if (buf) delete[] buf; }
	unsigned Len() const {	return len;	}

	unsigned RemoveBinary();
	unsigned Decompress();
	unsigned Compress();
	unsigned Issue(byte src, int& bSpace);
	unsigned DuplicateCR();
	void Clear() {delete[] buf; buf = new byte[len = 6000]; }
	void Dump() {printf("\nbuffer len=%d",len);}
};



//
// Issue()
//
// action: handle the details of writing a single
//		character to the compressed stream
//
unsigned
tBuf::Issue(byte src, int& bSpace)
{
	int iDest = len;
	byte* dest = buf;

	// if there is an outstanding space char, see if
	// we can squeeze it in with an ASCII char
	if (bSpace)
	{
		if (src>=0x40 && src<=0x7F)
			dest[iDest++] = src ^ 0x80;
		else
		{
			// couldn't squeeze it in, so issue the space char by itself
			// most chars go out simple, except the range 1...8,0x80...0xFF
			dest[iDest++] = ' ';
			if (src<0x80 && (src==0 || src>8) )
				dest[iDest++] = src;
			else
				dest[iDest++] = 1, dest[iDest++] = src;
		}
		// knock down the space flag
		bSpace = 0;
	}
	else
	{
		// check for a space char
		if (src==' ')
			bSpace = 1;
		else
		{
			if (src<0x80 && (src==0 || src>8))
				dest[iDest++] = src;
			else
				dest[iDest++] = 1, dest[iDest++] = src;

		}
	}
	len = iDest;
	return iDest;
}



//-----------------------------------

//
// Compress
//
// params: 	none
//
// action:	takes the given buffer,
//					and compresses
//					the original data down into a second buffer
//
// comment:	This version make heavy use of walking pointers.
//
unsigned tBuf::Compress()
{
	int i,j;
	int bSpace = 0;

	// run through the input buffer
	byte* pBuffer;		// points to the input buffer
	byte* pHit;		// points to a walking test hit; works upwards on successive matches
	byte* pPrevHit;		// previous value of pHit
	byte* pTestHead;	// current test string
	byte* pTestTail;	// current walking pointer; one past the current test buffer
	byte* pEnd;		// 1 past the end of the input buffer

	pHit = pPrevHit = pTestHead = pBuffer = buf;
	pTestTail = pTestHead+1;
	pEnd = buf + len;
//printf("pointers %x %x",pTestTail, pEnd);
//printf("\nstart compression buf len=%d",len);

	// make a dest buffer and reassign the local buffer
	buf = new byte[6000];
	len = 0;		// used to walk through the output buffer

	// loop, absorbing one more char from the input buffer on each pass
	for (; pTestHead != pEnd; pTestTail++)
	{
//printf("\npointers pTestHead %x pTestTail %x pTestHead[]=%x %x",pTestHead, pTestTail, pTestHead[0], pTestHead[1]);
		// establish where the scan can begin
		if (pTestHead - pPrevHit > ((1<<DISP_BITS)-1))
			pPrevHit = pTestHead - ((1<<DISP_BITS)-1);

		// scan in the previous data for a match
		pHit = memfind(pPrevHit, pTestTail - pPrevHit, pTestHead, pTestTail - pTestHead);

		if (pHit==0)
			printf("!! bug source %x%x%x, dest %x%x%x, %d bytes",	pPrevHit[0],
				pPrevHit[1],pPrevHit[2],pTestHead[0],
	pTestHead[1],	pTestHead[2],	pTestTail-pTestHead);

		// on a mismatch or end of buffer, issued codes
		if (pHit==0
			|| pHit==pTestHead
			|| pTestTail-pTestHead>(1<<COUNT_BITS)+2
			|| pTestTail==pEnd)
		{
			// issued the codes
			// first, check for short runs
			if (pTestTail-pTestHead < 4)
			{
//printf("\nissue a char %x",pTestHead[0]);
				Issue(pTestHead[0], bSpace);
				pTestHead++;
			}
			// for longer runs, issue a run-code
			else
			{
				// issue space char if required
				if (bSpace) buf[len++] = ' ', bSpace = 0;

				unsigned int dist = pTestHead - pPrevHit;
				unsigned int compound = (dist << COUNT_BITS) + pTestTail-pTestHead - 4;

if (dist>=(1<<DISP_BITS)) printf("\n!! error dist overflow");
if (pTestTail-pTestHead-4>7) printf("\n!! error dist overflow");

				buf[len++] = 0x80 + (compound>>8);
				buf[len++] = compound & 0xFF;
//printf("\nissuing code for sequence len %d <%c%c%c>",pTestTail-pTestHead-1,pTestHead[0],pTestHead[1],pTestHead[2]);
//printf("\n          <%x%x>",pOut[-2],pOut[-1]);
				// and start again
				pTestHead = pTestTail-1;
			}
			// start the search again
			pPrevHit = pBuffer;
		}
		// got a match
		else
		{
			pPrevHit = pHit;
		}
//printf("pointers %x %x %x",pTestHead, pTestTail, pPrevHit);
		// when we get to the end of the buffer, don't inc past the end
		// this forces the residue chars out one at a time
		if (pTestTail==pEnd) pTestTail--;
	}

	// clean up any dangling spaces
	if (bSpace) buf[len++] = ' ';


	// final scan to merge consecutive high chars together
	int k;
	for (i=k=0; i<len; i++,k++)
	{
		buf[k] = buf[i];
		// skip the run-length codes
		if (buf[k]>=0x80 && buf[k]<0xC0)
			buf[++k] = buf[++i];
		// if we hit a high char marker, look ahead for another
		else if (buf[k]==1)
		{
			buf[k+1] = buf[i+1];
			while (i+2<len && buf[i+2]==1 && buf[k]<8)
			{
				buf[k]++;
				buf[k+buf[k]] = buf[i+3];
				i+=2;
			}
			k += buf[k]; i++;
		}
	}

	// delete original buffer
	delete[] pBuffer;
	len = k;

	return k;
}

//--------------------------


// this nasty little beast removes really low ASCII and 0's
// and handles the CR problem
//
// if a cr appears before a lf, then remove the cr
// if a cr appears in isolation, change to a lf
unsigned tBuf::RemoveBinary()
{
	byte* in_buf = buf;
	byte* out_buf = new byte[len];

	int k,j;
	for (j=k=0; j<len; j++,k++)
	{
		// copy each byte
		out_buf[k] = in_buf[j];

		// throw away really low ASCII
		if ((out_buf[k]>=0 && out_buf[k]<9)) k--;

		// for CR
		if (out_buf[k]==0x0D)
		{
			// if next is LF, then drop it
			if (j<len-1 && in_buf[j+1]==0x0A)
				k--;
			else // turn it into a LF
				out_buf[k] = 0x0A;
		}
	}
	delete[] buf;
	buf = out_buf;
	len = k;
	return k;
}

void out_word(short w, FILE* fout)
{
	short m = SwapWord(w);
	fwrite(&m,2,1,fout);
}
void out_long(long d, FILE* fout)
{
	long d1 = SwapLong(d);
	fwrite(&d1,4,1,fout);
}
//------------------------------
// makedoc main
//MAIN


int *makedoc(char *import)

{
//	printf("MakeDoc ver 0.7a\n");
	
	
	int iArg = 1;
	int bDecomp = 0;
	int bBinary = 0;
	int bReport = 0;
	int bCompress = 1;


	int index =0;
	int index2=0;
	//char importname[255];
	//char exportname[255] ;
	//char recordname[255];
	
	
	
	if ( ! SwapChoose()) {
	  printf("\nfailed to select proper byte swapping algorithm");
#if UNIX
	  printf("\n");
#endif
	  exit(1);
	}

	

	else
	{
		FILE* fin;
		FILE* fout;
		tDocHeader head1;


//filenames
		fin = fopen(import,"rb");
		
		while ((import[index] != '.')  && (index<strlen(import))) 
		  {
		
		 // dafr will er 2 verschiedene Indices 
		 strncpy(recordname+index,&import[index2],1);
		 
		 index++; index2++;
		  }
	         recordname[index] = '\0'; 
		
		strncpy( filename, recordname,32);
		memcpy((void*) &filename[strlen(filename)],".pdb\0",0x05);
		
		
	//printf(" recordname: %s\n",recordname);	
	//printf(" filename: %s\n",filename);		
		fout = fopen(filename,"wb");
		
		if (fin==0 || fout==0)
		{
			printf("problem opening files");
			exit(2);
		}

		fseek(fin,0,SEEK_END);
		DWORD storySize = ftell(fin);
		fseek(fin,0,SEEK_SET);

		DWORD	x;
		WORD w;
		long	recSize = 4096;
		DWORD		z,numRecs;

		sprintf(head1.sName,"%.31s",recordname);
		head1.sName[31] = 0;
	//	printf("saving to %s as <%s>,%s%s compressed",filename,recordname, 
	//	  bBinary ? " binary mode," : "",
	//			bCompress ? "" : " not");

			/*LocalWrite just writes to the new file the number of bytes starting at the passed pointer*/

		head1.dwUnknown1 = 0;
		strncpy((char *)&head1.dwTime1, "\x06\xD1\x44\xAE", 4);
		strncpy((char *)&head1.dwTime2, "\x06\xD1\x44\xAE", 4);
		head1.dwTime3 = 0;
		head1.dwLastSync = 0;
		head1.ofsSort = 0;
		head1.ofsCatagories = 0;
		strncpy((char *)&head1.dwCreator, "TEXt", 4);	// database creator
	        strncpy((char *)&head1.dwType, "REAd", 4);	// database type
		head1.dwUnknown2 = 0;
		head1.dwUnknown3 = 0;



		z = (int) (storySize/(long) recSize);
		if (((long) z * recSize) < storySize)
			z ++;

		numRecs = z;
		z ++;

		head1.wNumRecs = SwapWord(z);		//  the number of records to follow
		fwrite(&head1,1,DOCHEADSZ,fout);
		unsigned long index;
		index = 0x406F8000;		// the pattern for attributes=dirty + unique_id=0x6f8000
		x = 0x50L + (long) z * 8;

		out_long(x,fout);		// start writing the record offsets
		out_long(index,fout);
		x += 0x0010L;

		index++;
		z--;

		while(z--) {
			out_long(x,fout);		//more record offsets
			out_long(index++,fout);		// the attributes + ID's
			x += 0x1000L;
		}
		// one more word.....
		out_word(0,fout);


		tDocRecord0 rec0;
		rec0.wVersion = SwapWord(bCompress ? 2 : 1);
		rec0.wSpare = 0;
		rec0.dwStoryLen = SwapLong(storySize);
		rec0.wNumRecs = SwapWord(SwapWord(head1.wNumRecs) - 1);
		rec0.wRecSize = SwapWord(recSize);
		rec0.dwSpare2 = 0;

		fwrite(&rec0,1,sizeof(rec0),fout);

		int n = recSize;
		// dump the whole story into the new file
		int recNum = 0;
		printf("\n");

		tBuf buf;

		while(recNum < numRecs)
			{
			long pos;
			pos = ftell(fout);
			fseek(fout, 0x56 + 8*recNum, SEEK_SET);
			if (recNum!=numRecs) out_long(pos,fout);
			fseek(fout, pos, SEEK_SET);

			int nOrg;

			buf.Clear();
			nOrg = n = fread(buf.buf,1,4096,fin);
			buf.len = n;
			if (n==0) break;

			if (!bBinary)
				buf.RemoveBinary();
			if (bCompress)
				buf.Compress();
			n = fwrite(buf.buf,1,buf.Len(),fout);

	//		printf("\rconverting record %d of %d\r\n",recNum+1,numRecs);
			if (bReport && n && bCompress)
				printf("\noriginal %d bytes, compressed to %d bytes, ratio: %f5.1\n",
					nOrg, n, 100. * n / nOrg);
			recNum++;
			}

		fclose(fin);
		fclose(fout);
	}
	return (0);
}



//-----------------------------


//---------------------
// hier fngt pdb2hdb an



int main(int argc, char *argv[])
{

        char shortname[255];       
	char txtname[255];
	FILE *in, *out;
	unsigned int i;

	HDBHeader hdb_header_buf;
	HDBRecordHeader *hdb_recheader_buf;
	BYTE** rec_data;

	PDBHeader pdb_header_buf;
	PDBRecordHeader pdb_recheader_buf;
	PDBRecordEntry *pdb_reclist_buf;
	PDBRecordEntry pdb_reclist_temp;

	UWORD offset,record_size,pdb_file_size,encoded_bytes,encoded_size,temp;
//-------------------	
    char *name="./";
    char ext[4];
    DIR           *dir;
    struct dirent *entry;
    int txtflag;
    char blop[32]="\0";

    
//bad command line

if ((argc>1) && (strcmp(argv[1],"all") != 0)  && (strstr(argv[1],"alltxt") == 0) && (strstr(argv[1],"allpdb") == 0) && (strstr(argv[1],".txt") == 0) && (strstr(argv[1],".TXT") == 0)&& (strstr(argv[1],".pdb") == 0)&& (strstr(argv[1],".PDB") == 0)  && (strstr(argv[1],"-h") ==0 ) || (argc==1)) 


		
       {       
		printf("\r\n Your command syntax is incorrect.\r\n");
		goto help;
       }		

if ((argc>1) && (strstr(argv[1],"-h") !=0 ))		

help: 
               {
	       	printf("\r\nMAKEHDB V. 0.997:\r\n converts .txt files and .pdb files to .hdb files.\r\n\r\n");
                printf("Usage: \r\n");
		printf("   \"makehdb\"         for GUI mode. \r\n");     
		printf("   \"makehdb <filename>\" for converting a single .txt file or .pdb file.\r\n");
                printf("   \"makehdb all\"     for converting all .txt and .pdb files in the current\r\n");  
                printf("                       directory.\r\n"); 
                printf("   \"makehdb allpdb\"   for converting all .pdb files in the current directory.\r\n");
                printf("   \"makehdb alltxt\"   for converting all .txt files in the current directory.\r\n");
                printf("   \"makehdb <option> <owner>\"   for processing files and editing\r\n"); 
                printf("                       the owner field.\r\n");
                printf("   \"makehdb  -h\"     for  this option display.\r\n\r\n"); 
                printf("(c) Coded by xor 2001, [Michael Muehlhaus, muhlhaus@t-online.de]\r\n"); 
                printf("  Original algorithms by Pandora and P. Beirne\r\n"); 
                return 1;
	        } 


		
else


// single file in command line .txt file


 
 if (((strstr(argv[1],".txt") != 0) || (strstr(argv[1],".TXT") != 0))  &&  (strstr(argv[1],"alltxt") == 0)) 

     	{
       	strncpy(txtname,argv[1],32);
   
                      if ((in = fopen(txtname, "r+b")) == NULL) 
	                {
			printf("error: file not found\r\n");
			return 1;
			}
   
   
   
    	dir = opendir(name);    
    	goto join; 
    	}
//single command line .pdb file 



if (((strstr(argv[1],".PDB") != 0) || (strstr(argv[1],".pdb") != 0))   &&  (strstr(argv[1],"*") == 0) &&  (strstr(argv[1],"all") ==0))
        {
        strncpy(filename,argv[1],32);	
        strncpy(txtname,argv[1],32);
        dir = opendir(name);
        goto palmonly;
        } 







// "all" in command line, or *.txt, or *.pdb 

dir = opendir(name);  
while ( (entry = readdir (dir)) !=0)   
    {
      txtflag=0;			
         if ((strstr(argv[1],"alltxt") !=0))


               goto txtall; 



palmall:
      //    printf(" %s\n",entry->d_name);
        if ((strstr(entry->d_name,".pdb") !=0) || (strstr(entry->d_name,".PDB") !=0)) 
            { 
	    strncpy(filename,entry->d_name,32);
            strncpy(txtname,entry->d_name,32);            
            goto palmonly;
             }           
      

txtall: 

if  ((strstr(argv[1],"allpdb") ==0) &&  (strstr(argv[1],"alltxt") ==0) &&  (strstr(argv[1],"all") ==0))
	//        if ((strstr(argv[1],"*.pdb") !=0) && (strstr(argv[1],"*.PDB") !=0))
             {
             closedir (dir);
             return 0;
             }
        
	
if (((strstr(entry->d_name,".TXT") !=0) || (strstr(entry->d_name,".txt") !=0))   &&   ((strstr(argv[1],"allpdb") ==0)))

            { 
            strncpy(txtname,entry->d_name,32);
            strncpy(filename,entry->d_name,32); 

             
      
join:     

//------------


//clear paths from filename
	for(i=strlen(txtname);i>0;i--)
	{
	//printf("txtname: %s\n",txtname);
		if(txtname[i]=='\\')
		{
		//printf("i1: %i\n",i);
		i = strlen(txtname) - i -1;
		
		//printf("i: %i\n",i);
		strncpy(shortname, txtname + (strlen(txtname) - i), i+1);
		//memcpy(shortname, txtname + (strlen(txtname) - i), i+1);
		shortname[strlen(txtname)]='\0';
		//printf("shortname: %s\n",shortname);
		goto cont;
	        }
      
	 }
i = strlen(txtname) - i -1;
strncpy(shortname, txtname + (strlen(txtname) -1 - i), i +1);
shortname[strlen(txtname)]='\0';

//printf(" strlen: %i\n",strlen(shortname)); 
//printf("shortname1: %s\n",shortname);


cont:





    
// -------------
//Delegation an makedoc      
      txtflag=1;
      makedoc(shortname);

palmonly:

//-----------------------------
//printf("filename: %s\n",filename);
  
	if ((in = fopen(filename, "r+b")) == NULL) 
	{
		printf("error: file not found\r\n");
		return 1;
	}

	filename[strlen(filename)-3] = 'h';
	
	//get file size
	fseek(in,0,SEEK_END);
	pdb_file_size = ftell(in);
	fseek(in,0,SEEK_SET);

	//read pdb header
	fread(&pdb_header_buf,sizeof(char),SIZE_OF_PDB_HEADER_STRUCT,in);
      
	//since INTEL stores data little-endian, which is how we will store .hdb data also
	//we need to flip the big-endian data contained in the PDB
	endian_convert((BYTE*)&pdb_header_buf.attributes,sizeof(USHORT));
	endian_convert((BYTE*)&pdb_header_buf.version,sizeof(USHORT));
	endian_convert((BYTE*)&pdb_header_buf.creation_date,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.modification_number,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.last_backup_date,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.modification_count,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.app_info_id,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.sort_info_id,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.type,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.creator,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.unique_id_seed,sizeof(UWORD));

	//ok, now we have the header data, let's grab that first record list ..
	fread(&pdb_recheader_buf,sizeof(char),SIZE_OF_PDB_RECLIST_HDR_STRUCT,in);
	endian_convert((BYTE*)&pdb_recheader_buf.next_recordlist_id,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_recheader_buf.num_records,sizeof(USHORT));

	//now for those record headers ...
	pdb_reclist_buf = (PDBRecordEntry*)malloc(pdb_recheader_buf.num_records * SIZE_OF_PDB_RECLIST_ENTRY_STRUCT);
	fread(pdb_reclist_buf,sizeof(char),pdb_recheader_buf.num_records * SIZE_OF_PDB_RECLIST_ENTRY_STRUCT,in);
	for(i=0;i<pdb_recheader_buf.num_records;i++)
		endian_convert((BYTE*)&pdb_reclist_buf[i].local_chunk_id,sizeof(UWORD));
	
	//we are going to ignore second record list, 
	//but need to find beginning of it so we
	//know where first record list ends
	if(pdb_recheader_buf.next_recordlist_id != 0)
	{
		fseek(in,pdb_recheader_buf.next_recordlist_id + SIZE_OF_PDB_RECLIST_HDR_STRUCT,SEEK_SET);
		fread(&pdb_reclist_temp,sizeof(char),SIZE_OF_PDB_RECLIST_ENTRY_STRUCT,in);
		endian_convert((BYTE*)&pdb_reclist_temp.local_chunk_id,sizeof(UWORD));
		pdb_file_size = pdb_reclist_temp.local_chunk_id;
		//move back to beginning of first recordset ...
	}

	//we are ignoring app and sort data, set pointer to beginning of rec data:
	fseek(in,pdb_reclist_buf[0].local_chunk_id,SEEK_SET);

	//now we have everything we need to build up our .hdb
	//check if PalmDOC
	if((pdb_header_buf.type == PDB_DOC_TYPE)&&(pdb_header_buf.creator == PDB_DOC_CREATOR))
	{
		//create header
		
	  //if txtflag, then recordname has been set be makedoc		
		if (txtflag==1)
		       {
		       memcpy(hdb_header_buf.name,recordname,0x20);
		       }
		
		else
 		       {
           		 strncpy (blop, (const char*) pdb_header_buf.name,32);
                         blop[strlen((const char*)pdb_header_buf.name)]='\0';  		
           		 memcpy(hdb_header_buf.name,blop,0x20);
	               }
	         
		// set owner field
	        if (argc>2)
	           {
	            strncpy(owner, argv[2],32);	
	           }
	        else
	           {
	           strncpy(owner,"<\0",3);	     
	           }    
	        memcpy (hdb_header_buf.owner,owner,0x20);
		//memcpy (hdb_header_buf.owner, ">>>>\0",0x05);
		//memset(hdb_header_buf.owner,0x00,0x20);
		hdb_header_buf.version = HDB_VERSION_TEXT;
		hdb_header_buf.dbtype = 0;
		hdb_header_buf.attributes = 0;
		hdb_header_buf.creation_date = 0;
		hdb_header_buf.backup_date = 0;
		hdb_header_buf.id = 0;
		hdb_header_buf.appid = 0;
		hdb_header_buf.record_count = pdb_recheader_buf.num_records;

		//create record list
		hdb_recheader_buf = (HDBRecordHeader*)malloc(hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);
		rec_data = (BYTE**)malloc(hdb_header_buf.record_count * sizeof(BYTE*));
		offset = SIZE_OF_HDB_HEADER_STRUCT + (hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);
		for(i=0;i<hdb_header_buf.record_count;i++)
		{
			hdb_recheader_buf[i].attribute = 0;
			hdb_recheader_buf[i].category = 0;
			hdb_recheader_buf[i].id = 0;
			hdb_recheader_buf[i].modify_date = 0;
			hdb_recheader_buf[i].offset = offset;
			hdb_recheader_buf[i].total_field = 1;
			record_size = (i == (hdb_header_buf.record_count - 1)) ? pdb_file_size - pdb_reclist_buf[i].local_chunk_id : pdb_reclist_buf[i + 1].local_chunk_id - pdb_reclist_buf[i].local_chunk_id;
			encoded_size = 0;
			temp = record_size;
		    EnFieldSize(encoded_size, temp, encoded_bytes);
			rec_data[i] = (BYTE*)malloc((record_size + encoded_bytes) * sizeof(BYTE));
			memcpy(rec_data[i],&encoded_size,encoded_bytes);
			temp = fread(&rec_data[i][encoded_bytes],sizeof(char),record_size,in);
			offset += (record_size + encoded_bytes);
		}

		//one last thing, lets switch the doc header info (record 0) data to little endian
		//so we change the record 0 data
		//and we already know there is one size byte preceeding it
		HDBDocHeader *hdb_docheader_buf;
		hdb_docheader_buf = (HDBDocHeader*)&rec_data[0][1];
		endian_convert((BYTE*)&hdb_docheader_buf->version,sizeof(USHORT));
		endian_convert((BYTE*)&hdb_docheader_buf->uncomp_size,sizeof(UWORD));
		endian_convert((BYTE*)&hdb_docheader_buf->rec_size,sizeof(USHORT));
		endian_convert((BYTE*)&hdb_docheader_buf->total_recs,sizeof(USHORT));

		//we have everythine we need now so
		//let's create .hdb file
		if ((out = fopen(filename, "w+b")) == NULL) 
		{
			//output error message
			printf("error: output file not found\r\n");
			return 1;
		}
		
		printf("%s created.\r\n",filename);  
		
		
		//let's write header
		fwrite(&hdb_header_buf,sizeof(char), SIZE_OF_HDB_HEADER_STRUCT, out);
		//write record list
		fwrite(hdb_recheader_buf,sizeof(char), hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT, out);
		//write records
		for(i=0;i<hdb_header_buf.record_count;i++)
		{
			if(i!=(hdb_header_buf.record_count - 1))
				record_size = hdb_recheader_buf[i+1].offset - hdb_recheader_buf[i].offset;
			else //calculated from original file
			{
				record_size = pdb_file_size - pdb_reclist_buf[i].local_chunk_id;
				//calc encoded bytes length
				encoded_size = 0;
				temp = record_size;
				EnFieldSize(encoded_size, temp, encoded_bytes);
				record_size += encoded_bytes;
			}
			fwrite(rec_data[i],sizeof(char), record_size, out);
		}

		//	fcloseall();
                
                filename[strlen(filename)-3] = 'p';
               
                              
                
          //if input file wasn`t .pdb, kill makedoc's intermediary .pdb file 
                
				//   printf("PRE_REMOVE txtname%s\n",txtname);
                //   printf("PRE_REMOVE filname %s\n",filename);

                if ((strstr(txtname,".pdb") == 0) && (strstr(txtname,".PDB") == 0))
                  {
                    remove(filename);
                  }

       //bye, GUI mode
                 
                
	           if (argc==1)
			{
	  		//call App Installer to ready hdb file for VSync
		abflug:
		        filename[strlen(filename)-3] = 'h';
 //			ShellExecute(NULL,"open",filename,NULL,NULL,0);
	        	return 0;
	        	}  


	//bye, single command line option

 if (((strstr(argv[1], ".txt") !=0) || (strstr(argv[1], ".TXT") !=0) || (strstr(argv[1], ".PDB") !=0) || (strstr(argv[1], ".pdb") !=0))    &&  (strstr(argv[1], "palmall") ==0))      


    {
	           //  printf("bye\n");
	             closedir (dir);	 
	             goto abflug;
	             }     
	
	
	}
	
	
	else
	{
		// fcloseall();
		printf("error: invalid .pdb file %s\r\n",txtname);
		 
		 
		 if  (argc==1)
		     goto baderror;
		 if ((strstr(argv[1], "*") ==0)  && (strstr(argv[1], "all") ==0))
		     {
		 baderror:
	//	 printf("here\n");
	//	     fcloseall(); 
		     return 1;
		     }
		
		// break;
		// return 1;
	
	}
        
        
        
        
        
        }  	
        
 }


return 0;
} 







//-------------------------------------------------------------

//lazy conversion :)
void endian_convert(BYTE* buffer, UWORD buf_len)
{ 
	BYTE temp;

	switch(buf_len)
	{
	case 1:	//do nothing
		break;
	case 2:	//USHORT vals
		temp = buffer[0];
		buffer[0] = buffer[1];
		buffer[1] = temp;
		break;
	case 3:	//USHORT vals
		temp = buffer[0];
		buffer[0] = buffer[2];
		buffer[2] = temp;
		break;
	case 4:	//UWORD vals
		temp = buffer[0];
		buffer[0] = buffer[3];
		buffer[3] = temp;
		temp = buffer[1];
		buffer[1] = buffer[2];
		buffer[2] = temp;
		break;
	}
}
