#ifndef __HDB_H_
#define __HDB_H_

#define HDB_VERSION_TEXT 0x8938

#define BYTE		unsigned char
#define USHORT		unsigned short
#define UWORD		unsigned int

#define DatabaseID	unsigned int
#define RecordID	unsigned int
#define AppID		unsigned int

#define SIZE_OF_HDB_HEADER_STRUCT		92
#define SIZE_OF_HDB_REC_HEADER_STRUCT	16
#define SIZE_OF_HDB_DOC_HEADER_STRUCT	16
#define SIZE_OF_HDB_DOC_BOOMARK_STRUCT	20
#define SIZE_OF_HDB_DOC_TOC_STRUCT		40

typedef struct HDB_HEADER_STRUCT 
{
    BYTE  name[32];			//31 chars + NULL
	BYTE  owner[32];		//31 chars + NULL
	USHORT version;			//used to distinguish db version on device
	USHORT dbtype;			//RFU
	UWORD attributes;		//RFU
	UWORD creation_date;	//updated after db is added to device
	UWORD backup_date;		//updated after db is backed up from device
	DatabaseID id;			//updated after db is added to device
	AppID appid;			//updated after db is added to device
	UWORD record_count;		//total records
} HDBHeader;

typedef struct HDB_REC_HEADER_STRUCT
{
	UWORD offset;			//offset to record from beginning of file
	RecordID id;			//user defined must be 0x80000000 - 0x8fffffff, else updated after db is added to device
	UWORD modify_date;		//updated after db is modified from device
	USHORT total_field;		//total fields
	BYTE category;			//record category
	BYTE attribute;			//record attributes
} HDBRecordHeader;

typedef struct HDB_DOC_HEADER_STRUCT
{
	USHORT version;			//HelioDOC version
	USHORT reserved1;		//RFU
	UWORD  uncomp_size;		//total size of doc
	USHORT total_recs;		//number of text records
	USHORT rec_size;		//max size of records
	UWORD  reserved2;		//RFU
} HDBDocHeader;

typedef struct HDB_DOC_BOOMARK_STRUCT
{
	BYTE name[16];			//bookmark identifier, 15 chars + NULL
	UWORD offset;			//char position from beginning of text (decoded)
} HDBDocBookmark;

typedef struct HDB_DOC_TOC_STRUCT
{
	BYTE title[32];				//TOC title, 31 chars + NULL
	UWORD record_count;			//number of entries in TOC
	HDBDocBookmark* toc_item;	//pointer to list of TOC entries, which immediately follow this struct
} HDBTocList;

#define EnFieldSize(word, size, byte_use)												\
{																						\
	byte_use = 0;																		\
	do {																				\
		*(BYTE*)((BYTE*)(&word) + byte_use++) = ((BYTE) size) << 1;						\
		size >>= 7;																		\
	}while(size != 0);																	\
	*(BYTE*)((BYTE*)(&word) + byte_use - 1) |= 0x01;									\
}

#endif
