#ifndef __PDB_H_
#define __PDB_H_

#define BYTE  unsigned char
#define USHORT unsigned short
#define UWORD unsigned int

#define SIZE_OF_PDB_HEADER_STRUCT			72
#define SIZE_OF_PDB_RECLIST_HDR_STRUCT		6
#define SIZE_OF_PDB_RECLIST_ENTRY_STRUCT	8

#define PDB_DOC_TYPE	0x54455874 //"TEXt"
#define PDB_DOC_CREATOR 0x52454164 //"REAd"

typedef struct PDB_HEADER_STRUCT
{
    BYTE name[32];
	USHORT attributes;
	USHORT version;
	UWORD creation_date;
	UWORD modification_number;
	UWORD last_backup_date;
	UWORD modification_count;
	UWORD app_info_id;
	UWORD sort_info_id;
	UWORD type;
	UWORD creator;
	UWORD unique_id_seed;
} PDBHeader;

typedef struct PDB_RECLIST_HDR_STRUCT
{
	UWORD next_recordlist_id;
	USHORT num_records;
} PDBRecordHeader;

typedef struct PDB_RECLIST_ENTRY_STRUCT
{
	UWORD local_chunk_id;
	UWORD attributes_id;		//bytes 0 = attributes, 1-3  = unique_id
} PDBRecordEntry;

#endif
