// pdb2hdb.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <commdlg.h>

#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <shellapi.h>
#include "hdb.h"
#include "pdb.h"

void endian_convert(BYTE *buffer, UWORD buf_len);

int main(int argc, char *argv[])
{
	char filename[255];
	FILE *in, *out;
	unsigned int i;

	HDBHeader hdb_header_buf;
	HDBRecordHeader *hdb_recheader_buf;
	BYTE** rec_data;

	PDBHeader pdb_header_buf;
	PDBRecordHeader pdb_recheader_buf;
	PDBRecordEntry *pdb_reclist_buf;
	PDBRecordEntry pdb_reclist_temp;

	UWORD offset,record_size,pdb_file_size,encoded_bytes,encoded_size,temp;
	if(argc==2)
		strcpy(filename,argv[1]);
	else
	{
		//popup Win common dialog
		BOOL blnRet;
		static TCHAR szFilter[] = TEXT("Palm Database Files (*.pdb)\0*.pdb\0")
								TEXT("All Files (*.*)\0*.*\0\0");
		static TCHAR szFileName[MAX_PATH],szTitleName[MAX_PATH];
		static OPENFILENAME ofn;

		ofn.lStructSize = sizeof(OPENFILENAME);
		ofn.hInstance = NULL;
		ofn.lpstrFilter = szFilter;
		ofn.lpstrCustomFilter = NULL;
		ofn.nMaxCustFilter = 0;
		ofn.nFilterIndex = 1;
		ofn.lpstrFile = szFileName;
		ofn.nMaxFile = MAX_PATH;
		ofn.lpstrFileTitle = szTitleName;
		ofn.nMaxFileTitle = MAX_PATH;
		ofn.lpstrInitialDir = NULL;
		ofn.lpstrTitle = NULL;
		ofn.Flags = OFN_HIDEREADONLY | OFN_CREATEPROMPT;
		ofn.nFileOffset = 0;
		ofn.nFileExtension = 0;
		ofn.lpstrDefExt = TEXT("pdb");
		ofn.lCustData = 0;
		ofn.lpfnHook = NULL;
		ofn.lpTemplateName = NULL;
         
		blnRet = ::GetOpenFileName(&ofn);
		if(strlen(ofn.lpstrFile))
			strcpy(filename,ofn.lpstrFile);
		else
			return 1;
//		//command prompt only version
//		printf("The syntax of the command is incorrect\r\n\r\n");
//		printf("PDB2HDB: converts .pdb file to .hdb file\r\n");
//		printf("usage: pdb2hdb <filename>\r\n");
//		return 1;
	}

	if ((in = fopen(filename, "r+b")) == NULL) 
	{
		printf("error: file not found\r\n");
		return 1;
	}

	filename[strlen(filename)-3] = 'h';
	
	//get file size
	fseek(in,0,SEEK_END);
	pdb_file_size = ftell(in);
	fseek(in,0,SEEK_SET);

	//read pdb header
	fread(&pdb_header_buf,sizeof(char),SIZE_OF_PDB_HEADER_STRUCT,in);
      
	//since INTEL stores data little-endian, which is how we will store .hdb data also
	//we need to flip the big-endian data contained in the PDB
	endian_convert((BYTE*)&pdb_header_buf.attributes,sizeof(USHORT));
	endian_convert((BYTE*)&pdb_header_buf.version,sizeof(USHORT));
	endian_convert((BYTE*)&pdb_header_buf.creation_date,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.modification_number,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.last_backup_date,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.modification_count,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.app_info_id,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.sort_info_id,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.type,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.creator,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_header_buf.unique_id_seed,sizeof(UWORD));

	//ok, now we have the header data, let's grab that first record list ..
	fread(&pdb_recheader_buf,sizeof(char),SIZE_OF_PDB_RECLIST_HDR_STRUCT,in);
	endian_convert((BYTE*)&pdb_recheader_buf.next_recordlist_id,sizeof(UWORD));
	endian_convert((BYTE*)&pdb_recheader_buf.num_records,sizeof(USHORT));

	//now for those record headers ...
	pdb_reclist_buf = (PDBRecordEntry*)malloc(pdb_recheader_buf.num_records * SIZE_OF_PDB_RECLIST_ENTRY_STRUCT);
	fread(pdb_reclist_buf,sizeof(char),pdb_recheader_buf.num_records * SIZE_OF_PDB_RECLIST_ENTRY_STRUCT,in);
	for(i=0;i<pdb_recheader_buf.num_records;i++)
		endian_convert((BYTE*)&pdb_reclist_buf[i].local_chunk_id,sizeof(UWORD));
	
	//we are going to ignore second record list, 
	//but need to find beginning of it so we
	//know where first record list ends
	if(pdb_recheader_buf.next_recordlist_id != 0)
	{
		fseek(in,pdb_recheader_buf.next_recordlist_id + SIZE_OF_PDB_RECLIST_HDR_STRUCT,SEEK_SET);
		fread(&pdb_reclist_temp,sizeof(char),SIZE_OF_PDB_RECLIST_ENTRY_STRUCT,in);
		endian_convert((BYTE*)&pdb_reclist_temp.local_chunk_id,sizeof(UWORD));
		pdb_file_size = pdb_reclist_temp.local_chunk_id;
		//move back to beginning of first recordset ...
	}

	//we are ignoring app and sort data, set pointer to beginning of rec data:
	fseek(in,pdb_reclist_buf[0].local_chunk_id,SEEK_SET);

	//now we have everything we need to build up our .hdb
	//check if PalmDOC
	if((pdb_header_buf.type == PDB_DOC_TYPE)&&(pdb_header_buf.creator == PDB_DOC_CREATOR))
	{
		//create header
		memcpy(hdb_header_buf.name,pdb_header_buf.name,0x20);
		memset(hdb_header_buf.owner,0x00,0x20);
		hdb_header_buf.version = HDB_VERSION_TEXT;
		hdb_header_buf.dbtype = 0;
		hdb_header_buf.attributes = 0;
		hdb_header_buf.creation_date = 0;
		hdb_header_buf.backup_date = 0;
		hdb_header_buf.id = 0;
		hdb_header_buf.appid = 0;
		hdb_header_buf.record_count = pdb_recheader_buf.num_records;

		//create record list
		hdb_recheader_buf = (HDBRecordHeader*)malloc(hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);
		rec_data = (BYTE**)malloc(hdb_header_buf.record_count * sizeof(BYTE*));
		offset = SIZE_OF_HDB_HEADER_STRUCT + (hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);
		for(i=0;i<hdb_header_buf.record_count;i++)
		{
			hdb_recheader_buf[i].attribute = 0;
			hdb_recheader_buf[i].category = 0;
			hdb_recheader_buf[i].id = 0;
			hdb_recheader_buf[i].modify_date = 0;
			hdb_recheader_buf[i].offset = offset;
			hdb_recheader_buf[i].total_field = 1;
			record_size = (i == (hdb_header_buf.record_count - 1)) ? pdb_file_size - pdb_reclist_buf[i].local_chunk_id : pdb_reclist_buf[i + 1].local_chunk_id - pdb_reclist_buf[i].local_chunk_id;
			encoded_size = 0;
			temp = record_size;
		    EnFieldSize(encoded_size, temp, encoded_bytes);
			rec_data[i] = (BYTE*)malloc((record_size + encoded_bytes) * sizeof(BYTE));
			memcpy(rec_data[i],&encoded_size,encoded_bytes);
			temp = fread(&rec_data[i][encoded_bytes],sizeof(char),record_size,in);
			offset += (record_size + encoded_bytes);
		}

		//one last thing, lets switch the doc header info (record 0) data to little endian
		//so we change the record 0 data
		//and we already know there is one size byte preceeding it
		HDBDocHeader *hdb_docheader_buf;
		hdb_docheader_buf = (HDBDocHeader*)&rec_data[0][1];
		endian_convert((BYTE*)&hdb_docheader_buf->version,sizeof(USHORT));
		endian_convert((BYTE*)&hdb_docheader_buf->uncomp_size,sizeof(UWORD));
		endian_convert((BYTE*)&hdb_docheader_buf->rec_size,sizeof(USHORT));
		endian_convert((BYTE*)&hdb_docheader_buf->total_recs,sizeof(USHORT));

		//we have everythine we need now so
		//let's create .hdb file
		if ((out = fopen(filename, "w+b")) == NULL) 
		{
			//output error message
			printf("error: output file not found\r\n");
			return 1;
		}
		//let's write header
		fwrite(&hdb_header_buf,sizeof(char), SIZE_OF_HDB_HEADER_STRUCT, out);
		//write record list
		fwrite(hdb_recheader_buf,sizeof(char), hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT, out);
		//write records
		for(i=0;i<hdb_header_buf.record_count;i++)
		{
			if(i!=(hdb_header_buf.record_count - 1))
				record_size = hdb_recheader_buf[i+1].offset - hdb_recheader_buf[i].offset;
			else //calculated from original file
			{
				record_size = pdb_file_size - pdb_reclist_buf[i].local_chunk_id;
				//calc encoded bytes length
				encoded_size = 0;
				temp = record_size;
				EnFieldSize(encoded_size, temp, encoded_bytes);
				record_size += encoded_bytes;
			}
			fwrite(rec_data[i],sizeof(char), record_size, out);
		}

		fcloseall();

		//call App Installer to ready pdb file for VSync
		ShellExecute(NULL,"open",filename,NULL,NULL,0);
	}
	else
	{
		fcloseall();
		printf("error: invalid pdb file\r\n");
		return 1;
	}
	
	return 0;
}

//lazy conversion :)
void endian_convert(BYTE* buffer, UWORD buf_len)
{
	BYTE temp;

	switch(buf_len)
	{
	case 1:	//do nothing
		break;
	case 2:	//USHORT vals
		temp = buffer[0];
		buffer[0] = buffer[1];
		buffer[1] = temp;
		break;
	case 3:	//USHORT vals
		temp = buffer[0];
		buffer[0] = buffer[2];
		buffer[2] = temp;
		break;
	case 4:	//UWORD vals
		temp = buffer[0];
		buffer[0] = buffer[3];
		buffer[3] = temp;
		temp = buffer[1];
		buffer[1] = buffer[2];
		buffer[2] = temp;
		break;
	}
}