// txt2hdb.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <commdlg.h>

#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <shellapi.h>
#include "hdb.h"

//1KB chunks work well, others don't!
#define TEXT_CHUNK	0x400

int main(int argc, char *argv[]) 
{
	char filename[255];
	FILE *in, *out;
	unsigned int i;

	HDBHeader hdb_header_buf;
	HDBRecordHeader *hdb_recheader_buf;
	BYTE** rec_data;

	UWORD offset,record_size,txt_file_size,encoded_bytes,encoded_size,record_count,temp;

	if(argc==2)
		strcpy(filename,argv[1]);
	else
	{
		//popup Win common dialog
		BOOL blnRet;
		static TCHAR szFilter[] = TEXT("Text Document Files (*.txt)\0*.txt\0")
								TEXT("All Files (*.*)\0*.*\0\0");
		static TCHAR szFileName[MAX_PATH],szTitleName[MAX_PATH];
		static OPENFILENAME ofn;

		ofn.lStructSize = sizeof(OPENFILENAME);
		ofn.hInstance = NULL;
		ofn.lpstrFilter = szFilter;
		ofn.lpstrCustomFilter = NULL;
		ofn.nMaxCustFilter = 0;
		ofn.nFilterIndex = 1;
		ofn.lpstrFile = szFileName;
		ofn.nMaxFile = MAX_PATH;
		ofn.lpstrFileTitle = szTitleName;
		ofn.nMaxFileTitle = MAX_PATH;
		ofn.lpstrInitialDir = NULL;
		ofn.lpstrTitle = NULL;
		ofn.Flags = OFN_HIDEREADONLY | OFN_CREATEPROMPT;
		ofn.nFileOffset = 0;
		ofn.nFileExtension = 0;
		ofn.lpstrDefExt = TEXT("txt");
		ofn.lCustData = 0;
		ofn.lpfnHook = NULL;
		ofn.lpTemplateName = NULL;
         
		blnRet = ::GetOpenFileName(&ofn);
		if(strlen(ofn.lpstrFile))
			strcpy(filename,ofn.lpstrFile);
		else
			return 1;
//		//command prompt only version
//		printf("The syntax of the command is incorrect\r\n\r\n");
//		printf("TXT2HDB: converts .txt file to .hdb file\r\n");
//		printf("usage: txt2hdb <filename>\r\n");
//		return 1;
	}

	//get file size for allocating buffer
	if ((in = fopen(filename, "r+b")) == NULL) 
	{
		printf("error: file not found\r\n");
		return 1;
	}

	fseek(in,0,SEEK_END);
	txt_file_size = ftell(in);
	fclose(in);

	//max record size will be TEXT_CHUNK
	if(txt_file_size > TEXT_CHUNK)
	{
		record_count = 1 + (txt_file_size / TEXT_CHUNK);
		if(record_count % TEXT_CHUNK)
			record_count++;
	}
	else
		record_count = 2;

	//set to name of file
	for(i=strlen(filename);i>0;i--)
	{
		if(filename[i]=='\\')
			break;
	}
	i = strlen(filename) - i - 1;
	memcpy(hdb_header_buf.name, filename + (strlen(filename) - i), i + 1);
	memcpy(hdb_header_buf.owner, "Pandora Technology\0", 0x13);
	hdb_header_buf.version = HDB_VERSION_TEXT;
	hdb_header_buf.dbtype = 0;
	hdb_header_buf.attributes = 0;
	hdb_header_buf.creation_date = 0;
	hdb_header_buf.backup_date = 0;
	hdb_header_buf.id = 0;
	hdb_header_buf.appid = 0;
	hdb_header_buf.record_count = record_count;

	hdb_recheader_buf = (HDBRecordHeader*) malloc(record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);
	offset = SIZE_OF_HDB_HEADER_STRUCT + (record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);

	hdb_recheader_buf[0].attribute = 0;
	hdb_recheader_buf[0].category = 0;
	hdb_recheader_buf[0].id = 0;
	hdb_recheader_buf[0].modify_date = 0;
	hdb_recheader_buf[0].offset = offset;
	hdb_recheader_buf[0].total_field = 1;
	offset += 17;	//we know this b/c rec[0] is hard coded

	rec_data = (BYTE**)malloc(hdb_header_buf.record_count * sizeof(BYTE*));
	rec_data[0] = (BYTE*)malloc(17 * sizeof(BYTE));

	for(i=1;i<record_count;i++)
	{
		hdb_recheader_buf[i].attribute = 0;
		hdb_recheader_buf[i].category = 0;
		hdb_recheader_buf[i].id = 0;
		hdb_recheader_buf[i].modify_date = 0;
		hdb_recheader_buf[i].offset = offset;
		hdb_recheader_buf[i].total_field = 1;

		//update offset
		encoded_size = 0;

		//crappy algorithm here:
		record_size = (i<(record_count-1)) ? TEXT_CHUNK : (txt_file_size % TEXT_CHUNK);
		if(record_size==0) record_size = TEXT_CHUNK;
		temp = record_size;

		EnFieldSize(encoded_size, temp, encoded_bytes);
		offset += (record_size + encoded_bytes);

		rec_data[i] = (BYTE*)malloc((record_size + encoded_bytes) * sizeof(BYTE));
	}
	//create doc header
	HDBDocHeader *hdb_docheader_buf;
	hdb_docheader_buf = (HDBDocHeader*)&rec_data[0][1];
	hdb_docheader_buf->version = 1;
	hdb_docheader_buf->reserved1 = 0;
	hdb_docheader_buf->uncomp_size = txt_file_size;
	hdb_docheader_buf->rec_size = TEXT_CHUNK;
	hdb_docheader_buf->total_recs = record_count - 1;
	hdb_docheader_buf->reserved2 = 0;

	encoded_size = 0;
	temp = 16;	//again, hardcoded b/c we know the size of this record
	EnFieldSize(encoded_size, temp, encoded_bytes);
	memcpy(rec_data[0],&encoded_size,encoded_bytes);

	//read data into buffer
	if ((in = fopen(filename, "r+b")) == NULL) 
	{
		printf("error: file not found\r\n");
		return 1;
	}
	fseek(in,0,SEEK_SET);
	for(i=1;i<record_count;i++)
	{
		//ok, so I used it again 
		record_size = (i<(record_count-1)) ? TEXT_CHUNK : (txt_file_size % TEXT_CHUNK);
		if(record_size==0) record_size = TEXT_CHUNK;
		temp = record_size;
		encoded_size = 0;
		EnFieldSize(encoded_size, temp, encoded_bytes);
		memcpy(rec_data[i],&encoded_size,encoded_bytes);
		fread(&rec_data[i][encoded_bytes],sizeof(char),record_size,in);
	}
	fclose(in);

	memcpy(filename,hdb_header_buf.name, strlen((const char*)hdb_header_buf.name) + 1);
	//quick check for extension replace
	if(filename[strlen(filename) - 4] == '.')
		memcpy((void*)&filename[strlen(filename) - 4],".hdb",0x04);
	else	//no ext, concatenate
		memcpy((void*)&filename[strlen(filename)],".hdb\0",0x05);

	if ((out = fopen(filename, "w+b")) == NULL) 
	{
		printf("error: file not created\r\n");
		return 1;
	}
	fwrite(&hdb_header_buf, sizeof(char), SIZE_OF_HDB_HEADER_STRUCT, out);
	fwrite(hdb_recheader_buf, sizeof(char), record_count * SIZE_OF_HDB_REC_HEADER_STRUCT, out);
	fwrite(rec_data[0], sizeof(char), 17, out);
	for(i=1;i<record_count;i++)
	{
		record_size = (i<(record_count-1)) ? TEXT_CHUNK : (txt_file_size % TEXT_CHUNK);
		if(record_size==0) record_size = TEXT_CHUNK;
		temp = record_size;
		encoded_size = 0;
		EnFieldSize(encoded_size, temp, encoded_bytes);
		fwrite(rec_data[i], sizeof(char),record_size + encoded_bytes, out);
	}
	fclose(out);

	//call App Installer to ready hdb file for VSync
	ShellExecute(NULL,"open",filename,NULL,NULL,0);

	return 0;
}