// AddAppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "vpsync.h"
#include "AddAppDlg.h"
#include "DelAppWarningDlg.h"
#include "syncfx.h"
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int doshow;

/////////////////////////////////////////////////////////////////////////////
// CAddAppDlg dialog


CAddAppDlg::CAddAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAddAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddAppDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CAddAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddAppDlg)
	DDX_Control(pDX, IDOK, m_btnOK);
	DDX_Control(pDX, IDC_SELECT_ALL, m_btnAll);
	DDX_Control(pDX, IDC_SEL_NONE, m_btnNone);
	DDX_Control(pDX, IDC_SEL_APP, m_ListBox);
	DDX_Control(pDX, IDC_DEL_SEL, m_btnDel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddAppDlg, CDialog)
	//{{AFX_MSG_MAP(CAddAppDlg)
	ON_BN_CLICKED(IDC_SELECT_ALL, OnSelectAll)
	ON_BN_CLICKED(IDC_SEL_NONE, OnSelNone)
	ON_BN_CLICKED(IDC_DEL_SEL, OnDelSel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddAppDlg message handlers

void CAddAppDlg::OnOK() 
{
	// TODO: Add extra validation here
	int sel_total;
	int sel_index[500];
	int i;
	CString oldn;
	CString newn;

	sel_total = m_ListBox.GetSelItems(500, sel_index);

	for(i=0;i<sel_total;i++)
	{
		//m_ListBox.GetText(sel_index[i], oldn);
		oldn = appname[sel_index[i]];
		newn = oldn;
		oldn = oldn.Left(oldn.GetLength()-3) + (CString) "apo";
	   TRY
	   {
		   CFile::Rename( oldn, newn );
	   }
	   CATCH( CFileException, e )
	   {
	   }
	   END_CATCH
	}	
	CDialog::OnOK();
}

void CAddAppDlg::OnSelectAll() 
{
	// TODO: Add your control notification handler code here
	m_ListBox.SelItemRange( TRUE, 0, m_ListBox.GetCount() );	
}

void CAddAppDlg::OnSelNone() 
{
	// TODO: Add your control notification handler code here
	m_ListBox.SelItemRange( FALSE, 0, m_ListBox.GetCount() - 1 );	
}

void CAddAppDlg::OnDelSel() 
{
	// TODO: Add your control notification handler code here
	int sel_total;
	int sel_index[500];
	int i;
	CString oldn;
	CString newn;

	m_ListBox.SetFocus();

	if(is_wdlg_show)
		 return;


	sel_total = m_ListBox.GetSelItems(500, sel_index);

	wdlg.total_app = sel_total;
	if(sel_total == 0)
		return;
	is_wdlg_show = 1;
	if(wdlg.DoModal() != IDOK)
	{
		is_wdlg_show = 0;
		return;
	}
	for(i=0;i<sel_total;i++)
	{
		//m_ListBox.GetText(sel_index[i], oldn);
		oldn = appname[sel_index[i]];
    	oldn = oldn.Left(oldn.GetLength()-3) + (CString) "apo";
	   DeleteFile(oldn);
	}	

	RefreshList();
	is_wdlg_show = 0;

}

BOOL CAddAppDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	if ( _chdir(path))
	{
	   CDialog::OnCancel();
	   return TRUE;
	}
	is_wdlg_show = 0;
	doshow = 1;

	RefreshList();
//	m_btnNone.OnMouseLeave(0, CPoint(0,0));
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CAddAppDlg::RefreshList()
{
	m_ListBox.ResetContent();
	m_ListBox.Dir(0, "*.apo");

	if(!m_ListBox.GetCount())
		CDialog::OnCancel();

	CString ofn;
	for(int i=0; i<m_ListBox.GetCount();i++)
	{
		m_ListBox.SetCurSel(i);
		m_ListBox.GetText(i, ofn);
		m_ListBox.DeleteString(i);
		m_ListBox.InsertString(i, GetAppName(ofn));
		ofn = ofn.Left(ofn.GetLength()-3) + (CString) "app";
		appname[i] = ofn;
	}
}

CString CAddAppDlg::GetAppName(CString filename)
{
	 CFile app_file;
	 CFileException e;
	 int header_len;
	 char data_buf[100];
	 int attribute;
	 char app_name[30];
	 char *extra_data = NULL;
	 CString progcode;
	 int return_code = 0;

/*
	| Header Len |       VTech declaration        | Attribute | extra info | prog code |
		 4             strlen(APP_HEADER_MSG) + 1        4        varies       varies

*/

#define APP_HEADER_MSG	(char*) "VTech Helio App Inf V1.0   "
#define APP_HEADER_MSG_SIZE	(strlen(APP_HEADER_MSG) + 1)

	if(!app_file.Open(filename, CFile::modeRead|CFile::shareDenyWrite, &e))
	{
		return (CString) "Unknown App";
	}

	if(app_file.GetLength() < ICON_BMP_SIZE + 4 + 50)  // len too short
	{
		return (CString) "Unknown App";
	}

//	app_file.Read(icon_data, ICON_BMP_SIZE);

	app_file.Read(&header_len, 4);
	if((header_len > 1000) || (header_len < APP_HEADER_MSG_SIZE + 4 + 20) || header_len > app_file.GetLength())
	{
		return (CString) "Unknown App";
	}

	app_file.Read(data_buf, APP_HEADER_MSG_SIZE);
	
	if(strcmp(APP_HEADER_MSG, data_buf) != 0)  // not a valid prg
	{
		return (CString) "Unknown App";
	}

	app_file.Read(&attribute, 4);

	app_file.Read(app_name, 20);
	app_name[19] = 0x00; /* force app name len < 20 */

	return (CString) app_name;

}
