#include "stdafx.h"
#include "syncfx.h"
#include "All_DB.h"
#include "SyncDB.h"
#include "TimeFct.h"
#include "schvox.h"
#include "recid.h"
#include "memo.h"
#include "phonebk.h"
#include "sch.h"
#include "todo.h"
#include "anni.h"
#include "email.h"
#include "emlist.h"
#include "sketch.h"
#include "voice.h"
#include "expense.h"
#include "schrep.h"
#include "schexcep.h"
#include "ExpenseType.h"
#include "resource.h"

extern BOOL m_sound;
extern BOOL bRun;
extern int miss_user_action;
int station_num;
extern int crash;

CString VoxGetExternFileName(RecordID rec_id);
 
BOOL PDADeleteRecord(DatabaseID dbid, RecordID recid)
{
	
	if (SyncRecDel(dbid, recid))
		return TRUE;
	return FALSE;
}


void GetLastSyncDate(CString dbname, RTM* sync_date)
{
	CDaoRecordset *rs = NULL;
	CString szSql;

	szSql = "select LastDate from ApplicationDB where DatabaseName = '";
	szSql += dbname + "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return;
	}

	if(rs->IsBOF())
	{
		sync_date->sec = 0;
		sync_date->min = 0;
		sync_date->hour = 0;
		sync_date->mday = 1;
		sync_date->mon = 0;
		sync_date->year = 0;
	}
	else
		*sync_date = DBDate2RTM(COleDateTime((rs->GetFieldValue("LastDate"))));

	if(rs)
	{
		delete rs;
		rs = NULL;
	}
}


void UpdateLastSyncDate(CString dbname)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	COleDateTime dtime = COleDateTime::GetCurrentTime();

//	CString szDate = dtime.Format("#%x %X#");
	CString szDate = dtime.Format("#%m %d %Y %X#"); //sql only accept m/d/y
	SqlDateHandle(szDate);
	szSql = "update ApplicationDB set LastDate = ";
	szSql += szDate;
	szSql += " where DatabaseName = '";
	szSql += dbname + "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}

}

extern int del_duration;

void TestSpeed()
{
   unsigned long  i = 15000000L;
   double  duration;
   
   clock_t start, finish;
   start = clock();
   while( i-- );
   finish = clock();
   duration = (double)(finish - start) / CLOCKS_PER_SEC;

   if(duration < (double) 0.15)
	   del_duration = 0x4f00;
   else
   if(duration < (double) 0.25)
	   del_duration = 0x3f00;
   else
   if(duration < (double) 0.35)
	   del_duration = 0x2f00;
   else
	   del_duration = 0x1a00;

}



CString ValidDBDate(COleDateTime *d)
{
	CString szDate;
	if (d->GetStatus() != COleDateTime::valid)
			return "";
	else
	{
		szDate = d->Format("%x %X");
		SqlDateHandle(szDate);
		return szDate;
//		return d->Format("%B %d %Y %H:%M:%S");
	}
}




void UpdateLastRecID(CString dbname, RecordID pda_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	int method1 = 0;
	RecordID pc_id;

	szSql = "select max(RecordID) as MaxID from ";
	szSql += dbname;

//	if(dbname != EXPDB)
		szSql += " where RecordID > 0 and RecordID < 1073741823 ";
//	else
//		szSql += " where RecordID > 0 and RecordID < 536870910 ";

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		rs = NULL;
		method1 = 1;
	}

	if(rs)
		if(rs->IsBOF())
			method1 = 1;

	if(method1 == 0)
		pda_id = rs->GetFieldValue(0).lVal;

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	method1 = 1;
	if(method1 == 1)
	{
	szSql = "update ApplicationDB set LastPC = NewPC, LastPDA = ";
	szSql += Str_ul(pda_id);
	szSql += " where DatabaseName = '";
	szSql += dbname + "'";
	}
	else
	{
	szSql = "update ApplicationDB set LastPC = ";
	szSql += Str_ul(pc_id);
	szSql += ", LastPDA = ";
	szSql += Str_ul(pda_id);
	szSql += " where DatabaseName = '";
	szSql += dbname + "'";
	}

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}

}

void ResetLastPCRecID(CString dbname,  RecordID pc_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	   
	szSql = "update ApplicationDB set LastPC = ";
    szSql += Str_ul(pc_default);
    szSql += ", NewPC = ";
    szSql += Str_ul(pc_id);
    szSql += " where DatabaseName = '";
	szSql += dbname + "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}
}


void ResetLastPCRecIDExp(CString dbname,  RecordID pc_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	   
	szSql = "update ApplicationDB set LastPC = ";
    szSql += Str_ul(536870911);
    szSql += ", NewPC = ";
    szSql += Str_ul(pc_id);
    szSql += " where DatabaseName = '";
	szSql += dbname + "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}
}


void UpdateLastPCRecID(CString dbname, RecordID pc_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	   
	szSql = "update ApplicationDB set LastPC = ";
	szSql += Str_ul(pc_id);
	szSql += ", NewPC = ";
	szSql += Str_ul(pc_id);
	szSql += " where DatabaseName = '";
	szSql += dbname + "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}

}


void UpdateLastPDARecID(CString dbname, RecordID pda_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;

  
	szSql = "update ApplicationDB set LastPDA = ";
	szSql += Str_ul(pda_id);
	szSql += " where DatabaseName = '";
	szSql += dbname + "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}

}



BOOL GetLastSyncRecIDNew(CString dbname, RecordID *last_pda_recid, RecordID *last_pc_recid, RecordID *new_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	if(last_pda_recid)
	*last_pda_recid = 0;
	if(last_pc_recid)
	*last_pc_recid = pc_default;
	if(new_pc_recid)
	*new_pc_recid =  pc_default;

	sqlst = "select LastPC, LastPDA, NewPC from ApplicationDB where DatabaseName = '";
	sqlst += dbname;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		if(last_pc_recid)
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		if(last_pda_recid)
		*last_pda_recid = fielddata.lVal;
		if(new_pc_recid)
		*new_pc_recid = rs->GetFieldValue(2).lVal; /* NewPC */
	}

	if(rs)
		delete rs;

	return TRUE;
}


BOOL GetLastSyncRecID(CString dbname, RecordID *last_pda_recid, RecordID *last_pc_recid)
{

	return GetLastSyncRecIDNew(dbname, last_pda_recid, last_pc_recid, NULL);
}


BOOLEAN ExistFile(CString fn)
{
	CFile fp;

	if(fp.Open(fn, CFile::modeRead|CFile::typeBinary))
	{
		fp.Close();
		return TRUE;
	}
	else
		return FALSE;
}


CString PDAGetCatName(DatabaseID dbid, unsigned char cat_num)
{
	RecordHeader header;
	CString rec_content, fielddata;
	CString str;

	if (cat_num == 0)
	{
		str.LoadString(IDS_UNFILED);
		return _T(str);
	}
	if(SyncReadRec(dbid, (int) 0x80000000 + (int) cat_num, (char*) &header, &rec_content))
	{
		str.LoadString(IDS_UNKNOWN);
		return  _T(str);
	}

	PDADataGetField(0, &rec_content, &fielddata);

	return fielddata;
}

BOOL PDAGetCatName(DatabaseID dbid, unsigned char cat_num, CString &name)
{
	RecordHeader header;
	CString rec_content, fielddata;
	BOOL return_val = TRUE;

	if (cat_num == 0)
		return_val = FALSE;
	else
	  if(SyncReadRec(dbid, (int) 0x80000000 + (int) cat_num, (char*) &header, &rec_content))
		  return_val = FALSE;
	else
 	      PDADataGetField(0, &rec_content, &name);

	return return_val;
}


CString PCGetCatName(CDaoDatabase *db, CString dbname, unsigned char cat, CString &catfieldname)
{
	CDaoRecordset *rs = NULL;
	CString sqlst;

	sqlst = "select ";
	sqlst += catfieldname;
	sqlst += " from ";
	sqlst += ExamSql(dbname);
	sqlst += " where RecordID = ";
	sqlst += Str_ul((unsigned long) 0x80000000 + cat);

	rs = new CDaoRecordset(db);

	CString str;
	str.LoadString(IDS_UNKNOWN);
	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		delete rs;
		return _T(str);
	}

	sqlst = str;

	if(!rs->IsBOF())
	{
		sqlst = (LPSTR) rs->GetFieldValue(0).bstrVal;	/* Last PDA */
	}

	if(rs)
		delete rs;

	return sqlst;

}

void PCDeleteRecord(CDaoDatabase *db, CString dbname, RecordID rec_id)
{
	CString szSql;

	szSql = "delete from ";
	szSql += dbname;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

}


void ValidRecIDAccrossDB(CString dbname)
{
	CString szSql;
	CDaoRecordset *pCurrent = NULL;
	CDaoRecordset *pArchive = NULL;
	int i;

	return;  /* do not do so, or record in archive will miss after del (user want to kepp record in arch) */

	CString szSql1;

	szSql = "select RecordID from ";
	szSql += dbname;
	szSql += " order by RecordID";

	pCurrent = new CDaoRecordset(dbCurrent);
	pArchive = new CDaoRecordset(dbArchive);

	try
	{
		pCurrent->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete pCurrent;
		pCurrent = NULL;
	}

	try
	{
		pArchive->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete pArchive;
		pArchive = NULL;
	}

	if(pCurrent)
		if(!pCurrent->IsBOF())
		{		
			szSql1 = "delete from ";
			szSql1 += dbname;
			szSql1 += " where RecordID in (0,";

			while(!pCurrent->IsEOF())
			{
				if(pCurrent->GetFieldValue(0).lVal > 0)
				{
				  szSql1 += Str_ul(pCurrent->GetFieldValue(0).lVal);
				  szSql1 += ",";
				}
				pCurrent->MoveNext();
			}
			szSql1 = szSql1.Left(szSql1.GetLength()-1);
			szSql1 += ")";

			try
			{
				dbArchive->Execute(szSql1);
			}
			catch(CException *e)
			{
				e->Delete();
				TRACE("\nError in delete record in archive");
			}

			try
			{
				dbRecycle->Execute(szSql1);
			}
			catch(CException *e)
			{
				e->Delete();
				TRACE("\nError in delete record in archive");
			}


		}

	if(pArchive)
		if(!pArchive->IsBOF())
		{		
			szSql1 = "delete from ";
			szSql1 += dbname;
			szSql1 += " where RecordID in (0,";

			while(!pArchive->IsEOF())
			{
				if(pArchive->GetFieldValue(0).lVal > 0)
				{
				  szSql1 += Str_ul(pArchive->GetFieldValue(0).lVal);
				  szSql1 += ",";
				}
				pArchive->MoveNext();
			}
			szSql1 = szSql1.Left(szSql1.GetLength()-1);
			szSql1 += ")";

			try
			{
				dbRecycle->Execute(szSql1);
			}
			catch(CException *e)
			{
				e->Delete();
				TRACE("\nError in delete record in archive");
			}
		}

	if(pCurrent)
	{
		delete pCurrent;
		pCurrent = NULL;
	}

	if(pArchive)
	{
		delete pArchive;
		pArchive = NULL;
	}

}

void AssignAllRecID2PC(CDaoDatabase *db, CString dbname, RecordID base)
{
	CDaoRecordset *rs=NULL;
	RecordID last_pda_rec_id, last_pc_recid;
	CString szSql;

	GetLastSyncRecIDNew(dbname, &last_pda_rec_id, NULL, &last_pc_recid);

	szSql = "select RecordID from ";
	szSql += dbname;
	szSql += " where RecordID < ";
	szSql += Str_ul(last_pc_recid);
	szSql += " and RecordID > ";
	szSql += Str_ul(base) ;
	szSql += " order by RecordID";

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	while(!rs->IsEOF())
	{
		szSql = "update ";
		szSql += dbname;
		szSql += " set RecordID = ";
		szSql += Str_ul(--last_pc_recid);
		szSql += " where RecordID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);
		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
	//		break;
		}
		rs->MoveNext();
	}

	if(rs)
		delete rs;
	rs = NULL;

//	UpdateLastPCRecID(dbname, last_pc_recid);
	ResetLastPCRecID(dbname, last_pc_recid);
	UpdateLastPDARecID(dbname, 0);
}


void AssignAllExpRecID2PC(CDaoDatabase *db)
{
	CDaoRecordset *rs=NULL;
	RecordID last_pda_rec_id, last_pc_recid;
	CString szSql;
	CString dbname = EXPDB;

	GetLastSyncRecIDNew(dbname, &last_pda_rec_id, NULL, &last_pc_recid);


	last_pc_recid += 1;  /* this is the behaviour of Exp. in PC Desktop */

	szSql = "select RecordID from ";
	szSql += dbname;
	szSql += " where RecordID < ";
//	szSql += Str_ul(last_pc_recid);
	szSql += Str_ul(536870910);
	szSql += " and RecordID > 0 order by RecordID";

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	while(!rs->IsEOF())
	{
		szSql = "update ";
		szSql += dbname;
		szSql += " set RecordID = ";
		szSql += Str_ul(++last_pc_recid);
		szSql += " where RecordID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);
		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
			//break;
		}
		rs->MoveNext();
	}

	if(rs)
		delete rs;
	rs = NULL;

//	ResetLastPCRecIDExp(dbname, last_pc_recid+1);
	ResetLastPCRecID(dbname, last_pc_recid+1);
	UpdateLastPDARecID(dbname, 0);
}



void RecIDCrashRecover(CString dbname)
{
	ValidRecIDAccrossDB(dbname);
	AssignAllRecID2PC(dbCurrent, dbname, 0);
	AssignAllRecID2PC(dbArchive, dbname, 0);
	AssignAllRecID2PC(dbRecycle, dbname, 0);
}


void RecIDCrashRecover(CString dbname, RecordID base)
{
	ValidRecIDAccrossDB(dbname);
	AssignAllRecID2PC(dbCurrent, dbname, base);
	AssignAllRecID2PC(dbArchive, dbname, base);
	AssignAllRecID2PC(dbRecycle, dbname, base);
}


CString SketchGetSketchFileName(RecordID);

void AssignAllSketchRecID2PC(CDaoDatabase *db)
{
	CDaoRecordset *rs=NULL;
	RecordID last_pda_rec_id, last_pc_recid;
	CString szSql;
	CString dbname = SKTDB;

	GetLastSyncRecIDNew(dbname, &last_pda_rec_id, NULL, &last_pc_recid);

	szSql = "select RecordID from ";
	szSql += dbname;
	szSql += " where RecordID < ";
	szSql += Str_ul(last_pc_recid);
	szSql += " and RecordID > 0 order by RecordID";

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	while(!rs->IsEOF())
	{
		CString ofname, nfname;
		ofname = szUserPath + (CString)"Sketch\\";

		ofname += SketchGetSketchFileName(rs->GetFieldValue(0).lVal);

		nfname = szUserPath + (CString)"Sketch\\";
		nfname += SketchGetSketchFileName(last_pc_recid - 1);

		if(ExistFile(nfname))
			DeleteFile(nfname);

		TRY
		{
			CFile::Rename(ofname, nfname);
		}
		CATCH( CFileException, e2 )
		{
		//	break;
		}
		END_CATCH

		szSql = "update ";
		szSql += dbname;
		szSql += " set RecordID = ";
		szSql += Str_ul(--last_pc_recid);
		szSql += " , filename = '";
		szSql += SketchGetSketchFileName(last_pc_recid);
		szSql += "' where RecordID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);
		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
			//break;
		}
		rs->MoveNext();
	}

	if(rs)
		delete rs;
	rs = NULL;

	//UpdateLastPCRecID(dbname, last_pc_recid);
	ResetLastPCRecID(dbname, last_pc_recid);
	UpdateLastPDARecID(dbname, 0);
}


void AssignAllTSVoxRecID2PC(CString dbname, CString voxpath, CString parentdbname, CDaoDatabase *db)
{
	CDaoRecordset *rs=NULL;
	RecordID last_pda_rec_id, last_pc_recid;
	CString szSql;

	ValidRecIDAccrossDB(dbname);

	GetLastSyncRecIDNew(dbname, &last_pda_rec_id, NULL, &last_pc_recid);

	szSql = "select RecordID from ";
	szSql += dbname;
	szSql += " where RecordID < 1073741823 ";
	szSql += " and RecordID > 0 order by RecordID";

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	while(!rs->IsEOF())
	{
		CString ofname, nfname;
		ofname = szUserPath + voxpath + (CString)"\\";
		ofname += VoxGetExternFileName(rs->GetFieldValue(0).lVal);

		nfname = szUserPath + voxpath + (CString)"\\";
		nfname += VoxGetExternFileName(last_pc_recid - 1);

		if(ExistFile(nfname))
			DeleteFile(nfname);

		TRY
		{
			CFile::Rename(ofname, nfname);
		}
		CATCH( CFileException, e2 )
		{
		//	break;
		}
		END_CATCH

		szSql = "update ";
		szSql += dbname;
		szSql += " set RecordID = ";
		szSql += Str_ul(--last_pc_recid);
		szSql += ", Filename = '";
		szSql += VoxGetExternFileName(last_pc_recid);
		szSql += "' where RecordID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);
		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
			break;
		}

		szSql = "update ";
		szSql += parentdbname;
		szSql += " set VoiceID = ";
		szSql += Str_ul(last_pc_recid);
		szSql += " where VoiceID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);

		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
		//	break;
		}
		rs->MoveNext();
	}

	if(rs)
		delete rs;
	rs = NULL;

	//UpdateLastPCRecID(dbname, last_pc_recid);
	ResetLastPCRecID(dbname, last_pc_recid);
	UpdateLastPDARecID(dbname, 0);
}


void AssignAllVoxRecID2PC(CDaoDatabase *db)
{
	CDaoRecordset *rs=NULL;
	RecordID last_pda_rec_id, last_pc_recid;
	CString szSql;
	CString dbname = VOXDB;

	GetLastSyncRecIDNew(dbname, &last_pda_rec_id, NULL, &last_pc_recid);

	szSql = "select RecordID from ";
	szSql += dbname;
	szSql += " where RecordID < ";
	szSql += Str_ul(last_pc_recid);
	szSql += " and RecordID > 0 order by RecordID";

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	while(!rs->IsEOF())
	{
		CString ofname, nfname;
		ofname = szUserPath + (CString)"Vox\\";
		ofname += VoxGetExternFileName(rs->GetFieldValue(0).lVal);

		nfname = szUserPath + (CString)"Vox\\";
		nfname += VoxGetExternFileName(last_pc_recid - 1);

		if(ExistFile(nfname))
			DeleteFile(nfname);


		TRY
		{
			CFile::Rename(ofname, nfname);
		}
		CATCH( CFileException, e2 )
		{
		//	break;
		}
		END_CATCH

		szSql = "update ";
		szSql += dbname;
		szSql += " set RecordID = ";
		szSql += Str_ul(--last_pc_recid);
		szSql += ", Filename = '";
		szSql += VoxGetExternFileName(last_pc_recid);
		szSql += "' where RecordID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);
		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
		//	break;
		}
		rs->MoveNext();
	}

	if(rs)
		delete rs;
	rs = NULL;

	//UpdateLastPCRecID(dbname, last_pc_recid);
	ResetLastPCRecID(dbname, last_pc_recid);
	UpdateLastPDARecID(dbname, 0);
}


void AssignAllMemoRecID2PC(CDaoDatabase *db)
{
	CDaoRecordset *rs=NULL;
	RecordID last_pda_rec_id, last_pc_recid;
	CString szSql;
	CString dbname = MEMODB;
	BOOL has_sketch;
	CString oldfile;

	GetLastSyncRecIDNew(dbname, &last_pda_rec_id, NULL, &last_pc_recid);

	szSql = "select RecordID, Filename from ";
	szSql += dbname;
	szSql += " where RecordID < ";
	szSql += Str_ul(last_pc_recid);
	szSql += " and RecordID > 1000 order by RecordID";

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	while(!rs->IsEOF())
	{
		CString ofname, nfname;
		ofname = szUserPath + (CString)"Memo\\";
		ofname += SketchGetSketchFileName(rs->GetFieldValue(0).lVal);

		nfname = szUserPath + (CString)"Memo\\";
		nfname += SketchGetSketchFileName(last_pc_recid - 1);

		oldfile = (LPSTR)rs->GetFieldValue("Filename").bstrVal;
		if(oldfile.GetLength() > 4)
			has_sketch = TRUE;
		else
			has_sketch = FALSE;

		if(has_sketch)
		{
		if(ExistFile(nfname))
			DeleteFile(nfname);


			TRY
			{
				CFile::Rename(ofname, nfname);
			}
			CATCH( CFileException, e2 )
			{
		//		break;
			}
			END_CATCH
		}

		szSql = "update ";
		szSql += dbname;
		szSql += " set RecordID = ";
		szSql += Str_ul(--last_pc_recid);
		if(has_sketch)
		{
			szSql += ", Filename = '";
			szSql += SketchGetSketchFileName(last_pc_recid);
			szSql += "'";
		}
		szSql += " where RecordID = ";
		szSql += Str_ul(rs->GetFieldValue(0).lVal);
		try
		{
			db->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
		//	break;
		}
		rs->MoveNext();
	}

	if(rs)
		delete rs;
	rs = NULL;

	//UpdateLastPCRecID(dbname, last_pc_recid);
	ResetLastPCRecID(dbname, last_pc_recid);
	UpdateLastPDARecID(dbname, 0);
}


void MemoRecIDCrashRecover()
{
	ValidRecIDAccrossDB(MEMODB);
	AssignAllMemoRecID2PC(dbCurrent);
	AssignAllMemoRecID2PC(dbArchive);
	AssignAllMemoRecID2PC(dbRecycle);
}


void SketchRecIDCrashRecover()
{
	ValidRecIDAccrossDB(SKTDB);
	AssignAllSketchRecID2PC(dbCurrent);
	AssignAllSketchRecID2PC(dbArchive);
	AssignAllSketchRecID2PC(dbRecycle);
}

void VoxRecIDCrashRecover()
{
	ValidRecIDAccrossDB(VOXDB);
	AssignAllVoxRecID2PC(dbCurrent);
	AssignAllVoxRecID2PC(dbArchive);
	AssignAllVoxRecID2PC(dbRecycle);
}


void ExpRecIDCrashRecover()
{
	ValidRecIDAccrossDB(EXPDB);
	AssignAllExpRecID2PC(dbCurrent);
	AssignAllExpRecID2PC(dbArchive);
	AssignAllExpRecID2PC(dbRecycle);
}

void TSVoxRecIDCrashRecover(CString dbname)
{
	CString voxpath;
	CString parendbname;
	
	if(dbname == TODOVOXDB)
	{
		voxpath = "ToDoVox";
		parendbname = "ToDo";
	}
	else
	{
		voxpath = "SchVox";
		parendbname = "Scheduler";
	}

	AssignAllTSVoxRecID2PC(dbname, voxpath, parendbname, dbCurrent);
	AssignAllTSVoxRecID2PC(dbname, voxpath, parendbname, dbArchive);
	AssignAllTSVoxRecID2PC(dbname, voxpath, parendbname, dbRecycle);
}


void ValidRecordModiDate(CDaoDatabase *db, CString dbname)
{
	COleDateTime x;
	CString cur_time;
	CString sqlst;

	return;

	x = COleDateTime::GetCurrentTime();
//	cur_time = x.Format("%x %X");
	cur_time = x.Format("%m %d %Y %X"); //sql only accept m/d/y
	SqlDateHandle(cur_time);

	sqlst = "update " + dbname + " set ModifyDate = #";
	sqlst += cur_time + "# where ModifyDate > #";
	sqlst += cur_time + "#";
 
	try
	{
		db->Execute(sqlst);
	}
	catch (CException *e)
	{
		TRACE("\nCannot execute SQL %s ", sqlst);
		e->Delete();
	}
}


void AlertSound(UINT snd)
{

	if (m_sound)
		MessageBeep(snd);
}


void CatDelEntry(RecStruct *record, int &total_rec, char name[256][150], int del_index)
{
	int i;
	for(i=del_index;i<total_rec;i++)
	{
		record[i] = record[i+1];
	}
}


void ReadPDACatName(DatabaseID dbid, char name[256][150], RecStruct *record, int &total_rec)
{
	CString pda_name;
	int i;

	for(i=0;i<255;i++)
		name[i][0] = 0;


	for(i=1;i<total_rec;i++)
		TRACE("\n%d %08x ", i, record[i].rec_header.rec_id);

	for(i=0;i<total_rec;i++)
	{
		if(record[i].rec_header.rec_id == CAT_RECID_START)
			continue;

        if(PDAGetCatName(dbid, record[i].rec_header.rec_id - CAT_RECID_START, pda_name))
		{
			for(int j=0;j<pda_name.GetLength();j++)
			{
				name[i][j] = pda_name[j];
				if(j>148)
					break;
			}
			name[i][j] = 0;
			if(name[i][0] ==0)  // cat is del from PDA, so content = ''
			{
				CatDelEntry(record, total_rec, name, i);
				total_rec--;
				i--;
			}

		}
		else
		   name[i][0] = 0;
		CHKTERM;
		continue;
terminate:
		break;
	}

		for(i=1;i<total_rec;i++)
		   TRACE("\n%d %08x [%s]", i, record[i].rec_header.rec_id, name[i]);


}



void PCMoveCatNum(CDaoDatabase *src_db, CString &PCDBName, RecordID old_cat_rec_id, RecordID new_cat_rec_id)
{
	CString sqlst;

	sqlst = "update ";
	sqlst += PCDBName;
	sqlst += " set RecordID = ";
	sqlst += Str_ul(new_cat_rec_id);
	sqlst += " where RecordID = ";
	sqlst += Str_ul(old_cat_rec_id);

	try
	{
		src_db->Execute(sqlst);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", sqlst);
		return;
	}

	sqlst = "update ";
	sqlst += PCDBName;
	sqlst += " set Category = ";
	sqlst += Str_ul(new_cat_rec_id - CAT_RECID_START);
	sqlst += " where Category = ";
	sqlst += Str_ul(old_cat_rec_id - CAT_RECID_START);

	try
	{
		src_db->Execute(sqlst);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", sqlst);
	}

}


void PCMoveCat(CDaoDatabase *src_db, CString &PCDBName, RecordID src_cat, RecordID dest_cat)
{
	CString sqlst;

	sqlst = "update ";
	sqlst += PCDBName;
	sqlst += " set Category = ";
	sqlst += Str_ul(dest_cat - CAT_RECID_START);
	sqlst += " where Category = ";
	sqlst += Str_ul(src_cat - CAT_RECID_START);

	try
	{
		src_db->Execute(sqlst);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", sqlst);
	}

}



void PCExchangeCatNum(CDaoDatabase *src_db, CString &PCDBName, RecordID old_cat_rec_id, RecordID new_cat_rec_id)
{
#define TMP_CAT_NUM  CAT_RECID_START + 260

   PCMoveCatNum(src_db, PCDBName, old_cat_rec_id, TMP_CAT_NUM);
   PCMoveCatNum(src_db, PCDBName, new_cat_rec_id, old_cat_rec_id);
   PCMoveCatNum(src_db, PCDBName, TMP_CAT_NUM, new_cat_rec_id);
}


void RematchPCCatWithPDACat(CString &PCDBName, CString &PCCatFieldName, DatabaseID pda_dbid, RecStruct *record, int &total_rec)
{
	char pda_cat_name[256][150];
	int i;
	CString sqlst;
	CDaoRecordset *pRs = NULL;
	CString cat_name;
	BOOL err;
 
	ReadPDACatName(pda_dbid, pda_cat_name, record, total_rec);
	CHKTERM;

	// match PDA name with PC name, if name match, cat# not match
	// assign PC cat# to PDA cat#, update PC record's cat
	pRs = new CDaoRecordset(dbCurrent);

	for(i=0;i<255;i++)
	{
		if(record[i].rec_header.rec_id == CAT_RECID_START)
			continue;

		if(pda_cat_name[i][0]) // cat not empty
		{
			err = FALSE;
			cat_name = pda_cat_name[i];
			sqlst = "select RecordID from ";
			sqlst += PCDBName;
			sqlst += " where ";
			sqlst += PCCatFieldName;
			sqlst += " = '";
			sqlst += ExamSql(cat_name);
			sqlst += "' and RecordID >= ";
			sqlst += Str_ul(CAT_RECID_START);
			sqlst += " and RecordID <> ";
//			sqlst += Str_ul(CAT_RECID_START + i);
			sqlst += Str_ul(record[i].rec_header.rec_id);
			sqlst += " and RecordID < 0 ";

			try
			{
				pRs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nCannot exe statement: %s ", sqlst);
				err = TRUE;
			}

			if(!err)
			{
				if(!pRs->IsBOF())
				{
				// if cat name match but Cat# not same,
				// b4 assign pc# to pda's cat#
				// chk if PC already has a cat# with pda#
				// if so, exchange the #
				  //if(DBIsExistRecord(dbCurrent, PCDBName, CAT_RECID_START + i))
				if(DBIsExistRecord(dbCurrent, PCDBName, record[i].rec_header.rec_id))
				  {
//				  	 PCExchangeCatNum(dbCurrent, PCDBName, pRs->GetFieldValue("RecordID").lVal, CAT_RECID_START + i);
				  	 PCExchangeCatNum(dbCurrent, PCDBName, pRs->GetFieldValue("RecordID").lVal, record[i].rec_header.rec_id);
				  }
				  else
//					  PCMoveCatNum(dbCurrent, PCDBName, pRs->GetFieldValue("RecordID").lVal, CAT_RECID_START + i);
					  PCMoveCatNum(dbCurrent, PCDBName, pRs->GetFieldValue("RecordID").lVal, record[i].rec_header.rec_id);
				}
				pRs->Close();
			}
		}
	}

terminate:
	if(pRs)
		delete pRs;
}

RecordID pda_cat_to_be_del[256];
int pda_cat_to_be_del_count;

void SyncUpdateCat(CString &PCDBName, CString &pc_cat_field_name, DatabaseID pda_dbid, RecStruct *record, int total_rec, int mode)
{

	int i;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RTM last_sync_date;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
	
	pda_cat_to_be_del_count = 0;

	CHKTERM;
	RematchPCCatWithPDACat(PCDBName, pc_cat_field_name,  pda_dbid, record, total_rec);
	CHKTERM;

    GetLastSyncDate(PCDBName, &last_sync_date);

	/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += PCDBName;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
//			if(record[i].rec_header.rec_id == CAT_RECID_START)
//				continue;
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and ( RecordID between ";
		szSql += Str_ul(CAT_RECID_START);
		szSql += " and ";
		szSql += Str_ul(CAT_RECID_END);
		szSql += ")";
	}
	else
	{
		szSql += " where RecordID between ";
		szSql += Str_ul(CAT_RECID_START);
		szSql += " and ";
		szSql += Str_ul(CAT_RECID_END);
		szSql += ")";
	}
	
	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += PCDBName;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}

//goto chkboth;

	
	if(mode == CAT_PC_PDA_SYNC)
		goto pc_pda_sync;

	if(mode == CAT_PDA_OVR_PC)
		goto pda_ovr_pc;

	if(mode == CAT_PC_OVR_PDA)
		goto pc_ovr_pda;
// use both sync instead of recover code
	goto pc_pda_sync;

////////////////////////////////////////////////////////////////////////////
//		Default:  Crash Recover
////////////////////////////////////////////////////////////////////////////
// sync PC only cat to PDA
// sync PDA only cat to PC
////////////////////////////////////////////////////////////////////////////
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	  {
		if(record[i].rec_header.rec_id == CAT_RECID_START)
				continue;

	   if(!DBIsExistRecord(dbCurrent, PCDBName, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
			/* record in PDA but not in PC */
		      SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
	   }
	  }
    }  // Rec not found in PC

// rec in PC only
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
			PDAAddCat(dbCurrent, PCDBName, pc_cat_field_name, pda_dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
			rs_pc->MoveNext();
		}
		rs_pc->Close();
  	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}

	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}


goto cat_sync_end;

pc_ovr_pda:
///////////////////////////////////////////////////////////////////////////////////
//  PC Over PDA
///////////////////////////////////////////////////////////////////////////////////
// del PDA only rec
//////////////////////////////////////////////////////////////////////////////////
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	  {
			if(record[i].rec_header.rec_id == CAT_RECID_START)
				continue;

	   if(!DBIsExistRecord(dbCurrent, PCDBName, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
			/* record in PDA but not in PC */
			  pda_cat_to_be_del[pda_cat_to_be_del_count++] = ((RecordHeader)(record[i].rec_header)).rec_id;
	   }
	  }
    }  // Rec not found in PC

goto cat_sync_end;


//////////////////////////////////////////////////////////////////////////////
//				PDA Over PC
//////////////////////////////////////////////////////////////////////////////
//  delete PC only cat
//////////////////////////////////////////////////////////////////////////////
pda_ovr_pc:
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
			PCDeleteRecord(dbRecycle, PCDBName,(rs_pc->GetFieldValue("RecordID")).lVal);
			PCMoveCat(dbCurrent, PCDBName, (rs_pc->GetFieldValue("RecordID")).lVal, CAT_RECID_START); // move all rec to unfile
			rs_pc->MoveNext();
		}
		rs_pc->Close();
  	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}
// add PDA only cat

	  for(i=0;i<total_rec;i++)
	  {
		if(record[i].rec_header.rec_id == CAT_RECID_START)
				continue;

	   if(!DBIsExistRecord(dbCurrent, PCDBName, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
			/* record in PDA but not in PC */
		      SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
	   }
	  }


	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
goto cat_sync_end;

//////////////////////////////////////////////////////////////////////////////
//				PC PDA SYNC
//////////////////////////////////////////////////////////////////////////////
pc_pda_sync:

	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	if(record[i].rec_header.rec_id == CAT_RECID_START)
			continue;

	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
			if(record[i].rec_header.rec_id == CAT_RECID_START)
				continue;


	   if(!DBIsExistRecord(dbCurrent, PCDBName, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > 0)
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should
		     /*   delete it */
			   pda_cat_to_be_del[pda_cat_to_be_del_count++] = ((RecordHeader)(record[i].rec_header)).rec_id;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			   int action = SYNC_REC;


			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					   PCDeleteRecord(dbArchive, PCDBName,((RecordHeader)(record[i].rec_header)).rec_id);
					   PCDeleteRecord(dbRecycle, PCDBName, ((RecordHeader)(record[i].rec_header)).rec_id);
					   PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
					   pda_cat_to_be_del[pda_cat_to_be_del_count++] = ((RecordHeader)(record[i].rec_header)).rec_id;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }
}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
			if(rs_pc->GetFieldValue(1).lVal == CAT_RECID_START)
				goto cat_next_cat;

			if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) >= MODI_TIME)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAAddCat(dbCurrent, PCDBName, pc_cat_field_name, pda_dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
				PCDeleteRecord(dbCurrent, PCDBName, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */

			   int action = SYNC_REC;
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDAAddCat(dbCurrent, PCDBName, pc_cat_field_name, pda_dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				   break;
				   case DEL_REC:
					   PCDeleteRecord(dbCurrent, PCDBName, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;

			}
cat_next_cat:
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}

///////////////////////////////////////////////////////////
// rec in PC and PDA (both)
chkboth:

	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
		  {
			if(record[i].rec_header.rec_id == CAT_RECID_START)
				continue;
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
		  }
			if(found)
			{

			CHKTERM;
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    //PDADeleteRecord(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDAAddCat(dbCurrent, PCDBName, pc_cat_field_name, pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
				int action;
				
				//specially for cat of sync with 2 PC (same id with different name)
/*			    if( TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME 
					&& crash == CRASH_NO && record[i].rec_header.rec_id > -2147483646) 
					//prevent the duplicate of the default categories,
					//drawback: when business & personal deleted, the last 2 cat can't sync. for 2 PC
				{
					//cat added from different station but with same recordid
					RecordID new_recordid;
					new_recordid = SyncUpdateCatFor2PC(dbCurrent, PCDBName, record[i].rec_header.rec_id);

					//add cat created from other station to this station
					CHKTERM;
				    SyncIdleMode(); CHKTERM;		  
				    SyncDBEnqMode(); CHKTERM;
			        SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
				    PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		            CHKTERM;
				    SyncIdleMode();
			        CHKTERM;
		            SyncDBEnqMode();
					CHKTERM;

					//add cat created from this station to th pda
					SyncIdleMode();
					CHKTERM;
				    SyncDBUpMode();
					CHKTERM;
					PDAAddCat(dbCurrent, PCDBName, pc_cat_field_name, pda_dbid, new_recordid);
					CHKTERM;
					
					rs_both->MoveNext();
					continue;
				}
*/ 				//cat rename by same station, do nothing
				
			    if( TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date)) > 0)
					action = SYNC_TO_PDA;
				else
				{
					action = SYNC_TO_PC;
					SyncIdleMode();
					SyncDBEnqMode();
					SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
				}

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
//   		               PDADeleteRecord(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
//			           CHKTERM;
					   PDAAddCat(dbCurrent, PCDBName, pc_cat_field_name, pda_dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case SYNC_TO_PC:
					   CHKTERM;
					  SyncIdleMode(); CHKTERM;		  
					  SyncDBEnqMode(); CHKTERM;
				      SyncReadRec(pda_dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
					   PCAddCat(dbCurrent, PCDBName, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			} // if
			rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}


	return;
cat_sync_end:
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;

	return;

}


void PCAddCat(CDaoDatabase *src_db, CString &PCDBName, CString &pc_cat_field_name, RecordID rec_id, RecordHeader *rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += PCDBName;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += PCDBName;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue(pc_cat_field_name,(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return;

}

void GetMaxSchAlarmNuminPC(RecordID *max_rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	int rec_id_1 = 0;
	int rec_id_2 = 0;
	
	szSql = "select max(AlarmNumber) as MaxID from ";
	szSql += SCHDB;
	szSql += " where AlarmNumber > 0 and AlarmNumber < ";
	szSql += Str_ul(0x3fffffff);
	
	*max_rec_id = 0;

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			rec_id_1 = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbArchive);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (rec_id_1 < rs->GetFieldValue(0).lVal))
			rec_id_1 = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (rec_id_1 < rs->GetFieldValue(0).lVal))
			rec_id_1 = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}
//////////////////////////for scheduler repeat.
	szSql = "select max(AlarmNumber) as MaxID from ";
	szSql += SCHREPDB;
	szSql += " where AlarmNumber > 0 and AlarmNumber < ";
	szSql += Str_ul(0x3fffffff);
	
	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			rec_id_2 = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbArchive);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (rec_id_2 < rs->GetFieldValue(0).lVal))
			rec_id_2 = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (rec_id_2 < rs->GetFieldValue(0).lVal))
			rec_id_2 = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	//compare the rec_id from scheduler and the sch repeat
	if(rec_id_1 > rec_id_2)
		*max_rec_id = rec_id_1;
	else
		*max_rec_id = rec_id_2;

}

void GetMaxSchApptNuminPC(RecordID *max_rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	RecordID rec_id2;
	
	szSql = "select max(Key) as MaxID from ";
	szSql += SCHDB;
	szSql += " where Key > 0 and key < ";
	szSql += Str_ul(0x3fffffff);
	
	*max_rec_id = 0;

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}


	rs = new CDaoRecordset(dbArchive);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (*max_rec_id < rs->GetFieldValue(0).lVal))
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (*max_rec_id < rs->GetFieldValue(0).lVal))
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

////////////////////////  modi key

	szSql = "select max(Key) as MaxID from ";
	szSql += SCHDB;
	szSql += " where Key <= ";
	szSql += Str_ul((0x3fffffff | 0x80000000));

	rec_id2= 0;

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			rec_id2 = rs->GetFieldValue(0).lVal & 0x7fffffff;

		delete rs;
		rs = NULL;
	}


	rs = new CDaoRecordset(dbArchive);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (rec_id2 < rs->GetFieldValue(0).lVal & 0x7fffffff))
			rec_id2 = rs->GetFieldValue(0).lVal & 0x7fffffff;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (rec_id2 < rs->GetFieldValue(0).lVal & 0x7fffffff))
			rec_id2 = rs->GetFieldValue(0).lVal & 0x7fffffff;

		delete rs;
		rs = NULL;
	}


	if(rec_id2 > *max_rec_id)
		*max_rec_id = rec_id2;
}

void GetMaxSchRepeatNuminPC(RecordID *max_rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	
	szSql = "select max(RepeatNumber) as MaxID from ";
	szSql += SCHREPDB;
	szSql += " where RepeatNumber > 0 and RepeatNumber < ";
	szSql += Str_ul(0x3fffffff);
	
	*max_rec_id = 0;

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}


	rs = new CDaoRecordset(dbArchive);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (*max_rec_id < rs->GetFieldValue(0).lVal))
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (*max_rec_id < rs->GetFieldValue(0).lVal))
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

}

void GetMaxPDARecIDinPC(CString dbname, RecordID *max_rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	
	szSql = "select max(RecordID) as MaxID from ";
	szSql += dbname;
	szSql += " where RecordID > 0 and RecordID < ";
	szSql += Str_ul(0x3fffffff);

	*max_rec_id = 0;

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}


	rs = new CDaoRecordset(dbArchive);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (*max_rec_id < rs->GetFieldValue(0).lVal))
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if((!rs->IsBOF()) && (*max_rec_id < rs->GetFieldValue(0).lVal))
			*max_rec_id = rs->GetFieldValue(0).lVal;

		delete rs;
		rs = NULL;
	}
}



void PDAAddCat(CDaoDatabase *src_db, CString &PCDBName, CString &pc_cat_field_name, DatabaseID pda_dbid, RecordID rec_id)
{

	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[30];
	unsigned int data32, data32_2, i ,j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += PCDBName;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue("ModifyDate")))));
	header.total_field = 1;
//	header.cat = 0;	/* category */
	header.cat = (char)(rec_id & 0x000000ff);	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));

	fielddata = (LPCSTR) (rs->GetFieldValue(pc_cat_field_name)).bstrVal;
	AddNULL(&fielddata);
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAddCat(pda_dbid, rec_id, 1, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}
 
	return;

}


void DeferDeletePDACat(DatabaseID dbid)
{
	int i;

	if(!pda_cat_to_be_del_count)
		return;

   SyncIdleMode();
   CHKTERM;
   SyncDBUpMode();
   CHKTERM;
	for(i=0;i<pda_cat_to_be_del_count;i++)
	{
	   PDADeleteRecord(dbid, pda_cat_to_be_del[i]);
		CHKTERM;
	}

terminate:
	return;
}



void PDAReasignRecID(DatabaseID dbid, unsigned int offset, RecordID exclude_recid)
{
	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	SyncReasignRecordID(dbid, offset, exclude_recid);
	CHKTERM;
	SyncIdleMode();
	SyncDBEnqMode();
terminate:
	return;
}

void UpdateLastSyncPCRecIDExp(CString dbname, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	RecordID last_rec_id;

	if(rec_id < 536870911) /* this is created from PDA */
		return;

	szSql = "select LastPC from ApplicationDB where DatabaseName = '";
	szSql += dbname;
	szSql += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		rs = NULL;
	}

	if(rs)
		if(!rs->IsBOF())
		{
			if(rs->GetFieldValue(0).lVal > rec_id)
				rec_id = rs->GetFieldValue(0).lVal;
		}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	szSql = "update ApplicationDB set LastPC = ";
	szSql += Str_ul(rec_id);
	szSql += " where DatabaseName = '";
	szSql += dbname;
	szSql += "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
}


void UpdateLastSyncPCRecID(CString dbname, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	RecordID last_rec_id;

	if(rec_id < 0x3fffffff) /* this is created from PDA */
		return;

	szSql = "select LastPC from ApplicationDB where DatabaseName = '";
	szSql += dbname;
	szSql += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		delete rs;
		rs = NULL;
	}

	if(rs)
		if(!rs->IsBOF())
		{
			if(rs->GetFieldValue(0).lVal < rec_id)
				rec_id = rs->GetFieldValue(0).lVal;
		}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	szSql = "update ApplicationDB set LastPC = ";
	szSql += Str_ul(rec_id);
	szSql += " where DatabaseName = '";
	szSql += dbname;
	szSql += "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
}


void UpdateCategoryTime()
{
	CString szSql;
	int i;

	char *dbname[5] = {MEMODB, TODODB, PBDB, EXPDB, EMDB};


	for(i=0;i<5;i++)
	{

	szSql = "update ";
	szSql += dbname[i];
	szSql += " set ModifyDate = ";
//	szSql +=  COleDateTime::GetCurrentTime().Format("#%b %d %Y %H:%M:%S#");
	szSql += "#1 July 2000#";
	szSql += " where RecordID between ";
	szSql += Str_ul(0x800000ff);
	szSql += " and ";
	szSql += Str_ul(0x80000000);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
	}

}


void ResetAllDBLastSyncRecIDandDate()
{
	CString szSql;
	CString dbheader;
	DatabaseID dbid;
	RecordID last_pda_recid, last_pc_recid;

	if(station_num != 2)
		szSql = "update ApplicationDB set LastPC = 2147483647, LastPDA = 0, LastDate = #31 July 1999 1:00am#";
//		szSql = "update ApplicationDB set LastPC = 2147483647, LastPDA = 0, LastDate = #31 July 1999 1:00am# where DatabaseName <> 'Expense'";
	else
		szSql = "update ApplicationDB set LastPC = 1610612735, LastPDA = 0, LastDate = #31 July 1999 1:00am#";	

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}

	if(sys_crashed == RESTORE_PC)
	{

		SyncIdleMode(); CHKTERM;
		SyncDBEnqMode(); CHKTERM;

//		ExpRecIDCrashRecover();
		TSVoxRecIDCrashRecover(SCHVOXDB);
		TSVoxRecIDCrashRecover(TODOVOXDB);

		if(SyncDBInfo(PDA_ANNIDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(ANNIDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 900);
		}

		CHKTERM;
		Sleep(10);

		if(SyncDBInfo(PDA_EMDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(EMDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 900);
		}

		CHKTERM;
		Sleep(10);

		if(SyncDBInfo(PDA_EMSGDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(EMSGDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
		}

		CHKTERM;
		Sleep(10);

//		UpdateCategoryTime();


		if(SyncDBInfo(PDA_SKTDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(SKTDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 900);
		}

				CHKTERM;
		Sleep(10);


		if(SyncDBInfo(PDA_VOXDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(VOXDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 900);
		}


		CHKTERM;
		Sleep(10);


		if(SyncDBInfo(PDA_MEMODB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(MEMODB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
		}

		CHKTERM;
		Sleep(10);

	if(SyncDBInfo(PDA_PBDB, &dbid, &dbheader) == 0)   /* get dbid of phone book */
	{
		GetMaxPDARecIDinPC(PBDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1002);

	}
	
	if(SyncDBInfo(PDA_SCHDB, &dbid, &dbheader) == 0)   /* get dbid */
	{
		GetMaxPDARecIDinPC(SCHDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;

		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 0);

		RecordID alarm_num, appt_num, repeat_num;
		GetMaxSchAlarmNuminPC(&alarm_num);
		GetMaxSchApptNuminPC(&appt_num);
		GetMaxSchRepeatNuminPC(&repeat_num);
				
		if(alarm_num < 1000)
			alarm_num = 1000;
		if(appt_num < 1000)
			appt_num = 1000;
		if(repeat_num < 1000)
			repeat_num = 1000;
//		SyncSetPDASchApptNum(last_pda_recid + 1 - 1000);
#define SCH_STATUS      0x80001000
		RecordHeader rec_header;
		CString rec_content;
		CString fielddata;

		CHKTERM;
		SyncReadRec(dbid, SCH_STATUS, (char*)&rec_header, &rec_content);		
		PDADataGetField(2, &rec_content, &fielddata);
		if(fielddata != "")
		{
			alarm_num += atoi(fielddata);
		}
		PDADataGetField(3, &rec_content, &fielddata);		
		if(fielddata != "")
		{
			appt_num += atoi(fielddata);
		}
		PDADataGetField(4, &rec_content, &fielddata);
		if(fielddata != "")
		{
			repeat_num += atoi(fielddata);
		}
		UpdateSchStatus(alarm_num,appt_num,repeat_num);

		SyncIdleMode(); CHKTERM;
		SyncDBUpMode(); CHKTERM;
		SyncRecDel(dbid, SCH_STATUS);
		PDASchAddSpecRecord(dbid, SCH_STATUS ,alarm_num,appt_num,repeat_num);
		SyncIdleMode(); CHKTERM;	
		SyncDBEnqMode(); CHKTERM;
	
	}
//	CHKTERM;
//	SchUpdateAlmNumber(dbid);

		CHKTERM;
		Sleep(10);


		if(SyncDBInfo(PDA_TODODB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(TODODB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
		}

		if(SyncDBInfo(PDA_SCHREPDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(SCHREPDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
		}

		CHKTERM;
		Sleep(10);
		if(SyncDBInfo(PDA_SCHEXCEPDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(SCHEXCEPDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
		}

		CHKTERM;
		Sleep(10);

		if(SyncDBInfo(PDA_EXPDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(EXPDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1027);
		}

		CHKTERM;
		Sleep(10);

		if(SyncDBInfo(PDA_EXPENSETYPEDB, &dbid, &dbheader) == 0)   /* get dbid */
		{
		GetMaxPDARecIDinPC(EXPENSETYPEDB, &last_pda_recid);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1028);
		}

	}


	CHKTERM;
	SyncIdleMode(); CHKTERM;
	SyncClearPdaCrash();
terminate:
	return;
}


void ValidDBLastSyncID()
{
	CString szSql;
//	szSql = "update ApplicationDB set LastPC = NewPC where DatabaseName <> '";
//	szSql += EXPDB;
//	szSql += "' and LastPC > NewPC";
	szSql = "update ApplicationDB set LastPC = NewPC where ";
	szSql += "LastPC < NewPC";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}

/*	szSql = "update ApplicationDB set LastPC = NewPC where DatabaseName = '";
	szSql += EXPDB;
	szSql += "' and LastPC > NewPC";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}
*/
}



void SetNextNewPCID(CString dbname)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	RecordID rec_id;
	int pc_default;
	int pc_default2;

	pc_default = 0x7fffffff;
	pc_default2 = 0x5fffffff;
	if(station_num == 2)
	{
		pc_default = 0x5fffffff;
		pc_default2 = 0x3fffffff;
	}

	szSql = "select Min(RecordID) as Ans from ";
	szSql += dbname;
	szSql += " where RecordID > ";
	szSql += Str_ul(pc_default2);
	szSql += " and RecordID <= ";
	szSql += Str_ul(pc_default);
	rec_id = pc_default; // default


	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
		if(!rs->IsBOF())
		{
			if(rs->GetFieldValue(0).lVal >= 536870910)
				rec_id = rs->GetFieldValue(0).lVal;
		}

	szSql = "update ApplicationDB set NewPC = ";
	szSql += Str_ul(rec_id);
	szSql += " where DatabaseName = '";
	szSql += dbname;
	szSql += "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}
}


void ValidDupNextPCID()
{  // if user choose dup, need to adjust next pc id for applications

		SetNextNewPCID(ANNIDB);
		SetNextNewPCID(EMDB);
		SetNextNewPCID(EMSGDB);
		SetNextNewPCID(EXPDB);
		SetNextNewPCID(SCHVOXDB);
		SetNextNewPCID(TODOVOXDB);
		SetNextNewPCID(SCHDB);
		SetNextNewPCID(TODODB);
		SetNextNewPCID(MEMODB);
		SetNextNewPCID(PBDB);
		SetNextNewPCID(SKTDB);
		SetNextNewPCID(VOXDB);

		SetNextNewPCID(SCHREPDB);
		SetNextNewPCID(SCHEXCEPDB);
		SetNextNewPCID(EXPENSETYPEDB);
}


void SetNextNewDupPCID(CString pdadbname, CString pcdbname)
{
	DatabaseID dbid;
	RecStruct *record = NULL;
	CString dbheader;
	int total_rec, i;
	RecordID sel_rec_id;
	int mode = 0;
	CString szSql;
	int pc_default;
	int pc_default2;

	pc_default = 0x7fffffff;
	pc_default2 = 0x5fffffff;
	if(station_num == 2)
	{
		pc_default = 0x5fffffff;
		pc_default2 = 0x3fffffff;
	}

	sel_rec_id = pc_default;

	if(SyncDBInfo(pdadbname, &dbid, &dbheader))   /* get dbid of phone book */
		return;

	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return;		// error

	for(i=0;i<total_rec;i++)
	{
		if( (record[i].rec_header.rec_id > pc_default2) &&
			(record[i].rec_header.rec_id <= pc_default) &&
			(record[i].rec_header.rec_id < sel_rec_id))
			sel_rec_id = record[i].rec_header.rec_id;
	}

	szSql = "update ApplicationDB set NewPC = ";
	szSql += Str_ul(sel_rec_id);
	szSql += " where DatabaseName = '";
	szSql += pcdbname;
	szSql += "'";

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}

	if(record)
		free(record);

}


void ValidDupPDANextPCID()
{
	SyncIdleMode(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;
		SetNextNewDupPCID(PDA_ANNIDB, ANNIDB); CHKTERM;
		SetNextNewDupPCID(PDA_EMDB, EMDB); CHKTERM;
		SetNextNewDupPCID(PDA_EMSGDB, EMSGDB); CHKTERM;
		SetNextNewDupPCID(PDA_EXPDB, EXPDB); CHKTERM;
		SetNextNewDupPCID(PDA_PBDB, PBDB); CHKTERM;
		SetNextNewDupPCID(PDA_MEMODB, MEMODB); CHKTERM;
		SetNextNewDupPCID(PDA_SCHDB, SCHDB); CHKTERM;
		SetNextNewDupPCID(PDA_SCHVOXDB, SCHVOXDB); CHKTERM;
		SetNextNewDupPCID(PDA_TODODB, TODODB); CHKTERM;
		SetNextNewDupPCID(PDA_TODOVOXDB, TODOVOXDB); CHKTERM;
		SetNextNewDupPCID(PDA_SKTDB, SKTDB); CHKTERM;
		SetNextNewDupPCID(PDA_VOXDB, VOXDB); CHKTERM;

		SetNextNewDupPCID(PDA_SCHREPDB, SCHREPDB); CHKTERM;
		SetNextNewDupPCID(PDA_SCHEXCEPDB, SCHEXCEPDB); CHKTERM;
		SetNextNewDupPCID(PDA_EXPENSETYPEDB, EXPENSETYPEDB); CHKTERM;

	SyncIdleMode(); CHKTERM;
terminate:
	return;
}


RecordID SyncUpdateCatFor2PC(CDaoDatabase *src_db, CString &PCDBName, RecordID src_cat)
{

	RecordID dest_cat;
	CString szSql;
	CDaoRecordset* pRs;
	
	szSql = "Select Min(RecordID) from ";
	szSql += PCDBName;
	szSql += " where RecordID < 0 and RecordID > -2147483646";

	pRs = new CDaoRecordset(src_db);
	pRs->Open(dbOpenSnapshot,szSql,0);

	if(!pRs->IsEOF())
		pRs->MoveLast();
	if(pRs->GetRecordCount() > 0)
	{
		dest_cat = pRs->GetFieldValue(0).lVal - 1;
	}
	else
	{
		dest_cat = src_cat - 1;
	}
	pRs->Close();
	delete pRs;
	pRs = NULL;

	szSql = "Update ";
	szSql += PCDBName;
	szSql += " set RecordID = ";
	szSql += Str_ul(dest_cat);
	szSql += " where RecordID = ";
	szSql += Str_ul(src_cat);

	src_db->Execute(szSql);

	PCMoveCat(src_db, PCDBName, src_cat, dest_cat); 
	return dest_cat;
}

void SqlDateHandle(CString& szDate)
{
	szDate.Replace(".","/");
}