#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "Anni.h"

extern CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;


CString AnniConvertPCDateToPDA(COleDateTime t)
{
	// chg to MM/DD/YYYY
		if (t.GetStatus() != COleDateTime::valid)
			return (CString) "";
		else
			return t.Format("%m/%d/%Y");
}


CString AnniConvertPCDateToPDAAlm(COleDateTime t)
{
	// chg to MM/DD/YYYY
		if (t.GetStatus() != COleDateTime::valid)
			return (CString) "";
		else
			return t.Format("%Y/%m/%d");
}


CString AnniConvertPDADateToPC(CString data)
{
	// chg MM/DD/YYYY to Sql

	unsigned long u_val;
	CString year, mon, day, min, hr, sec, result;
	COleDateTime tTime;

	if(data.GetLength() < 10)
	{
		tTime.SetDate(1999,4,1);
		CString szDate = tTime.Format("%x");
		SqlDateHandle(szDate);
		return szDate;
//		return "Apr 01 1999";
	}

	mon = data.Left(2);
	u_val = atol(mon);

//	if((u_val<=12) && (u_val >= 1))
//			mon = MonName[u_val-1];
//	else
//			mon = MonName[0];
	if(!((u_val<=12) && (u_val >= 1)))
		mon = "1";

	day = data.Mid(3,2);
	u_val = atol(day);
  	if((u_val < 1) || (u_val > 31))
			day = "01";

	year = data.Mid(6,4);

//	result = "#";
//	result = mon + " " + day + " " + year ;
//	result += "#";
	tTime.SetDate(atoi(year),atoi(mon),atoi(day));
	CString szDate = tTime.Format("%x");
	SqlDateHandle(szDate);
	result = szDate;

	return result;

}


CString AnniConvertPDAAlmDateToPCA(CString data)
{
	// chg MM/DD/YYYY to Sql

	unsigned long u_val;
	CString year, mon, day, min, hr, sec, result;
	COleDateTime tTime;

	if(data.GetLength() < 10)
	{
		tTime.SetDate(1999,8,1);
		CString szDate = tTime.Format("%x");
		SqlDateHandle(szDate);
		return szDate;
//		return "Aug 01 1999";
	}

	RemoveNULL(&data);
 
	mon = data.Mid(5,2);
	u_val = atol(mon);

//	if((u_val<=12) && (u_val >= 1))
//			mon = MonName[u_val-1];
//	else
//			mon = MonName[0];
	if(!((u_val<=12) && (u_val >= 1)))
		mon = "1";

	day = data.Right(2);
	u_val = atol(day);
  	if((u_val < 1) || (u_val > 31))
			day = "01";

	year = data.Left(4);

//	result = "#";
//	result = mon + " " + day + " " + year ;
//	result += "#";
	tTime.SetDate(atoi(year),atoi(mon),atoi(day));
	result = tTime.Format("%x");
	SqlDateHandle(result);

	return result;

}


BOOL AnniAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	CString AnnYear;
	
	if (CatRec(rec_id))
		return AnniAddCat(dbCurrent, rec_id, rec_header, rec_content);

// todo handle NewRecordWithID record

	szSql = "delete from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += ANNIDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	// Status
	PDADataGetField(0, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		if(fielddata[0] == (char) 0x01)
			rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)"1");
		else
			rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)"0");
	}
	else
		rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)"0");

	// content
	PDADataGetField(1, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)(fielddata));

	// Anni date
	PDADataGetField(2, rec_content, &fielddata);
	if(AnniConvertPDADateToPC(fielddata) == "NULL")
		rsCurrent->SetFieldValueNull("AnniDate");
	else
		rsCurrent->SetFieldValue("AnniDate",(LPCTSTR)AnniConvertPDADateToPC(fielddata));

	// Alarm Date
	PDADataGetField(3, rec_content, &fielddata);
	if(AnniConvertPDAAlmDateToPCA(fielddata) == "NULL")
		rsCurrent->SetFieldValueNull("AlarmDate");
	else
		rsCurrent->SetFieldValue("AlarmDate",(LPCTSTR)AnniConvertPDAAlmDateToPCA(fielddata));

	// Yearly repeated
	PDADataGetField(4, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		if(fielddata[0] == (char) 0x01)
			rsCurrent->SetFieldValue("YearlyRepeat",(LPCTSTR)"TRUE");
		else
			rsCurrent->SetFieldValue("YearlyRepeat",(LPCTSTR)"FALSE");
	}
	else
			rsCurrent->SetFieldValue("YearlyRepeat",(LPCTSTR)"FALSE");

	// Anni Year
	PDADataGetField(5, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	TRACE("\n%d ", fielddata.GetLength());
	if(fielddata.GetLength() == 4)
	{
		rsCurrent->SetFieldValue("AnniYear",(LPCTSTR)fielddata);
		AnnYear = fielddata;
	}
	else
	{
		COleDateTime now = COleDateTime::GetCurrentTime();
		rsCurrent->SetFieldValue("AnniYear",(LPCTSTR)Str_ul(now.GetYear()));
		AnnYear = Str_ul(now.GetYear());
	}

	// Anni Month
	PDADataGetField(6, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		if ( (atoi(fielddata) >= 0) && (atoi(fielddata) <=12))
		{
			RemoveNULL(&fielddata);
			rsCurrent->SetFieldValue("AnniMonth",(LPCTSTR)fielddata);
		}
		else
			rsCurrent->SetFieldValue("AnniMonth",(LPCTSTR)"1");
	}
	else
		rsCurrent->SetFieldValue("AnniMonth",(LPCTSTR)"1");

	// Anni Day
	PDADataGetField(7, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		if ( (atoi(fielddata)>=0) && (atoi(fielddata) <= 31))
		{
			char buf[10];
//			fielddata = itoa(atoi(fielddata) + 1, buf, 10);
			fielddata = itoa(atoi(fielddata), buf, 10);
			RemoveNULL(&fielddata);
			rsCurrent->SetFieldValue("AnniDay",(LPCTSTR)fielddata);
		}
		else
			rsCurrent->SetFieldValue("AnniDay",(LPCTSTR)"1");
	}
	else
		rsCurrent->SetFieldValue("AnniDay",(LPCTSTR)"1");

	// Anni Week
	PDADataGetField(8, rec_content, &fielddata);
	if(fielddata.GetLength())
	{ // range 0 - 54 and  63
		if( (atoi(fielddata) >=0) && (atoi(fielddata) <= 70))
		{
			RemoveNULL(&fielddata);
			if(fielddata.IsEmpty())
				fielddata = '0';
			rsCurrent->SetFieldValue("AnniWeek",(LPCTSTR)fielddata);
		}
		else
			rsCurrent->SetFieldValue("AnniWeek",(LPCTSTR)"1");
	}
	else
		rsCurrent->SetFieldValue("AnniWeek",(LPCTSTR)"1");

	// Sequence
	PDADataGetField(9, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		if( (atoi(fielddata) >= 0) && (atoi(fielddata) <= 5))
		{
			RemoveNULL(&fielddata);
			rsCurrent->SetFieldValue("Sequence",(LPCTSTR)fielddata);
		}
		else
			rsCurrent->SetFieldValue("Sequence",(LPCTSTR)"0");
	}
	else
		rsCurrent->SetFieldValue("Sequence",(LPCTSTR)"0");

//AlarmIndicate: 0 -> exact day,  1 -> 1day before
	PDADataGetField(10, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		if(fielddata[0] != 0)
			rsCurrent->SetFieldValue("AlarmIndicate",(LPCTSTR)"1");
		else
			rsCurrent->SetFieldValue("AlarmIndicate",(LPCTSTR)"0");
	}
	else
		rsCurrent->SetFieldValue("AlarmIndicate",(LPCTSTR)"0");

	//Input Year: input day of the year, only used in the WK# style
	int InputYear;
	char *ptr = (char*)&InputYear;
	PDADataGetField(11, rec_content, &fielddata);

	if(fielddata.GetLength() == 2)
	{
		ptr[0] = fielddata[0];
		ptr[1] = fielddata[1];
		if(InputYear < 1900)
			InputYear = atoi(AnnYear);
		else if(InputYear > 2100)
			InputYear = atoi(AnnYear);
		rsCurrent->SetFieldValue("InputYear",(LPCTSTR)Str_ul(InputYear));
	}
	else
		rsCurrent->SetFieldValue("InputYear",(LPCTSTR)AnnYear);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;
	return FALSE;
}


BOOL AnniMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	
	if (CatRec(rec_id))
		return AnniMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += ANNIDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	int data32;
	
	data32 = (rs->GetFieldValue("AlarmStatus")).lVal;
	szStr = Str_ul(data32);  // Alarm Status
	rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Content");
	if ((LPCSTR) fielddata.bstrVal)
		szStr = ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AnniDate");
	if(fielddata != NULL)
	{
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("AnniDate",(LPCTSTR)szStr);
	}

	fielddata = rs->GetFieldValue("AlarmDate");
	if(fielddata != NULL)
	{
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("AlarmDate",(LPCTSTR)szStr);
	}

	fielddata = rs->GetFieldValue("YearlyRepeat");
	if(fielddata.boolVal)
		rsCurrent->SetFieldValue("YearlyRepeat",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("YearlyRepeat",(LPCTSTR)"FALSE");


	fielddata = rs->GetFieldValue("AnniYear");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("AnniYear",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AnniWeek");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("AnniWeek",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AnniDay");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("AnniDay",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Sequence");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("Sequence",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AnniMonth");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("AnniMonth",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("VoiceID");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AlarmIndicate");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmIndicate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("InputYear");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("InputYear",(LPCTSTR)szStr);


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	rs->Close();

	szSql = "delete from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}



BOOL AnniAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;

	szSql = "delete from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += ANNIDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(1, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	return FALSE;
}



BOOL AnniMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += ANNIDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Content");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	rs->Close();

	szSql = "delete from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return FALSE;
}

BOOL AnniArchivePDAOvrPC(DatabaseID dbid)
{

	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
		return 1;

	for(i=0;i<total_rec;i++)
	{
	  if(((RecordHeader*)&(record[i].rec_header))->rec_id < 0x80000000)
	  {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
//		if(DBIsExistRecord(dbArchive, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
//			AnniMoveRecord(dbArchive, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbRecycle, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		AnniAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
//		AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	}
	}

	if(record)
	   free(record);

	return 0;
}


BOOL AnniArchivePCOvrPDA(DatabaseID dbid)
{ 
	return AnniArchivePDAOvrPC(dbid);
}


BOOL PDAAnniAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[15];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += ANNIDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 12;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));


	fielddata.Empty();
	fielddata = (char) (rs->GetFieldValue("AlarmStatus")).lVal;
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;	

	fielddata.Empty();
	fielddata = (LPSTR) (rs->GetFieldValue("Content")).bstrVal;
	AddNULL(&fielddata);
	size_array[1] = fielddata.GetLength();
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	fielddata.Empty();
	
	fielddata = AnniConvertPCDateToPDA(COleDateTime((rs->GetFieldValue("AnniDate"))));
	AddNULL(&fielddata);
	size_array[2] = fielddata.GetLength();
	data32_2 = size_array[2];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	fielddata = AnniConvertPCDateToPDAAlm(COleDateTime((rs->GetFieldValue("AlarmDate"))));
	AddNULL(&fielddata);
	size_array[3] = fielddata.GetLength();
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;
    
	if((rs->GetFieldValue("YearlyRepeat")).boolVal)
		fielddata = (char) 0x01;
	else
		fielddata = (char) 0x00;
	size_array[4] = fielddata.GetLength();
	data32_2 = size_array[4];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

//	short date16;
//	char *p = (char*) &date16;
//	date16 = (rs->GetFieldValue("AnniYear")).lVal;
//	fielddata = p[0];
//	fielddata += p[1];
	fielddata = Str_ul((rs->GetFieldValue("AnniYear")).lVal);
	AddNULL(&fielddata);
	size_array[5] = fielddata.GetLength();
	data32_2 = size_array[5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

//	char data8;
//	data8 = (rs->GetFieldValue("AnniMonth")).lVal;
//	fielddata = data8;
	fielddata = Str_ul((rs->GetFieldValue("AnniMonth")).lVal);
	AddNULL(&fielddata);
	size_array[6] = fielddata.GetLength();
	data32_2 = size_array[6];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;


	fielddata = Str_ul((rs->GetFieldValue("AnniDay")).lVal);
	AddNULL(&fielddata);
//	fielddata = data8;
	size_array[7] = fielddata.GetLength();
	data32_2 = size_array[7];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

//	data8 = (rs->GetFieldValue("AnniWeek")).lVal;
//	fielddata = data8;
	fielddata = Str_ul((rs->GetFieldValue("AnniWeek")).lVal);
	AddNULL(&fielddata);
	size_array[8] = fielddata.GetLength();
	data32_2 = size_array[8];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

//	data8 = (rs->GetFieldValue("AnniSequence")).lVal;
//	fielddata = data8;
	fielddata = Str_ul((rs->GetFieldValue("Sequence")).lVal);
	AddNULL(&fielddata);
	size_array[9] = fielddata.GetLength();
	data32_2 = size_array[9];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	//Alarm Indicate
	if((rs->GetFieldValue("AlarmIndicate")).lVal)
		fielddata = (char) 0x01;
	else
		fielddata = (char) 0x00;
	size_array[10] = fielddata.GetLength();
	data32_2 = size_array[10];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	// Input Year
	short InputYear;
	InputYear = (short) rs->GetFieldValue("InputYear").lVal;
	size_array[11] = 2;
	data32_2 = size_array[11];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	ptr = (char*) &InputYear;
	content += ptr[0];
	content += ptr[1];

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 12, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;
}


BOOL AnniGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += ANNIDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}




