#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "Anni.h"


extern BOOL bRun;
extern BOOL recycle_pda_anni;
extern int station_num;

void AnniConvertDate(CString &date)
{

// in: YYYY/MM/DD/hh/mm/ss
// out:YYYY MM DD hh:mm:ss

	if(date.GetLength() < 19)
	{
		date.Empty();
	}
	else
	{
		date.SetAt(4, ' ');
		date.SetAt(7, ' ');
		date.SetAt(10, ' ');
		date.SetAt(13, ':');
		date.SetAt(16, ':');
	}
}


int CSyncDispDlg::UpdateDatabasePDAOvrPCAnni()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();
	CHKTERM;


	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_ANNIDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	AnniArchivePDAOvrPC(dbid);

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 10000)
		return 1;
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);

		DoEvents();
//		if(DBIsExistRecord(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			//AnniMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
//			PCDeleteRecord(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id));
//		}
		PCDeleteRecord(dbRecycle, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		DoEvents();
		AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += ANNIDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			//AnniMoveRecord(dbCurrent, dbRecycle, recid);
			PCDeleteRecord(dbCurrent, ANNIDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	CHKTERM;

	SyncIdleMode(); CHKTERM;
	SyncSetAnnAlm(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;

	UpdateLastRecID(ANNIDB, 1000);

	return 0;

terminate:
	if(rs)
		delete rs;

	SyncIdleMode();
	SyncSetAnnAlm();
	SyncDBEnqMode();

	return 1;
}



int CSyncDispDlg::UpdateDatabasePCOvrPDAAnni()
{
	DatabaseID dbid;
	int total_rec; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/*
	if(sys_crashed == RESTORE_PC)
		RecIDCrashRecover(ANNIDB);
*/
/* send all record header data from PDA */
	if(SyncDBInfo(PDA_ANNIDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	AnniArchivePCOvrPDA(dbid);
	CHKTERM;

	CHKTERM;

	total_rec = 0;

	CHKTERM;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record) != 0)
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;
/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */

		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
   		   rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
   		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		/* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDAAnniAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		  UpdateLastSyncPCRecID(ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += ANNIDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat

	szSql += " order by RecordID DESC";
	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDAAnniAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
	        UpdateLastSyncPCRecID(ANNIDB, (rs->GetFieldValue(0)).lVal);
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	SyncIdleMode(); CHKTERM;
	SyncSetAnnAlm(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;

	UpdateLastRecID(ANNIDB, 1000);
	CHKTERM;
	return 0;

terminate:
	if(rs)
		delete rs;

	SyncIdleMode();
	SyncSetAnnAlm();
	SyncDBEnqMode();


	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncAnni()
{
	DatabaseID dbid;
	int total_rec;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;


   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 4;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 280;
   missrec_dlg.row_height[1] = 280;
   missrec_dlg.row_height[2] = 280;
   missrec_dlg.row_height[3] = 280;
   missrec_dlg.row_height[4] = 280;

   CString str;
   str.LoadString(IDS_CATEGORY);
   missrec_dlg.m_Content[0][0] = str;
   str.LoadString(IDS_DATE);
   missrec_dlg.m_Content[1][0] = str;
   str.LoadString(IDS_CONTENT);
   missrec_dlg.m_Content[2][0] = str;
   missrec_dlg.m_Content[3][0] = "";
//   missrec_dlg.m_Content[4][0] = "";


   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 4;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 280;
   duprec_dlg.row_height[1] = 280;
   duprec_dlg.row_height[2] = 280;
   duprec_dlg.row_height[3] = 280;
   duprec_dlg.row_height[4] = 280;

   str.LoadString(IDS_CATEGORY);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_DATE);
   duprec_dlg.m_ContentPC[1][0] = str;
   str.LoadString(IDS_CONTENT);
   duprec_dlg.m_ContentPC[2][0] = str;
   duprec_dlg.m_ContentPC[3][0] = "";
//   duprec_dlg.m_ContentPC[4][0] = "Subject";

	str.LoadString(IDS_CATEGORY);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_DATE);
   duprec_dlg.m_ContentPDA[1][0] = str;
   str.LoadString(IDS_CONTENT);
   duprec_dlg.m_ContentPDA[2][0] = str;
   duprec_dlg.m_ContentPDA[3][0] = "";
//   duprec_dlg.m_ContentPDA[4][0] = "Subject";

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;


/* send all record header data from PDA */
	if(SyncDBInfo(PDA_ANNIDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	GetLastSyncRecID(ANNIDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(ANNIDB, &last_sync_date);

		AnniArchivePCOvrPDA(dbid);
	CHKTERM;

	
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 12000)
		return 1;

/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += ANNIDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, not condiser cat

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += ANNIDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}

//goto chkboth;
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, ANNIDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
			  if(recycle_pda_anni)
			  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  AnniAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			   int action;

			   missrec_act = SYNC_REC;

			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
					  rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
				   }
 				   action = missrec_act;
			   }
			   else
			   {
				      rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
					  missrec_dlg.total_rows = 5;
					  missrec_dlg.total_cols = 2;

				CString str;
				str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
				str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;

			   fielddata.Empty(); //date
			   PDADataGetField(2, &rec_content, &fielddata);  //date
			   AnniConvertDate(fielddata);
			   missrec_dlg.m_Content[1][1] = fielddata;
				   
			   fielddata.Empty(); // content
			   PDADataGetField(1, &rec_content, &fielddata);
			   missrec_dlg.m_Content[2][1] = fielddata;

				str.LoadString(IDS_NO);
			   missrec_dlg.m_Content[3][1] = str;
			   fielddata.Empty();  // sketch
			   PDADataGetField(0, &rec_content, &fielddata);
			   if(fielddata.GetLength())
			   {
				   if(fielddata[0] == (char)0x01)
					   str.LoadString(IDS_YES);
					   missrec_dlg.m_Content[3][1] = str;
			   }

			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					   AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;

		   }
	   }
}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{

			CHKTERM;
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAAnniAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
				AnniMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */		

				int action;

				missrec_act = SYNC_REC;

			if(missrec_act)
				action = missrec_act;
			else
			{

			// Date
				CString data;
		
			   data =  (LPSTR)(rs_pc->GetFieldValue("AnniDate")).bstrVal;
			   AnniConvertDate(data);
				
			   missrec_dlg.m_Content[1][1] =  data;
				   
			   // content
			   missrec_dlg.m_Content[2][1] = (LPSTR)(rs_pc->GetFieldValue("Content")).bstrVal;

//			   // Sketch
//			   missrec_dlg.m_Content[3][1] = (LPSTR)(rs_pc->GetFieldValue("Filename")).bstrVal;


				str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDADeleteRecord(dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   PDAAnniAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				   break;
				   case DEL_REC:
		   			   AnniMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;

			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
				TRACE("nnn");
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  AnniMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDAAnniAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */

				int action;

//				duprec_act = SYNC_TO_PC;

			if(TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date)) < 0)
			 {
				 duprec_act = SYNC_TO_PC;
				  SyncIdleMode(); CHKTERM;
				  SyncDBEnqMode(); CHKTERM;
		         SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			 }
			 else
				 duprec_act = SYNC_TO_PDA;


			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 	//  	              SyncIdleMode(); CHKTERM;
      //                SyncDBEnqMode(); CHKTERM;
				   }
					action = duprec_act;
			   }
			   else
			   {
				   ///////////////// prepare PDA content
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
// 	  	              SyncIdleMode(); CHKTERM;
  //                    SyncDBEnqMode(); CHKTERM;

				str.LoadString(IDS_MODIFY);
               duprec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_MODIFY);
			   duprec_dlg.m_szDupMsg = str;

			   fielddata.Empty(); //date
			   PDADataGetField(2, &rec_content, &fielddata);  //date
			   AnniConvertDate(fielddata);
			   duprec_dlg.m_ContentPDA[1][1] = fielddata;
				   
			   fielddata.Empty(); // content
			   PDADataGetField(1, &rec_content, &fielddata);
			   duprec_dlg.m_ContentPDA[2][1] = fielddata;

			   fielddata.Empty();  // Sketch
			   PDADataGetField(0, &rec_content, &fielddata);
			   str.LoadString(IDS_NO);
			   duprec_dlg.m_ContentPDA[3][1] = str;
			   if( fielddata.GetLength())
			   {
				   str.LoadString(IDS_YES);
				   if(fielddata[0] == (char) 0x01)
					   duprec_dlg.m_ContentPDA[3][1] = str;
			   }
   

			   fielddata.Empty(); // subject
            
			    ///////////////////  Prepare PC content

			   // date
			   CString data;
			   data = (LPSTR)(rs_both->GetFieldValue("AnniDate")).bstrVal;
			   AnniConvertDate(data);
			   duprec_dlg.m_ContentPC[1][1] = data;
			   
			   // content
			   duprec_dlg.m_ContentPC[2][1] = (LPSTR)(rs_both->GetFieldValue("Content")).bstrVal;

			   // sketch
			   data = (LPSTR)(rs_both->GetFieldValue("Filename")).bstrVal;


			   duprec_dlg.DoModal();

			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDAAnniAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   break;
				   case SYNC_TO_PC:
		   			   AnniMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   AnniAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;

			}
			} // if
			rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 0x3fffffff)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}


	if(record)
	{
	   free(record);
	   record = NULL;
	}

	CHKTERM;

	UpdateLastRecID(ANNIDB, last_pda_recid);

	
	SyncIdleMode(); CHKTERM;
	SyncSetAnnAlm(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;

	
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	SyncIdleMode();
	SyncSetAnnAlm();
	SyncDBEnqMode();

	return 1;
}
