#include "stdafx.h"
#include "CKString.h"

CKString::CKString()
{
	data = (char*) malloc(KS_BUF_SIZE);
	data_size = 0;
	buf_size = KS_BUF_SIZE;
}

CKString::~CKString()
{
	free(data);
}

void CKString::operator += (CString x)
{
	if(data_size + x.GetLength() >= buf_size)
	{
		TRACE("\nStart alloc");
		char *new_data = (char*) malloc(data_size * 2);
		for(long i = 0; i < data_size;i+=4)
			*(int*)(new_data + i) = *(int*) (data + i);
		free(data);
		data = new_data;
		buf_size = data_size * 2;
		TRACE("\nEnd alloc");
	}

	for(int k=0;k<x.GetLength();k++)
		data[data_size++] = x[k];
}

void CKString::operator += (char x)
{
	if(data_size >= buf_size)
	{
		TRACE("\nStart alloc");
		char *new_data = (char*) malloc(data_size * 2);
		for(long i = 0; i < data_size;i+=4)
			*(int*)(new_data + i) = *(int*) (data + i);
		free(data);
		data = new_data;
		buf_size = data_size * 2;
		TRACE("\nEnd alloc");
	}

	data[data_size++] = x;
}


void CKString::Reset()
{
	free(data);
	data = (char*) malloc(KS_BUF_SIZE);
	data_size = 0;
	buf_size = KS_BUF_SIZE;
}


char CKString::operator[] (long x)
{

	return GetAt(x);
}


char CKString::GetAt(long pos)
{
	return data[pos];
}

void CKString::SetAt(long pos, char x)
{
	if(pos > data_size)
	{
		TRACE("\nError in accessing buffer");
		return;
	}
	data[pos] = x;
}

void CKString::Empty()
{
	data_size = 0;
}

long CKString::GetLength()
{
	return data_size;
}


void CKString::operator = (CKString x)
{
	buf_size = x.buf_size;
	data_size = x.data_size;
	TRACE("\nAlloc in op = ");
	data = (char*) malloc(buf_size);
	for(long i = 0; i < data_size;i+=4)
		*(int*)(data + i) = *(int*) (x.data + i);
}


CString tmp_str;
CString CKString::Left(long len)
{
	tmp_str.Empty();
	for(long i=0;i<len;i++)
		tmp_str += data[i];
//	tmp_str = data;
	int k = tmp_str.GetLength();
	return tmp_str.Left(len);
}

CString CKString::Right(long len)
{
	tmp_str = data;
	return tmp_str.Right(len);
}

void CKString::CutLeft(long len)
{
	if(len < data_size)
		data_size = len;
}

void CKString::CutRight(long len)
{
	if(len > data_size)
		return;
	for(long i = 0; i < len;i+=4)
		*(int*)(data + i ) = *(int*) (data + data_size - len + i );
	data_size = len;
}

long CKString::Find(char x)
{
	for(long i=0;i<data_size;i++)
		if(data[i] == x)
			return i;
	return -1;
}