// commport.h : header file
//

#ifndef _COMMPROT_H
#define _COMMPROT_H

// ASCII defination
#define ASCII_XON				0x11
#define ASCII_XOFF				0x13

#define MAXBUFFER				4000

#define WM_COMMPORT				WM_USER + 1

#define WM_COMM_RX_CHAR			WM_USER + 50
/////////////////////////////////////////////////////////////////////////////
// CCommPort class

class CCommPort : public CObject
{
	// data members
public:

	// port settings data
	int		m_Port;			// 1 to 4  0 = NONE
	int		m_Baud;			// 300 600 1200 2400 .. 57600
	int		m_DataBits;		// 0 to 1
	int		m_Parity;		// 0 to 2
	int		m_StopBits;		// 0 to 2
	BOOL	m_bSoftFlow;
	BOOL	m_bHardFlow;

	// The previous comm port
	int	m_PrevPort;			// 0 to 4

	// handle for communication device
	HANDLE	m_hComDev;

	// other tools
	CString	m_Section;				// section name in .INI file
	BOOL	m_bConnect;				// flag for connection
	BOOL	m_bIniConnect;			// indicate whether it is 
									// the 1st comm port connection.
	// read & write 
	OVERLAPPED m_osRead, m_osWrite;

private:
	// second thread to watch for COMM events
	CWinThread* m_pWatchThread;
	CWnd *m_pParent;

public:
	// constructor & destructor
	CCommPort();
	~CCommPort();

	void Send(char);
	void SetRxParent(CWnd *);

	// data processing
	void InitPortData(LPCTSTR section);
	void GetPortData();
	void SetPortData();
	void operator=(const CCommPort& dataSrc);
	virtual void  OnPendingRead();

	// port setup
	BOOL OpenConnection();
	BOOL SetupConnection();
	BOOL CloseConnection();

	// signal sending
	int WriteStr(void* str, int length);

	// signal receiving
	int ReadStr(void* str, int length);
};

/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// controlling function for the worker thread to watch for COMM events

DWORD CommWatchProc(LPVOID pParam);

#endif
