// DupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VPSync.h"
#include "DupDlg.h"
#include "syncfx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDupDlg dialog


CDupDlg::CDupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDupDlg)
	m_chkForAll = FALSE;
	m_szDupMsg = _T("");
	//}}AFX_DATA_INIT
}


void CDupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDupDlg)
	DDX_Control(pDX, IDC_PDAOVRPC, m_btnPDAOvrPC);
	DDX_Control(pDX, IDC_PCOVRPDA, m_btnPCOvrPDA);
	DDX_Control(pDX, IDC_NOSYNC, m_btnNoSync);
	DDX_Check(pDX, IDC_FOR_ALL_DUP, m_chkForAll);
	DDX_Text(pDX, IDC_DUP_STATIC, m_szDupMsg);
	DDX_Control(pDX, IDC_GRIDPC, m_gdPC);
	DDX_Control(pDX, IDC_GRIDPDA, m_gdPDA);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDupDlg, CDialog)
	//{{AFX_MSG_MAP(CDupDlg)
	ON_BN_CLICKED(IDC_NOSYNC, OnNosync)
	ON_BN_CLICKED(IDC_PCOVRPDA, OnPcOvrPda)
	ON_BN_CLICKED(IDC_PDAOVRPC, OnPdaOvrPc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDupDlg message handlers


void CDupDlg::Init()
{

   int i, j;
   m_gdPC.SetRows(total_rows);
   m_gdPC.SetCols(total_cols);
   m_gdPDA.SetRows(total_rows);
   m_gdPDA.SetCols(total_cols);
   
   for(i=0;i<total_cols;i++)
   {
	   m_gdPC.SetColWidth(i, col_width[i]);
	   m_gdPDA.SetColWidth(i, col_width[i]);
   }

   for(i=0;i<total_rows;i++)
   {
	   m_gdPC.SetRowHeight(i, row_height[i]);
	   m_gdPDA.SetRowHeight(i, row_height[i]);
   }

   SetWindowText(WndTitle);
   
   for(i=0;i<total_cols;i++)
   {
		m_gdPC.SetCol(i);
		m_gdPDA.SetCol(i);
		for(j=0;j<total_rows;j++)
		{
			m_gdPC.SetRow(j);
			m_gdPC.SetText(m_ContentPC[j][i]);
			m_gdPDA.SetRow(j);
			m_gdPDA.SetText(m_ContentPDA[j][i]);
		}
   }

}

BOOL CDupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	Result = NOT_SYNC;
	Init();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDupDlg::OnNosync() 
{
	// TODO: Add your control notification handler code here
	Result = NOT_SYNC;
	OnOK();	
}

void CDupDlg::OnPcOvrPda() 
{
	// TODO: Add your control notification handler code here
	Result = SYNC_TO_PDA;
	OnOK();
}

void CDupDlg::OnPdaOvrPc() 
{
	// TODO: Add your control notification handler code here
    Result = SYNC_TO_PC;
	OnOK();
}
 
