#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "EMail.h"
#include "EMList.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"


extern BOOL bRun;
extern BOOL recycle_pda_email;
extern int station_num;

////////////

///////////////
/////////////////
/////////////////////

//////////////////////////////
//////////////////////////////////////////////////////////////
/////////////////        E-Mail
//////////////////////////////////////////////////////////////
int CSyncDispDlg::UpdateDatabasePDAOvrPCEMail()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if (SyncDBInfo(PDA_EMDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;
	total_rec = 0;
	EMailArchivePDAOvrPC(dbid);
	CHKTERM;


	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

		if(total_rec > 10000)
		return 1;

	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{
		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		DoEvents();
//		if(DBIsExistRecord(dbCurrent, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
//			EMailMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
//		}
		PCDeleteRecord(dbRecycle, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		DoEvents();
		EMailAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}

		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += EMDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0";
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			//EMailMoveRecord(dbCurrent, dbRecycle, recid);
			PCDeleteRecord(dbCurrent, EMDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	CHKTERM;
	UpdateLastRecID(EMDB, 1000);
	return 0;

terminate:
	if(rs)
		delete rs;

	return 1;
}


int CSyncDispDlg::UpdateDatabasePCOvrPDAEMail()
{
	DatabaseID dbid;
	int total_rec; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;

	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/*
	if(sys_crashed == RESTORE_PC)
		RecIDCrashRecover(EMDB);
*/
/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EMDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	EMailArchivePCOvrPDA(dbid);
	CHKTERM;


	total_rec = 0;

	CHKTERM;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;
/* Compare all record in PC with PDA */
	if(total_rec)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(!DBIsExistRecord(dbCurrent, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   DoEvents();
	       EMailAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		   rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
		{
			continue;
		}

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDAEMailAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		  UpdateLastSyncPCRecID(EMDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += EMDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0";

	szSql += " order by RecordID DESC";

	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
		CHKTERM;
	    SyncDBUpMode();
		CHKTERM;
		while(!rs->IsEOF())
		{
			PDAEMailAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			UpdateLastSyncPCRecID(EMDB, (rs->GetFieldValue(0)).lVal);
			rs->MoveNext();
		}
	    SyncIdleMode();	
		CHKTERM;
	    SyncDBEnqMode();
		CHKTERM;
	}
		rs->Close();
	CHKTERM;

nextstate:

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	CHKTERM;

	UpdateLastRecID(EMDB, 1000);

	return 0;

terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncEMail()
{
	DatabaseID dbid;
	int total_rec;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = 0x7fffffff;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
	CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;

   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 4;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 280;
   missrec_dlg.row_height[1] = 280;
   missrec_dlg.row_height[2] = 280;
   missrec_dlg.row_height[3] = 280;

   CString str;
   str.LoadString(IDS_MODIFYDATE);
   missrec_dlg.m_Content[0][0] = str;
   str.LoadString(IDS_FIRSTNAME);
   missrec_dlg.m_Content[1][0] = str;
   str.LoadString(IDS_LASTNAME);
   missrec_dlg.m_Content[2][0] = str;
   str.LoadString(IDS_EMAILADDRESS);
   missrec_dlg.m_Content[3][0] = str;


   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 4;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 280;
   duprec_dlg.row_height[1] = 280;
   duprec_dlg.row_height[2] = 280;
   duprec_dlg.row_height[3] = 280;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_FIRSTNAME);
   duprec_dlg.m_ContentPC[1][0] = str;
   str.LoadString(IDS_LASTNAME);
   duprec_dlg.m_ContentPC[2][0] = str;
   str.LoadString(IDS_EMAILADDRESS);
   duprec_dlg.m_ContentPC[3][0] = str;


   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_FIRSTNAME);
   duprec_dlg.m_ContentPDA[1][0] = str;
   str.LoadString(IDS_LASTNAME);
   duprec_dlg.m_ContentPDA[2][0] = str;
   str.LoadString(IDS_EMAILADDRESS);
   duprec_dlg.m_ContentPDA[3][0] = str;

	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EMDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	GetLastSyncRecID(EMDB, &last_pda_recid, &last_pc_recid);
	CHKTERM;

	GetLastSyncDate(EMDB, &last_sync_date);

	EMailArchivePCPDASync(dbid);


	CHKTERM;
//todo PhoneBookGetLastSyncDate(&last_sync_date);
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 10000)
		return 1;

/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += EMDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0";
	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += EMDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSqlBoth.GetLength()-1);
		szSqlBoth += ')';

		rs_both = new CDaoRecordset(dbCurrent);
		try
		{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSqlBoth);
			rs_both =NULL;
		}
	}
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	   if(!DBIsExistRecord(dbCurrent, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
   		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			   CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  EMailAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
		  	  SyncIdleMode();	
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			   if(recycle_pda_email)
			   {
				   CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  EMailAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			   }
#endif
		   /* then delete it */
			   SyncIdleMode();
			   CHKTERM;
			   SyncDBUpMode();
			   CHKTERM;
		      PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   int action;
			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
					  rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
				   }
 				   action = missrec_act;
			   }
			   else
			   {
				      rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
					  missrec_dlg.total_rows = 4;
					  missrec_dlg.total_cols = 2;

				CString str;
				str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;

			   missrec_dlg.m_Content[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   missrec_dlg.m_Content[0][1].Remove('#');
				   
			   fielddata.Empty(); // First Name
			   PDADataGetField(0, &rec_content, &fielddata);
			   missrec_dlg.m_Content[1][1] = fielddata;

			   fielddata.Empty();  // Last Name
			   PDADataGetField(1, &rec_content, &fielddata);
			   missrec_dlg.m_Content[2][1] = fielddata;

			   fielddata.Empty(); // Address
			   PDADataGetField(2, &rec_content, &fielddata);
			   missrec_dlg.m_Content[3][1] = fielddata;

			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					   PCDeleteRecord(dbCurrent, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id);
					   PCDeleteRecord(dbRecycle, EMDB, ((RecordHeader)(record[i].rec_header)).rec_id);
					   EMailAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }  // Rec not found in PC
	}

// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
//			if((rs_pc->GetFieldValue(0)).lVal <= last_pc_recid)
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAEMailAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue(0)).lVal);	
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
			//	EMailMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
				PCDeleteRecord(dbCurrent, EMDB, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */
//				AfxMessageBox(" not implemented ");
			int action;
			if(missrec_act)
				action = missrec_act;
			else
			{
				CString str;
				str.LoadString(IDS_MISS_PDA);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PDA);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPC);
			   missrec_dlg.m_szMissLabel = str;
			  
			   missrec_dlg.m_Content[0][1] = ValidDBDate(&COleDateTime((rs_pc->GetFieldValue("MailDate"))));
			
			   missrec_dlg.m_Content[1][1] = (LPSTR)(rs_pc->GetFieldValue("Name1st")).bstrVal;
			   // from
			   missrec_dlg.m_Content[2][1] = (LPSTR)(rs_pc->GetFieldValue("Name2nd")).bstrVal;

			   // to
			   missrec_dlg.m_Content[3][1] = (LPSTR)(rs_pc->GetFieldValue("Address")).bstrVal;;


			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDAEMailAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				   break;
				   case DEL_REC:
		   			  // EMailMsgMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   PCDeleteRecord(dbCurrent, EMDB, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;

			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode(); CHKTERM;	
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}

	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode(); CHKTERM;	
	  SyncDBUpMode(); CHKTERM;
		rs_both->MoveFirst();
		while(!rs_both->IsEOF())
		{
			char found = 0;

  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
				TRACE("nnn");
				// not modi
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //EMailMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
 			  EMailAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue(1)))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
				PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDAEMailAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
//				AfxMessageBox(" not implemented ");

			   int action;
			if (abs(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(record[i].rec_header.modi_date))) > 2)
			  {

			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 	//  	              SyncIdleMode(); CHKTERM;
      //                SyncDBEnqMode(); CHKTERM;
				   }
					action = duprec_act;
			   }
			   else
			   {
				   ///////////////// prepare PDA content
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
// 	  	              SyncIdleMode(); CHKTERM;
  //                    SyncDBEnqMode(); CHKTERM;

// RTM xx = DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate"))));
// RTM yy = _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date);

				CString str;
				str.LoadString(IDS_MODIFY);
               duprec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_MODIFY);
 		       duprec_dlg.m_szDupMsg = str;

			   duprec_dlg.m_ContentPDA[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   duprec_dlg.m_ContentPDA[0][1].Remove('#');
		   	   
			   fielddata.Empty(); // Name 1st
			   PDADataGetField(0, &rec_content, &fielddata);
			   duprec_dlg.m_ContentPDA[1][1] = fielddata;

			   fielddata.Empty();  // Name 2nd
			   PDADataGetField(1, &rec_content, &fielddata);
			   duprec_dlg.m_ContentPDA[2][1] = fielddata;

			   fielddata.Empty(); // Addr
			   PDADataGetField(2, &rec_content, &fielddata);
			   duprec_dlg.m_ContentPDA[3][1] = fielddata;
             
			    ///////////////////  Prepare PC content

			   COleDateTime modi_date;
			   modi_date = ((rs_both->GetFieldValue("MailDate")));
			   if(modi_date.GetStatus() == COleDateTime::valid)
			   {
				   duprec_dlg.m_ContentPC[0][1] = COleDateTime((rs_both->GetFieldValue("MailDate"))).Format("%b %d %Y %H:%M:%S");
			   }
			   else
				   duprec_dlg.m_ContentPC[0][1] = "";
				   
			   // Name 1st
			   duprec_dlg.m_ContentPC[1][1] = (LPSTR)(rs_both->GetFieldValue("Name1st")).bstrVal;

			   duprec_dlg.m_ContentPC[2][1] = (LPSTR)(rs_both->GetFieldValue("Name2nd")).bstrVal;

			   // Addr
			   duprec_dlg.m_ContentPC[3][1] = (LPSTR)(rs_both->GetFieldValue("Address")).bstrVal;

			   duprec_dlg.DoModal();

			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDAEMailAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   break;
				   case SYNC_TO_PC:
		   			   //EMailMsgMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   PCDeleteRecord(dbCurrent, EMDB, (rs_both->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   EMailAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
			  }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}

			}
			rs_both->MoveNext();
			CHKTERM;
		}
	   rs_both->Close();			
	   SyncIdleMode();	CHKTERM;
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	DeferDeletePDACat(dbid);
	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}


	if(record)
	{
	   free(record);
	   record = NULL;
	}

	CHKTERM;

	UpdateLastRecID(EMDB, last_pda_recid);

//	SyncEmailMsg();

	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}



