#include "stdafx.h"
#include "syncdb.h"
#include "EMList.h"
#include "Email.h"
#include "TimeFct.h"
#include "All_DB.h"

CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

void ConvertPDAEmailAddrToPC(CString *addr)
{

	addr->Replace('\r', ',');
	addr->Remove('\n');
/*
	if(addr->GetLength())
		if(addr->GetAt(0) != '<')
	{
		*addr = '<' + *addr;
		addr->Replace(",", ">,<");
		if(addr->Right(2) == ",<")
			*addr = addr->Left(addr->GetLength() - 2);
	}
*/
}

void ConvertPCEmailAddrToPDA(CString *addr)
{
	/*
	addr->Remove('<');
	addr->Remove('>');
	*/
	addr->Replace(",", "\r\n");
	addr->Replace("<", " <");
	addr->Replace("  <", " <");
	addr->Replace("   <", " <");
	addr->Replace("    <", " <");
	addr->TrimLeft();
	addr->TrimRight();
}


CString EmailGetBodyFileName(RecordID rec_id)
{
	CString name;

	name.Format("%08x.txt", rec_id);

	return name;
}

CString EmailPCDate2PDA(RTM data)
{
	// convert rtm date to "19980609102152" format
	CString result,tmp;

//	if(data.year > 2037)
//		data.year = 2037;
//	if(data.year < 1973)
//		data.year = 1973;
	result = Str_ul(data.year);

	data.mon++;

	if(data.mon < 10)
		result += "0"; 
	result += Str_ul(data.mon);

	if(data.mday < 10)
		result += "0";
	result += Str_ul(data.mday);

	if(data.hour<10)
		result += "0";
	result += Str_ul(data.hour);

	if(data.min<10)
		result += "0";
	result += Str_ul(data.min);

	if(data.sec < 10)
		result += "0";
	result += Str_ul(data.sec);

//	ASSERT(result.GetLength() == 14);

	return result;
}


CString EmailPDADate2PC(CString data)
{
	// data in format "19980609102152"
	// convert to "Jun 09 1998 10:21:52"
	unsigned long u_val;
	CString year, mon, day, min, hr, sec, result;
	COleDateTime tTime;

	if(data.GetLength()>=4)
	{
		year = data.Left(4);
//		if (year > "2037")
//			year = "2037";
	}
	else
	{
		CString szDate = COleDateTime::GetCurrentTime().Format("%x %X");
		SqlDateHandle(szDate);
		return szDate;
//		return COleDateTime::GetCurrentTime().Format("%B %d %Y %H:%M:%S");
//		year = "1973";
	}

	if(data.GetLength()>=6)
	{
		mon = data.Mid(4,2);
		u_val = atol(mon);
//		if((u_val<=12) && (u_val >= 1))
//			mon = MonName[u_val-1];
//		else
//			mon = MonName[0];
		if(!((u_val<=12) && (u_val >= 1)))
			mon = "1";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateMon ");
//		mon = MonName[0];
		mon = "1";
	}

	if(data.GetLength() >= 8)
	{
		day = data.Mid(6,2);
		u_val = atol(day);
		if((u_val < 1) || (u_val > 31))
			day = "01";
	}
	else
	{
		//TRACE("\nError in PDA EmailDateDay ");
		day = "01";
	}

	if(data.GetLength() >= 10)
	{
		hr = data.Mid(8,2);
		u_val = atol(hr);
		if((u_val < 0) || (u_val > 23))
			hr = "00";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateHr ");
		hr = "00";
	}

	if(data.GetLength() >= 12)
	{
		min = data.Mid(10,2);
		u_val = atol(min);
		if((u_val<0) || (u_val>59))
			min = "00";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateMin ");
		min = "00";
	}

	if(data.GetLength() >= 14)
	{
		sec = data.Mid(12,2);
		u_val = atol(sec);
		if((u_val < 0) || (u_val > 59))
			sec = "00";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateSec ");
		sec = "00";
	}


//	result = "#";
//	result = mon + " " + day + " " + year + " " + hr + ":" + min + ":" + sec;
//	result += "#";
	tTime.SetDateTime(atoi(year),atoi(mon),atoi(day),atoi(hr),atoi(min),atoi(sec));
	result = tTime.Format("%x %X");
	SqlDateHandle(result);
//	AfxMessageBox( data + "  " + result );

	return result;

}

CString EmailPDADate2PC2(CString data)
{
	// data in format "19980609102152"
	// convert to "Jun 09 1998 10:21:52"
	unsigned long u_val;
	CString year, mon, day, min, hr, sec, result;
	COleDateTime tTime;

	if(data.GetLength()>=4)
	{
		year = data.Left(4);
//		if (year > "2037")
//			year = "2037";
	}
	else
	{
		CString szDate = COleDateTime::GetCurrentTime().Format("%m %d %Y %X");
		SqlDateHandle(szDate);
		return szDate; //sql only accept m/d/y
//		return COleDateTime::GetCurrentTime().Format("%B %d %Y %H:%M:%S");
//		year = "1973";
	}

	if(data.GetLength()>=6)
	{
		mon = data.Mid(4,2);
		u_val = atol(mon);
//		if((u_val<=12) && (u_val >= 1))
//			mon = MonName[u_val-1];
//		else
//			mon = MonName[0];
		if(!((u_val<=12) && (u_val >= 1)))
			mon = "1";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateMon ");
//		mon = MonName[0];
		mon = "1";
	}

	if(data.GetLength() >= 8)
	{
		day = data.Mid(6,2);
		u_val = atol(day);
		if((u_val < 1) || (u_val > 31))
			day = "01";
	}
	else
	{
		//TRACE("\nError in PDA EmailDateDay ");
		day = "01";
	}

	if(data.GetLength() >= 10)
	{
		hr = data.Mid(8,2);
		u_val = atol(hr);
		if((u_val < 0) || (u_val > 23))
			hr = "00";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateHr ");
		hr = "00";
	}

	if(data.GetLength() >= 12)
	{
		min = data.Mid(10,2);
		u_val = atol(min);
		if((u_val<0) || (u_val>59))
			min = "00";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateMin ");
		min = "00";
	}

	if(data.GetLength() >= 14)
	{
		sec = data.Mid(12,2);
		u_val = atol(sec);
		if((u_val < 0) || (u_val > 59))
			sec = "00";
	}
	else
	{
//		TRACE("\nError in PDA EmailDateSec ");
		sec = "00";
	}


//	result = "#";
//	result = mon + " " + day + " " + year + " " + hr + ":" + min + ":" + sec;
//	result += "#";
	tTime.SetDateTime(atoi(year),atoi(mon),atoi(day),atoi(hr),atoi(min),atoi(sec));
	result = tTime.Format("%m %d %Y %X"); //sql only accept m/d/y
	SqlDateHandle(result);
//	AfxMessageBox( data + "  " + result );

	return result;

}

BOOL AttachmentExtractFilename(CString &szData, CString &szSaveName, CString &szRealName)
{
	if(szData.IsEmpty())
		return FALSE;

	int pos = 0;

	pos = szData.Find('*');

	if (pos<0)
	{
		szData.Empty();
		return FALSE;
	}
	else
	{
		szSaveName = szData.Left(pos);
		if(szData.GetLength() == pos + 1)
			szData.Empty();
		else
			szData = szData.Mid(pos +1);

		pos = szData.Find('*');
		if(pos<0)
		{
			if(szData.GetLength())
				szRealName = szData;
			else
				return FALSE;
		}
		else
		{
			szRealName = szData.Left(pos);
			if(szData.GetLength() == pos + 1)
				szData.Empty();
			else
				szData = szData.Mid(pos +1);
		}
	}

	return TRUE;
}

BOOL EmailMsgDeleteExternFile(CDaoDatabase *db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs= NULL;

	szSql = "select Attachment from EmailMessage where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		goto skip_del_att;
	}

	if(!rs->IsBOF())
	{
		CString szSaveName, szRealName, szData;

		szData = (LPSTR) rs->GetFieldValue("Attachment").bstrVal;

		if(szData.IsEmpty())
			goto skip_del_att;		

		while(AttachmentExtractFilename(szData, szSaveName, szRealName))
		{
			DeleteFile(szUserFullPath + "Email\\" + szSaveName);
		}
	}

skip_del_att:
	if(rs)
		delete rs;

	DeleteFile(szUserFullPath + "Email\\" + EmailGetBodyFileName(rec_id));
	return TRUE;
}

BOOL EMailMsgAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{

	// Note: The secret (inbox read) flag is reversed in PDA & PC
	CString szSql;
	CString fielddata;
	int i;
	
	if (CatRec(rec_id))
		return EMailMsgAddCat(dbCurrent, rec_id, rec_header, rec_content);


	if((rec_header->total_field == 9) && (rec_header->cat == 1))  // new inbox email
	{
		PDADataGetField(8, rec_content, &fielddata);
		RemoveNULL(&fielddata);

		if(fielddata.GetLength())
		{
			CDaoRecordset *rs;

			szSql = "select RecordID from ";
			szSql += EMSGDB;
			szSql += " where MessageID = '";
			szSql += (fielddata);
			szSql += "'";

			rs = new CDaoRecordset(dbCurrent);

			try
			{
				rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nCannot exe statement: %s ", szSql);
				delete rs;
				rs = NULL;
			}

			if(rs)
				if(!rs->IsBOF())
			{
				szSql = "update ";
				szSql += EMSGDB;
				szSql += " set RecordID = ";
				szSql += Str_ul(rec_id);
				szSql += ", ModifyDate = ";
				szSql += _date322DB(rec_header->modi_date);
				szSql += ", MailDate = ";

				PDADataGetField(0, rec_content, &fielddata);  

				RemoveNULL(&fielddata);

				szSql += "#";
				szSql += EmailPDADate2PC2(fielddata);	// %x not necessary true
				szSql += "#";

				szSql += " where RecordID = ";
				szSql += Str_ul(rs->GetFieldValue("RecordID").lVal);

				try
				{
					dbCurrent->Execute(szSql);
				}
				catch(CException *e)
				{
					e->Delete();
					TRACE("\nCannot exe statement: %s ", szSql);
				}

				delete rs;

				return TRUE;
			}

			if(rs)
				delete rs;
			rs = NULL;

		}
	}

// todo handle NewRecordWithID record
	szSql = "delete from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += EMSGDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	// MailDate, format = "19980609102152" -> 1998  6  9  10   21  52
	//                                         Yr  Mon D  Hr  Min   S

	if((rec_header->cat == 4) ||
		(rec_header->cat == 2))// draft and outbox, mail date = NULL in PDA but must set to valid date for PC
	{
		rsCurrent->SetFieldValue("MailDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	}
	else
	{
		PDADataGetField(0, rec_content, &fielddata);  

		RemoveNULL(&fielddata);

		if(EmailPDADate2PC(fielddata) == "NULL")
			rsCurrent->SetFieldValueNull("MailDate");
		else
			rsCurrent->SetFieldValue("MailDate",(LPCTSTR)EmailPDADate2PC(fielddata));
	}

	PDADataGetField(1, rec_content, &fielddata);  // TimeIndex
	rsCurrent->SetFieldValue("TimeIndex",(LPCTSTR)Val_ul(fielddata));

//from
	PDADataGetField(2, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	ConvertPDAEmailAddrToPC(&fielddata);
	rsCurrent->SetFieldValue("MailFrom",(LPCTSTR)(fielddata));
//to
	PDADataGetField(3, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	ConvertPDAEmailAddrToPC(&fielddata);
	rsCurrent->SetFieldValue("MailTo",(LPCTSTR)(fielddata));
//cc
	PDADataGetField(4, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	ConvertPDAEmailAddrToPC(&fielddata);
	rsCurrent->SetFieldValue("MailCC",(LPCTSTR)(fielddata));
//bcc
	PDADataGetField(5, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	ConvertPDAEmailAddrToPC(&fielddata);
	rsCurrent->SetFieldValue("MailBCC",(LPCTSTR)(fielddata));
//subject
	PDADataGetField(6, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Subject",(LPCTSTR)(fielddata));

//body
	CString bodydata;
	CString fn;
//	fn = szUserFullPath + "Email\\" + EmailGetBodyFileName(rec_id);
	fn = EmailGetBodyFileName(rec_id);

// body, save as file
	PDADataGetField(7, rec_content, &bodydata);
	RemoveNULL(&bodydata);
	rsCurrent->SetFieldValue("Body",(LPCTSTR)(fn));

// attachment
	rsCurrent->SetFieldValue("Attachment",(LPCTSTR)"");

//messageid	
	if(rec_header->total_field == 9)
	{
		PDADataGetField(8, rec_content, &fielddata);
		RemoveNULL(&fielddata);
		if(fielddata.GetLength())
		{
			rsCurrent->SetFieldValue("MessageID",(LPCTSTR)(fielddata));
		}
		else
			rsCurrent->SetFieldValue("MessageID",(LPCTSTR)"");
	}
	else
		rsCurrent->SetFieldValue("MessageID",(LPCTSTR)"");


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	CFile fp;

	fn = szUserFullPath + "Email\\" + EmailGetBodyFileName(rec_id);

	if(fp.Open(fn, CFile::modeCreate|CFile::modeWrite|CFile::typeBinary))
	{
		fp.Write(bodydata, bodydata.GetLength());
		fp.Close();
	}
	else
		TRACE("\nEmail: cannot create output file %s", fn);

	nPDA2PC++;
	return FALSE;
}


BOOL EMailMsgMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;
	int i;
	
	if (CatRec(rec_id))
		return EMailMsgMoveCat(src_db, dest_db, rec_id);


/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += EMSGDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("MailDate");  /* MailDate */
	if(fielddata.vt == VT_NULL)
		rsCurrent->SetFieldValueNull("MailDate");
	else
	{
		szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
		rsCurrent->SetFieldValue("MailDate",(LPCTSTR)szStr);
	}

	fielddata = rs->GetFieldValue("TimeIndex");	/* TimeIndex */
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("TimeIndex",(LPCTSTR)szStr);

	for(i=7;i<14;i++)
	{
		fielddata = rs->GetFieldValue(i);
		if ((LPCSTR) fielddata.bstrVal)
			szStr = ((LPCSTR) fielddata.bstrVal);
		rsCurrent->SetFieldValue(i,(LPCTSTR)szStr);
	}

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	szSql = "delete from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return FALSE;
}



BOOL EMailMsgAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += EMSGDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("MailFrom",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return FALSE;
}



BOOL EMailMsgMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += EMSGDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("MailFrom");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("MailFrom",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	rs->Close();

	szSql = "delete from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return FALSE;
}


void EMailMsgDeletePCRecord(CDaoDatabase *db, RecordID rec_id)
{
//	EmailMsgDeleteExternFile(db, rec_id);
	PCDeleteRecord(db, EMSGDB, rec_id);
}

BOOL EMailMsgArchivePDAOvrPC(DatabaseID dbid)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
		return 1;

	for(i=0;i<total_rec;i++)
	{
	  if(((RecordHeader*)&(record[i].rec_header))->rec_id < 0x80000000)
	  {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
//		if(DBIsExistRecord(dbArchive, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
//			EMailMsgMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			EMailMsgDeletePCRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		EMailMsgAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	  }
	}

	if(record)
	   free(record);

	return 0;
}


BOOL EMailMsgArchivePCOvrPDA(DatabaseID dbid)
{ 
	return EMailMsgArchivePDAOvrPC(dbid);
}


BOOL PDAEMailMsgAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[8];
	unsigned int data32, data32_2, i ,j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += EMSGDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 8;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;
//logic of secret is reverse in PDA and PC
	if(!(rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));
	
	// MailDate, convert to format "19980609102152"
	COleDateTime modi_date;
	BOOL IsModiDateOk = TRUE;

	modi_date = rs->GetFieldValue(5);

	if(modi_date.GetStatus() == COleDateTime::valid)
	{
		fielddata = EmailPCDate2PDA(DBDate2RTM(modi_date));
		AddNULL(&fielddata);
	}
	else
		fielddata.Empty();

	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	//TimeIndex
	fielddata = Str_ul(rs->GetFieldValue(6).lVal);
	size_array[1] = fielddata.GetLength();
	data32_2 = size_array[1];
	EL32(data32_2);		// time index in PDA should be swap the HL byte
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;


	for(i=7;i<11;i++)
	{  // FORM  - BCC
		fielddata = (LPCSTR) (rs->GetFieldValue(i)).bstrVal;
		AddNULL(&fielddata);
		ConvertPCEmailAddrToPDA(&fielddata);
		size_array[i-5] = fielddata.GetLength();
		data32_2 = size_array[i-5];
//		TRACE("\nData32_2 = % d ", data32_2);
	    EnFieldSize(data32, data32_2, byte_use);
//		TRACE(" Data32  = % 08x , byte use = %d", data32, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
		  content += ptr[j];
		content += fielddata;	
	}

// Subject
		fielddata = (LPCSTR) (rs->GetFieldValue(i)).bstrVal;
		AddNULL(&fielddata);
		size_array[i-5] = fielddata.GetLength();
		data32_2 = size_array[i-5];
	    EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
		  content += ptr[j];
		content += fielddata;	

		i++;
// body
	CString fn;
	CFile fp;
	fn = szUserFullPath + "Email\\" + EmailGetBodyFileName(rec_id);

	if(fp.Open(fn, CFile::modeRead|CFile::typeBinary))
	{
		DWORD flen = fp.GetLength();
		char *buf = new char[flen + 1];
		fp.Read(buf, flen);
		buf[flen] = 0;
		fielddata = buf;  // pda need a '\0' to terminate
		delete []buf;
		fp.Close();
	}
	else
		fielddata.Empty();

		AddNULL(&fielddata);
		size_array[i-5] = fielddata.GetLength();
		data32_2 = size_array[i-5];
	    EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
		  content += ptr[j];
		content += fielddata;	

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 8, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
	}

	nPC2PDA++;

	return FALSE;
}


BOOL EMailMsgGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += EMSGDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return TRUE;
}


void EmailSetPDATimeIndex(DatabaseID dbid, unsigned int pda_timeindex[4])
{
	RecordHeader header;
	CString content, fielddata;
	unsigned int size_array[5];
	unsigned int data32, data32_2;
	unsigned short byte_use;
	char *ptr;
	int i,j;

	content.Empty();
	header.total_field = 4;
	for(i=0;i<4;i++)
	{
		fielddata.Empty();
		ptr = (char*) &pda_timeindex[i];
		ptr+=3;
		for(j=0;j<4;j++)
			fielddata += *(ptr--);

		size_array[i] = 4;
		data32_2 = size_array[i];
	    EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;
	}

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncIdleMode();CHKTERM;
	SyncDBUpMode();CHKTERM;
	PDADeleteRecord(dbid, TIME_INDEX_RECID);
	SyncRecAdd(dbid, TIME_INDEX_RECID, 4, size_array, &header, &content);
	SyncIdleMode();CHKTERM;
	SyncDBEnqMode();CHKTERM;
terminate:
	return;
}


BOOL EMailUpdateTimeIndex(DatabaseID dbid)
{
  /* current PDA stauts is in DBEnq Mode */
	char rec_header[RECHEADER_SIZE + 10];
	CString rec_content;
	unsigned int pda_timeindex[4];
	CString fielddata;
	char *ptr;
	int i;

 	if(SyncReadRec(dbid, TIME_INDEX_RECID, (char*)&rec_header, &rec_content) != 0)
		return TRUE;

	for(i=0;i<4;i++)
	{
		if (PDADataGetField(i, &rec_content, &fielddata) != 0)
		{
			pda_timeindex[i] = 0;
			if(fielddata.GetLength() == 4)
			{
				ptr = (char*) &pda_timeindex[i];
				for(int j =0;j<4;j++)
					ptr[j] = fielddata[3-j];
			}
			else
				return 1;
		}
		else
			return 1;
	}

	CString szSql;
	CDaoRecordset *rs = NULL;
	long diff;
	unsigned long lastsync_value;
	unsigned long newpc_value;
	COleVariant dbdata;
		
	szSql = "select EMailLastSyncSent,EMailLastSyncOutbox, EMailLastSyncDraft, EMailNewPCSent, EMailNewPCOutbox, EMailNewPCDraft from ApplicationDB where DatabaseName = '";
	szSql += EMSGDB;
	szSql += "'" ;

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	if(rs->IsBOF())
	{
		delete rs;
		return TRUE;
	}

	/* 1. Sent Folder */
	rs->GetFieldValue("EMailLastSyncSent", dbdata);
	lastsync_value = dbdata.lVal;
	rs->GetFieldValue("EMailNewPCSent", dbdata);
	newpc_value = dbdata.lVal;

	diff = pda_timeindex[SENT] - lastsync_value;
	
	if(diff > 0)  /* pda add some record */
	{
		/* update PC index */
		szSql = "update ";
		szSql += EMSGDB;
		szSql += " set TimeIndex = TimeIndex + ";
		szSql += Str_ul(diff);
		szSql += " where TimeIndex > ";
		szSql += Str_ul(lastsync_value);
		szSql += " and Category = ";
		szSql += Str_ul(SENT + 1);
		try
		{
			dbCurrent->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			if(rs)
			{
				rs->Close();
				delete rs;
			}
			return TRUE;
		}
		try
		{
			dbArchive->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			/* prog continue even cannot update arch. db */
		}

		pda_timeindex[SENT] = newpc_value + diff;

		szSql = "update ApplicationDB set EMailNewPCSent = ";
		szSql += Str_ul(pda_timeindex[SENT]);
		szSql += ", EmailLastSyncSent = ";
		szSql += Str_ul(pda_timeindex[SENT]);
		szSql += " where DatabaseName = '";
		szSql += EMSGDB;
		szSql += "'";
		try
		{
			dbAppDB->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			if(rs)
			{
				rs->Close();
				delete rs;
			}
			return TRUE;
		}
	}
	

	/* 2. Outbox Folder */
	rs->GetFieldValue("EMailLastSyncOutbox", dbdata);
	lastsync_value = dbdata.lVal;
	rs->GetFieldValue("EMailNewPCOutbox", dbdata);
	newpc_value = dbdata.lVal;

	diff = pda_timeindex[OUTBOX] - lastsync_value;
	
	if(diff > 0)  /* pda add some record */
	{
		/* update PC index */
		szSql = "update ";
		szSql += EMSGDB;
		szSql += " set TimeIndex = TimeIndex + ";
		szSql += Str_ul(diff);
		szSql += " where TimeIndex > ";
		szSql += Str_ul(lastsync_value);
		szSql += " and Category = ";
		szSql += Str_ul(OUTBOX + 1);
		try
		{
			dbCurrent->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			if(rs)
			{
				rs->Close();
				delete rs;
			}
			return TRUE;
		}
		try
		{
			dbArchive->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			/* prog continue even cannot update arch. db */
		}

		pda_timeindex[OUTBOX] = newpc_value + diff;

		szSql = "update ApplicationDB set EMailNewPCOutbox = ";
		szSql += Str_ul(pda_timeindex[OUTBOX]);
		szSql += ", EmailLastSyncOutbox = ";
		szSql += Str_ul(pda_timeindex[OUTBOX]);
		szSql += " where DatabaseName = '";
		szSql += EMSGDB;
		szSql += "'";
		try
		{
			dbAppDB->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			if(rs)
			{
				rs->Close();
				delete rs;
			}
			return TRUE;
		}
	}

	/* 3. Draft Folder */
	rs->GetFieldValue("EMailLastSyncDraft", dbdata);
	lastsync_value = dbdata.lVal;
	rs->GetFieldValue("EMailNewPCDraft", dbdata);
	newpc_value = dbdata.lVal;

	diff = pda_timeindex[DRAFT] - lastsync_value;
	
	if(diff > 0)  /* pda add some record */
	{
		/* update PC index */
		szSql = "update ";
		szSql += EMSGDB;
		szSql += " set TimeIndex = TimeIndex + ";
		szSql += Str_ul(diff);
		szSql += " where TimeIndex > ";
		szSql += Str_ul(lastsync_value);
		szSql += " and Category = ";
		szSql += Str_ul(DRAFT + 1);
		try
		{
			dbCurrent->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			if(rs)
			{
				rs->Close();
				delete rs;
			}
			return TRUE;
		}
		try
		{
			dbArchive->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			/* prog continue even cannot update arch. db */
		}

		pda_timeindex[DRAFT] = newpc_value + diff;

		szSql = "update ApplicationDB set EMailNewPCDraft = ";
		szSql += Str_ul(pda_timeindex[DRAFT]);
		szSql += ", EmailLastSyncDraft = ";
		szSql += Str_ul(pda_timeindex[DRAFT]);
		szSql += " where DatabaseName = '";
		szSql += EMSGDB;
		szSql += "'";
		try
		{
			dbAppDB->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			if(rs)
			{
			rs->Close();
			delete rs;
			}
			return TRUE;
		}
	}

	EmailSetPDATimeIndex(dbid, pda_timeindex);

	if(rs)
	{
		rs->Close();
		delete rs;
	}

	return FALSE;
}


void EMailMsgIDAddRecord(RecordID rec_id, RecordHeader *rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;

	PDADataGetField(0, rec_content, &fielddata);

	RemoveNULL(&fielddata);
	if(!fielddata.GetLength())
		return;

//	CString szDate = COleDateTime::GetCurrentTime().Format("#%x %X#");
	CString szDate = COleDateTime::GetCurrentTime().Format("#%m %d %Y %X#"); //sql only accept m/d/Y
	SqlDateHandle(szDate);
	szSql = "insert into ";
	szSql += EMSIDDB;
	szSql += " (ModifyDate, MessageID) values (";
	szSql += szDate;
	szSql += ",'";
	szSql += ExamSql(fielddata);
	szSql += "')";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}
}



void PDAEMailMsgIDAddRecord(DatabaseID dbid, RecordID rec_id, CString data)
{
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[8];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime::GetCurrentTime()));
	header.total_field = 1;
	header.cat = 0;
    header.attribute = 0;

	// Notes
	size_array[0] = data.GetLength();
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += data;

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 1, size_array, &header, &content);
	
term:

	return;

}



void SyncEmailMsg()
{				  
	DatabaseID dbid;
	CString dbheader;
	RecStruct *record = NULL;
	int i;
	RTM last_sync_date;
	CString rec_content;
	CDaoRecordset *rs = NULL;
	CString szSql;
	int total_rec;
	int pc_default;
	CString szDate;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID next_rec_id = pc_default;

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EMSIDDB, &dbid, &dbheader))   /* get dbid of phone book */
		return;

	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return;		// error
	if (total_rec > 12000)
		return;

	for(i=0;i<total_rec; i++)
	{
		if ((record[i].rec_header.rec_id > 0x3fffffff) &&
			(record[i].rec_header.rec_id < next_rec_id))
			next_rec_id = record[i].rec_header.rec_id - 2;
	}
			 
	GetLastSyncDate("Install", &last_sync_date);

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{
		 if(TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME)
		 {
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	CHKTERM;
			  SyncDBUpMode(); CHKTERM;
			  //EMailMsgMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  EMailMsgIDAddRecord(((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
		 }
		}
	}

	szSql = "select * from EMailMessageID where ModifyDate > ";
	szSql += 	_date322DB(_rtm2date32(last_sync_date));

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	SyncIdleMode();
	SyncDBUpMode();
	if(rs)
	if(!rs->IsBOF())
	{
		while(!rs->IsEOF())
		{
		   CString data;
		   data = (LPSTR) rs->GetFieldValue("MessageID").bstrVal;
		   if(data.GetLength())
			  PDAEMailMsgIDAddRecord(dbid, next_rec_id--, data);
		   CHKTERM;
		   rs->MoveNext();
		}
	}
	SyncIdleMode();
		
	UpdateLastSyncDate("Install");

//	szDate = COleDateTime::GetCurrentTime().Format("#%x %X#");
	szDate = COleDateTime::GetCurrentTime().Format("#%m %d %Y %X#"); //sql only accept m/d/y
	SqlDateHandle(szDate);
	szSql = "update EMailMessageID set ModifyDate = ";
	szSql += szDate;
	szSql += " where ModifyDate > ";
	szSql += szDate;

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}


terminate:
	if(rs)
		delete rs;
}
