#include "stdafx.h"
#include "stdafx.h"
#include "VPSync.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "Expense.h"

//#define EXP_RECID_BASE 536870910

extern BOOL bRun;
extern int station_num;

int CSyncDispDlg::UpdateDatabasePDAOvrPCExpense()
{
	DatabaseID dbid;
	RecordID recid;
//	RecordID undelete_recid = 900;
	int total_rec=0, total_arc_rec=0;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *norm_record = NULL;
	RecStruct *arc_rec = NULL;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;


	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_EXPDB, &dbid, &dbheader) != 0)   /* get dbid of exp */
		return 1;

	ExpenseArchivePDAOvrPC(dbid);
	CHKTERM;

	ExpensenConstructCurr(dbid);
	CHKTERM;

	
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&norm_record))
		return 1;		// error

	total_arc_rec = 0;
//	if(SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_rec))
//		return 1;

	record = (RecStruct*) malloc( sizeof(RecStruct) * (total_rec + total_arc_rec));

	for(i=0;i<total_rec;i++)
		record[i] = norm_record[i];
	for(i=0;i<total_arc_rec;i++)
		record[total_rec + i] = arc_rec[i];
	if(total_rec)
		free(norm_record);
	if(total_arc_rec)
		free(arc_rec);

	total_rec += total_arc_rec;

	CHKTERM;

	ExpenseDeleteInvalidCat();

	if(total_rec > 12000)
		return 1;

/*	if(total_rec)
	{
		undelete_recid = ExpenseGetUndeleteRecordID(dbid);
		CHKTERM;
		ExpenseRestoreUndeleteRecID(undelete_recid, record, total_rec);
	}
*/
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{
		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);

		DoEvents();
		PCDeleteRecord(dbRecycle, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		ExpenseAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += EXPDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			PCDeleteRecord(dbCurrent, EXPDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();

		ExpenseDeleteInvalidCat();
		SetPCDBCatNum();
		DeferDeletePDACat(dbid);
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);
//	ExpenseSetUndeleteRecID(undelete_recid);
UpdateLastRecID(EXPDB, 1000);
	return 0;

terminate:
	if(rs)
		delete rs;
	SetPCDBCatNum();

//	ExpenseSetUndeleteRecID(undelete_recid);

	return 1;
}


int CSyncDispDlg::UpdateDatabasePCOvrPDAExpense()
{
	DatabaseID dbid;
	int total_rec=0, total_arc_rec=0; 
//	RecordID undelete_recid = 900;
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL, *norm_record = NULL, *arc_rec = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
	CHKTERM;
/*
	if(sys_crashed == RESTORE_PC)
		ExpRecIDCrashRecover();
*/
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();

	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EXPDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	ExpenseArchivePCOvrPDA(dbid);
	CHKTERM;

	ExpensenConstructCurr(dbid);
	CHKTERM;


	total_rec = 0;

	CHKTERM;

	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&norm_record))
		return 1;		// error


	total_arc_rec = 0;
//	if(SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_rec))
//		return 1;

	record = (RecStruct*) malloc( sizeof(RecStruct) * (total_rec + total_arc_rec));

	for(i=0;i<total_rec;i++)
		record[i] = norm_record[i];
	for(i=0;i<total_arc_rec;i++)
		record[total_rec + i] = arc_rec[i];
	if(total_rec)
		free(norm_record);
	if(total_arc_rec)
		free(arc_rec);

	ExpenseDeleteInvalidCat();

	total_rec += total_arc_rec;

	CHKTERM;

	if(total_rec > 10000)
		return 1;

/*	if(total_rec)
	{
		undelete_recid = ExpenseGetUndeleteRecordID(dbid);
		CHKTERM;
		ExpenseRestoreUndeleteRecID(undelete_recid, record, total_rec);
	}
*/

/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       ExpenseAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDAExpenseAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
//		  UpdateLastSyncPCRecIDExp(EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		  UpdateLastSyncPCRecID(EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += EXPDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat

	szSql += " order by RecordID DESC";

	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDAExpenseAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			(EXPDB, (rs->GetFieldValue(0)).lVal);
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

	ExpenseDeleteInvalidCat();
	SetPCDBCatNum();
		DeferDeletePDACat(dbid);

nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

//	ExpenseSetUndeleteRecID(undelete_recid);
UpdateLastRecID(EXPDB, 1000);
	CHKTERM;
	return 0;

terminate:
	if(rs)
		delete rs;
	SetPCDBCatNum();

//	ExpenseSetUndeleteRecID(undelete_recid);

	return 1;
}


int CSyncDispDlg::UpdateDatabasePCPDASyncExpense()
{
	DatabaseID dbid;
	int total_rec = 0, total_arc_rec = 0;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
//	RecordID undelete_recid = 900;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RecStruct *norm_record = NULL, *arc_rec = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EXPDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	ExpenseArchivePCPDASync(dbid);
	CHKTERM;

	ExpensenConstructCurr(dbid);
	CHKTERM;

	GetLastSyncRecID(EXPDB, &last_pda_recid, &last_pc_recid);
	CHKTERM;
    GetLastSyncDate(EXPDB, &last_sync_date);
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&norm_record))
		return 1;		// error


	total_arc_rec = 0;
//	if(SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_rec))
//		return 1;
//

	record = (RecStruct*) malloc( sizeof(RecStruct) * (total_rec + total_arc_rec));

	for(i=0;i<total_rec;i++)
		record[i] = norm_record[i];
	for(i=0;i<total_arc_rec;i++)
		record[total_rec + i] = arc_rec[i];
	if(total_rec)
		free(norm_record);
	if(total_arc_rec)
		free(arc_rec);

	total_rec += total_arc_rec;

	if (total_rec > 12000)
		return 1;

	ExpenseDeleteInvalidCat();

/*	if(total_rec)
	{
		undelete_recid = ExpenseGetUndeleteRecordID(dbid);
		CHKTERM;
		ExpenseRestoreUndeleteRecID(undelete_recid, record, total_rec);
	}
*/
/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += EXPDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, not condiser cat

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += EXPDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}

	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
//		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < EXP_RECID_BASE))
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  ExpenseAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			  rec_content.Empty();
	          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
	          CHKTERM;
		      ExpenseAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }

		}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
//			if((rs_pc->GetFieldValue(0)).lVal <= last_pc_recid)
			if( (rs_pc->GetFieldValue(0)).lVal > last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAExpenseAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
			//	ExpenseMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
				PCDeleteRecord(dbCurrent, EXPDB, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */		
	  		   SyncIdleMode();
	           CHKTERM;
               SyncDBUpMode();
	           CHKTERM;
			   PDAExpenseAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
		   }
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //ExpenseMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  PCDeleteRecord(dbCurrent, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			  ExpenseAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDAExpenseAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA */
				/* compare the date, sync most update record */
			int action = NOT_SYNC;

			if(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date)) <= 0)
			{
				action = SYNC_TO_PC;
				SyncIdleMode();
				SyncDBEnqMode();
		         SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			}
			else
			{
				action = SYNC_TO_PDA;
			}

			switch(action)
			{  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDAExpenseAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   break;
				   case SYNC_TO_PC:
		   		//	   ExpenseMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   PCDeleteRecord(dbCurrent, EXPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
					   CHKTERM;
					   ExpenseAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			} // if
			rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;

//			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
//				&& ((((RecordHeader)(record[i].rec_header)).rec_id < EXP_RECID_BASE))
//				)
//				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}

	if(record)
	{
	   free(record);
	   record = NULL;
	}

	UpdateLastRecID(EXPDB, last_pda_recid);

	ExpenseDeleteInvalidCat();
	SetPCDBCatNum();
	DeferDeletePDACat(dbid);
//	ExpenseSetUndeleteRecID(undelete_recid);
	
	return 0;
terminate:
//	ExpenseSetUndeleteRecID(undelete_recid);

	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);
SetPCDBCatNum();
	return 1;
}


