#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "Expense.h"


CString temp_d_result;
extern int nPDA2PC;
extern int nPC2PDA;

CString Str_d(double d_value)
{
   int  decimal, sign;
   char *buffer;
   buffer = _fcvt( d_value, 2, &decimal, &sign );
   temp_d_result = buffer;
   lconv*  details = localeconv();
   if(decimal && (decimal < strlen(buffer)))
   {
//	   temp_d_result = temp_d_result.Left(decimal) + (CString) '.' +
	   temp_d_result = temp_d_result.Left(decimal) + (CString) details->decimal_point +
       temp_d_result.Right(strlen(buffer) - decimal);
   }
   else
	   temp_d_result = (CString) "0." + temp_d_result;

   return temp_d_result;

}

typedef struct
{
	char	yr;
	char	mon;
	char	day;
	char	hr;
	char	min;
	char    sec;
} EXP_DATE;

CString ExpensePDADate2PC(CString date)
{
	// date: BYTE 0: Year relative to DATE_OFFSET, BYTE 1: M, BYTE 2: D 
	//       BYTE 3: Hr  BYTE 4: Min
	COleDateTime dtime;
	
	if(date.GetLength() < 6)
	{
		TRACE("\nError in ExpRecord Date");
		dtime.GetCurrentTime();
        return dtime.Format("%x %X");
//        return dtime.Format("%B %d %Y %H:%M:%S");
	}

	if(date[1] < 1) date.SetAt(1,1); //mon
	else if(date[1] > 12) date.SetAt(1,12);
	if(date[2] < 1) date.SetAt(2,1); //day
	else if(date[2] > 31) date.SetAt(2,31);
	if(date[3] > 23) date.SetAt(3,23); //hr
	if(date[4] > 59) date.SetAt(4,59);  // min
//	if(date[0] < (1970 - DATE_OFFSET))  // PC need time at least at 1970
//		date.SetAt(0, 1970 - DATE_OFFSET);
//	else if(date[0] + DATE_OFFSET > (2036))		// PC need time before 2036
//		date.SetAt(0, 2035 - DATE_OFFSET);
	if((unsigned char) date[5] > 59)
		date.SetAt(5,0);

	COleDateTime time1(date[0]+DATE_OFFSET, date[1], date[2], date[3], date[4], date[5]);

	CString szDate = time1.Format("%x %X");
	SqlDateHandle(szDate);
	return szDate;
//	return time1.Format("%B %d %Y %H:%M:%S");
}

CString ExpensePCDate2PDA(COleDateTime date)
{
	CString time1;
	
	time1 = (char) (date.GetYear() - DATE_OFFSET);
	time1 += (char) date.GetMonth();
	time1 += (char) date.GetDay();
	time1 += (char) date.GetHour();
	time1 += (char) date.GetMinute();
	time1 += (char) date.GetSecond();

	return time1;
}


BOOL ExpenseAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	double amt;
	int i;
	CDaoRecordset *pRs = NULL;
	CString cat_name;
	int nCurrency = 25;


	PDADataGetField(1, rec_content, &fielddata);  // incompeleted entry in PDA
	if(fielddata.GetLength())
		if( (int)fielddata[0] == 100)
			return TRUE;

	szSql = "delete from ";
	szSql += EXPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	szSql = "select CategoryName from Expense where RecordID = ";
	szSql += Str_ul(rec_header->cat + 0x80000000);
	
	pRs = new CDaoRecordset(dbCurrent);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete pRs;
		pRs = NULL;
	}

	cat_name = "Unfiled";
	if(pRs)
	{
		if(!pRs->IsBOF())
			cat_name = (LPSTR) pRs->GetFieldValue(0).bstrVal;
		delete pRs;
		pRs = NULL;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += EXPDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	if(rec_id < 0x80000000)
	{
		PDADataGetField(0, rec_content, &fielddata);  // date
		if(ExpensePDADate2PC(fielddata) == "NULL")
			rsCurrent->SetFieldValueNull("ExpenseDate");
		else
			rsCurrent->SetFieldValue("ExpenseDate",(LPCTSTR)ExpensePDADate2PC(fielddata));

		PDADataGetField(1, rec_content, &fielddata);  // type
		rsCurrent->SetFieldValue("Type",(LPCTSTR)Val_ul(fielddata));
//		if(fielddata.GetLength())
//			szSql += Str_ul(fielddata[0]);
//		else
//			szSql += "27";  // type = 'other'

		PDADataGetField(2, rec_content, &fielddata); // amt
		if(fielddata.GetLength() == sizeof(double))
		{
			char *p = (char*) &amt;
			for(i=0;i<sizeof(double);i++)
				p[i] = fielddata[i];
			rsCurrent->SetFieldValue("Amt",(LPCTSTR)Str_d(amt));
		}
		else
			rsCurrent->SetFieldValue("Amt",(LPCTSTR)"0.0");

		rsCurrent->SetFieldValue("CategoryName",(LPCTSTR)(cat_name));

//////////////get the currency from the virtual 'expensecurrency' table
		CString szCurrency;
		szCurrency = "Select * from ExpenseCurrency where CatNum = ";
		szCurrency += Str_ul( (unsigned int) (rec_header->cat));
		
		CDaoRecordset* rsTemp = NULL;
		rsTemp = new CDaoRecordset(dbCurrent);

		try
		{
			rsTemp->Open(dbOpenSnapshot, szCurrency, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nCannot exe statement: %s ", szSql);
			delete rsTemp;
			rsTemp = NULL;
		}
		if(!rsTemp->IsBOF())
			nCurrency = rsTemp->GetFieldValue("CurNum").lVal;
		else
			nCurrency = 25;

		rsCurrent->SetFieldValue("Currencies",(LPCTSTR)Str_ul(nCurrency));

		delete rsTemp;
		rsTemp = NULL;
/////////////////////////////////////////////////////////////////////////
	}
	else if(rec_id < 0x800000ff)
	{
		return FALSE;
	}


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

//////////////////////update all record currencies at last;
/*	szSql = "Update Expense set currencies = ";
	szSql += Str_ul(nCurrency);
	szSql += " where category = ";
	szSql += Str_ul( (unsigned int) (rec_header->cat));

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}
*////////////////////////////////////////////////////////////////////
	nPDA2PC++;

	return FALSE;
}


BOOL PDAExpenseAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[30];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += EXPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		header.rec_id = rec_id;
		header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
		header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
	    header.attribute = 0;
		if((rs->GetFieldValue(3)).boolVal)
			SetRecSecret(((RecordHeader*)&header));
		if((rs->GetFieldValue(4)).boolVal)
			SetRecLock(((RecordHeader*)&header));

		if(rec_id < 0x80000000)
		{
		/* encode the record into PDA data format */
			header.total_field = 3;
		    fielddata = ExpensePCDate2PDA(COleDateTime((rs->GetFieldValue("ExpenseDate"))));
			size_array[0] = fielddata.GetLength();
			data32_2 = size_array[0];
		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  content += ptr[j];
			content += fielddata;

//		    char exp_type = (char) (rs->GetFieldValue("Type")).lVal;
			size_array[1] = 4;
			data32_2 = size_array[1];
		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  content += ptr[j];
//			content += exp_type;
			unsigned int exp_type = rs->GetFieldValue("Type").lVal;

			ptr = (char*) &exp_type;
			content += ptr[0];
			content += ptr[1];
			content += ptr[2];
			content += ptr[3];

		    double exp_amt = (rs->GetFieldValue("Amt")).dblVal;
			char *p = (char*) &exp_amt;
			size_array[2] = sizeof(double);
			data32_2 = size_array[2];
		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  content += ptr[j];
			for(j=0;j<sizeof(double);j++)
			  content += p[j];

			header.size = content.GetLength();
			if((header.size) % 4)
				header.size += 4 - (header.size) % 4;
			SyncRecAdd(dbid, rec_id, 3, size_array, &header, &content);
		}
		else //cat
		{
/*
			header.total_field = 1;
		    fielddata = (LPSTR) (rs->GetFieldValue("CategoryName")).bstrVal;
			AddNULL(&fielddata);
			size_array[0] = fielddata.GetLength();
			data32_2 = size_array[0];
		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  content += ptr[j];
			content += fielddata;

			header.size = content.GetLength();
			if((header.size) % 4)
				header.size += 4 - (header.size) % 4;

			SyncRecAdd(dbid, rec_id, 1, size_array, &header, &content);
*/
		}
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return TRUE;
}


void ExpenseDeleteInvalidCat()
{
	CString szSql;

	szSql = "delete from ";
	szSql += EXPDB;
	szSql += " where RecordID < 0 and CategoryName = '' ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return;
	}
}


int ExpensenConstructCurr(DatabaseID dbid)
{
#define NUM_CAT	50  // 0 - 49
#define NUM_CUR 25  // 0 - 25
#define CAT_REC_ID	0x80001000
#define EXPCURDB    "ExpenseCurrency"
#define NONE_CUR		25
	
	RecordHeader header;
	CString content, fielddata;
	CString szSql;
	RTM last_sync_date;
	CDaoRecordset *rs = NULL;
	int cat_num, cur_num;
	unsigned int size_array[NUM_CAT];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;
	int i;

	unsigned char cat_cur[NUM_CAT];


	if(SyncReadRec(dbid, CAT_REC_ID , (char*)&header, &content))
	{
		// record missing, need to re-construct and sync to PDA
		for(i=0;i<NUM_CAT;i++)
			cat_cur[i] = NUM_CUR;

	}
	else
	{
	for(i=0;i<NUM_CAT;i++)
	{
		if(PDADataGetField(i, &content, &fielddata))
		{
			if( (unsigned char) fielddata[0] < NUM_CUR)
				cat_cur[i] = (unsigned char) fielddata[0];
			else
				cat_cur[i] = NUM_CUR;  // none curr
		}
		else
			cat_cur[i] = NUM_CUR;  // none curr
	}
	}

	GetLastSyncDate(EXPDB, &last_sync_date);
///////////////////build a virtual table for sync only;
/*	CString szTemp;
	COleDateTime tModify;
	szTemp = "Select max(ModifyDate), distinct Category,Currencies from Expense";
	CDaoRecordset* rsCurrency = NULL;
	rsCurrency = new CDaoRecordset(dbCurrent);

	try
	{
		rsCurrency->Open(dbOpenSnapshot, szTemp, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szTemp);
		delete rsCurrency;
		return 1;
	}

	if(!rsCurrency->IsBOF())
	{
		while(!rsCurrency->IsEOF())
		{
			tModify = rsCurrency->GetFieldValue("ModifyDate");
			szTemp = "Update ExpenseCurrency set CurNum = ";
			szTemp += Str_ul(rsCurrency->GetFieldValue("Currencies").lVal);
			szTemp += "And ModifyDate = # ";
			szTemp += tModify.Format("%x %X");
			szTemp += " #";
			szTemp += " where CatNum = ";
			szTemp += Str_ul(rsCurrency->GetFieldValue("Category").lVal);
			dbCurrent->Execute(szTemp);
			
			rsCurrency->MoveNext();
		}
	}

	delete rsCurrency;
	rsCurrency = NULL;*/
///////////////////////////////////////////////////////////
	szSql = "select CatNum, CurNum from ExpenseCurrency where ModifyDate > ";
	szSql += 	_date322DB(_rtm2date32(last_sync_date));
	szSql += " and CatNum >= 0 and CatNum < ";
	szSql += Str_ul(NUM_CAT);
	szSql += " and CurNum >= 0 and CurNum <= ";
	szSql += Str_ul(NUM_CUR);
	szSql += " and CurNum <> ";
	szSql += Str_ul(NONE_CUR);


	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return 1;
	}

	if(!rs->IsBOF())
	{
		while(!rs->IsEOF())
		{
			cat_num = rs->GetFieldValue("CatNum").lVal;
			cur_num = rs->GetFieldValue("CurNum").lVal;

			cat_cur[cat_num] = cur_num;
			rs->MoveNext();
		}
	}

	content.Empty();
	fielddata = ' ';
	header.total_field = NUM_CAT;
	for(i=0;i<NUM_CAT;i++)
	{
		fielddata.SetAt(0,cat_cur[i]);
		size_array[i] = 1;
		data32_2 = size_array[i];
	    EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;
	}

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncIdleMode();CHKTERM;
	SyncDBUpMode();CHKTERM;
	PDADeleteRecord(dbid, CAT_REC_ID);
	if(SyncRecAdd(dbid, CAT_REC_ID, NUM_CAT, size_array, &header, &content))
	{
		delete rs;
		return 1;
	}
	SyncIdleMode();CHKTERM;
	SyncDBEnqMode();CHKTERM;


	szSql = "delete * from ";
	szSql += EXPCURDB;

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}

	for(i=0;i<NUM_CAT;i++)
	{
//		CString szDate = COleDateTime::GetCurrentTime().Format("#%x %X#");
		CString szDate = COleDateTime::GetCurrentTime().Format("#%m %d %Y %X#"); //sql only accept m/d/y
		SqlDateHandle(szDate);
		szSql = "insert into ";
		szSql += EXPCURDB;
		szSql += " (RecordID, ModifyDate, Category, Secret, Lock, CatNum, CurNum) values (";
		szSql += "0 , ";
		szSql += szDate;
		szSql += ", ";
		szSql += Str_ul(i);
		szSql += ", 0, 0, ";
		szSql += Str_ul(i);
		szSql += ",";
		szSql += Str_ul(cat_cur[i]);
		szSql += ")";

		try
		{
			dbCurrent->Execute(szSql);
		}
		catch(CException *e)
		{
			e->Delete();
		}
	}
terminate:
	delete rs;
	return 0;
}


BOOL ExpenseArchive(DatabaseID dbid, int mode)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	RecStruct *cat_record = NULL;
	int total_cat = 0;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	cat_record = (RecStruct*)malloc(300 * sizeof(RecStruct));

	for(i=0;i<total_rec;i++)  // process non-category item
	{
	  if(((RecordHeader*)&(record[i].rec_header))->rec_id < (RecordID) 0x80000000)
	  {
		  continue;
	  }
	  else
		  if(CatRec(record[i].rec_header.rec_id ))

//	  if(((RecordHeader*)&(record[i].rec_header))->rec_id < 0x80000100)
	  {
		//category
		   cat_record[total_cat++] = record[i];
	  }
	}

	SyncUpdateCat((CString)EXPDB, (CString)EXP_CAT_FIELD_NAME, dbid, cat_record, total_cat, mode);

	if(record)
	   free(record);
	if(cat_record)
		free(cat_record);

	return 0;
}


BOOL ExpenseArchivePCOvrPDA(DatabaseID dbid)
{ 
	if(sys_crashed == RESTORE_PC)
		return ExpenseArchive(dbid, CAT_PC_PDA_RESTORE);
	else		
		return ExpenseArchive(dbid, CAT_PC_OVR_PDA);
}

BOOL ExpenseArchivePDAOvrPC(DatabaseID dbid)
{ 
	return ExpenseArchive(dbid, CAT_PDA_OVR_PC);
}

BOOL ExpenseArchivePCPDASync(DatabaseID dbid)
{
	return ExpenseArchive(dbid, CAT_PC_PDA_SYNC);
}


void SetPCDBCatNum()
{
	CString szSql;

	szSql = "update Expense set Category = RecordID - ";
	szSql += Str_ul(0x80000000);
	szSql += " where RecordID between ";
	szSql += Str_ul(0x80000000);
	szSql += " and  ";
	szSql += Str_ul(0x80000000 + NUM_CAT);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}

}


RecordID ExpenseGetUndeleteRecordID(DatabaseID dbid)
{
#define EXP_APPSAVE_RECID	 0x80001002
#define UNDELETE_RECID_FIELD 8

	CString content, fielddata;
	RecordID result = 0;
	char p[4];
	RecordHeader header;

	if(SyncReadRec(dbid, EXP_APPSAVE_RECID , (char*)&header, &content))
	{	
		return result ; /* record miss */
	}

	if(PDADataGetField(UNDELETE_RECID_FIELD, &content, &fielddata) == 4)
	{
		/* field size = 4 */
		p[0] = fielddata[0];
		p[1] = fielddata[1];
		p[2] = fielddata[2];
		p[3] = fielddata[3];

		result = *(RecordID*)p;
	}

	return result;

}


void ExpenseRestoreUndeleteRecID(RecordID rec_id, RecStruct *record, int total_rec)
{
/* if undelete recid in PDA != PC
       => if undel recid in PC is in PDA
	         => rec has been undeleted, restore it from PC
	   => if undel recid in PC is not in PDA
	         => rec has been deleted, delete it from PC
*/
	CString szSql;
	CDaoRecordset *rs = NULL;
	RecordID pc_recid;
	int i;
	BOOL undel = 0;

	if((rec_id < 1000) || (rec_id > (RecordID) 0x7fffffff))
		if(rec_id != 0x80001200)  /* = 0x80001200 => no undel rec in PDA */
			return;  /* should % 1000 - 0x7fffffff */
		else
			rec_id = 999;

	szSql = "select 1 from ";
	szSql += EXPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul( rec_id + (RecordID) 0x80000000);
	
	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return;
	}

	if(!rs->IsBOF())
	{
		delete rs;  /* undelete recid is same as PDA */
		return;
	}

	delete rs;
	rs = NULL;

	szSql = "select RecordID from ";
	szSql += EXPDB;
	szSql += " where RecordID < 0 ";
	szSql += " and RecordID > ";
	szSql += Str_ul(0x80000033);

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return;
	}

	if(rs->IsBOF())
	{
		delete rs;  /* no undelete rec in PC */
		return;
	}

	pc_recid = rs->GetFieldValue("RecordID").lVal + 0x80000000;

	delete rs;
	rs = NULL;

	for(i=0;i<total_rec;i++)
	{
		if(record[i].rec_header.rec_id == pc_recid)
		{
			undel = 1;
			break;
		}
	}

	if(undel)
	{
		/* record has been undel in PDA */
		szSql = "update ";
		szSql += EXPDB;
		szSql += " set RecordID = ";
		szSql += Str_ul(pc_recid);
		szSql += ", CategoryName = '' ";
		szSql += " where RecordID = ";
		szSql += Str_ul(pc_recid + 0x80000000);
	}
	else
	{
		/* record has been del in PDA */
		szSql = "delete * from ";
		szSql += EXPDB;
		szSql += " where RecordID = ";
		szSql += Str_ul(pc_recid + 0x80000000);
	}

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
}


void ExpenseSetUndeleteRecID(RecordID rec_id)
{

	CString szSql;

	if(rec_id == 0x80001200)  /* no undel record */
		return;

	szSql = "delete * from ";
	szSql += EXPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id + 0x80000000);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}

	szSql = "update ";
	szSql += EXPDB;
	szSql += " set RecordID = ";
	szSql += Str_ul(rec_id + 0x80000000);
	szSql += ", CategoryName = 'Undel' where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}

}

void UpdateAllCurrencies()
{

	CString szSql1;
	CString szSql2;
	int nCat;
	int nCurrency;
	int nCount;
	CDaoRecordset* rs = NULL;

	szSql1 = "Select * from ExpenseCurrency";
	rs = new CDaoRecordset(dbCurrent);
	rs->Open(dbOpenSnapshot,szSql1,0);
	if(!rs->IsBOF())
	{
		rs->MoveLast();
	}
	nCount = rs->GetRecordCount();
	if(nCount == 0) return;
	rs->MoveFirst();

	while(!rs->IsEOF())
	{
		nCat = rs->GetFieldValue("CatNum").lVal;
		nCurrency = rs->GetFieldValue("CurNum").lVal;
		szSql2 = "Update Expense set Currencies = ";
		szSql2 += Str_ul(nCurrency);
		szSql2 += " where Category = ";
		szSql2 += Str_ul(nCat);

		try
		{
			dbCurrent->Execute(szSql2);
		}
		catch(CException *e)
		{
			e->Delete();
		}

		rs->MoveNext();
	}

	delete rs;
	return;
}