#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "EXPENSETYPE.h"

extern CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

BOOL ExpenseTypeAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	COleDateTime date;
	

// todo handle NewRecordWithID record

	szSql = "delete from ";
	szSql += EXPENSETYPEDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

///////////////////prevent any expense type with the same name
	szSql.Empty();
	szSql = "Select * from ";
	szSql += EXPENSETYPEDB;
	szSql += " where TypeName = '";

	PDADataGetField(0, rec_content, &fielddata);  // type name
	RemoveFrontNULL(&fielddata);
	CString szTypeName = fielddata;
	szSql += fielddata + "'";

	CDaoRecordset* rs = NULL;
	rs = new CDaoRecordset(src_db);	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}
	if(!rs->IsBOF()){
		rs->MoveFirst();
		int nCatNum = rs->GetFieldValue("TypeNumber").lVal;
		szSql = "Delete * from ";
		szSql += EXPENSETYPEDB;
		szSql += " where TypeName = '";
		szSql += szTypeName + "'";

		src_db->Execute(szSql);

		szSql = "Update ";
		szSql += EXPDB;
		szSql += " set Category = ";
		szSql += Str_ul(rec_id);
		szSql += " where Category = ";
		szSql += Str_ul(nCatNum);

		src_db->Execute(szSql);
	}
	delete rs;
////////////////////////////////////////////////////////////////

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += EXPENSETYPEDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)(CString)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	//type number
	rsCurrent->SetFieldValue("TypeNumber",(LPCTSTR)Str_ul(rec_id));

	// type name
	PDADataGetField(0, rec_content, &fielddata);  
	RemoveFrontNULL(&fielddata);
	rsCurrent->SetFieldValue("TypeName",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;
	return FALSE;
}



BOOL ExpenseTypeMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;
	
//	if (CatRec(rec_id))
//		return ExpenseTypeMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += EXPENSETYPEDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += EXPENSETYPEDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += EXPENSETYPEDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("TypeNumber");
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("TypeNumber",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("TypeName");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("TypeName",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	rs->Close();

	szSql = "delete from ";
	szSql += EXPENSETYPEDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}



BOOL ExpenseTypeArchive(DatabaseID dbid, int mode)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	RecStruct *cat_record = NULL;
	int total_cat = 0;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	cat_record = (RecStruct*)malloc(300 * sizeof(RecStruct));

	for(i=0;i<total_rec;i++)  // process non-category item
	{
		TRACE("\n%08x ", record[i].rec_header.rec_id );
	  if((record[i].rec_header.rec_id < (RecordID) 0x80000000))
	  {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		if(DBIsExistRecord(dbArchive, EXPENSETYPEDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			PCDeleteRecord(dbRecycle, EXPENSETYPEDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, EXPENSETYPEDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		ExpenseTypeAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	  }
	  else
		  if(CatRec(record[i].rec_header.rec_id ))
//	  if(record[i].rec_header.rec_id < (UWORD) 0x80000100)
	  {
		//category
		   cat_record[total_cat++] = record[i];
	  }
	}

	if(record)
	   free(record);
	if(cat_record)
		free(cat_record);

	return 0;
}


BOOL ExpenseTypeArchivePCOvrPDA(DatabaseID dbid)
{ 
	if(sys_crashed == RESTORE_PC)
		return ExpenseTypeArchive(dbid, CAT_PC_PDA_RESTORE);
	else		
		return ExpenseTypeArchive(dbid, CAT_PC_OVR_PDA);
}

BOOL ExpenseTypeArchivePDAOvrPC(DatabaseID dbid)
{ 
	return ExpenseTypeArchive(dbid, CAT_PDA_OVR_PC);
}

BOOL ExpenseTypeArchivePCPDASync(DatabaseID dbid)
{
	return ExpenseTypeArchive(dbid, CAT_PC_PDA_SYNC);
}


BOOL PDAExpenseTypeAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[12];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += EXPENSETYPEDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	//prevent the expense type other to sync to the PDA.
//	if(rec_id == 255)
//		return FALSE;

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 1;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));


	// Expense Type
	fielddata = (LPSTR) rs->GetFieldValue("TypeName").bstrVal;
	AddNULL(&fielddata);

	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	content += fielddata;

	TRACE("\n %d ", content.GetLength());

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;
	
	SyncRecAdd(dbid, rec_id, 1, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;
}


BOOL ExpenseTypeGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += EXPENSETYPEDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}

