// FindUserDlg.cpp : implementation file
//

#include "stdafx.h"

#define VTOS_VER_CHECK		// define this for PDA's VTOS version checking

#include "vpsync.h"
#include "FindUserDlg.h"
#include "syncdb.h"
#include "errmsgdlg.h"
#include "newuserinfodlg.h"
#include "sysetup.h"
#include <stdlib.h>
#include <direct.h>
#include <errno.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL bRun;
extern int crash;
/////////////////////////////////////////////////////////////////////////////
// CFindUserDlg dialog


CFindUserDlg::CFindUserDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFindUserDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindUserDlg)
	m_szPdaUserName = _T("");
	m_szListFname = _T("");
	m_MsgLabel = _T("");
	//}}AFX_DATA_INIT
}


void CFindUserDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindUserDlg)
	DDX_Control(pDX, IDC_USER_COM, m_UserList);
	DDX_Control(pDX, IDOK, m_btnOK);
	DDX_Control(pDX, IDCANCEL, m_btnCancel);
	DDX_Text(pDX, IDC_USER_NAME, m_szPdaUserName);
	DDX_LBString(pDX, IDC_DIR, m_szListFname);
	DDX_Text(pDX, IDC_MSG_LABEL, m_MsgLabel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindUserDlg, CDialog)
	//{{AFX_MSG_MAP(CFindUserDlg)
	ON_BN_CLICKED(IDC_NEW_USER, OnNewUser)
	ON_BN_CLICKED(IDC_DUP_USER, OnDupUser)
	ON_BN_CLICKED(IDC_SEL_CUR, OnSelCur)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindUserDlg message handlers

BOOL CFindUserDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	name = NULL;
	FillComboContent();
	CButton *pRB = (CButton*) GetDlgItem(IDC_NEW_USER);
	pRB->SetCheck(TRUE);
	pRB->SetFocus();
	CString dispname = '[';
	CString str;
	if(nameinfo.Name1st.GetLength())
		dispname += nameinfo.Name1st;
	if(nameinfo.Name2nd.GetLength())
	{
		if(dispname.GetLength() != 1)
			dispname += ' ';
		dispname += nameinfo.Name2nd;
	}
	if(dispname.GetLength() == 1)
	{
		str.LoadString(IDS_USERNAMENOTSET);
		dispname += str;
	}
	dispname += ']';

	str.LoadString(IDS_PDAUSERNOTFOUND);
	m_MsgLabel = str;

	if(m_resetmode == 1)
	{
		str.LoadString(IDS_USERUSED);
		m_MsgLabel = str;
	}
	UpdateData(FALSE);
	CStatic* pName = (CStatic*) GetDlgItem(IDC_USER_NAME);
	pName->SetWindowText(dispname);
	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pCB->EnableWindow(FALSE);
	m_Action = 0;

	return TRUE;  // return TRUE unless you set the focus to a control
		         // EXCEPTION: OCX Property Pages should return FALSE
}


void CFindUserDlg::DisableUserSel()
{
	CButton *pRB = (CButton*)GetDlgItem(IDC_SEL_CUR);
	pRB->EnableWindow(FALSE);
	CButton *pRBD = (CButton*)GetDlgItem(IDC_DUP_USER);
	pRBD->EnableWindow(FALSE);
	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pCB->EnableWindow(FALSE);
}

void CFindUserDlg::EnableUserSel()
{
	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	CButton *pRB = (CButton*)GetDlgItem(IDC_SEL_CUR);
	CButton *pRBD = (CButton*)GetDlgItem(IDC_SEL_CUR);
	if(pCB->GetCount())
	{
	    pCB->EnableWindow(TRUE);
		pRB->EnableWindow(TRUE);
		pRBD->EnableWindow(TRUE);
	}
	else
	{
	    pCB->EnableWindow(FALSE);
		pRB->EnableWindow(FALSE);
		pRBD->EnableWindow(FALSE);
	}
}

int OpenProfile(CDaoWorkspace *wrk_space);
void CFindUserDlg::FillComboContent()
{
	CDaoRecordset *pRs;
	CString sqlst;

	 wrk_space.Create(_T("PDAWorkspace1"),_T("Admin"),_T(""));
	 wrk_space.SetDefaultUser(_T("admin"));
	 wrk_space.SetDefaultPassword(_T(""));

	if(OpenProfile(&wrk_space))
	{
		if(dbProfile)
		{
			CloseDatabase(dbProfile);
			dbProfile = NULL;
		}
		OnOK();
		return;
	}

	sqlst = "Select Name1st, Name2nd from UserData order by Name1st, Name2nd";

	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", sqlst);
		delete pRs;
		pRs = NULL;
	}
	if(!pRs)
		return;

	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pCB->ResetContent();
	int cur_row = 0;
	if(!pRs->IsBOF() && (m_resetmode != 1))
	{
		pRs->MoveLast();
		name = new UserNameInfo[pRs->GetRecordCount()];
		pRs->MoveFirst();
		while(!pRs->IsEOF())
		{
			BOOL err = FALSE;
				try
				{
					name[cur_row].Name1st = (LPSTR) pRs->GetFieldValue("Name1st").bstrVal;
					name[cur_row].Name2nd = (LPSTR) pRs->GetFieldValue("Name2nd").bstrVal;
				}
				catch(CException *e)
				{
					e->Delete();
					err = TRUE;
				}

				if(!err)
				{
					pCB->AddString(name[cur_row].Name1st + (CString)" "
						           + name[cur_row].Name2nd);
					cur_row++;
				}
				pRs->MoveNext();
		}
	}
	if((cur_row) && (crash == CRASH_YES))
	{
		pCB->SetCurSel(0);
		EnableUserSel();
	}
	else
	{
		DisableUserSel();
	}

	if(pRs)
	{
		pRs->Close();
		delete pRs;
		pRs = NULL;
	}
}


BOOL CFindUserDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	if(name)
		delete []name;

	if(dbProfile)
	{
		CloseDatabase(dbProfile);
		dbProfile = NULL;
	}
	return CDialog::DestroyWindow();
}


void CFindUserDlg::OnNewUser() 
{
	// TODO: Add your control notification handler code here
	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pCB->EnableWindow(FALSE);
}

void CFindUserDlg::OnDupUser() 
{
	// TODO: Add your control notification handler code here
	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pCB->EnableWindow(TRUE);	
}

void CFindUserDlg::OnSelCur() 
{
	// TODO: Add your control notification handler code here
	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pCB->EnableWindow(TRUE);	
}


void CFindUserDlg::GetUserInfo(CString n1st, CString n2nd)
{
	CString szSql;
	CDaoRecordset *pRs = NULL;

//	szSql = "select Tel, Company from UserData where UserName = '";
//	szSql += ExamSql(username);
//	szSql += "'";

	n1st.TrimRight();
	n2nd.TrimRight();

	szSql = "select Tel, Company from UserData where Name1st = '";
	szSql += ExamSql(n1st);
	szSql += "' and Name2nd = '";
	szSql += ExamSql(n2nd);
	szSql += "'";

	pRs = new CDaoRecordset(dbProfile);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return;
	}

	if(!pRs->IsBOF())
	{
			m_szContactTel = (LPSTR) pRs->GetFieldValue("Tel").bstrVal;
			m_szCompanyName = (LPSTR) pRs->GetFieldValue("Company").bstrVal;;
	}

	if(pRs)
		delete pRs;

}

void CFindUserDlg::OnOK() 
{
	// TODO: Add extra validation here

	CButton *pRB = (CButton*)GetDlgItem(IDC_SEL_CUR);
	CButton *pRBD = (CButton*)GetDlgItem(IDC_DUP_USER);
	CString content;
	CString dbheader;
	CString szSql;
	CDaoRecordset *pRs=NULL;

	ShowWindow(SW_HIDE);
	
	if(pRBD->GetCheck())  // duplicate
	{
		if( (!nameinfo.Name1st.GetLength()) &&
			(!nameinfo.Name2nd.GetLength()) )
		{
			CNewUserInfoDlg n_namedlg;
			n_namedlg.m_ComName = m_szCompanyName;
			n_namedlg.m_ComTel = m_szContactTel;
			if(n_namedlg.DoModal() != IDOK)
			{
				ShowWindow(SW_SHOW);
				CButton *pRB = (CButton*) GetDlgItem(IDC_NEW_USER);
				pRB->SetFocus();				
				return;
			}

	szSql = "select 1 from UserData where UserName = '";
 	szSql += ExamSql(n_namedlg.m_Name1st  + ' ' + n_namedlg.m_Name2nd );
	szSql += "'";

//	szSql = "select 1 from UserData where Name1st = '";
//	szSql += ExamSql(n_namedlg.m_Name1st);
//	szSql += "' and Name2nd = '";
//	szSql += ExamSql(n_namedlg.m_Name2nd);
//	szSql += "'";

	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		delete pRs;
		pRs = NULL;
		ShowWindow(SW_SHOW);
		return;
	}

	if(pRs)
		if(!pRs->IsBOF())
		{
			ShowWindow(SW_SHOW);
			CString str;
			str.LoadString(IDS_USEREXISTED);
			ShowErrDlg(str);
			delete pRs;
			CButton *pRB = (CButton*) GetDlgItem(IDC_NEW_USER);
			pRB->SetFocus();				

			return;
		}

	if(pRs)
	{
		delete pRs;
		pRs = NULL;
	}
			nameinfo.Name1st = n_namedlg.m_Name1st;
			nameinfo.Name2nd = n_namedlg.m_Name2nd;
			m_szContactTel = n_namedlg.m_ComTel;
			m_szCompanyName = n_namedlg.m_ComName;


	DatabaseID dbid;
	unsigned int size_array[5];

	AddNULL(&nameinfo.Name1st);
	AddNULL(&nameinfo.Name2nd);
	
    AddNULL(&m_szContactTel);
	AddNULL(&m_szCompanyName);

	size_array[0] = 1;
	size_array[1] = nameinfo.Name1st.GetLength();
	size_array[2] = nameinfo.Name2nd.GetLength();
	size_array[3] = m_szContactTel.GetLength();
	size_array[4] = m_szCompanyName.GetLength();

	content = (CString) (char) (SYS_OWNINFO - FIRST_REC_ID) + nameinfo.Name1st + nameinfo.Name2nd + m_szContactTel + m_szCompanyName;

	RemoveNULL(&nameinfo.Name1st);
	RemoveNULL(&nameinfo.Name2nd);
	
    RemoveNULL(&m_szContactTel);
	RemoveNULL(&m_szCompanyName);

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)
	{
		ShowWindow(SW_SHOW);
		return;
	}
	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	SyncWriteProfile(dbid, SYS_OWNINFO, 0, 5, size_array, content);
	CHKTERM;
	SyncIdleMode();
	CHKTERM;

	}
		if(!DupUser())
		{
			ShowWindow(SW_SHOW);
			return;
		}
		m_Action = 3;
	}
	else if(pRB->GetCheck())  // sel current
	{ // update PDA's name to PC's name
	int pos;
	DatabaseID dbid;
	unsigned int size_array[5];

	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pos = pCB->GetCurSel();

	name[pos].Name1st.TrimRight();
	name[pos].Name2nd.TrimRight();
	GetUserInfo(name[pos].Name1st , name[pos].Name2nd);

	nameinfo.Name1st = name[pos].Name1st;
	AddNULL(&nameinfo.Name1st);
	nameinfo.Name2nd = name[pos].Name2nd;
	AddNULL(&nameinfo.Name2nd);
	
    AddNULL(&m_szContactTel);
	AddNULL(&m_szCompanyName);

	size_array[0] = 1;
	size_array[1] = nameinfo.Name1st.GetLength();
	size_array[2] = nameinfo.Name2nd.GetLength();
	size_array[3] = m_szContactTel.GetLength();
	size_array[4] = m_szCompanyName.GetLength();

	content = (CString) (char) (SYS_OWNINFO - FIRST_REC_ID) + nameinfo.Name1st + nameinfo.Name2nd + m_szContactTel + m_szCompanyName;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
	{
		ShowWindow(SW_SHOW);
		return;
	}
	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	SyncWriteProfile(dbid, SYS_OWNINFO, 0, 5, size_array, content);
	m_Action = 2;
	SyncIdleMode();
	CHKTERM;
	}
	else  // new user
	{
		if( ((!nameinfo.Name1st.GetLength()) &&
			(!nameinfo.Name2nd.GetLength()))  || m_resetmode != 0)
		{
			CNewUserInfoDlg n_namedlg;
			n_namedlg.m_ComName = m_szCompanyName;
			n_namedlg.m_ComTel = m_szContactTel;
			if(m_resetmode != 0)  // user name set but syncid not found
			{
				n_namedlg.m_Name1st = nameinfo.Name1st;
				n_namedlg.m_Name2nd = nameinfo.Name2nd;
			}
			if(n_namedlg.DoModal() != IDOK)
			{
				ShowWindow(SW_SHOW);
				CButton *pRB = (CButton*) GetDlgItem(IDC_NEW_USER);
				pRB->SetFocus();				
				return;
			}
			nameinfo.Name1st = n_namedlg.m_Name1st;
			nameinfo.Name2nd = n_namedlg.m_Name2nd;
			m_szContactTel = n_namedlg.m_ComTel;
			m_szCompanyName = n_namedlg.m_ComName;
		}
		else
		{
			char rec_header[RECHEADER_SIZE];
			CString rec_content;
			CString fielddata;
			DatabaseID dbid;
			SyncIdleMode(); CHKTERM;
			SyncDBEnqMode(); CHKTERM;
			if (SyncDBInfo(SYSDB, &dbid, &dbheader) == 0)   /* get dbid of phone book */
			{
				if(SyncReadRec(dbid, SYS_OWNINFO, (char*)rec_header, &rec_content) == 0)
				{
					PDADataGetField(3, &rec_content, &fielddata);
					RemoveNULL(&fielddata);
					m_szContactTel = fielddata;
					PDADataGetField(4, &rec_content, &fielddata);
					RemoveNULL(&fielddata);
					m_szCompanyName = fielddata;
				}
			}
			SyncIdleMode(); CHKTERM;
		}
		if(CreateNewUser() != TRUE)
		{
			nameinfo.Name1st = "";
			nameinfo.Name2nd = "";
			ShowWindow(SW_SHOW);
			return;
		}
		m_Action = 1;
	}
terminate:
	
	CDialog::OnOK();
}


BOOL CreateFolder(CString folder_name)
{
	return ( _mkdir( folder_name ) == 0 );
}

BOOL CreateIndexFolder(CString folder_name, CString &final_folder)
{
	int index = 1;
	BOOL done = FALSE;
	char buf[10];
	int i;
	
//	folder_name.TrimLeft();
//	folder_name.TrimRight();
//	final_folder = folder_name;

//	for(i=0;i<final_folder.GetLength();i++)
//	{  /* map invalid directory char to  _  */
//		if ( (final_folder[i] < 43) ||
//			  (final_folder[i] >= 127))
//			  final_folder.SetAt(i, '_');
//	}

/*	while(!done)
	{
		errno = 0;
		_mkdir(final_folder);
		switch(errno)
		{
		case 0:   // ok
			done = TRUE;
			break;
		case EEXIST:  // folder exist
			final_folder = folder_name + itoa(index++, buf, 10);
			break;
		case ENOENT:  // path not found
			return FALSE;
		default:
			return FALSE;
		}
	}
*/
	final_folder = "1";
	while (_mkdir (final_folder) != 0)
	{
		char szPath[255];
		int nPath = atoi (final_folder);
		nPath++;
		itoa (nPath, szPath, 10);

		final_folder = szPath;
	}

	return TRUE;
}

BOOL CFindUserDlg::CreateNewUser()
{
	CDaoWorkspace wrk_space;
//	int nReturn;
	CString msg;
	CString szSql;
	CString folder_path;
	unsigned int size_array[5];
	CString content;
	DatabaseID dbid;
	CString dbheader;
	CDaoRecordset *pRs = NULL;
	CDaoRecordset* rsCurrent = NULL;
	CString str;

/*
	wrk_space.Create(_T("PDAWorkspaceTemp"),_T("Admin"),_T(""));
	wrk_space.SetDefaultUser(_T("admin"));
	wrk_space.SetDefaultPassword(_T(""));

	if(dbProfile)
		CloseDatabase(dbProfile);

    dbProfile = new CDaoDatabase(&wrk_space);
	
	nReturn = OpenDatabase(dbProfile, "Profile.mdb");
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			msg = _T("Cannot open user information file, ");
			msg += '\n';
			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			msg = _T("Not enough memory to perform the synchronization process!");
			msg += '\n';
			msg += _T("Please close some applications and try again!");
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			msg = _T("System file Profile.mdb is missing");
			msg += '\n';
			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	if(nReturn)
	{
		goto terminate;
	}

*/
	szSql = "select 1 from UserData where UserName = '";
 	szSql += ExamSql(nameinfo.Name1st + ' ' + nameinfo.Name2nd);
	szSql += "'";

//	szSql = "select 1 from UserData where Name1st = '";
//	szSql += ExamSql(nameinfo.Name1st );
//	szSql += "' and Name2nd = '";
//	szSql += ExamSql(nameinfo.Name2nd);
//	szSql += "'";

	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		delete pRs;
		pRs = NULL;
	}

	if(pRs)
		if(!pRs->IsBOF())
		{
			CString str;
			str.LoadString(IDS_USEREXISTED);
			ShowErrDlg(str);
			CButton *pRB = (CButton*) GetDlgItem(IDC_NEW_USER);
			pRB->SetFocus();				
			goto terminate;
		}

	if(pRs)
	{
		delete pRs;
		pRs = NULL;
	}

	str.LoadString(IDS_CANNOTCREATENEW);

	if(!CreateIndexFolder(nameinfo.Name1st+nameinfo.Name2nd, folder_path))  // create user dir.
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CreateFolder(folder_path + "\\EMail"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\Vox"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\Sketch"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}


	if(!CreateFolder(folder_path + "\\Memo"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}


	if(!CreateFolder(folder_path + "\\TodoVox"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\SchVox"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\Acc"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	str.LoadString(IDS_CANNOTCREATEDATA);
	if(!CopyFile("db.def", folder_path + "\\Current.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile("db.emp", folder_path + "\\Archive.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile("db.emp", folder_path + "\\Recycle.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile("AppDB.def", folder_path + "\\AppDB.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile("000003e8.txt", folder_path + "\\Email\\000003e8.txt", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

//	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dbProfile);

	szSql = "Select * from UserData";

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return FALSE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("UserName",(LPCTSTR)(nameinfo.Name1st + ' ' + nameinfo.Name2nd));
	rsCurrent->SetFieldValue("Path",(LPCTSTR)(folder_path + '\\'));
	rsCurrent->SetFieldValue("Name1st",(LPCTSTR)(nameinfo.Name1st));
	rsCurrent->SetFieldValue("Name2nd",(LPCTSTR)(nameinfo.Name2nd));
//	rsCurrent->SetFieldValue("EmailUsername",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailPassword",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailPop3",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailSMTP",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailAddress",(LPCTSTR)"");
	rsCurrent->SetFieldValue("Tel",(LPCTSTR)m_szContactTel);
	rsCurrent->SetFieldValue("Company",(LPCTSTR)m_szCompanyName);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

/*
	if(dbProfile)
	{
		CloseDatabase(dbProfile);
		dbProfile = NULL;
	}
	
	wrk_space.Close();
*/
	AddNULL(&nameinfo.Name1st);
	AddNULL(&nameinfo.Name2nd);
	AddNULL(&m_szContactTel);
	AddNULL(&m_szCompanyName);
	size_array[0] = 1;
	size_array[1] = nameinfo.Name1st.GetLength();
	size_array[2] = nameinfo.Name2nd.GetLength();
	size_array[3] = m_szContactTel.GetLength();
	size_array[4] =	m_szCompanyName.GetLength();

	content = (CString) (char) (SYS_OWNINFO - FIRST_REC_ID) + nameinfo.Name1st + nameinfo.Name2nd + m_szContactTel+m_szCompanyName;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return FALSE;

	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	SyncWriteProfile(dbid, SYS_OWNINFO, 0, 5, size_array, content);
	m_Action = 2;
	SyncIdleMode();
	CHKTERM;

	return TRUE;

terminate:
	if(pRs)
		delete pRs;
/*
	if(dbProfile)
	{
		CloseDatabase(dbProfile);
		dbProfile = NULL;
	}
	wrk_space.Close();
*/
	return FALSE;
}

BOOL CFindUserDlg::GetSrcPath(CString &src_path)
{
	CDaoRecordset *pRs = NULL;
	CString sqlst;
	int pos;

	CComboBox *pCB = (CComboBox*)GetDlgItem(IDC_USER_COM);
	pos = pCB->GetCurSel();

	sqlst = "select Path from UserData where Name1st = '";
	sqlst += ExamSql(name[pos].Name1st);
	sqlst += "' and Name2nd = '";
	sqlst += ExamSql(name[pos].Name2nd);
	sqlst += "'";

	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", sqlst);
		delete pRs;
		pRs = NULL;
	}
	if(!pRs)
		return FALSE;

	src_path = (LPSTR) pRs->GetFieldValue("Path").bstrVal;

	pRs->Close();
	delete pRs;
	return TRUE;
}

CString CFindUserDlg::GetCurrDrive()
{
	char drive = 'c' - 3;
	CString result;

	result = drive + _getdrive();
	result += ":\\";

	return result;
}

BOOL CFindUserDlg::DupUser()
{
//	CDaoWorkspace wrk_space;
	int nReturn;
	CString msg;
	CString szSql;
	int i, j;
	CString folder_path;
	char root_path[100];
	CString sub_path;
	CString src_path;
	CString f_buf;
	char folder_name[6][12] = {"EMail\\", "Vox\\",  "Sketch\\", "Memo\\", "TodoVox\\", "SchVox\\"};
	char file_ext[6][7] = {"*.*", "*.alp", "*.skt", "*.skt", "*.alp", "*.alp"};
	CListBox *pList;

	root_path[0] = 0;
	CDaoRecordset* rsCurrent = NULL;
/*
	wrk_space.Create(_T("PDAWorkspaceTemp"),_T("Admin"),_T(""));
	wrk_space.SetDefaultUser(_T("admin"));
	wrk_space.SetDefaultPassword(_T(""));

	if(dbProfile)
		CloseDatabase(dbProfile);

    dbProfile = new CDaoDatabase(&wrk_space);
	
	nReturn = OpenDatabase(dbProfile, "Profile.mdb");
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			msg = _T("Cannot open user information file, ");
			msg += '\n';
			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			msg = _T("Not enough memory to perform the synchronization process!");
			msg += '\n';
			msg += _T("Please close some applications and try again!");
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			msg = _T("System file Profile.mdb is missing");
			msg += '\n';
			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	if(nReturn)
	{
		goto terminate;
	}
*/
	CString str;
	if(!GetSrcPath(src_path))
	{
		str.LoadString(IDS_ERRORREADING);
		ShowErrDlg(str);
		goto terminate;
	}

	str.LoadString(IDS_CANNOTCREATENEW);
	if(!CreateIndexFolder(nameinfo.Name1st+nameinfo.Name2nd, folder_path))  // create user dir.
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CreateFolder(folder_path + "\\EMail"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\Vox"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\Sketch"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}


	if(!CreateFolder(folder_path + "\\Memo"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}


	if(!CreateFolder(folder_path + "\\TodoVox"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\SchVox"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	if(!CreateFolder(folder_path + "\\Acc"))  // fail create \email, not critical
	{
		msg = _T(str);
		ShowErrDlg(msg);
	}

	str.LoadString(IDS_CANNOTCREATEDATA);
   	if(!CopyFile(src_path + "Current.mdb", folder_path + "\\Current.mdb", FALSE))
	{
		msg = _T(str);
 		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile(src_path + "Archive.mdb", folder_path + "\\Archive.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile(src_path + "Recycle.mdb", folder_path + "\\Recycle.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	if(!CopyFile(src_path + "AppDB.mdb", folder_path + "\\AppDB.mdb", FALSE))
	{
		msg = _T(str);
		ShowErrDlg(msg);
		goto terminate;
	}

	pList = (CListBox*)GetDlgItem(IDC_DIR);
	// copy all link files
	for(i=0;i<6;i++)
	{   
		sub_path = src_path + folder_name[i]; //+ file_ext[i];
		if (i !=0) 
			_chdir (root_path);
		_getdcwd (_getdrive(), root_path, 100);
		if ( _chdir((CString)root_path + (CString)"\\" + sub_path))
		{
		   ShowErrDlg(str);
		   break;
		}

		pList->ResetContent ();
		pList->Dir(0, file_ext[i]);

		CString str;
		str.LoadString(IDS_CANNOTCREATEDATA);
		for(j=0;j<pList->GetCount();j++)

	   {
		   if (pList->GetCount() == 0)
			   break;
		   pList->GetText(j, f_buf);
	
			if (!CopyFile(root_path + (CString)"\\" + sub_path + (CString)f_buf, root_path + (CString)"\\" + folder_path + (CString)"\\" + folder_name[i] + (CString)f_buf, false))
		   //if(!CopyFile(src_path + (CString) folder_name[i] + f_buf,
			//    folder_path + "\\" + (CString) folder_name[i] + f_buf, FALSE))
		   {
 			   ShowErrDlg(str);
			   break;
		   }
	   }
	   if(j != pList->GetCount() )
		   break;
	}


	if((i!=6) || (j != pList->GetCount() )) // error
		goto terminate;

//	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dbProfile);

	szSql = "Select * from UserData";

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return FALSE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("UserName",(LPCTSTR)(nameinfo.Name1st + ' ' + nameinfo.Name2nd));
	rsCurrent->SetFieldValue("Path",(LPCTSTR)(folder_path + '\\'));
	rsCurrent->SetFieldValue("Name1st",(LPCTSTR)(nameinfo.Name1st));
	rsCurrent->SetFieldValue("Name2nd",(LPCTSTR)(nameinfo.Name2nd));
//	rsCurrent->SetFieldValue("EmailUsername",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailPassword",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailPop3",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailSMTP",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("EmailAddress",(LPCTSTR)"");
//	rsCurrent->SetFieldValue("Tel",(LPCTSTR)(m_szContactTel));
//	rsCurrent->SetFieldValue("Company",(LPCTSTR)(m_szCompanyName));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

/*
	if(dbProfile)
	{
		CloseDatabase(dbProfile);
		dbProfile = NULL;
	}
	
	wrk_space.Close();
	*/
	if(root_path[0])
	_chdir (root_path);
	return TRUE;

terminate:
	/*
	if(dbProfile)
	{
		CloseDatabase(dbProfile);
		dbProfile = NULL;
	}
	wrk_space.Close();
	*/
	if(root_path[0])
	_chdir (root_path);
	return FALSE;
}

void CFindUserDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	m_Action = 0;
	CDialog::OnCancel();
}
