#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "Jot.h"
#include <direct.h>
#include "sysetup.h"


int SyncSetMaxRecordID(DatabaseID dbid, RecordID max_rec_id);
extern CString szUserPath;

CString JotGetMacroFileName(RecordID rec_id)
{
	CString name;

	name.Format("%d", rec_id);
	name.MakeUpper();
	name += ".mac";
	return name;
}

CString JotGetTrainerFileName(RecordID rec_id)
{
	CString name;

	name.Format("%d", rec_id);
	name.MakeUpper();
	name += ".tra";
	return name;
}


void JotAddMacroRecord(RecordID rec_id , CString &rec_content)
{
	CString filename;
	CFile file;
	CFileException e;
	char *data;
	int len;

	filename = szUserPath + "Vox\\" + JotGetMacroFileName(rec_id);

	DeleteFile(filename);

	try
	{
	  if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return ;
	}

	len = rec_content.GetLength();

	if(len <=0 )
		return;
	
	data = rec_content.GetBuffer(len);
	file.WriteHuge(data, len);
	file.Close();
	rec_content.ReleaseBuffer(len);
}

void JotAddTrainerRecord(RecordID rec_id , CString &rec_content)
{
	CString filename;
	CFile file;
	CFileException e;
	char *data;
	int len;

	filename = szUserPath + "Vox\\" + JotGetTrainerFileName(rec_id);

	DeleteFile(filename);

	try
	{
	  if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return ;
	}

	len = rec_content.GetLength();

	if(len <=0 )
		return;
	
	data = rec_content.GetBuffer(len);
	file.WriteHuge(data, len);
	file.Close();
	rec_content.ReleaseBuffer(len);
}


void CSyncDispDlg::PDAJotAddMacro(DatabaseID dbid)
{
	int i, j;
	int datalen;
	CString path = szUserPath + "Vox\\";
	char root_path[100];
	RecordID rec_id;
	RecordHeader header;
	CString content, fielddata, filecontent;
	CFile file;
	CFileException e;
	char data[1000];
	CString filename;
	unsigned int size_array[30];
	unsigned int data32, data32_2;
	unsigned short byte_use;
	char *ptr;
	RecordID max_rec_id = 1000;

	_getdcwd (_getdrive(), root_path, 100);
	
	if ( _chdir(path))
	{
	   return;
	}

	m_List.ResetContent();
	m_List.Dir(0, "*.mac");

	_chdir (root_path);

	if(!m_List.GetCount())
		return;

	CString ofn;
	CString cmp_str;
	int found;
	for(i=0; i<m_List.GetCount();i++)
	{
		m_List.SetCurSel(i);
		m_List.GetText(i, ofn);
		rec_id = atoi(ofn.Left(ofn.GetLength()-4));
		if(rec_id>max_rec_id)
			max_rec_id = rec_id;
		header.rec_id = rec_id;
		header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime::GetCurrentTime()));
		header.total_field = 2;
		header.cat = 0;
		header.attribute = 0;

		filename = szUserPath + "Vox\\" + JotGetMacroFileName(rec_id);

		try
		{
      	if( !file.Open( filename, CFile::modeRead|CFile::typeBinary, &e ) )
		  {
		    TRACE("\nCannot read file %s ", filename);
			continue;
		  }  
		}
	   catch( CFileException f )
	   {
		TRACE("\nCannot create file %s ", filename);
		continue;
	   }

	   file.SeekToEnd();
	   file.SeekToBegin();
	   datalen = file.GetLength();
	   file.Read(data, datalen);

	   file.Close();

	   filecontent.Empty();
	   content.Empty();
	   for(j=0;j<datalen;j++)
		   filecontent += data[j];

 	    size_array[0] = PDADataGetField(0, &filecontent, &fielddata);
		data32_2 = size_array[0];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;	

		fielddata.Empty();
 	    size_array[1] = PDADataGetField(1, &filecontent, &fielddata);
		data32_2 = size_array[1];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;	

		header.size = content.GetLength();
		if((header.size) % 4)
			header.size += 4 - (header.size) % 4;

		SyncRecAdd(dbid, rec_id, 2, size_array, &header, &content);
		CHKTERM;
	}

	SyncSetMaxRecordID(dbid, max_rec_id + 1);

terminate:
	return ;  

}



int CSyncDispDlg::PDAJotCountMacro(DatabaseID dbid)
{
	int i, j;
	int datalen;
	CString path = szUserPath + "Vox\\";
	char root_path[100];
	RecordID rec_id;
	RecordHeader header;
	CString content, fielddata, filecontent;
	CFile file;
	CFileException e;
	char data[1000];
	CString filename;
	unsigned int size_array[30];
	unsigned int data32, data32_2;
	unsigned short byte_use;
	char *ptr;
	RecordID max_rec_id = 1000;

	_getdcwd (_getdrive(), root_path, 100);
	
	if ( _chdir(path))
	{
	   return 0;
	}

	m_List.ResetContent();
	m_List.Dir(0, "*.mac");

	_chdir (root_path);

	return m_List.GetCount();

}



void CSyncDispDlg::PDAJotAddTrainer(DatabaseID dbid)
{
	int i, j;
	int datalen;
	CString path = szUserPath + "Vox\\";
	char root_path[100];
	RecordID rec_id;
	RecordHeader header;
	CString content, fielddata, filecontent;
	CFile file;
	CFileException e;
	char data[1000];
	CString filename;
	unsigned int size_array[5];
	unsigned int data32, data32_2;
	unsigned short byte_use;
	char *ptr;
	RecordID max_rec_id = 1000;

	_getdcwd (_getdrive(), root_path, 100);
	
	if ( _chdir(path))
	{
	   return;
	}

	m_List.ResetContent();
	m_List.Dir(0, "*.tra");

	_chdir (root_path);

	if(!m_List.GetCount())
		return;

	CString ofn;
	CString cmp_str;
	int found;
	for(i=0; i<m_List.GetCount();i++)
	{
		m_List.SetCurSel(i);
		m_List.GetText(i, ofn);
		rec_id = atoi(ofn.Left(ofn.GetLength()-4));
		if(rec_id>max_rec_id)
			max_rec_id = rec_id;
		header.rec_id = rec_id;
		header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime::GetCurrentTime()));
		header.total_field = 3;
		header.cat = 0;
		header.attribute = 0;

		filename = szUserPath + "Vox\\" + JotGetTrainerFileName(rec_id);

		try
		{
      	if( !file.Open( filename, CFile::modeRead|CFile::typeBinary, &e ) )
		  {
		    TRACE("\nCannot create file %s ", filename);
		  }  
		}
	   catch( CFileException f )
	   {
		TRACE("\nCannot create file %s ", filename);
		continue;
	   }

	   file.SeekToEnd();
	   file.SeekToBegin();
	   datalen = file.GetLength();
	   file.Read(data, datalen);

	   file.Close();

	   filecontent.Empty();
	   content.Empty();
	   for(j=0;j<datalen;j++)
		   filecontent += data[j];

 	    size_array[0] = PDADataGetField(0, &filecontent, &fielddata);
		data32_2 = size_array[0];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;	

		fielddata.Empty();
 	    size_array[1] = PDADataGetField(1, &filecontent, &fielddata);
		data32_2 = size_array[1];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;	

		fielddata.Empty();
 	    size_array[2] = PDADataGetField(2, &filecontent, &fielddata);
		data32_2 = size_array[2];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;	

		header.size = content.GetLength();
		if((header.size) % 4)
			header.size += 4 - (header.size) % 4;

		SyncRecAdd(dbid, rec_id, 3, size_array, &header, &content);
		CHKTERM;
	}

	SyncSetMaxRecordID(dbid, max_rec_id + 1);

terminate:
	return ;  

}




void CSyncDispDlg::JotDeleteInvalidMacro(RecStruct *record, int total_rec)
{
	int i, j;
	CString path = szUserPath + "Vox\\";
	char root_path[100];

	_getdcwd (_getdrive(), root_path, 100);
	
	if ( _chdir(path))
	{
	   return;
	}

	m_List.ResetContent();
	m_List.Dir(0, "*.mac");

	_chdir (root_path);

	if(!m_List.GetCount())
		return;

	CString ofn;
	CString cmp_str;
	int found;
	for(i=0; i<m_List.GetCount();i++)
	{
		m_List.SetCurSel(i);
		m_List.GetText(i, ofn);
		ofn = ofn.Left(ofn.GetLength()-4);
		found = 0;

		for(j=0;j<total_rec;j++)
		{
			cmp_str.Format("%d", record[i].rec_header.rec_id);
			if(ofn == cmp_str)
			{
				found = 1;
				break;
			}
		}
		if(!found)
			DeleteFile(szUserPath + "Vox\\" + ofn + ".mac");
	}

	return ;  
}


int CSyncDispDlg::UpdateDatabasePDAOvrPCJot()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(JOT_MACRO_DB_NAME, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error

	CHKTERM;

	if(total_rec > 12000)
		return 1;
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		CHKTERM;
		JotAddMacroRecord(record[i].rec_header.rec_id , rec_content);
	}

	JotDeleteInvalidMacro(record, total_rec);

	if(record)
		free(record);

	record = NULL;


	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	if (SyncDBInfo(JOT_TRAINER_DB_NAME, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 0;

	for(i=0;i<total_rec;i++)
	{
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		CHKTERM;
		JotAddTrainerRecord(record[i].rec_header.rec_id , rec_content);
	}

	if(record)
		free(record);
	record = NULL;


	ReadPDASysSettings();


	return 0;

terminate:
		if(record)
		free(record);

	return 1;
}


int CSyncDispDlg::UpdateDatabasePCOvrPDAJot()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;


	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(JOT_MACRO_DB_NAME, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error

	CHKTERM;

	if(total_rec > 12000)
		return 1;


	if(PDAJotCountMacro(dbid) == 0)  /* not system info yet */
		return 0;

	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	for(i=0;i<total_rec;i++)
	{
		PDADeleteRecord(dbid, record[i].rec_header.rec_id);
		CHKTERM;
	}

	PDAJotAddMacro(dbid);

	if(record)
		free(record);
	record = NULL;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	if (SyncDBInfo(JOT_TRAINER_DB_NAME, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 0;
	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;

	for(i=0;i<total_rec;i++)
	{
		PDADeleteRecord(dbid, record[i].rec_header.rec_id);
		CHKTERM;
	}

	PDAJotAddTrainer(dbid);


	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

	if(record)
		free(record);
	record = NULL;

	WritePDASysSettings();

// check & set DST 	
	SyncSetDST();
	SyncIdleMode();
	SyncDBUpMode();
	
	return 0;

terminate:

	if(record)
		free(record);

	return 1;


}