#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "MEMO.h"

extern CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

CString MemoGetSketchFileName(RecordID rec_id)
{
	CString name;

	name.Format("%08x", rec_id);
	name.MakeUpper();
	name += ".skt";

	return name;
}

void SketchPDAToPC( char *PDA, char *PC);
void SketchPCToPDA(char *PC, char *PDA);

BOOLEAN MemoGetSketchFile(RecordID rec_id, CString &fielddata)
{
	CString filename;
	CFileException e;
	CFile file;
//	char PC[57000];
	char PC[78000];
	char *PDA;

	PDA = (char*) fielddata.GetBuffer(2440);

	filename = szUserPath + "Memo\\" + MemoGetSketchFileName(rec_id);

	try
	{
	  if(!file.Open( filename, CFile::modeRead | CFile::typeBinary, &e ))
	  {
		TRACE("\nCannot open file %s ", filename);
		fielddata.ReleaseBuffer(0);
		return TRUE;
	  } 
	}
	catch( CFileException *f)
	{
		TRACE("\nCannot open file %s ", filename);
		fielddata.ReleaseBuffer(0);
		f->Delete();
		return TRUE;
	}

	try
	{
//		file.Read(PC, 56174);
		file.Read(PC, file.GetLength());
	}
	catch (CFileException *ee)
	{
		ee->Delete();
		fielddata.ReleaseBuffer(0);
		file.Close();
		return TRUE;
	}

	SketchPCToPDA(PC, PDA);

	fielddata.ReleaseBuffer(2440);

	return FALSE;

}



BOOLEAN MemoCreateSketchFile(RecordID rec_id, CString &fielddata)
{
// return TRUE if OK, else FALSE
	// create a sketch file in dir Memo\ with rec_id as name
	CString filename;
	CFileException e;
	CFile file;
	char PC[59000];

	filename = szUserPath + "Memo\\" + MemoGetSketchFileName(rec_id);

	try
	{
		if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return TRUE;
	}

	// copy sketch data to char array

	int x = fielddata.GetLength();

	char *PDA = fielddata.GetBuffer(2440);

	SketchPDAToPC(PDA, PC);

	try
	{
		file.WriteHuge(PC, 56174);
	}

    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		fielddata.ReleaseBuffer(2440);
		return TRUE;
	}

	file.Close();
	fielddata.ReleaseBuffer(2440);
	return FALSE;
}


BOOLEAN MemoExistFile(RecordID rec_id)
{
	CString fn;
	fn = szUserFullPath + "Memo\\" + MemoGetSketchFileName(rec_id);
	return ExistFile(fn);
}


BOOL MemoAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	
	if (CatRec(rec_id))
		return MemoAddCat(dbCurrent, rec_id, rec_header, rec_content);

// todo handle NewRecordWithID record

	szSql = "delete from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += MEMODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	// field 0 is sketch status, can skip
//	PDADataGetField(0, rec_content, &fielddata);  


// Content, Date
	PDADataGetField(1, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)(fielddata));

	PDADataGetField(2, rec_content, &fielddata);
	if(fielddata.GetLength() > 10)
		fielddata= fielddata.Left(10);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("MemoDate",(LPCTSTR)(fielddata));

// sketch data
	PDADataGetField(3, rec_content, &fielddata);  
	if(fielddata.GetLength() > 5)  // has data
	{
		if(!MemoCreateSketchFile(rec_id,fielddata))
		{
			rsCurrent->SetFieldValue("Filename",(LPCTSTR)MemoGetSketchFileName(rec_id));
		}
		else
			rsCurrent->SetFieldValue("Filename",(LPCTSTR)"");
	}
	else
		rsCurrent->SetFieldValue("Filename",(LPCTSTR)"");


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

/*
	CString fn;
	fn = szUserFullPath + "Email\\" + EmailGetBodyFileName(rec_id);

	szSql += "'";		// body, save as file
	PDADataGetField(7, rec_content, &fielddata);
	szSql += ExamSql(fn);
	szSql += "','')";  // attachment
//	szSql = szSql.Left(szSql.GetLength()-1);
//	szSql += ')';
*/

	nPDA2PC++;
	return FALSE;
}


BOOL MemoMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;
	
	if (CatRec(rec_id))
		return MemoMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += MEMODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Content");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("MemoDate");	 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("MemoDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Filename");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Filename",(LPCTSTR)szStr);


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	rs->Close();

	szSql = "delete from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}



BOOL MemoAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += MEMODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Filename",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return FALSE;
}



BOOL MemoMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += MEMODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Filename");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Filename",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	szSql = "delete from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return FALSE;
}

BOOL MemoArchive(DatabaseID dbid, int mode)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	RecStruct *cat_record = NULL;
	int total_cat = 0;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	cat_record = (RecStruct*)malloc(300 * sizeof(RecStruct));

	for(i=0;i<total_rec;i++)  // process non-category item
	{
		TRACE("\n%08x ", record[i].rec_header.rec_id );
	  if((record[i].rec_header.rec_id < (RecordID) 0x80000000))
	  {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		if(DBIsExistRecord(dbArchive, MEMODB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			PCDeleteRecord(dbRecycle, MEMODB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, MEMODB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		MemoAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	  }
	  else
		  if(CatRec(record[i].rec_header.rec_id ))
//	  if(record[i].rec_header.rec_id < (UWORD) 0x80000100)
	  {
		//category
		   cat_record[total_cat++] = record[i];
	  }
	}

	SyncUpdateCat((CString)MEMODB, (CString)MEMO_CAT_FIELD_NAME, dbid, cat_record, total_cat, mode);

	if(record)
	   free(record);
	if(cat_record)
		free(cat_record);

	return 0;
}


BOOL MemoArchivePCOvrPDA(DatabaseID dbid)
{ 
	if(sys_crashed == RESTORE_PC)
		return MemoArchive(dbid, CAT_PC_PDA_RESTORE);
	else		
		return MemoArchive(dbid, CAT_PC_OVR_PDA);
}

BOOL MemoArchivePDAOvrPC(DatabaseID dbid)
{ 
	return MemoArchive(dbid, CAT_PDA_OVR_PC);
}

BOOL MemoArchivePCPDASync(DatabaseID dbid)
{
	return MemoArchive(dbid, CAT_PC_PDA_SYNC);
}


BOOL PDAMemoAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[8];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	int sket_pos;
	char *ptr;

	szSql = "select * from ";
	szSql += MEMODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 4;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));

	BOOL has_sketch = FALSE;
//#ifdef MEMO_WITH_SKETCH	
// sketch status
	fielddata = (LPCSTR) (rs->GetFieldValue("Filename")).bstrVal;
	if(fielddata.GetLength() > 3)
	{
//	if(MemoExistFile(rec_id)
		sket_pos = fielddata.GetLength();
		fielddata = (char) 0x01;
		has_sketch = TRUE;
	}

	else
	{
		fielddata = (char) 0x00;
	}
//#else
//	fielddata = (char) 0x00;
//#endif

	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;


	// content
	fielddata = (LPCSTR) (rs->GetFieldValue("Content")).bstrVal;
	AddNULL(&fielddata);
	size_array[1] = fielddata.GetLength();
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];
	content += fielddata;	

	// MemoDate
	fielddata = (LPCSTR) (rs->GetFieldValue("memoDate")).bstrVal;
	AddNULL(&fielddata);
	size_array[2] = fielddata.GetLength();
	data32_2 = size_array[2];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];
	content += fielddata;	


	if(has_sketch)
	{
		if(MemoGetSketchFile(rec_id, fielddata))
		{  // fail
			content.SetAt(sket_pos,0);
			fielddata.Empty();
			AddNULL(&fielddata);
		}
	}
	else
	{
		fielddata.Empty();
		AddNULL(&fielddata);
	}
	size_array[3] = fielddata.GetLength();
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;	

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAddLarge(dbid, rec_id, 4, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;
}


BOOL MemoGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += MEMODB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}

