#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "phonebk.h"
#include "Voice.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "recid.h"


extern BOOL bRun;
extern BOOL recycle_pda_pb;

int CSyncDispDlg::UpdateDatabasePDAOvrPCPhoneBook()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

/* send all record header data from PDA */
	if (SyncDBInfo(PDA_PBDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;
	PhoneBookArchivePDAOvrPC(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 12000)
		return 1;

	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{
		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		CHKTERM;
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxx
		if(DBIsExistRecord(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			CHKTERM;
//			PhoneBookMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		CHKTERM;
#endif
		PCDeleteRecord(dbRecycle, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		PhoneBookAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}

		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += PBDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0";
	CHKTERM;
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}
CHKTERM;
		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
//			PhoneBookMoveRecord(dbCurrent, dbRecycle, recid);
			PCDeleteRecord(dbCurrent, PBDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);


	DeferDeletePDACat(dbid);
	CHKTERM;

	PhoneBookDeleteInvalidRec();

		UpdateLastRecID(PBDB, 1000);
	return 0;

terminate:
	if(rs)
		delete rs;
	PhoneBookDeleteInvalidRec();
	return 1;
}


int CSyncDispDlg::UpdateDatabasePCOvrPDAPhoneBook()
{
	DatabaseID dbid;
	int total_rec; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
//	RecordID last_pda_recid;
//	RecordID last_pc_recid;

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;


/* send all record header data from PDA */
	if(SyncDBInfo(PDA_PBDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;
/*
#ifndef UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
	{
		GetLastSyncRecID(PBDB, &last_pda_recid, &last_pc_recid);
		RecIDCrashRecover(PBDB, 1002);
	}
#endif

#ifdef UNIQUE_RECID	
	if(sys_crashed == RESTORE_PC)
	{
		GetLastSyncRecID(PBDB, &last_pda_recid, &last_pc_recid);
		//RecIDCrashRecover(PBDB, 1002);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;

		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1002);
	}
#endif
	*/

	PhoneBookArchivePCOvrPDA(dbid);
	CHKTERM;
	total_rec = 0;

	CHKTERM;

	/* get all record header in PDA */
 	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;
/* Compare all record in PC with PDA */
	if(total_rec)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(!DBIsExistRecord(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   DoEvents();
	       PhoneBookAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		   rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */

		if(DBCompDate(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDAPhoneBookAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += PBDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0 ";

	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
		CHKTERM;
	    SyncDBUpMode();
		CHKTERM;
		while(!rs->IsEOF())
		{
			DoEvents();
			PDAPhoneBookAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

//#ifdef UNIQUE_RECID
/*	if(sys_crashed == RESTORE_PC)
	{
	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}
*/
	UpdateLastRecID(PBDB, 1000);
//	}
//#endif



	if(record)
	   free(record);

	DeferDeletePDACat(dbid);
		CHKTERM;
	PhoneBookDeleteInvalidRec();

		UpdateLastRecID(PBDB, 1000);
	return 0;

terminate:
	if(rs)
		delete rs;

	PhoneBookDeleteInvalidRec();
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncPhoneBook()
{
	DatabaseID dbid;
	int total_rec;
	RecordID last_pda_recid, last_pc_recid;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
    CMissRecDlg missrec_dlg;
	char found = 0;

   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 7;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 280;
   missrec_dlg.row_height[1] = 280;
   missrec_dlg.row_height[2] = 280;
   missrec_dlg.row_height[3] = 280;
   missrec_dlg.row_height[4] = 280;
   missrec_dlg.row_height[5] = 280;
   missrec_dlg.row_height[6] = 850;

   CString str;
   str.LoadString(IDS_MODIFYDATE);
   missrec_dlg.m_Content[0][0] = str;
	str.LoadString(IDS_CATEGORY);
   missrec_dlg.m_Content[1][0] = str;
   str.LoadString(IDS_NAME);
   missrec_dlg.m_Content[2][0] = str;
   str.LoadString(IDS_TEL_HOME);
   missrec_dlg.m_Content[3][0] = str;
   str.LoadString(IDS_TEL_COMPANY);
   missrec_dlg.m_Content[4][0] = str;
   str.LoadString(IDS_EMAILADDRESS);
   missrec_dlg.m_Content[5][0] = str;
   str.LoadString(IDS_NOTE);
   missrec_dlg.m_Content[6][0] = str;

   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 7;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 280;
   duprec_dlg.row_height[1] = 280;
   duprec_dlg.row_height[2] = 280;
   duprec_dlg.row_height[3] = 280;
   duprec_dlg.row_height[4] = 280;
   duprec_dlg.row_height[5] = 280;
   duprec_dlg.row_height[6] = 850;


   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_CATEGORY);
   duprec_dlg.m_ContentPC[1][0] = str;
   str.LoadString(IDS_NAME);
   duprec_dlg.m_ContentPC[2][0] = str;
   str.LoadString(IDS_TEL_HOME);
   duprec_dlg.m_ContentPC[3][0] = str;
   str.LoadString(IDS_TEL_COMPANY);
   duprec_dlg.m_ContentPC[4][0] = str;
   str.LoadString(IDS_EMAILADDRESS);
   duprec_dlg.m_ContentPC[5][0] = str;
   str.LoadString(IDS_NOTE);
   duprec_dlg.m_ContentPC[6][0] = str;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_CATEGORY);
   duprec_dlg.m_ContentPDA[1][0] = str;
   str.LoadString(IDS_NAME);
   duprec_dlg.m_ContentPDA[2][0] = str;
   str.LoadString(IDS_TEL_HOME);
   duprec_dlg.m_ContentPDA[3][0] = str;
   str.LoadString(IDS_TEL_COMPANY);
   duprec_dlg.m_ContentPDA[4][0] = str;
   str.LoadString(IDS_EMAILADDRESS);
   duprec_dlg.m_ContentPDA[5][0] = str;
   str.LoadString(IDS_NOTE);
   duprec_dlg.m_ContentPDA[6][0] = str;
   
	CHKTERM;

	SyncIdleMode();	
	SyncDBEnqMode();


/* send all record header data from PDA */
	if(SyncDBInfo(PDA_PBDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	PhoneBookArchivePCPDASync(dbid);
	CHKTERM;


	PhoneBookGetLastSyncRecID(&last_pda_recid, &last_pc_recid);

	GetLastSyncRecID(PBDB, &last_pda_recid, &last_pc_recid);
	
	CHKTERM;

	GetLastSyncDate(PBDB, &last_sync_date);
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 12000)
		return 1;

/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += PBDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0 ";

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSql = "select * from ";
		szSql += PBDB;
		szSql += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ')';

		rs_both = new CDaoRecordset(dbCurrent);
		try
		{
			rs_both->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
		}
	}
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	   if(!DBIsExistRecord(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
//		   if(((RecordHeader)(record[i].rec_header)).rec_id >= last_pda_recid)
		   {  /* this is a new record in PDA since last sync, send it to PC */
			   CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  PhoneBookAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      CHKTERM;
			  rec_content.Empty();
		  	  SyncIdleMode();	
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxx
			  if(recycle_pda_pb)
			  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PhoneBookAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
		   /* then delete it */
#endif
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
		      PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
		   
			   int action;

			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
					  rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
				   }
 				   action = missrec_act;
			   }
			   else
			   {
			   // this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db 
				  CString fielddata;
			   rec_content.Empty();
			   SyncIdleMode();
			   CHKTERM;
			   SyncDBEnqMode();
			   CHKTERM;
			   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			   CHKTERM;

				CString str;
				str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;
			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.total_rows = 7;
			   missrec_dlg.total_cols = 2;

			   missrec_dlg.m_Content[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   missrec_dlg.m_Content[0][1].Remove('#');
 		       missrec_dlg.m_Content[1][1] = PDAGetCatName(dbid, ((RecordHeader)(record[i].rec_header)).cat);
			   CHKTERM;
			   SyncIdleMode();  CHKTERM;
			   SyncDBUpMode();  CHKTERM;
			   PDADataGetField(2, &rec_content, &fielddata); // name whole
			   missrec_dlg.m_Content[2][1] = fielddata;
			   fielddata.Empty();
			   PDADataGetField(15, &rec_content, &fielddata); // home tel
			   missrec_dlg.m_Content[3][1] = fielddata;		             
			   fielddata.Empty();
			   PDADataGetField(5, &rec_content, &fielddata); // com tel
			   missrec_dlg.m_Content[4][1] = fielddata;
			   fielddata.Empty();
			   PDADataGetField(8, &rec_content, &fielddata); // email addr
			   missrec_dlg.m_Content[5][1] = fielddata;
			   fielddata.Empty();
			   PDADataGetField(25, &rec_content, &fielddata); // Note
			   missrec_dlg.m_Content[6][1] = fielddata;
			   fielddata.Empty();
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					   PCDeleteRecord(dbRecycle, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id);
					   PCDeleteRecord(dbArchive, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id); 	
					   PhoneBookAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }

//???	   }
	   }  // Rec not found in PC
	}

// rec in PC only	
	missrec_act = 0;

	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	
		SyncDBUpMode();
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			DoEvents();
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAPhoneBookAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
//				PhoneBookMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
				PCDeleteRecord(dbCurrent, PBDB, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				// Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA 
			int action;
			if(missrec_act)
				action = missrec_act;
			else
			{
			   COleDateTime modid;
			   modid = rs_pc->GetFieldValue("ModifyDate");
			   missrec_dlg.m_Content[0][1] = ValidDBDate(&modid);
			   missrec_dlg.m_Content[1][1] = PCGetCatName(dbCurrent, PBDB, (unsigned char)rs_pc->GetFieldValue("Category").lVal, (CString)"Name1st"); 
			   missrec_dlg.m_Content[2][1] = (LPSTR) rs_pc->GetFieldValue("NameWhole").bstrVal;	   
			   missrec_dlg.m_Content[3][1] = (LPSTR) rs_pc->GetFieldValue("Tel").bstrVal;
			   missrec_dlg.m_Content[4][1] = (LPSTR) rs_pc->GetFieldValue("ComTel").bstrVal;
			   missrec_dlg.m_Content[5][1] = (LPSTR) rs_pc->GetFieldValue("ComMail").bstrVal;
			   missrec_dlg.m_Content[6][1] = (LPSTR) rs_pc->GetFieldValue("Notes").bstrVal;

			   CString str;
			   str.LoadString(IDS_MISS_PDA);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PDA);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPC);
			   missrec_dlg.m_szMissLabel = str;
			   str.LoadString(IDS_SYNCTOPDA);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDAPhoneBookAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				   break;
				   case DEL_REC:
		   			   //PhoneBookMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   PCDeleteRecord(dbCurrent, PBDB, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;
				
			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode();CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
		delete rs_pc;
		rs_pc = NULL;
	}

	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode();   CHKTERM;
		rs_both->MoveFirst();
		while(!rs_both->IsEOF())
		{
		  found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{
				DoEvents();				
//			if(((RecordHeader)(record[i].rec_header)).rec_id < 1003)
//			{

//			}
//			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
				// not modi
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //PhoneBookMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  //PCDeleteRecord(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 			  PhoneBookAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
				PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDAPhoneBookAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
				//AfxMessageBox(" not implemented ");
			   int action;

				if (abs(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(record[i].rec_header.modi_date))) > 2)
			   {

			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
				   }
					action = duprec_act;
			   }
			   else
			   {
				   ///////////////// prepare PDA content
				  CString fielddata;
			   rec_content.Empty();
			   SyncIdleMode();
			   CHKTERM;
			   SyncDBEnqMode();
			   CHKTERM;
			   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			   CHKTERM;
			   duprec_dlg.total_rows = 7;
			   duprec_dlg.total_cols = 2;

			   duprec_dlg.m_ContentPDA[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   duprec_dlg.m_ContentPDA[0][1].Remove('#');
 		       duprec_dlg.m_ContentPDA[1][1] = PDAGetCatName(dbid, ((RecordHeader)(record[i].rec_header)).cat);
			   CHKTERM;
			   SyncIdleMode();  CHKTERM;
			   SyncDBUpMode();  CHKTERM;
			   PDADataGetField(2, &rec_content, &fielddata); // name whole
			   duprec_dlg.m_ContentPDA[2][1] = fielddata;
			   fielddata.Empty();
			   PDADataGetField(15, &rec_content, &fielddata); // home tel
			   duprec_dlg.m_ContentPDA[3][1] = fielddata;		             
			   fielddata.Empty();
			   PDADataGetField(5, &rec_content, &fielddata); // com tel
			   duprec_dlg.m_ContentPDA[4][1] = fielddata;
			   fielddata.Empty();
			   PDADataGetField(8, &rec_content, &fielddata); // email addr
			   duprec_dlg.m_ContentPDA[5][1] = fielddata;
			   fielddata.Empty();
			   PDADataGetField(25, &rec_content, &fielddata); // Note
			   duprec_dlg.m_ContentPDA[6][1] = fielddata;
			   fielddata.Empty();

			   /// PC Data
			   COleDateTime modid;
			   modid = rs_both->GetFieldValue("ModifyDate");
			   duprec_dlg.m_ContentPC[0][1] = ValidDBDate(&modid);	   
			   duprec_dlg.m_ContentPC[1][1] = PCGetCatName(dbCurrent, PBDB, (unsigned char)rs_both->GetFieldValue("Category").lVal, (CString)"Name1st"); 
			   duprec_dlg.m_ContentPC[2][1] = (LPSTR) rs_both->GetFieldValue("NameWhole").bstrVal;
			   duprec_dlg.m_ContentPC[3][1] = (LPSTR) rs_both->GetFieldValue("Tel").bstrVal;
			   duprec_dlg.m_ContentPC[4][1] = (LPSTR) rs_both->GetFieldValue("ComTel").bstrVal;
			   duprec_dlg.m_ContentPC[5][1] = (LPSTR) rs_both->GetFieldValue("ComMail").bstrVal;
			   duprec_dlg.m_ContentPC[6][1] = (LPSTR) rs_both->GetFieldValue("Notes").bstrVal;

			   CString str;
			   str.LoadString(IDS_MODIFY);
               duprec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_MODIFY);
			   duprec_dlg.m_szDupMsg = str;

			   duprec_dlg.DoModal();

			   action = SYNC_TO_PC;
			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDAPhoneBookAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   break;
				   case NOT_SYNC:
					   break;
				   case SYNC_TO_PC:
				   default:
//					   PCDeleteRecord(dbCurrent, PBDB,(rs_both->GetFieldValue("RecordID")).lVal);
//		   			   PhoneBookMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
//					   CHKTERM;
					   PhoneBookAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;

			   }
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			}
			rs_both->MoveNext();
			CHKTERM;
		}
	   rs_both->Close();			
	   SyncIdleMode();	
 	   SyncDBEnqMode();
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}

	if(record)
	{
	   free(record);
	   record = NULL;
	}


	UpdateLastRecID(PBDB, last_pda_recid);
	DeferDeletePDACat(dbid);
	CHKTERM;
	PhoneBookDeleteInvalidRec();
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);
	PhoneBookDeleteInvalidRec();
	return 1;
}
