#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "Sch.h" 
#include "resource.h"

int nPDA2PC;
int nPC2PDA;

extern CString current_path;
extern DatabaseID sch_vox_dbid;
//extern int sch_next_alarm_number;
extern int station_num;
 
COleDateTime ConstructDate(int yr, int mon, int day, int hr, int min, int sec)
{
	COleDateTime dt(yr, mon, day, hr, min, sec);
	return dt;
}

CString sch_data;

CString &SchExtractContent(char *contentdata, int pos, int len)
{
	int i = 0;

	sch_data.Empty();
	while(pos)
	{
		if(contentdata[i++] == '\0')
			pos--;
		if(i>=len)
			return sch_data;
	}
	sch_data = contentdata + i;
	return sch_data;
}

int SchExamPDARecord(CString *rec_content, SchNode **sch_node, int *total_node)
{
	int sch_year;
	char sch_month;
	char sch_day;
	COleDateTime sch_date;
	CString fielddata;
	CString contentdata;
	int i, j;
	int total_appt, content_len;
	char *data_ptr, *content_ptr;
	SchNode *new_node;

	int MaxDay[] = {31,28,31,30,31,30,31,31,30,31,30,31};

	PDADataGetField(0, rec_content, &fielddata);
	if(fielddata.GetLength() != 3)
		return 1;		// error

	sch_year = DATE_OFFSET + (int)(unsigned char) fielddata[0];
//	if(sch_year < 1973)
//		sch_year = 1973;
//	else if(sch_year > 2037)
//		sch_year = 2037;

	sch_month = fielddata[1];
	if(sch_month < 1)
		sch_month = 1;
	else if(sch_month > 12)
		sch_month = 12;

	sch_day = fielddata[2];
	if(sch_day < 1)
		sch_day = 1;
	else if(sch_day > 31)
		sch_day = MaxDay[sch_month - 1];

	sch_date = ConstructDate(sch_year, sch_month, sch_day, 0 , 0, 0);

	PDADataGetField(1, rec_content, &fielddata);
	total_appt = *total_node;
	*total_node = 0;
	
	if(total_appt > 100)  // too many, impossible!
		return 1;
	
	new_node = *sch_node;

	TRACE("\n %d ", sizeof(SchNode) * total_appt);
	if(!sch_node)
	{
		CString string;
		string.LoadString(IDS_ERROR_MEMORY);
		AfxMessageBox(string);
		return 2;
	}

	PDADataGetField(2, rec_content, &contentdata);
	content_len = contentdata.GetLength();
	data_ptr = (LPSTR) fielddata.GetBuffer(fielddata.GetLength());
	content_ptr = (LPSTR) contentdata.GetBuffer(contentdata.GetLength());

	// init all node
	for(i=0;i<total_appt;i++)
	{
		new_node[i].schdate = sch_date;
		
		new_node[i].schstart_time = ConstructDate(sch_year, sch_month, sch_day,((AppointmentDB*) data_ptr)[i].hour  , ((AppointmentDB*) data_ptr)[i].minute ,0);
		
		new_node[i].connected_row = ((AppointmentDB*) data_ptr)[i].appointment;

		new_node[i].alm_num = ((AppointmentDB*) data_ptr)[i].alarm_num;
		new_node[i].appmt_num = ((AppointmentDB*) data_ptr)[i].appmt_num;

		if(new_node[i].connected_row == -1)
			continue;   // unused row

		switch(((AppointmentDB*) data_ptr)[i].alarm)
		{ // no , vox, tone for PC,  no, tone, vox for PDA
		case 1:  // pda and pda type is not the same
			new_node[i].alert_type = 2;
			break;
		case 2:
			new_node[i].alert_type = 1;
			break;
		default:
			new_node[i].alert_type = 0;
		}
		new_node[i].msg = SchExtractContent(content_ptr, i, content_len);
		switch(((AppointmentDB*) data_ptr)[i].alarm_time)
		{
		case EXACT_TIME:
		case MIN_15_BEFORE:
		case MIN_30_BEFORE:
		case MIN_60_BEFORE:
			if(new_node[i].alert_type != 0)
				new_node[i].alert_time = ((AppointmentDB*) data_ptr)[i].alarm_time;
			else
				new_node[i].alert_time = 0;
			break;
		default:
			new_node[i].alert_time = 0;
//			new_node[i].alert_time = EXACT_TIME;
			break;
		}

		new_node[i].alm_num = ((AppointmentDB*) data_ptr)[i].alarm_num;
		new_node[i].dbid = ((AppointmentDB*) data_ptr)[i].dbid;
		new_node[i].rec_id = ((AppointmentDB*) data_ptr)[i].recid;
		new_node[i].appmt_num = ((AppointmentDB*) data_ptr)[i].appmt_num;
	}


	//resolve the end time
	for(i=0;i<total_appt;i++)
	{
		if(new_node[i].connected_row == -1)
			continue;   // unused row

		if((new_node[i].connected_row >= 0) &&
		   (new_node[i].connected_row < total_appt))
		{
			new_node[i].schend_time =  new_node[new_node[i].connected_row].schstart_time;
		}
		else
			new_node[i].schend_time = new_node[i].schstart_time;
	}

	// remove invalid row
	for(i=0;i<total_appt;i++)
	{
		if(new_node[i].connected_row != -1)
			continue;
		for(j=i+1;j<total_appt;j++)
		{
			new_node[j-1] = new_node[j];
		}
		total_appt--;
		i--;
	}

	*total_node = total_appt;

	return 0;

}



int SchExamPDAModiRecord(CString *rec_content, SchNode **sch_node, int *total_node)
{
	int sch_year;
	char sch_month;
	char sch_day;
	COleDateTime sch_date;
	CString fielddata;
	CString contentdata;
	int i, j;
	int total_appt, content_len;
	char *data_ptr, *content_ptr;
	SchNode *new_node;

	int MaxDay[] = {31,28,31,30,31,30,31,31,30,31,30,31};

	PDADataGetField(0, rec_content, &fielddata);
	if(fielddata.GetLength() != 3)
		return 1;		// error

	sch_year = DATE_OFFSET + (int)(unsigned char) fielddata[0];
//	if(sch_year < 1973)
//		sch_year = 1973;
//	else if(sch_year > 2037)
//		sch_year = 2037;

	sch_month = fielddata[1];
	if(sch_month < 1)
		sch_month = 1;
	else if(sch_month > 12)
		sch_month = 12;

	sch_day = fielddata[2];
	if(sch_day < 1)
		sch_day = 1;
	else if(sch_day > 31)
		sch_day = MaxDay[sch_month - 1];

	sch_date = ConstructDate(sch_year, sch_month, sch_day, 0 , 0, 0);

	PDADataGetField(1, rec_content, &fielddata);
	total_appt = *total_node;
	*total_node = 0;
	
	if(total_appt > 100)  // too many, impossible!
		return 1;
	
	new_node = *sch_node;

	TRACE("\n %d ", sizeof(SchNode) * total_appt);
	if(!sch_node)
	{
		CString string;
		string.LoadString(IDS_ERROR_MEMORY);
		AfxMessageBox(string);
		return 2;
	}

	PDADataGetField(2, rec_content, &contentdata);
	content_len = contentdata.GetLength();
	data_ptr = (LPSTR) fielddata.GetBuffer(fielddata.GetLength());
	content_ptr = (LPSTR) contentdata.GetBuffer(contentdata.GetLength());

	// init all node
	for(i=0;i<total_appt;i++)
	{
		new_node[i].schdate = sch_date;
		
		new_node[i].schstart_time = ConstructDate(sch_year, sch_month, sch_day,((AppointmentDB*) data_ptr)[i].hour  , ((AppointmentDB*) data_ptr)[i].minute ,0);
		
		new_node[i].connected_row = ((AppointmentDB*) data_ptr)[i].appointment;

		new_node[i].alm_num = ((AppointmentDB*) data_ptr)[i].alarm_num;

		new_node[i].appmt_num = ((AppointmentDB*) data_ptr)[i].appmt_num;

		if(station_num == 2)
		{
			if(!(new_node[i].appmt_num & 0x80000000) && ((new_node[i].appmt_num < 0x3fffffff) || (new_node[i].appmt_num <= 0x5fffffff)) ) /* not modi */
				new_node[i].connected_row = -1;
		}
		else
		{
			if(!(new_node[i].appmt_num & 0x80000000) && ((new_node[i].appmt_num < 0x3fffffff) || (new_node[i].appmt_num > 0x5fffffff)) ) /* not modi */
				new_node[i].connected_row = -1;
		}

		if(new_node[i].connected_row == -1)
			continue;   // unused row

		switch(((AppointmentDB*) data_ptr)[i].alarm)
		{ // no , vox, tone for PC,  no, tone, vox for PDA
		case 1:  // pda and pda type is not the same
			new_node[i].alert_type = 2;
			break;
		case 2:
			new_node[i].alert_type = 1;
			break;
		default:
			new_node[i].alert_type = 0;
		}
		new_node[i].msg = SchExtractContent(content_ptr, i, content_len);
		switch(((AppointmentDB*) data_ptr)[i].alarm_time)
		{
		case EXACT_TIME:
		case MIN_15_BEFORE:
		case MIN_30_BEFORE:
		case MIN_60_BEFORE:
			if(new_node[i].alert_type != 0)
				new_node[i].alert_time = ((AppointmentDB*) data_ptr)[i].alarm_time;
			else
				new_node[i].alert_time = 0;
			break;
		default:
//			new_node[i].alert_time = EXACT_TIME;
			new_node[i].alert_time = 0;
			break;
		}

		new_node[i].alm_num = ((AppointmentDB*) data_ptr)[i].alarm_num;
		new_node[i].dbid = ((AppointmentDB*) data_ptr)[i].dbid;
		new_node[i].rec_id = ((AppointmentDB*) data_ptr)[i].recid;
		new_node[i].appmt_num = ((AppointmentDB*) data_ptr)[i].appmt_num;
	}


	//resolve the end time
	for(i=0;i<total_appt;i++)
	{
		if(new_node[i].connected_row == -1)
			continue;   // unused row

		if((new_node[i].connected_row >= 0) &&
		   (new_node[i].connected_row < total_appt))
		{
			new_node[i].schend_time =  new_node[new_node[i].connected_row].schstart_time;
		}
		else
			new_node[i].schend_time = new_node[i].schstart_time;
	}

	// remove invalid row
	for(i=0;i<total_appt;i++)
	{
		if(new_node[i].connected_row != -1)
			continue;
		for(j=i+1;j<total_appt;j++)
		{
			new_node[j-1] = new_node[j];
		}
		total_appt--;
		i--;
	}

	*total_node = total_appt;


	return 0;

}


BOOL SchAddAbsRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	/* Note: all record in pc with same record id will be deleted,
	   then add the record in pda to pc */

	CString szSql;
	CString fielddata;
	SchNode *sch_node = NULL;
	int total_node, i;
	
	if (CatRec(rec_id))
		return FALSE;

	PDADataGetField(1, rec_content, &fielddata);
	total_node = fielddata.GetLength() / APPT_SIZE;

	if(total_node > 100)  // should not more than 100 in each day
		return FALSE;

	try
	{
		sch_node = new SchNode[total_node + 1];
	}
	catch(CException *e)
	{  // not enough mem
		e->Delete();
		return TRUE;
	}


	if(SchExamPDARecord(rec_content, &sch_node, &total_node) != 0)
	{
		delete []sch_node;
		return TRUE;
	}


	szSql = "delete from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		delete []sch_node;
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += SCHDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	for(i=0;i<total_node;i++)
	{

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");


	rsCurrent->SetFieldValue("SchDate",(LPCTSTR)sch_node[i].schdate.Format("%b %d %Y %H:%M:%S"));
	rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)Str_ul(sch_node[i].alert_type));
	rsCurrent->SetFieldValue("StartTime",(LPCTSTR)sch_node[i].schstart_time.Format("%H:%M:%S"));
	rsCurrent->SetFieldValue("EndTime",(LPCTSTR)sch_node[i].schend_time.Format("%H:%M:%S"));
	rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)Str_ul(sch_node[i].alert_time));

	fielddata = (sch_node[i].msg);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)fielddata);

	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)Str_ul(sch_node[i].rec_id));
	rsCurrent->SetFieldValue("VoiceDBID",(LPCTSTR)Str_ul(sch_node[i].dbid));
	rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)Str_ul(sch_node[i].alm_num));

	if(sch_node[i].appmt_num & 0x80000000) // modi flag set
		sch_node[i].appmt_num &= 0x7fffffff;// clr modi flag

	rsCurrent->SetFieldValue("Key",(LPCTSTR)Str_ul(sch_node[i].appmt_num));

	rsCurrent->Update();
	}

	rsCurrent->Close();
	delete rsCurrent;

	delete []sch_node;

	nPDA2PC++;
	return FALSE;
}



BOOL SchAddModiRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	/* Note: all record in pc with same record id will be deleted,
	   then add the record in pda to pc */

	CString szSql;
	CString fielddata;
	SchNode *sch_node = NULL;
	int total_node, i;
	
	if (CatRec(rec_id))
		return FALSE;

	PDADataGetField(1, rec_content, &fielddata);
	total_node = fielddata.GetLength() / APPT_SIZE;

	if(total_node > 100)  // should not more than 100 in each day
		return FALSE;

	try
	{
		sch_node = new SchNode[total_node + 1];
	}
	catch(CException *e)
	{  // not enough mem
		e->Delete();
		return TRUE;
	}


	if(SchExamPDAModiRecord(rec_content, &sch_node, &total_node) != 0)
	{
		delete []sch_node;
		return TRUE;
	}


	szSql = "delete from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		delete []sch_node;
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += SCHDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	for(i=0;i<total_node;i++)
	{

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	rsCurrent->SetFieldValue("SchDate",(LPCTSTR)sch_node[i].schdate.Format("%b %d %Y %H:%M:%S"));
	rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)Str_ul(sch_node[i].alert_type));
	rsCurrent->SetFieldValue("StartTime",(LPCTSTR)sch_node[i].schstart_time.Format("%H:%M:%S"));
	rsCurrent->SetFieldValue("EndTime",(LPCTSTR)sch_node[i].schend_time.Format("%H:%M:%S"));
	rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)Str_ul(sch_node[i].alert_time));

	fielddata = (sch_node[i].msg);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)fielddata);

	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)Str_ul(sch_node[i].rec_id));
	rsCurrent->SetFieldValue("VoiceDBID",(LPCTSTR)Str_ul(sch_node[i].dbid));
	rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)Str_ul(sch_node[i].alm_num));

	if(sch_node[i].appmt_num & 0x80000000) // modi flag set
		sch_node[i].appmt_num &= 0x7fffffff;// clr modi flag

	rsCurrent->SetFieldValue("Key",(LPCTSTR)Str_ul(sch_node[i].appmt_num));

	rsCurrent->Update();
	}


	rsCurrent->Close();
	delete rsCurrent;


	delete []sch_node;
	return FALSE;
}


void SchFindandInsertConnectRow(SchNode *sch_node, int *cur_row, int *total_row)
{
	// find the connect row
	// cur_row: cur examed row
	// total_row: total row in sch_node
	// assume all record in sch_node is in asc order of time
#define ACTION_FOUND	0
#define ACTION_INSERT	1
#define ACTION_LAST		2

	if(sch_node[*cur_row].connected_row != 65534)
	{
		(*cur_row)++;
		return;
	}

	int j, action = ACTION_LAST ;
	for(j=*cur_row+1;j<*total_row;j++)
	{
		if(sch_node[j].connected_row == 0xffff) // last vaild row
			break;

		if(sch_node[j].connected_row == -1)
			if(sch_node[j].schstart_time == sch_node[*cur_row].schend_time)
			{
				sch_node[*cur_row].connected_row = j;
				action = ACTION_FOUND;
				break;
			}
		if(sch_node[j].schstart_time >= sch_node[*cur_row].schend_time)
//		if(sch_node[j].schstart_time > sch_node[*cur_row].schend_time)
		{
			action = ACTION_INSERT;
			break;
		}
	}

	int k;
	COleDateTime x;
	switch(action)
	{
	case ACTION_FOUND:
		(*cur_row)++;
		break;
	case ACTION_INSERT:
		for(k=0;k<j;k++)  // adjust row reference
		{
			if((sch_node[k].connected_row >= j) &&
			   (sch_node[k].connected_row < 65530))
					sch_node[k].connected_row++;
		}
		for(k=*total_row;k>j;k--)
			sch_node[k] = sch_node[k-1];
		sch_node[j].connected_row = -1;
		sch_node[j].schstart_time.SetDateTime(sch_node[*cur_row].schend_time.GetYear(), sch_node[*cur_row].schend_time.GetMonth(), sch_node[*cur_row].schend_time.GetDay(), sch_node[*cur_row].schend_time.GetHour(), sch_node[*cur_row].schend_time.GetMinute(), sch_node[*cur_row].schend_time.GetSecond());
		sch_node[j].alm_num = 0;
		sch_node[j].dbid = 0;
		sch_node[j].rec_id = 0;
		sch_node[j].alert_type = 0;
		TRACE("\n%d", (char) sch_node[j].schstart_time.GetHour());
		sch_node[*cur_row].connected_row = j;
		(*total_row)++;
		(*cur_row)++;
		break;
	case ACTION_LAST:
	default:
		sch_node[*total_row].connected_row = -1;
		sch_node[*total_row].schstart_time.SetDateTime(sch_node[*cur_row].schend_time.GetYear(), sch_node[*cur_row].schend_time.GetMonth(), sch_node[*cur_row].schend_time.GetDay(), sch_node[*cur_row].schend_time.GetHour(), sch_node[*cur_row].schend_time.GetMinute(), sch_node[*cur_row].schend_time.GetSecond());
		sch_node[*total_row].alm_num = 0;
		sch_node[*total_row].dbid = 0;
		sch_node[*total_row].rec_id = 0;
		sch_node[*total_row].alert_type = 0;
		TRACE("\n%d", (char) sch_node[j].schstart_time.GetHour());
		sch_node[*cur_row].connected_row = *total_row;
		(*total_row)++;
		(*cur_row)++;
		break;

	}
	return;

}


void SchConvertSchNode2AppointmentDB(SchNode *sch_node, int total_row, CString &appt, CString &appt_msg)
{
	// last node connectedrow value = 0xffff
	int i,j;
	appt.Empty();
	appt_msg.Empty();
	char *ptr;

	
	for(i=0;i<total_row;i++)
	{
		appt += (char) sch_node[i].schstart_time.GetHour();
		TRACE("\n%d ", (char) sch_node[i].schstart_time.GetHour());
		appt += (char) sch_node[i].schstart_time.GetMinute();
		TRACE("\n%d ", (char) sch_node[i].schstart_time.GetMinute());
		appt += (char) sch_node[i].alert_type;
		appt += (char) sch_node[i].alert_time;
		ptr = (char*) &sch_node[i].alm_num;
		for(j=0;j<4;j++)
			appt +=  ptr[j];
		ptr = (char*) &sch_node[i].connected_row;
		for(j=0;j<4;j++)
			appt +=  ptr[j];
		ptr = (char*) &sch_node[i].appmt_num;
		for(j=0;j<4;j++)
			appt +=  ptr[j];
		ptr = (char*) &sch_node[i].dbid;
		for(j=0;j<4;j++)
			appt +=  ptr[j];
		ptr = (char*) &sch_node[i].rec_id;
		for(j=0;j<4;j++)
			appt +=  ptr[j];

		if(sch_node[i].connected_row != -1)
		{
			if (strlen(sch_node[i].msg) == 0)	// Henry
				appt_msg += (char) 0;			// Henry
			RemoveNULL(&sch_node[i].msg);
			appt_msg += sch_node[i].msg;
			AddNULL(&appt_msg);
		}
		else
			appt_msg += (char) 0;
	}
}

BOOL PDASchAddAbsRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	SchNode *sch_node = NULL;
	CString appt;
	CString appt_msg;
	BOOL has_alarm = FALSE;
	int total_node = 0;
	int cur_row, i, total_row = 0;
	unsigned int size_array[10];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " order by StartTime";

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(rs->IsBOF())
	{
		if(rs)
		{
			rs->Close();
			delete rs;
		}
		return TRUE;
	}

	rs->MoveLast();
	try
	{
		// at most total number of node = total rec * 2
		sch_node = new SchNode[rs->GetRecordCount() * 2 + 14];
	}
	catch (CException *e)
	{
		e->Delete();
		TRACE("\nNot enougn memory in Sch");
		rs->Close();
		delete rs;
	}

	// init the rows for start time
	for(i=0;i<rs->GetRecordCount() * 2 + 1; i++)
	{
		sch_node[i].connected_row = 0xffff;
		sch_node[i].alert_time = 0;
	}

	cur_row = 0;
	rs->MoveFirst();
	while(!rs->IsEOF())
	{
		sch_node[cur_row].schdate = COleDateTime(rs->GetFieldValue("SchDate"));
		if(COleDateTime(rs->GetFieldValue("StartTime")).GetMinute() % 5 != 0)
		{
			COleDateTimeSpan tmpDate(0,0,(COleDateTime(rs->GetFieldValue("StartTime")).GetMinute() % 5),0);
			sch_node[cur_row].schstart_time = COleDateTime(rs->GetFieldValue("StartTime")) - tmpDate;
		}
		else
			sch_node[cur_row].schstart_time = COleDateTime(rs->GetFieldValue("StartTime"));
		if(COleDateTime(rs->GetFieldValue("EndTime")).GetMinute() % 5 != 0)
		{
			COleDateTimeSpan tmpDate(0,0,(COleDateTime(rs->GetFieldValue("EndTime")).GetMinute() % 5),0);
			sch_node[cur_row].schend_time = COleDateTime(rs->GetFieldValue("EndTime")) - tmpDate;
		}
		else
			sch_node[cur_row].schend_time = COleDateTime(rs->GetFieldValue("EndTime"));
		sch_node[cur_row].rec_id = rs->GetFieldValue("VoiceID").lVal;
		sch_node[cur_row].dbid = sch_vox_dbid;
		sch_node[cur_row].connected_row = 0xfffe;
		sch_node[cur_row].appmt_num = rs->GetFieldValue("Key").lVal;
		if(sch_node[cur_row].appmt_num & 0x80000000)  // modi flag set
			sch_node[cur_row].appmt_num &= 0x7fffffff;

//		TRACE("\n%d %d %d", rs->GetFieldValue("RecordID").lVal, rs->GetFieldValue("AlarmType").lVal,rs->GetFieldValue("AlarmTime").lVal);

		switch(rs->GetFieldValue("AlarmType").lVal)
		{
		case 1:  // alarm type, PC & PDA swap type 1 & 2
			sch_node[cur_row].alert_type = 2;
			break;
		case 2:  
			sch_node[cur_row].alert_type = 1;
			break;
		case 3:
			sch_node[cur_row].alert_type = 3;
			break;
		default:
			sch_node[cur_row].alert_type = 0;
			break;
		}
		// note: in PC, even if alarm type = 2, but if alm time = 0, 
		// also means no alarm
		if(rs->GetFieldValue("AlarmTime").lVal == 0)
			sch_node[cur_row].alert_type = 0;

		if( (sch_node[cur_row].alert_type == 2) ||  // has voice
		    (sch_node[cur_row].alert_type == 3) )
		{
			sch_node[cur_row].rec_id = rs->GetFieldValue("VoiceID").lVal;
			sch_node[cur_row].dbid = sch_vox_dbid;
		}

		if( (sch_node[cur_row].alert_type == 1) ||  // has alarm
		    (sch_node[cur_row].alert_type == 2) )
		{
			has_alarm = TRUE;
			sch_node[cur_row].alert_time = rs->GetFieldValue("AlarmTime").lVal;
			if((sch_node[cur_row].alert_time < 0) || (sch_node[cur_row].alert_time > 5))
			{
				sch_node[cur_row].alert_time = 2;
			}
//			if(rs->GetFieldValue("AlarmNumber").lVal ==0)  // no alarm number yet
//				sch_node[cur_row].alm_num = sch_next_alarm_number++;
			sch_node[cur_row].alm_num = rs->GetFieldValue("AlarmNumber").lVal;
		}
		else
			sch_node[cur_row].alm_num = 0;

		sch_node[cur_row].msg = (LPSTR) rs->GetFieldValue("Content").bstrVal;
		cur_row++;
		rs->MoveNext();
	}

	total_row = cur_row;
	cur_row = 0;
	// insert end time row
	for(i=0;i<total_row;i++)
		SchFindandInsertConnectRow(sch_node, &cur_row, &total_row);
/*
	for(i=0;i<10;i++)
	{
	sch_node[total_row] = sch_node[total_row-1];
	total_row++;
	}
*/
	SchConvertSchNode2AppointmentDB(sch_node, total_row, appt, appt_msg);

/*	if(has_alarm)			//unknown usage
	{
		CString sql;
		sql = "update Scheduler set AlarmNumber = ";
		sql += Str_ul(sch_next_alarm_number);
		sql += " where RecordID = ";
		sql += Str_ul(rec_id);
		try
		{
			src_db->Execute(sql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
		}
	}
*/
	rs->MoveFirst();

	/* encode the record into PDA data format */
	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 4;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));

	fielddata.Empty();  // date
	fielddata = (char) (sch_node[0].schdate.GetYear() - DATE_OFFSET);
	fielddata += (char) (sch_node[0].schdate.GetMonth());
	fielddata += (char) (sch_node[0].schdate.GetDay());
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	fielddata.Empty();  // appointmentdb
	size_array[1] = appt.GetLength();
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += appt;
	appt.Empty();

	size_array[2] = appt_msg.GetLength();
	data32_2 = size_array[2];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += appt_msg;
	appt_msg.Empty();

	size_array[3] = 1;
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	if(has_alarm)
		content += (char) 0x01;
	else
		content += (char) 0x00;

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 4, size_array, &header, &content);


	szSql = "update ";
	szSql += SCHDB;
	szSql += " set Key =  Key - ";
	szSql += Str_ul(0x80000000);
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and Key < 0 ";

	try
	{
		src_db->Execute(szSql);
	}
	catch (CException *e)
	{
		e->Delete();
	}


	if(rs)
	{
		rs->Close();
		delete rs;
	}

	delete []sch_node;
	nPC2PDA++;

	return FALSE;
}


BOOL SchGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += SCHDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}


BOOL SchMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	COleVariant fielddata;
	CString szStr;

#ifdef xxxxxxxxxxxxxxxxxxx

/* if the record is in dest, delete it */
/*	szSql = "delete from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += SCHDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AlarmType"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AlarmTime"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("VoiceID"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("VoiceDBID"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("VoiceDBID",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AlarmNumber"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Key"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Key",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("SchDate");
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("SchDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("StartDate"); 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("StartDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("EndDate"); 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("EndDate",(LPCTSTR)szStr);


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;



	rs->Close();
*/
#endif
	szSql = "delete from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
//		delete rs;
		return TRUE;
	}

//	delete rs;

	return FALSE;
}


BOOL SchExistModiRecord(CDaoDatabase *src_db, RTM last_sync_date, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *pRs;

	szSql = "select 1 from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and ModifyDate >= ";
	szSql += _date322DB(_rtm2date32(last_sync_date));

	pRs = new CDaoRecordset(src_db);
	
	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		return FALSE;
	}

	BOOL rv;

	if(pRs->IsBOF())
		rv = FALSE;
	else
		rv = TRUE;


	delete pRs;

	return rv;

}
					
void SchDeleteInvalidRec()
{
	CString szSql;

	szSql = "delete * from ";
	szSql += SCHDB;
	szSql += " where RecordID < 0 ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
	}
}


BOOL SchExistKey(CDaoDatabase *src_db, int key_value)
{
	CString szSql;
	CDaoRecordset *pRs = NULL;
	BOOL return_value = FALSE;
	
	szSql = "select key from ";
	szSql += SCHDB;
	szSql += " where Key = ";
	szSql += Str_ul(key_value & 0x7fffffff);
	szSql += " or Key = ";
	szSql += Str_ul(key_value | 0x80000000);

	pRs = new CDaoRecordset(src_db);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(pRs)
		delete pRs;
		return FALSE;
	}

	if(pRs->IsBOF())
		return_value = FALSE;
	else
		return_value = TRUE;

	delete pRs;

	return return_value;
}



void SchMoveAppttoRecycle(RecordID rec_id, unsigned int key)
{
	CString szSql;
	CDaoRecordset *pRs = NULL;
	COleDateTime dt;
	CString fd;
	CString szStr;

	szSql = "Select * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and ( Key = ";
	szSql += Str_ul(key & 0x7fffffff);
	szSql += " or Key = ";
	szSql += Str_ul(key | 0x80000000);
	szSql += ")";

	pRs = new CDaoRecordset(dbCurrent);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(pRs)
			delete pRs;
		return;
	}

	if(!pRs->IsBOF())
      if(!SchExistKey(dbArchive, pRs->GetFieldValue("Key").lVal))
	  {

			CDaoRecordset* rsCurrent = NULL;
			rsCurrent = new CDaoRecordset(dbRecycle);
			COleVariant fielddata;

			szSql = "Select * from ";
			szSql += SCHDB;

			try
			{
				rsCurrent->Open(dbOpenDynaset, szSql , 0);
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\ncannot exe SQL statement %s ", szSql);
				return;
			}

			rsCurrent->AddNew();

			szStr = Str_ul(pRs->GetFieldValue("RecordID").lVal);
			rsCurrent->SetFieldValue("RecordID",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("ModifyDate");	// Modifydata 
			szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
			rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("Category");	// category 
			szStr.Format("%d", fielddata.lVal);
			rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("Secret");	// secret 
			szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
			rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("Lock");	// lock
			szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
			rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

			  if(pRs->GetFieldValue("AlarmType").lVal)
				  szStr = "2";  // only allow tone alarm
			  else
				  szStr = "0";
			rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)szStr);

//			  szStr =  Str_ul(pRs->GetFieldValue("AlarmTime").lVal);
//			rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)szStr);

			  fd = (LPSTR) pRs->GetFieldValue("Content").bstrVal;
			rsCurrent->SetFieldValue("Content",(LPCTSTR)fd);

			  dt = COleDateTime(pRs->GetFieldValue("SchDate"));
			  szStr = dt.Format("%b %d %Y");
			rsCurrent->SetFieldValue("SchDate",(LPCTSTR)szStr);

			  dt = COleDateTime(pRs->GetFieldValue("StartTime"));
			  szStr = dt.Format("%H:%M:%S");
			rsCurrent->SetFieldValue("StartTime",(LPCTSTR)szStr);

			  dt = COleDateTime(pRs->GetFieldValue("EndTime"));
			  szStr = dt.Format("%H:%M:%S");
			rsCurrent->SetFieldValue("EndTime",(LPCTSTR)szStr);

			  szStr =  Str_ul(pRs->GetFieldValue("AlarmTime").lVal);
			rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)szStr);

			rsCurrent->SetFieldValue("VoiceDBID",(LPCTSTR)"7");

			  szStr =  Str_ul(pRs->GetFieldValue("AlarmNumber").lVal);
			rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)szStr);

			  szStr = Str_ul((pRs->GetFieldValue("Key").lVal & 0x7fffffff));
			rsCurrent->SetFieldValue("Key",(LPCTSTR)szStr);

			rsCurrent->Update();
			rsCurrent->Close();
			delete rsCurrent;


			  if((pRs->GetFieldValue("AlarmType").lVal == 1) ||
				 (pRs->GetFieldValue("AlarmType").lVal == 3))
			  {
				  szSql = "delete * from SchVox where RecordID = ";
				  szSql += Str_ul(pRs->GetFieldValue("VoiceID").lVal);

				  try
				  {
					  dbCurrent->Execute(szSql);
				  }
				  catch(CException *e)
				  {
					  e->Delete();
					  TRACE("\nCannot exe %s", szSql);
				  }
				  CString fn;
				  fn.Format("%08x.alp", pRs->GetFieldValue("VoiceID").lVal);
				  fn = szUserPath + "SchVox\\" + fn;
//				  DeleteFile(fn);
			  }
	  }


	szSql = "delete * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and ( Key = ";
	szSql += Str_ul(key & 0x7fffffff);
	szSql += " or Key = ";
	szSql += Str_ul(key | 0x80000000);
	szSql += ")";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}

	if(pRs)
		delete pRs;

}








void SchDelUnModiRecord(RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *pRs = NULL;
	COleDateTime dt;
	CString fd;

	szSql = "Select * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and Key > 0";

	pRs = new CDaoRecordset(dbCurrent);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(pRs)
			delete pRs;
		return;
	}

	if(!pRs->IsBOF())
	  while(!pRs->IsEOF())
	  {
		  if(!SchExistKey(dbArchive, pRs->GetFieldValue("Key").lVal))
		  {
			CDaoRecordset* rsCurrent = NULL;
			rsCurrent = new CDaoRecordset(dbRecycle);
			COleVariant fielddata;
			CString szStr;

			szSql = "Select * from ";
			szSql += SCHDB;

			try
			{
				rsCurrent->Open(dbOpenDynaset, szSql , 0);
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\ncannot exe SQL statement %s ", szSql);
				return;
			}

			rsCurrent->AddNew();

			szStr = Str_ul(pRs->GetFieldValue("RecordID").lVal);
			rsCurrent->SetFieldValue("RecordID",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("ModifyDate");	// Modifydata 
			szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
			rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("Category");	// category 
			szStr.Format("%d", fielddata.lVal);
			rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("Secret");	// secret 
			szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
			rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

			fielddata = pRs->GetFieldValue("Lock");	// lock
			szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
			rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	  	    if(pRs->GetFieldValue("AlarmType").lVal)
				  szStr = "2";  // only allow tone alarm
			else
				  szStr = "0";
			rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)szStr);

//			  szStr =  Str_ul(pRs->GetFieldValue("AlarmTime").lVal);
//			rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)szStr);

			  fd = (LPSTR) pRs->GetFieldValue("Content").bstrVal;
			rsCurrent->SetFieldValue("Content",(LPCTSTR)fd);

			  dt = COleDateTime(pRs->GetFieldValue("SchDate"));
			  szStr = dt.Format("%b %d %Y");
			rsCurrent->SetFieldValue("SchDate",(LPCTSTR)szStr);

			  dt = COleDateTime(pRs->GetFieldValue("StartTime"));
			  szStr = dt.Format("%H:%M:%S");
			rsCurrent->SetFieldValue("StartTime",(LPCTSTR)szStr);

			  dt = COleDateTime(pRs->GetFieldValue("EndTime"));
			  szStr = dt.Format("%H:%M:%S");
			rsCurrent->SetFieldValue("EndTime",(LPCTSTR)szStr);

			  szStr =  Str_ul(pRs->GetFieldValue("AlarmTime").lVal);
			rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)szStr);

			rsCurrent->SetFieldValue("VoiceDBID",(LPCTSTR)"7");

			  szStr =  Str_ul(pRs->GetFieldValue("AlarmNumber").lVal);
			rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)szStr);

			  szStr = Str_ul((pRs->GetFieldValue("Key").lVal & 0x7fffffff));
			rsCurrent->SetFieldValue("Key",(LPCTSTR)szStr);

			rsCurrent->Update();
			rsCurrent->Close();
			delete rsCurrent;

			  if((pRs->GetFieldValue("AlarmType").lVal == 1) ||
				 (pRs->GetFieldValue("AlarmType").lVal == 3))
			  {
				  szSql = "delete * from SchVox where RecordID = ";
				  szSql += Str_ul(pRs->GetFieldValue("VoiceID").lVal);

				  try
				  {
					  dbCurrent->Execute(szSql);
				  }
				  catch(CException *e)
				  {
					  e->Delete();
					  TRACE("\nCannot exe %s", szSql);
				  }
				  CString fn;
				  fn.Format("%08x.alp", pRs->GetFieldValue("VoiceID").lVal);
				  fn = szUserPath + "SchVox\\" + fn;
				  DeleteFile(fn);
			  }
		  }
		  pRs->MoveNext();
	  }

	  if(pRs)
		  delete pRs;

  	szSql = "delete * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and Key > 0";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}

}


int SchExamPDAModiAndNotModiRecord(RecordID rec_id, CString *rec_content, SchNode **sch_node, int *total_node)
{
/* 1) del rec in PC but not in PDA, and Key in PC > 0  */
/* 2) return modi rec in PDA */

	int sch_year;
	char sch_month;
	char sch_day;
	COleDateTime sch_date;
	CString fielddata;
	CString contentdata;
	int i, j;
	int total_appt, content_len;
	char *data_ptr, *content_ptr;
	SchNode *new_node;
	CString szSql;


	int MaxDay[] = {31,28,31,30,31,30,31,31,30,31,30,31};

	PDADataGetField(0, rec_content, &fielddata);
	if(fielddata.GetLength() != 3)
		return 1;		// error

	sch_year = DATE_OFFSET + (int)(unsigned char) fielddata[0];
//	if(sch_year < 1973)
//		sch_year = 1973;
//	else if(sch_year > 2037)
//		sch_year = 2037;

	sch_month = fielddata[1];
	if(sch_month < 1)
		sch_month = 1;
	else if(sch_month > 12)
		sch_month = 12;

	sch_day = fielddata[2];
	if(sch_day < 1)
		sch_day = 1;
	else if(sch_day > 31)
		sch_day = MaxDay[sch_month - 1];

	sch_date = ConstructDate(sch_year, sch_month, sch_day, 0 , 0, 0);

	PDADataGetField(1, rec_content, &fielddata);
	total_appt = *total_node;
	*total_node = 0;
	
	if(total_appt > 100)  // too many, impossible!
		return 1;
	
	new_node = *sch_node;

	TRACE("\n %d ", sizeof(SchNode) * total_appt);
	if(!sch_node)
	{
		CString string;
		string.LoadString(IDS_ERROR_MEMORY);
		AfxMessageBox(string);
		return 2;
	}

	PDADataGetField(2, rec_content, &contentdata);
	content_len = contentdata.GetLength();
	data_ptr = (LPSTR) fielddata.GetBuffer(fielddata.GetLength());
	content_ptr = (LPSTR) contentdata.GetBuffer(contentdata.GetLength());

	szSql = "select * from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " and Key > 0 and Key not in(0,";

	// init all node
	for(i=0;i<total_appt;i++)
	{
		new_node[i].schdate = sch_date;
		
		new_node[i].schstart_time = ConstructDate(sch_year, sch_month, sch_day,((AppointmentDB*) data_ptr)[i].hour  , ((AppointmentDB*) data_ptr)[i].minute ,0);
		
		new_node[i].connected_row = ((AppointmentDB*) data_ptr)[i].appointment;

		new_node[i].alm_num = ((AppointmentDB*) data_ptr)[i].alarm_num;
		new_node[i].appmt_num = ((AppointmentDB*) data_ptr)[i].appmt_num;

		if(new_node[i].connected_row != -1)
			szSql += Str_ul(new_node[i].appmt_num) + (CString) ",";

		if(station_num == 2)
		{
			if(!(new_node[i].appmt_num & 0x80000000) && new_node[i].appmt_num <= 0x5fffffff ) /* not modi */
				new_node[i].connected_row = -1;
		}
		else
		{
			if(!(new_node[i].appmt_num & 0x80000000) && new_node[i].appmt_num > 0x5fffffff ) /* not modi */
				new_node[i].connected_row = -1;
		}

		if(new_node[i].connected_row == -1)
			continue;   // unused row

		switch(((AppointmentDB*) data_ptr)[i].alarm)
		{ // no , vox, tone for PC,  no, tone, vox for PDA
		case 1:  // pda and pda type is not the same
			new_node[i].alert_type = 2;
			break;
		case 2:
			new_node[i].alert_type = 1;
			break;
		default:
			new_node[i].alert_type = 0;
		}
		new_node[i].msg = SchExtractContent(content_ptr, i, content_len);
		switch(((AppointmentDB*) data_ptr)[i].alarm_time)
		{
		case EXACT_TIME:
		case MIN_15_BEFORE:
		case MIN_30_BEFORE:
		case MIN_60_BEFORE:
			if(new_node[i].alert_type != 0)
				new_node[i].alert_time = ((AppointmentDB*) data_ptr)[i].alarm_time;
			else
				new_node[i].alert_time = 0;
			break;
		default:
//			new_node[i].alert_time = EXACT_TIME;
			new_node[i].alert_time = 0;
			break;
		}

		new_node[i].alm_num = ((AppointmentDB*) data_ptr)[i].alarm_num;
		new_node[i].dbid = ((AppointmentDB*) data_ptr)[i].dbid;
		new_node[i].rec_id = ((AppointmentDB*) data_ptr)[i].recid;
		new_node[i].appmt_num = ((AppointmentDB*) data_ptr)[i].appmt_num;
	}


	//resolve the end time
	for(i=0;i<total_appt;i++)
	{
		if(new_node[i].connected_row == -1)
			continue;   // unused row

		if((new_node[i].connected_row >= 0) &&
		   (new_node[i].connected_row < total_appt))
		{
			new_node[i].schend_time =  new_node[new_node[i].connected_row].schstart_time;
		}
		else
			new_node[i].schend_time = new_node[i].schstart_time;
	}

	// remove invalid row
	for(i=0;i<total_appt;i++)
	{
		if(new_node[i].connected_row != -1)
			continue;
		for(j=i+1;j<total_appt;j++)
		{
			new_node[j-1] = new_node[j];
		}
		total_appt--;
		i--;
	}

	*total_node = total_appt;

	szSql = szSql.Left(szSql.GetLength()-1); // cut last ','
	szSql += ")";

	CDaoRecordset *pRs=NULL;

	pRs = new CDaoRecordset(dbCurrent);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete pRs;
		return 0;
	}

	if(!pRs->IsBOF())
		while(!pRs->IsEOF())
		{
			SchMoveAppttoRecycle(pRs->GetFieldValue("RecordID").lVal, pRs->GetFieldValue("Key").lVal);
			pRs->MoveNext();
		}

	if(pRs)
		delete pRs;


	return 0;

}


BOOL SchDelPCNotModiRecordAndNotInPDA(RecordHeader *rec_header, CString *rec_content)
{
	/* Note: all record in pc with same record id will be deleted,
	   then add the record in pda to pc */

	CString szSql;
	CString fielddata;
	SchNode *sch_node = NULL;
	int total_node, i;
	RecordID rec_id = rec_header->rec_id;
	
	if (CatRec(rec_id))
		return FALSE;

	PDADataGetField(1, rec_content, &fielddata);
	total_node = fielddata.GetLength() / APPT_SIZE;

	if(total_node > 100)  // should not more than 100 in each day
		return FALSE;

	try
	{
		sch_node = new SchNode[total_node + 1];
	}
	catch(CException *e)
	{  // not enough mem
		e->Delete();
		return TRUE;
	}

	if(SchExamPDAModiAndNotModiRecord(rec_id, rec_content, &sch_node, &total_node) != 0)
	{
		delete []sch_node;
		return TRUE;
	}
/*

	szSql = "delete from ";
	szSql += SCHDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		delete []sch_node;
		return TRUE;
	}
*/
	for(i=0;i<total_node;i++)
	{

		sch_node[i].appmt_num &= 0x7fffffff;// clr modi flag

		SchMoveAppttoRecycle(rec_id, sch_node[i].appmt_num);

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dbCurrent);

	szSql = "Select * from ";
	szSql += SCHDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");
	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");
	rsCurrent->SetFieldValue("SchDate",(LPCTSTR)sch_node[i].schdate.Format("%b %d %Y %H:%M:%S"));
	rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)Str_ul(sch_node[i].alert_type));
	rsCurrent->SetFieldValue("StartTime",(LPCTSTR)sch_node[i].schstart_time.Format("%H:%M:%S"));
	rsCurrent->SetFieldValue("EndTime",(LPCTSTR)sch_node[i].schend_time.Format("%H:%M:%S"));
	rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)Str_ul(sch_node[i].alert_time));
	CString string;
	string = (sch_node[i].msg);
	RemoveNULL(&string);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)string);
	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)Str_ul(sch_node[i].rec_id));
	rsCurrent->SetFieldValue("VoiceDBID",(LPCTSTR)Str_ul(sch_node[i].dbid));
	rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)Str_ul(sch_node[i].alm_num));
	rsCurrent->SetFieldValue("Key",(LPCTSTR)Str_ul(sch_node[i].appmt_num));


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	}
	delete []sch_node;
	return FALSE;
}

void SchSyncBoth(DatabaseID dbid, RecordHeader *rec_header, RTM last_sync_date)
{
	/* 1) del from PC where key not in PDA and key > 0
	   2) sync PDA rec with key high bit set to PC
	   3) del PDA rec
	   4) sync to PDA
   */
	CString rec_content;
	char header[RECHEADER_SIZE + 1];

	if (TimeDiff(_date322rtm(rec_header->modi_date), last_sync_date) > MODI_TIME)
	{
 	SyncIdleMode();
	SyncDBEnqMode();
	SyncReadRec(dbid, rec_header->rec_id, header, &rec_content);
	SchDelPCNotModiRecordAndNotInPDA(rec_header, &rec_content);
	SyncIdleMode(); CHKTERM;
	SyncDBUpMode(); CHKTERM;
	}
	PDADeleteRecord(dbid, rec_header->rec_id); CHKTERM;
	PDASchAddAbsRecord(dbCurrent, dbid, rec_header->rec_id); CHKTERM;

terminate:
	return;
}


BOOL SchUpdateAlmNumber(DatabaseID dbid)
{
  /* current PDA stauts is in DBEnq Mode */
	char rec_header[RECHEADER_SIZE + 10];
	CString rec_content;
	unsigned int pda_timeindex[4];

	unsigned char status;
	unsigned char font_size;
	int alm_no;
	unsigned int appt_no;
	CString szSql;

	CString fielddata;
	char *ptr;
	int i;

#define SCH_STATUS	0x80001000

	szSql = "update ";
	szSql += SCHDB;
	szSql += " set Key = Key + ";
	szSql += Str_ul(0x80000000);
	szSql += " where Key > 0 and Key < ";
	szSql += Str_ul(0x7fffffff);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
	

 	if(SyncReadRec(dbid, SCH_STATUS, (char*)&rec_header, &rec_content) != 0)
		return TRUE;

	ptr = (char*) &alm_no;

	PDADataGetField(2, &rec_content, &fielddata);

	if(fielddata.GetLength() != 4)
		return FALSE;

	for(i=0;i<4;i++)
	  *(ptr++) = fielddata[i];

	alm_no -= 1000;

	if((alm_no > 0) && (alm_no < 0x3fffffff))
	{
	
		szSql = "update ";
		szSql += SCHDB;
		szSql += " set AlarmNumber = AlarmNumber + ";
		szSql += Str_ul(alm_no);
		szSql += " where AlarmNumber > 0";
		szSql += " and AlarmNumber < ";
		szSql += Str_ul(0x3fffffff);
		try
		{
			dbCurrent->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
		}
		try
		{
			dbArchive->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			/* prog continue even cannot update arch. db */
		}
		try
		{
			dbRecycle->Execute(szSql);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\ncannot exe SQL statement %s ", szSql);
			/* prog continue even cannot update arch. db */
		}
	}

	return TRUE;

}


void ValidSchAlmAndApptNumber()
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	int pc_default;
	int pc_default2;

	pc_default = 0x7fffffff;
	pc_default2 = 0x5fffffff;
	if(station_num == 2)
	{
		pc_default = 0x5fffffff;
		pc_default2 = 0x3fffffff;
	}

	int value = pc_default;
	int value2;

	szSql = "select Min(AlarmNumber) from ";
	szSql += SCHDB;
	szSql += " where AlarmNumber < ";
	szSql += Str_ul(pc_default);
	szSql += " and AlarmNumber > ";
	szSql += Str_ul(pc_default2);
	
	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
		if(!rs->IsBOF())
			if(rs->GetFieldValue(0).lVal != 0)
			  if(rs->GetFieldValue(0).lVal > pc_default2)
				value = rs->GetFieldValue(0).lVal;

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(value > pc_default2)
	{
	szSql = "update ApplicationDB set EMailNewPCDraft = ";
	szSql += Str_ul(value);
	szSql += " where DatabaseName = '";
	szSql += SCHDB;
	szSql += "' and EMailNewPCDraft > ";
	szSql += Str_ul(value);

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}
	}


	value = pc_default;

	szSql = "select Min(Key) from ";
	szSql += SCHDB;
	szSql += " where Key < ";
	szSql += Str_ul(pc_default);
	szSql += " and Key > ";
	szSql += Str_ul(pc_default2);
	
	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
		if(!rs->IsBOF())
			if(rs->GetFieldValue(0).lVal != 0)
			  if(rs->GetFieldValue(0).lVal > pc_default2)
				value = rs->GetFieldValue(0).lVal;

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

//////////// modi rec
	szSql = "select Min(Key) as MinID from ";
	szSql += SCHDB;
	szSql += " where Key > ";
	szSql += Str_ul((pc_default2 | 0x80000000));
	szSql += " and Key < 0";

	value2 = pc_default;

	rs = new CDaoRecordset(dbCurrent);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		rs = NULL;
	}

	if(rs)
	{
		if(!rs->IsBOF())
			if(rs->GetFieldValue(0).lVal != 0)
 		  value2 = rs->GetFieldValue(0).lVal & 0x7fffffff;

		delete rs;
		rs = NULL;
	}

	if(value2 < value)
		value = value2;

	if(value > pc_default2)
	{
	szSql = "update ApplicationDB set EMailLastSyncDraft = ";
	szSql += Str_ul(value);
	szSql += " where DatabaseName = '";
	szSql += SCHDB;
	szSql += "' and EMailLastSyncDraft > ";
	szSql += Str_ul(value);

	try
	{
		dbAppDB->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\nCannot exe %s ", szSql);
	}
	}


}

void UpdateSchStatus(int alarm_num,int appt_num, int repeat_num)
{
	
	CString szSql;

	szSql = "update ";
	szSql += SCHDB;
	szSql += " set AlarmNumber = AlarmNumber + ";
	szSql += Str_ul(alarm_num - 1000);
	szSql += " where AlarmNumber >= ";
	szSql += Str_ul(1000);
	szSql += " and AlarmNumber < ";
	szSql += Str_ul(0x3fffffff);
	
	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
	}

	szSql = "update ";
	szSql += SCHDB;
	szSql += " set key = key + ";
	szSql += Str_ul(appt_num - 1000 + 0x80000000);
	szSql += " where key >= ";
	szSql += Str_ul(1000);
	szSql += " and key < ";
	szSql += Str_ul(0x3fffffff);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
	}

	szSql = "update ";
	szSql += SCHREPDB;
	szSql += " set repeatnumber = repeatnumber + ";
	szSql += Str_ul(repeat_num - 1000);
	szSql += " where repeatnumber >= ";
	szSql += Str_ul(1000);
	szSql += " and repeatnumber < ";
	szSql += Str_ul(0x3fffffff);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
	}

}

BOOL PDASchAddSpecRecord(DatabaseID dbid, RecordID rec_id,int offset1,int offset2,int offset3)
{
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[5];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;
	char *ptr1;
	char *ptr2;
	char *ptr3;

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime::GetCurrentTime()));
	header.total_field = 5;
	header.cat = 0;	/* category */
    header.attribute = 0;

	fielddata.Empty();
	fielddata = (char)0x00; //application status == RESTART
	size_array[0] = 1;
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	fielddata.Empty();		
	fielddata = (char)0x00;	//FONT SIZE
	size_array[1] = 1;
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	fielddata.Empty();		

	//alarm number
	size_array[2] = 4;
	data32_2 = size_array[2];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	ptr1 = (char*) &offset1;
	content += ptr1[0];
	content += ptr1[1];
	content += ptr1[2];
	content += ptr1[3];

	//appoint no
	size_array[3] = 4;
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	ptr2 = (char*) &offset2;
	content += ptr2[0];
	content += ptr2[1];
	content += ptr2[2];
	content += ptr2[3];

	//repeat no
	size_array[4] = 4;
	data32_2 = size_array[4];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	ptr3 = (char*) &offset3;
	content += ptr3[0];
	content += ptr3[1];
	content += ptr3[2];
	content += ptr3[3];

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 5, size_array, &header, &content);

	return FALSE;
}
