
#ifndef __Sch_H__
#define __Sch_H__
#include "syncfx.h"
#include "SyncDB.h"

   
/* Scheduler Appointment Database Structure */
typedef struct _APPOINTMENT_DB 
{
	char			hour;
	char			minute;
	char			alarm;
	char			alarm_time;
	unsigned int	alarm_num;
	int 			appointment; 
	unsigned int	appmt_num;
	DatabaseID		dbid;
	RecordID		recid;
}AppointmentDB;

#define APPT_SIZE	sizeof(AppointmentDB)

typedef struct _SCH_NODE
{
	COleDateTime schdate;
	COleDateTime schstart_time;
	COleDateTime schend_time;
	char alert_type;
	char alert_time;
	unsigned int alm_num;
	unsigned int appmt_num;
	DatabaseID dbid;
	RecordID rec_id;
	CString msg;
	int connected_row;
}SchNode;

 // pda and pc swap the tone & voice, pc 1->vox 2->tone,  pda 1->tone 2->vox
#define	NO_ALARM					0
#define	TONE_ALARM					1 
#define	VOICE_ALARM					2
#define VOICE_NOT_ALARM             3

#define AM							0
#define PM							1

#define DONT_CARE					1
#define EXACT_TIME					2
#define MIN_15_BEFORE				3
#define MIN_30_BEFORE				4
#define MIN_60_BEFORE				5

BOOL SchAddAbsRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content);
BOOL PDASchAddAbsRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id);
BOOL SchMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id);
BOOL SchExistModiRecord(CDaoDatabase *src_db, RTM last_sync_date, RecordID rec_id);
BOOL SchAddModiRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content);
void SchDeleteInvalidRec();
void SchDelUnModiRecord(RecordID rec_id);
void SchSyncBoth(DatabaseID dbid, RecordHeader *rec_header, RTM lsd);
void ValidSchAlmAndApptNumber();
BOOL PDASchAddSpecRecord(DatabaseID dbid, RecordID rec_id,int offset1,int offset2,int offset3);
void UpdateSchStatus(int alarm_num,int appt_num, int repeat_num);

/*
BOOL PDASchAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id);
BOOL SchMoveRecordToRecycle(RecordID);
BOOL SchArchivePDAOvrPC(DatabaseID dbid);
BOOL SchArchivePCOvrPDA(DatabaseID dbid);
BOOL SchArchivePCPDA(DatabaseID dbid);
BOOL SchMoveRecord(CDaoDatabase*, CDaoDatabase*, RecordID);
BOOL SchMoveCat(CDaoDatabase*, CDaoDatabase*, RecordID);
BOOL SchAddCat(CDaoDatabase*, RecordID, RecordHeader*, CString*);
BOOL PDASchAddRecord(DatabaseID dbid, RecordHeader rec_id);
BOOL SchAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content);
BOOL SchGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid);
BOOLEAN SchExistFile(RecordID rec_id);
*/

#define PDA_SCHDB	"Scheduler Appointment Database"
#define SCH_VOXDB   "Scheduler Voice Database"
#define SCHDB		"Scheduler"

#endif


