#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "SCHEXCEP.h"

extern CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

BOOL SchExcepAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	COleDateTime date;

	int nTotalDates;
	CString szDate;
	
// todo handle NewRecordWithID record
	szSql = "delete from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	PDADataGetField(1, rec_content, &fielddata); // exception dates
	szDate = fielddata;
	nTotalDates = szDate.GetLength() / 3;
TRACE("%d\n",szDate.GetLength());
TRACE("%d\n",szDate);

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += SCHEXCEPDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	for (int i =0 ; i< nTotalDates; i++){

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);  // repeatnumber
	rsCurrent->SetFieldValue("RepeatNumber",(LPCTSTR)Val_ul(fielddata));

	date.SetDate(szDate[0 + i*3] + 1900, szDate[1 + i*3], szDate[2 + i*3]); //exceptiondate
	rsCurrent->SetFieldValue("ExceptionDate",(LPCTSTR)date.Format("%b %d %Y"));

	rsCurrent->Update();

	}

	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;
	return FALSE;
}


BOOL SchExcepAddRecord1(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	COleDateTime date;

	int nTotalDates;
	CString szDate;
	bool bFound;

// todo handle NewRecordWithID record
/*	szSql = "delete from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += "and ModifyDate <= ";
	szSql += tModifyDate.Format("%d %b %Y");

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}
*/
////prevent duplicate by getting all existing record in pc
	CDaoRecordset* rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF()){
		rs->MoveLast();
		rs->MoveFirst();
	}
	int nCount = rs->GetRecordCount();
////////////////////////////////////////////

	PDADataGetField(1, rec_content, &fielddata); // exception dates
	szDate = fielddata;
	nTotalDates = szDate.GetLength() / 3;

	for (int i =0 ; i< nTotalDates; i++){
	szSql = "insert into ";
	szSql += SCHEXCEPDB;
	szSql += "(RecordID, ModifyDate, Category, Secret, Lock, ";	
	szSql += "RepeatNumber, ExceptionDate) values (";

	szSql += Str_ul(rec_id);
	szSql += ", ";
	szSql += _date322DB(rec_header->modi_date);
	szSql += ", ";
	szSql += Str_ul( (unsigned int) (rec_header->cat));
	szSql += ", ";
	if(IsRecSecret(rec_header))
		szSql += "TRUE, ";
	else
		szSql += "FALSE, ";
	if(IsRecLock(rec_header))
		szSql += "TRUE, ";
	else
		szSql += "FALSE, ";

	PDADataGetField(0, rec_content, &fielddata);  // repeatnumber
	szSql += fielddata;
	szSql += ",";

//	PDADataGetField(1, rec_content, &fielddata); // exception date
	date.SetDate(szDate[0 + i*3] + 1900, szDate[1 + i*3], szDate[2 + i*3]);

	TRACE("%d - %d - %d\n",szDate[0 + i*3] + 1900, szDate[1 + i*3], szDate[2 + i*3]);

/*check for existing of record in pc*/
	rs->MoveFirst();
	for(int j =0; j< nCount; j++){
		bFound = false;
		if((COleDateTime)rs->GetFieldValue("ExceptionDate") == date){
			bFound = true;
			break;
		}
		rs->MoveNext();
	}
	if(bFound) continue;
////////////////////////////////////////

//	CString szDate = (CString) "#" + date.Format("%x") + "#)";
	CString szDate = (CString) "#" + date.Format("%m %d %Y") + "#)"; //sql only accept m/d/y
	SqlDateHandle(szDate);
	szSql += szDate;

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}
	
	}

	nPDA2PC++;
	return FALSE;
}


BOOL SchExcepMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;
	
//	if (CatRec(rec_id))
//		return SchExcepMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += SCHEXCEPDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("ExceptionDate"); 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ExceptionDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("RepeatNumber"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("RepeatNumber",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	
	rs->Close();

	szSql = "delete from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}



BOOL SchExcepArchive(DatabaseID dbid, int mode)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	RecStruct *cat_record = NULL;
	int total_cat = 0;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	cat_record = (RecStruct*)malloc(300 * sizeof(RecStruct));

	for(i=0;i<total_rec;i++)  // process non-category item
	{
		TRACE("\n%08x ", record[i].rec_header.rec_id );
	  if((record[i].rec_header.rec_id < (RecordID) 0x80000000))
	  {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		if(DBIsExistRecord(dbArchive, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			PCDeleteRecord(dbRecycle, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		SchExcepAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	  }
	  else
		  if(CatRec(record[i].rec_header.rec_id ))
//	  if(record[i].rec_header.rec_id < (UWORD) 0x80000100)
	  {
		//category
		   cat_record[total_cat++] = record[i];
	  }
	}

	if(record)
	   free(record);
	if(cat_record)
		free(cat_record);

	return 0;
}


BOOL SchExcepArchivePCOvrPDA(DatabaseID dbid)
{ 
	if(sys_crashed == RESTORE_PC)
		return SchExcepArchive(dbid, CAT_PC_PDA_RESTORE);
	else		
		return SchExcepArchive(dbid, CAT_PC_OVR_PDA);
}

BOOL SchExcepArchivePDAOvrPC(DatabaseID dbid)
{ 
	return SchExcepArchive(dbid, CAT_PDA_OVR_PC);
}

BOOL SchExcepArchivePCPDASync(DatabaseID dbid)
{
	return SchExcepArchive(dbid, CAT_PC_PDA_SYNC);
}


BOOL PDASchExcepAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[4];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	int sket_pos;
	char *ptr;

	int nCount;

	szSql = "select * from ";
	szSql += SCHEXCEPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		rs->MoveLast();
		rs->MoveFirst();
		nCount = rs->GetRecordCount();

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 2;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));


	// Repeat Number
	size_array[0] = 4;
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

	unsigned int repeat_number = rs->GetFieldValue("RepeatNumber").lVal;

	ptr = (char*) &repeat_number;
	content += ptr[0];
	content += ptr[1];
	content += ptr[2];
	content += ptr[3];

	TRACE("\n %d ", content.GetLength());

	// Exception Date
	size_array[1] = nCount*3 + 1;    // add the null at the end
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	rs->MoveFirst();
	for (int i =0; i < nCount; i++){

	COleDateTime exception_date = rs->GetFieldValue("ExceptionDate");
	fielddata = (char)(exception_date.GetYear() - 1900);
	fielddata += (char)exception_date.GetMonth();
	fielddata += (char)exception_date.GetDay();

	if(i == (nCount - 1))
		AddNULL(&fielddata);

	content += fielddata;	

	rs->MoveNext();
	}

//	content += "\0"; // add null to determine the end of the exception date

	TRACE("\n %d ", content.GetLength());

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAddLarge(dbid, rec_id, 2, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;
}


BOOL SchExcepGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += SCHEXCEPDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}

