#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "SchExcep.h"
#include "recid.h"


extern BOOL bRun;
extern BOOL recycle_pda_schexcep;
extern int station_num;

void SchExcepMapPCRecIDtoPDA(DatabaseID dbid, RecStruct *record, int total_rec)
{
	CString rec_content, szSql, fielddata;

	for(int i=0;i<total_rec;i++)
	  {
		  SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		  //Update the recordid in pc with exist repeatnumber
		  PDADataGetField(0, &rec_content, &fielddata);
			CString string = "Update SchException set RecordID = ";
			string += Str_ul((((RecordHeader)(record[i].rec_header)).rec_id));
			string += " where RepeatNumber = " + Val_ul(fielddata);

			dbCurrent->Execute(string);
	  }
}


int CSyncDispDlg::UpdateDatabasePDAOvrPCSchExcep()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_SCHEXCEPDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	SchExcepArchivePDAOvrPC(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 10000)
		return 1;
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(SchDBCompDate(dbCurrent, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);

		DoEvents();
//		if(DBIsExistRecord(dbCurrent, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
//			/* Move the record to recycle database, then add the new record */
//			SchExcepMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
//		}
		PCDeleteRecord(dbRecycle, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		DoEvents();
		SchExcepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += SCHEXCEPDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			//SchExcepMoveRecord(dbCurrent, dbRecycle, recid);
			PCDeleteRecord(dbCurrent, SCHEXCEPDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
	
		DeferDeletePDACat(dbid);
		CHKTERM;
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);
UpdateLastRecID(SCHEXCEPDB, 1000);

	return 0;

terminate:
	if(rs)
		delete rs;

	return 1;
}



int CSyncDispDlg::UpdateDatabasePCOvrPDASchExcep()
{
	DatabaseID dbid;
	int total_rec; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
//	RecordID last_pda_recid, last_pc_recid;


	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();

	CHKTERM;
/*
#ifndef	UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
		SchExcepRecIDCrashRecover();
#endif
		*/
/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SCHEXCEPDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;
/*
#ifdef UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
	{
		GetLastSyncRecID(SCHEXCEPDB, &last_pda_recid, &last_pc_recid);
		//RecIDCrashRecover(PBDB, 1002);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;

		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
	}
#endif
	*/

	CHKTERM;
	SchExcepArchivePCOvrPDA(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record) != 0)
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;

/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       SchExcepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(SchDBCompDate(dbCurrent, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDASchExcepAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += SCHEXCEPDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat
	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDASchExcepAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

	DeferDeletePDACat(dbid);
	CHKTERM;

nextstate:

	if(rs)
	{
		delete rs;
		rs = NULL;
	}
//#ifdef UNIQUE_RECID
/*	if(sys_crashed == RESTORE_PC)
	{
	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}
*/
	UpdateLastRecID(SCHEXCEPDB, 1000);
//	}
//#endif
	if(record)
	   free(record);

	CHKTERM;
	return 0;

terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncSchExcep()
{
	DatabaseID dbid;
	int total_rec;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
	int prev_recid;

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SCHEXCEPDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	GetLastSyncRecID(SCHEXCEPDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(SCHEXCEPDB, &last_sync_date);

	SchExcepArchivePCPDASync(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 1000)
		return 1;


	SchExcepMapPCRecIDtoPDA(dbid,record,total_rec);

/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += SCHEXCEPDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, not condiser cat

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += SCHEXCEPDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSqlBoth.GetLength()-1);
		szSqlBoth += ")order by RecordID,ModifyDate";


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSqlBoth);
			rs_both =NULL;
	}
	}

//goto chkboth;
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
//for(i=0;i<total_rec;i++)
//	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, SCHEXCEPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  SchExcepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else // if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			  if(recycle_pda_schexcep)
			  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  SchExcepAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
#endif
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }

	   }
//}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{

			CHKTERM;
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDASchExcepAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
			}
			else //if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
			//	SchExcepMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
				PCDeleteRecord(dbCurrent, SCHEXCEPDB, (rs_pc->GetFieldValue(0)).lVal);
			}

			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	//rec in both
	prev_recid = 0;

	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{

//as many record with the same recordid as may delete from the below flow
	  // so move to the last record with same recordid
		int nRecordID = rs_both->GetFieldValue("RecordID").lVal;
		CString szFind = (CString)"RecordID = " + Str_ul(nRecordID);
		rs_both->FindLast(szFind);
///////////////////////////////////////
		  
		  char found = 0;;
		  if( (rs_both->GetFieldValue("RecordID")).lVal == prev_recid)
			  goto next_loop2;
		  prev_recid = (rs_both->GetFieldValue("RecordID")).lVal;

		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;
//			if(((RecordHeader)(record[i].rec_header)).rec_id < 1001)
//			{

//			}
//			else

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //SchExcepMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  SchExcepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDASchExcepAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */

			  //Add to PC;
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //SchExcepMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  SchExcepAddRecord1(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;

			  //Add to Pda;
			  SyncIdleMode(); CHKTERM;
	  		  SyncDBUpMode(); CHKTERM;
		      PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  PDASchExcepAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}

			} // if
next_loop2:
		 rs_both->MoveNext();
		  CHKTERM;
	  }  // while

	  
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;
	
	DeferDeletePDACat(dbid);
	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}

	if(record)
	{
	   free(record);
	   record = NULL;
	}

	UpdateLastRecID(SCHEXCEPDB, last_pda_recid);
	
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}
