// SelectAppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "vpsync.h"
#include "SelectAppDlg.h"
#include "syncfx.h"
#include <direct.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectAppDlg dialog


CSelectAppDlg::CSelectAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectAppDlg)
	//}}AFX_DATA_INIT
}


void CSelectAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectAppDlg)
	DDX_Control(pDX, IDOK, m_btnOK);
	DDX_Control(pDX, IDC_SEL_NONE, m_btnNone);
	DDX_Control(pDX, IDC_SEL_APP, m_ListBox);
	DDX_Control(pDX, IDC_SEL_ALL, m_btnAll);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectAppDlg, CDialog)
	//{{AFX_MSG_MAP(CSelectAppDlg)
	ON_BN_CLICKED(IDC_SEL_ALL, OnSelAll)
	ON_BN_CLICKED(IDC_SEL_NONE, OnSelNone)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectAppDlg message handlers

BOOL CSelectAppDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	if ( _chdir(path))
	{
	   CDialog::OnCancel();
	   return TRUE;
	}

	m_ListBox.ResetContent();
	m_ListBox.Dir(0, "*.apo");

	if(!m_ListBox.GetCount())
		CDialog::OnCancel();

	CString ofn;
	for(int i=0; i<m_ListBox.GetCount();i++)
	{
		m_ListBox.SetCurSel(i);
		m_ListBox.GetText(i, ofn);
		m_ListBox.DeleteString(i);
		m_ListBox.InsertString(i, GetAppName(ofn));
		ofn = ofn.Left(ofn.GetLength()-3) + (CString) "app";
		appname[i] = ofn;
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


CString CSelectAppDlg::GetAppName(CString filename)
{
	 CFile app_file;
	 CFileException e;
	 int header_len;
	 char data_buf[100];
	 int attribute;
	 char app_name[30];
	 char *extra_data = NULL;
	 int extra_data_len;
	 CString progcode;
	 char *code_ptr;
	 int progcode_len;
	 char icon_data[1000];
	 int return_code = 0;

/*
	| Header Len |       VTech declaration        | Attribute | extra info | prog code |
		 4             strlen(APP_HEADER_MSG) + 1        4        varies       varies

*/

#define APP_HEADER_MSG	(char*) "VTech Helio App Inf V1.0   "
#define APP_HEADER_MSG_SIZE	(strlen(APP_HEADER_MSG) + 1)

	if(!app_file.Open(filename, CFile::modeRead|CFile::shareDenyWrite, &e))
	{
		return (CString) "Unknown App";
	}

	if(app_file.GetLength() < ICON_BMP_SIZE + 4 + 50)  // len too short
	{
		return (CString) "Unknown App";
	}

//	app_file.Read(icon_data, ICON_BMP_SIZE);

	app_file.Read(&header_len, 4);
	if((header_len > 1000) || (header_len < APP_HEADER_MSG_SIZE + 4 + 20) || header_len > app_file.GetLength())
	{
		return (CString) "Unknown App";
	}

	app_file.Read(data_buf, APP_HEADER_MSG_SIZE);
	
	if(strcmp(APP_HEADER_MSG, data_buf) != 0)  // not a valid prg
	{
		return (CString) "Unknown App";
	}

	app_file.Read(&attribute, 4);

	app_file.Read(app_name, 20);
	app_name[19] = 0x00; /* force app name len < 20 */

	return (CString) app_name;

}

void CSelectAppDlg::OnSelAll() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	m_ListBox.SelItemRange( TRUE, 0, m_ListBox.GetCount() );	
}

void CSelectAppDlg::OnSelNone() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	m_ListBox.SelItemRange( FALSE, 0, m_ListBox.GetCount() - 1 );	
}

void CSelectAppDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	int sel_total;
	int sel_index[1000];
	int i;
	CString oldn;
	CString newn;

	sel_total = m_ListBox.GetSelItems(1000, sel_index);

	for(i=0;i<sel_total;i++)
	{
		//m_ListBox.GetText(sel_index[i], oldn);
		oldn = appname[i];
		newn = oldn;
		oldn = oldn.Left(oldn.GetLength()-3) + (CString) "apo";
	   TRY
	   {
		   CFile::Rename( oldn, newn );
	   }
	   CATCH( CFileException, e )
	   {
	   }
	   END_CATCH
	}

	CDialog::OnOK();
}
