#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "sketch.h"

extern BOOL bRun;
extern BOOL recycle_pda_sketch;
extern int station_num;

void SketchRecIDCrashRecover();

int CSyncDispDlg::UpdateDatabasePDAOvrPCSketch()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec, total_arc_rec = 0, sync_rec_total;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL, *arc_record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_SKTDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;
	CHKTERM;
	SketchArchivePDAOvrPC(dbid);

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 12000)
		return 1;


	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);
	if(arc_record)
		free(arc_record);
	CHKTERM;

	sync_rec_total = total_arc_rec;

////////////////////
// find num rec to sync
	for(i=0;i<total_rec;i++)
	{
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
		sync_rec_total++;
	}

	if(sync_rec_total)
	{
		m_remain = sync_rec_total;

		UpdateRemain(sync_rec_total);
	}


	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
UpdateRemainDec();
		DoEvents();
//		if(DBIsExistRecord(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
		//	SketchMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
//		}
		DoEvents();
		SketchDeletePCRecord(dbRecycle,((RecordHeader)(record[i].rec_header)).rec_id);
		SketchAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += SKTDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
//			SketchMoveRecord(dbCurrent, dbRecycle, recid);
			SketchDeletePCRecord(dbCurrent, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	CHKTERM;
	SketchArchivePDAOvrPC(dbid);
	UpdateLastRecID(SKTDB, 0);
	return 0;

terminate:
	if(rs)
		delete rs;

	return 1;
}



int CSyncDispDlg::UpdateDatabasePCOvrPDASketch()
{
	DatabaseID dbid;
	int total_rec, total_arc_rec = 0, sync_rec_total; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL, *arc_record = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
	CHKTERM;

/*
	if(sys_crashed == RESTORE_PC)
		SketchRecIDCrashRecover();

*/
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SKTDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;
	CHKTERM;
//	SketchArchivePCOvrPDA(dbid);

	CHKTERM;


	total_rec = 0;

	CHKTERM;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record) != 0)
		return 1;		// error

	CHKTERM;

	if(total_rec > 12000)
		return 1;


/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += SKTDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat

	szSql += " order by RecordID DESC";

	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}

	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);
	if(arc_record)
		free(arc_record);
	CHKTERM;

	sync_rec_total = total_arc_rec;


///////////////////////////////////
//  count num of rec to sync
	if(total_rec != 0)
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   if(sys_crashed == RESTORE_PC)
		   {
			sync_rec_total++;
		   }
	   }
	   else
	   {
		if(DBCompDate(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
			sync_rec_total++;
	   }

	}

//	if(sync_rec_total)
	//	
//	{
//		m_remain = sync_rec_total;
//		UpdateRemain(sync_rec_total);
//	}

	if(!rs->IsBOF())
	{
		rs->MoveFirst();
		while(!rs->IsEOF())
		{
			sync_rec_total++;
			rs->MoveNext();
		}
	}

	if(sync_rec_total)
	{
		m_remain = sync_rec_total;
		UpdateRemain(sync_rec_total);
	}

	SketchArchivePCOvrPDA(dbid);
	CHKTERM;


/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	          SketchAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  UpdateRemainDec();
			  rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		   /* then add to PDA */
		  PDASketchAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		  UpdateRemainDec();
		  UpdateLastSyncPCRecID(SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDASketchAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			UpdateRemainDec();
			UpdateLastSyncPCRecID(SKTDB, (rs->GetFieldValue(0)).lVal);
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);
UpdateLastRecID(SKTDB, 0);
	CHKTERM;
	return 0;

terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncSketch()
{
	DatabaseID dbid;
	int total_rec, total_arc_rec, sync_rec_total = 0;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL, *arc_record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;


   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 2;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 280;
   missrec_dlg.row_height[1] = 280;

   CString str;
   str.LoadString(IDS_MODIFYDATE);
   missrec_dlg.m_Content[0][0] = str;
   str.LoadString(IDS_NOTE);
   missrec_dlg.m_Content[1][0] = str;


   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 2;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 280;
   duprec_dlg.row_height[1] = 280;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_NOTE);
   duprec_dlg.m_ContentPC[1][0] = str;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_NOTE);
   duprec_dlg.m_ContentPDA[1][0] = str;


	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SKTDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	CHKTERM;
//	SketchArchivePCOvrPDA(dbid);


	GetLastSyncRecID(SKTDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(SKTDB, &last_sync_date);
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 12000)
		return 1;

	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);

	CHKTERM;

	sync_rec_total = total_arc_rec;


/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += SKTDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, not condiser cat

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += SKTDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}






////////////////////////////////////////////////
// count # of record need to update

	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   { 
			sync_rec_total++;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { 
		   }
		   else
		   {
			sync_rec_total++;
		   }
	   }
	   }
	}
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{ 
				sync_rec_total++;
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ 
			}
			else
			{
				sync_rec_total++;
			}
			rs_pc->MoveNext();
		}
		rs_pc->MoveFirst();
	}
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ 
			sync_rec_total++;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ 
			sync_rec_total++;
			}
			else
			{ 
			sync_rec_total++;
			} 
		  rs_both->MoveNext();
	  }
	} 
	  	  rs_both->MoveFirst();
	}



////////////////////////////////////////////

	if(sync_rec_total)
	{
		m_remain = sync_rec_total;
		UpdateRemain(sync_rec_total);
	}

	SketchArchivePCOvrPDA(dbid);

	CHKTERM;


//goto chkboth;
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, SKTDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  SketchAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			   UpdateRemainDec();
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			  if(recycle_pda_sketch)
			  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  SketchAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
#endif
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */

			   int action;

			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
					  rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
				   }
 				   action = missrec_act;
			   }
			   else
			   {
				      rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
					  missrec_dlg.total_rows = 2;
					  missrec_dlg.total_cols = 2;

				CString str;
				str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;


			   // modi date
			   missrec_dlg.m_Content[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   missrec_dlg.m_Content[0][1].Remove('#');

			   fielddata.Empty(); // Note
			   PDADataGetField(0, &rec_content, &fielddata);
			   missrec_dlg.m_Content[1][1] = fielddata;

			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					  // SketchDeletePCRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id);
					  // SketchDeletePCRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
					   SketchAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					    UpdateRemainDec();
					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					    UpdateRemainDec();
					   break;
				   case NOT_SYNC:
					    UpdateRemainDec();
						break;
				   default:
					    UpdateRemainDec();
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }
	   }
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{

			CHKTERM;
//			if((rs_pc->GetFieldValue(0)).lVal <= last_pc_recid)
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDASketchAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
				 UpdateRemainDec();
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
//				SketchMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
				SketchDeletePCRecord(dbCurrent,  (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
			/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */		
			int action;
			if(missrec_act)
				action = missrec_act;
			else
			{
				CString str;
				str.LoadString(IDS_MISS_PDA);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PDA);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPC);
			   missrec_dlg.m_szMissLabel = str;
			   COleDateTime modid;
			   modid = rs_pc->GetFieldValue("ModifyDate");
   
   			   missrec_dlg.m_Content[0][1] = ValidDBDate(&modid);
			   missrec_dlg.m_Content[1][1] = (LPSTR) rs_pc->GetFieldValue("Notes").bstrVal;

			   str.LoadString(IDS_SYNCTOPDA);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDASketchAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				    UpdateRemainDec();
					   break;
				   case DEL_REC:
		   			   //SketchMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   SketchDeletePCRecord(dbCurrent, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					    UpdateRemainDec();
					   break;
				   case NOT_SYNC: 
					   UpdateRemainDec();
					   break;

				   default:
					    UpdateRemainDec();
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;
			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //SketchMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  SketchAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			   UpdateRemainDec();
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDASketchAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
				 UpdateRemainDec();
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
				int action;


			if (abs(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(record[i].rec_header.modi_date))) > 2)
			  {

			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 	//  	              SyncIdleMode(); CHKTERM;
      //                SyncDBEnqMode(); CHKTERM;
				   }
					action = duprec_act;
			   }
			   else
			   {
				   ///////////////// prepare PDA content
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
// 	  	              SyncIdleMode(); CHKTERM;
  //                    SyncDBEnqMode(); CHKTERM;

// RTM xx = DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate"))));
 //RTM yy = _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date);
               
				CString str;
				str.LoadString(IDS_MODIFY);
               duprec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_MODIFY);
			   duprec_dlg.m_szDupMsg = str;

			   // modi date
			   duprec_dlg.m_ContentPDA[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   duprec_dlg.m_ContentPDA[0][1].Remove('#');

			   fielddata.Empty(); // Note
			   PDADataGetField(0, &rec_content, &fielddata);
			   duprec_dlg.m_ContentPDA[1][1] = fielddata;
             
			    ///////////////////  Prepare PC content
			   COleDateTime modidx;
			   modidx = rs_both->GetFieldValue("ModifyDate");
   			   duprec_dlg.m_ContentPC[0][1] = ValidDBDate(&modidx);
			   duprec_dlg.m_ContentPC[1][1] = (LPSTR) rs_both->GetFieldValue("Notes").bstrVal;

			   duprec_dlg.DoModal();

			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDASketchAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					    UpdateRemainDec();
					   break;
				   case SYNC_TO_PC:
		   			   //SketchMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   SketchDeletePCRecord(dbCurrent, (rs_both->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   SketchAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					    UpdateRemainDec();
					   break;
				   case NOT_SYNC:
					    UpdateRemainDec();
						break;
				   default:
					    UpdateRemainDec();
					   break;
			   }
			  }
			else
				 UpdateRemainDec();

			   SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;

			}
			} // if
		  rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}


	if(record)
	{
	   free(record);
	   record = NULL;
	}


	UpdateLastRecID(SKTDB, last_pda_recid);
	
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}