#include "stdafx.h"
#include "SyncDB.h"
#include "VPSync.h"
#include "ErrMsgDlg.h"
#include "TimeFct.h"
#include <direct.h> 
 

CDaoDatabase *dbProfile=NULL;
CDaoDatabase *dbAppDB=NULL;
CDaoDatabase *dbCurrent=NULL;
CDaoDatabase *dbArchive=NULL;
CDaoDatabase *dbRecycle=NULL;
//char *szTitle = "PC/PDA Sync";
 

CString szUserPath;
CString szCurrentPath;
CString szUserFullPath;

BOOL InitPath()
{
	char buffer[_MAX_PATH];   /* Get the current working directory: */
    if( _getcwd( buffer, _MAX_PATH ) == NULL )
		return FALSE;

	szCurrentPath = buffer;
	szCurrentPath += '\\';
	szUserFullPath = szCurrentPath + szUserPath;
//	szUserFullPath += '\\';
	return TRUE;
}

/* Found the user name in Profile.mdb and get the path,
   open all the databases								*/
int InitUser(CString szFirstName, CString szLastName, CDaoWorkspace *wrk_space)
{
	CDaoRecordset *pRs;
	CString msg;
	CString szSQL;
	COleVariant fdata;
	int nReturn;

	szFirstName.TrimRight();
	szLastName.TrimRight();

	if(!dbProfile)
	  dbProfile = new CDaoDatabase(wrk_space);
	if(!dbCurrent)
	  dbCurrent = new CDaoDatabase(wrk_space);
	if(!dbAppDB)
	  dbAppDB = new CDaoDatabase(wrk_space);
	if(!dbArchive)
	  dbArchive = new CDaoDatabase(wrk_space);
	if(!dbRecycle)
	  dbRecycle = new CDaoDatabase(wrk_space);
	
	nReturn = OpenDatabase(dbProfile, "Profile.mdb");
	CString str;
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			str.LoadString(IDS_DBERROR1);
			msg = _T(str);
			msg += '\n';
			str.LoadString(IDS_DBERROR2);
			msg += _T(str);
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			str.LoadString(IDS_DBERROR3);
			msg = _T(str);
			msg += '\n';
			str.LoadString(IDS_DBERROR4);
			msg += _T(str);
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			str.LoadString(IDS_DBERROR5);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	if(nReturn)
	{
	//	PostQuitMessage(1);	// quit the application
		return nReturn;
	}

	szSQL = "select Path from UserData where Name1st ='";
	szSQL += ExamSql(szFirstName);
	szSQL += "' and Name2nd = '";
	szSQL += ExamSql(szLastName);
	szSQL += "'";

//	CString uname;
//	uname = szFirstName + ' ' + szLastName;
//	szSQL = "select Path from UserData where UserName = '";
//	szSQL += ExamSql(uname);
//	szSQL += "'";


	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenDynaset, szSQL, dbReadOnly);
	}
	catch (CDaoException *e)
	{	// error in SQL statement, should not happen
		e->Delete();
		delete pRs;
		CString str;
		str.LoadString(IDS_DBERROR6);
		msg = _T(str);
		ShowErrDlg(msg);
	//	PostQuitMessage(1);
		return -1;
	}

	if(pRs->IsBOF())	// user not found
	{
		delete pRs;
//		msg = _T("Cannot found user ");
//		msg += _T(szLastName + szFirstName);
//		msg += ".";
//		msg += '\n';
//		msg += _T("Please create a new user from PC Desktop.");
//		ShowErrDlg(msg);
		return 1;
	}

	try		// get user default path 
	{
		fdata = pRs->GetFieldValue("Path");
	}
	catch (CMemoryException *f)
	{
		f->Delete();
		delete pRs;
		return 4;
	}

	delete pRs;

	szUserPath = (LPCSTR) fdata.bstrVal;
	szUserPath.TrimLeft();
	if(szUserPath.Right(1) == '\\')
	{
		szUserPath = szUserPath.Left(szUserPath.GetLength()-1);
		szUserPath.TrimRight();
		szUserPath += '\\';
	}

	if(szUserPath.Right(1) != '\\')
		szUserPath += '\\';

	InitPath();
	
	CString szCurrent;

	//szCurrent = szUserPath + "\\Current.mdb";
	szCurrent = szUserPath + "Current.mdb";
	nReturn = OpenDatabase(dbCurrent, szCurrent);
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			str.LoadString(IDS_DBERROR1);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			str.LoadString(IDS_DBERROR3);
			msg = _T(str);
			msg += '\n';
			str.LoadString(IDS_DBERROR4);
			msg += _T(str);
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			str.LoadString(IDS_DBERROR5);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	if(nReturn)
	{	// cannot open current.mdb
	//	PostQuitMessage(1);	// quit the application
		return nReturn;
	}

	CString szAppDB;
	//szAppDB = szUserPath + "\\AppDB.mdb";
	szAppDB = szUserPath + "AppDB.mdb";
	nReturn = OpenDatabase(dbAppDB, szAppDB);
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			str.LoadString(IDS_DBERROR1);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			str.LoadString(IDS_DBERROR3);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please close some applications and try again!");
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			str.LoadString(IDS_DBERROR5);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	if(nReturn)
	{	// cannot open current.mdb
	//	PostQuitMessage(1);	// quit the application
		return nReturn;
	}

	CString szArchive;
//	szArchive = szUserPath + "\\Archive.mdb";
	szArchive = szUserPath + "Archive.mdb";
	nReturn = OpenDatabase(dbArchive, szArchive);
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			str.LoadString(IDS_DBERROR1);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			str.LoadString(IDS_DBERROR3);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please close some applications and try again!");
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			str.LoadString(IDS_DBERROR5);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	if(nReturn)
	{	// cannot open current.mdb
	//	PostQuitMessage(1);	// quit the application
		return nReturn;
	}

	CString szRecycle;
//	szRecycle = szUserPath + "\\Recycle.mdb";
	szRecycle = szUserPath + "Recycle.mdb";
	nReturn = OpenDatabase(dbRecycle, szRecycle);
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			str.LoadString(IDS_DBERROR1);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Helio Desktop to delete this user.");
			ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			str.LoadString(IDS_DBERROR3);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please close some applications and try again!");
			ShowErrDlg(msg);
			break;
		case 4:		// file not found
			str.LoadString(IDS_DBERROR5);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run PC Desktop to correct this problem.");
			ShowErrDlg(msg);
			break;
	}

	return nReturn;
}


int OpenDatabase(CDaoDatabase *pDatabase, CString szName)
{
	int nReturn = 0;

	   if (pDatabase->IsOpen())
	 	  pDatabase->Close();

	try
	{
		pDatabase->Open(szName);
	}
	catch (CDaoException *e)
	{
		if (e->m_pErrorInfo->m_lErrorCode == 3024)
			    nReturn = 4;
		else 
			nReturn = 2;
		
		e->Delete();
	}
	catch (CMemoryException *e)
	{
		e->Delete();
		nReturn = 3;
	}

	return nReturn;
}

void CloseDatabase(CDaoDatabase *pDatabase)
{
	if(pDatabase)
	{
	   if (pDatabase->IsOpen())
	 	  pDatabase->Close();
	   delete pDatabase;
	}
}


//CString examsql_result;

CString ExamSql(CString x)
{
//	examsql_result.Empty();
	x.Replace("\'", "\'\'");
	x.Replace("\"", "\"\"");
	x.Replace('|', ' ');

/*
	int i, j = 0;
	for(i=0;i<x.GetLength();i++)
	{
		if(x[i] == '\'') 
			examsql_result += '\'';
		examsql_result += x[i];
	}

	x = examsql_result;
	examsql_result.Empty();

	for(i=0;i<x.GetLength();i++)
	{
		if(x[i] == '\"') 
			examsql_result += '\"';
		examsql_result += x[i];
	}
*/
//	return examsql_result;
	return x;
}


char db_val_to_str[20];

char *Str_ul(unsigned int val)
{
	itoa(val, db_val_to_str, 10);
	return db_val_to_str;
}

CString Val_ul(CString val)
{
   // CAN ONLY USED BY EMAILMSG function ONLY!!!!
   // convert a string contain a long value from PDA to a long string
   // and swap the h-l byte 
   // e.g. val = 0x00, 0x00, 0x00 ,0x01
   //      return "1";
	char *ptr;
	unsigned long u_val;
	CString result;

	if (val.GetLength() < 4)
	{
		result = "0";
	}
	else
	{
		ptr = (char*) &u_val;
		ptr[0] = val[0];
		ptr[1] = val[1];
		ptr[2] = val[2];
		ptr[3] = val[3];

		result = Str_ul(u_val);
	}

	return result;
}


BOOL DBIsExistRecord(CDaoDatabase *src_db, CString table_name, RecordID rec_id)
{
	
	CDaoRecordset *rs;
	BOOL value;
	CString szQuery;

	rs = new CDaoRecordset(src_db);

	szQuery = "select 1 from ";
	szQuery += ExamSql(table_name);
	szQuery += " where RecordID = ";
	szQuery += Str_ul(rec_id);

	try
	{
		rs->Open(dbOpenSnapshot, szQuery, dbReadOnly);
	}

	catch(CDaoException *e)
	{
//		CString msg;
//		msg.Format("Error in the database: [%s] is missing", table_name);
//		ShowErrDlg(msg);
		e->Delete();
		delete rs;
		return FALSE;
	}

	value = !(rs->IsBOF());
	delete rs;
	return value;
}


BOOL DBIsExistRecordInAllDB(CString table_name, RecordID rec_id)
{
	
	CDaoRecordset *rs;
	BOOL value;
	CString szQuery;
	int i;

	for(i=0;i<3;i++)
	{
		switch(i)
		{
		case 0:
		rs = new CDaoRecordset(dbCurrent);
		break;
		case 1:
		rs = new CDaoRecordset(dbArchive);
		break;
		case 2:
		rs = new CDaoRecordset(dbRecycle);
		break;
		}

	szQuery = "select 1 from ";
	szQuery += ExamSql(table_name);
	szQuery += " where RecordID = ";
	szQuery += Str_ul(rec_id);

	try
	{
		rs->Open(dbOpenSnapshot, szQuery, dbReadOnly);
	}

	catch(CDaoException *e)
	{
//		CString msg;
//		msg.Format("Error in the database: [%s] is missing", table_name);
//		ShowErrDlg(msg);
		e->Delete();
		delete rs;
		return FALSE;
	}

	value = !(rs->IsBOF());
	delete rs;
	if(value)
		break;
	}

	return value;
}




// compare the record date in pda with pc, if same return 0
// if not found in PC return > 0
// if PDA > PC return > 0
// if PDA < PC return < 0
int DBCompDate(CDaoDatabase *src_db, CString table_name, RecordID rec_id, unsigned int pda_modidate)
{
	CDaoRecordset *rs;
	CString szSql;
	int ret;

	szSql = "select ModifyDate from ";
	szSql += table_name;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch(CDaoException *e)
	{
		TRACE("\nError EXE SQL: %s ", szSql);
		e->Delete();
		delete rs;
		return FALSE;
	}

	if(rs->IsBOF())
	{
		rs->Close();
		delete rs;
		return 1;
	}

     ret = TimeDiff(_date322rtm(pda_modidate), DBDate2RTM(COleDateTime((rs->GetFieldValue(0)))));

	 rs->Close();
	 delete rs;
	 return ret;
}


// compare Scheduler record date in pda with pc, if same return 0
// if not found in PC return > 0
// if PDA > PC return > 0
// if PDA < PC return < 0
int SchDBCompDate(CDaoDatabase *src_db, CString table_name, RecordID rec_id, unsigned int pda_modidate)
{
	CDaoRecordset *rs;
	CString szSql;
	int ret;

	szSql = "select ModifyDate from ";
	szSql += table_name;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	szSql += " order by ModifyDate DESC";

	rs = new CDaoRecordset(src_db);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch(CDaoException *e)
	{
		TRACE("\nError EXE SQL: %s ", szSql);
		e->Delete();
		delete rs;
		return FALSE;
	}

	if(rs->IsBOF())
	{
		rs->Close();
		delete rs;
		return 1;
	}

     ret = TimeDiff(_date322rtm(pda_modidate), DBDate2RTM(COleDateTime((rs->GetFieldValue(0)))));

	 rs->Close();
	 delete rs;
	 return ret;
}



int BackupDatabase()
{

	if(!CopyFile(szUserPath + (CString)"\\appdb.mdb",
		szUserPath + (CString) "\\appdb.bak", FALSE))
		return 1;

	if(!CopyFile(szUserPath + (CString)"\\current.mdb",
		szUserPath + (CString) "\\current.bak", FALSE))
		return 1;

	if(!CopyFile(szUserPath + (CString)"\\archive.mdb",
		szUserPath + (CString) "\\archive.bak", FALSE))
		return 1;

	if(!CopyFile(szUserPath + (CString)"\\recycle.mdb",
		szUserPath + (CString) "\\recycle.bak", FALSE))
		return 1;

	return 0;
}


int OpenProfile(CDaoWorkspace *wrk_space)
{
	return OpenProfile(wrk_space, TRUE);
}

int OpenProfile(CDaoWorkspace *wrk_space, BOOL show_err)
{
	CDaoRecordset *pRs;
	CString msg;
	CString szSQL;
	COleVariant fdata;
	int nReturn;

	if(!dbProfile)
	  dbProfile = new CDaoDatabase(wrk_space);

	if(dbProfile->IsOpen())
		return 0; 

	nReturn = OpenDatabase(dbProfile, "Profile.mdb");
	CString str;
	switch (nReturn)
	{
		case 0:		// ok!
			break;
		case 2:		// unknown error when open db
			str.LoadString(IDS_DBERROR1);
			msg = _T(str);
			msg += '\n';
			str.LoadString(IDS_DBERROR2);
			msg += _T(str);
			if(show_err) ShowErrDlg(msg);
			break;
		case 3:		// not enough memory
			str.LoadString(IDS_DBERROR3);
			msg = _T(str);
			msg += '\n';
			str.LoadString(IDS_DBERROR4);
			msg += _T(str);
			if(show_err) ShowErrDlg(msg);
			break;
		case 4:		// file not found
			str.LoadString(IDS_DBERROR5);
			msg = _T(str);
//			msg += '\n';
//			msg += _T("Please run Sync Desktop to correct this problem.");
			if(show_err) ShowErrDlg(msg);
			break;
	}

	if((nReturn) && dbProfile)
	{
		delete dbProfile;
		dbProfile = NULL;
	}

		return nReturn;
}