#ifndef __SYNCDB_H__
#define __SYNCDB_H__
 
#include "syncfx.h"
#include "PortCtrl.h"

#define PBDB	"Phonebook"
#define VOXDB   "Voice"
#define EMDB    "Email"
#define EMSGDB  "EmailMessage"
#define MEMODB  "Memo"
#define EXPDB	"Expense"
#define SKTDB	"Sketch"
#define SCHDB	"Scheduler"
#define TODODB  "ToDo"
#define ANNIDB	"Anniversary"
#define SCHREPDB "SchRepeat"
#define SCHEXCEPDB	"SchException"
#define EXPENSETYPEDB "ExpenseTypeNumberName"

extern CDaoDatabase *dbProfile;
extern CDaoDatabase *dbCurrent;
extern CDaoDatabase *dbAppDB;
extern CDaoDatabase *dbArchive;
extern CDaoDatabase *dbRecycle;
extern CString szUserPath;
extern CString szUserFullPath;

char *Str_ul(unsigned int val);
CString Val_ul(CString val);

CString ExamSql(CString);
int InitUser(CString, CString, CDaoWorkspace*);
int OpenDatabase(CDaoDatabase*, CString);
void CloseDatabase(CDaoDatabase*);
BOOL DBIsExistRecord(CDaoDatabase*, CString, RecordID);
int DBCompDate(CDaoDatabase*, CString, RecordID, unsigned int);
int BackupDatabase();
int SchDBCompDate(CDaoDatabase *src_db, CString table_name, RecordID rec_id, unsigned int pda_modidate);
int OpenProfile(CDaoWorkspace *wrk_space, BOOL show_err);
BOOL DBIsExistRecordInAllDB(CString table_name, RecordID rec_id);
#endif 