// SyncDispDlg.cpp : implementation file
//
#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "phonebk.h"
#include "Voice.h"
#include "EMail.h"
#include "EMList.h"
#include "Expense.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "StopQueryDlg.h"
#include "BackupErrDlg.h"
#include <process.h>
#include "PDACrashDlg.h"
#include "DelRecDlg.h"
#include "WinLink.h"
#include "FindUserDlg.h"
#include "FirstSyncDlg.h"
#include "sysetup.h"
#include <afx.h>
#include <direct.h>
#include "syncdb.h"
#include "StartFailDlg.h"
#include "InvalidOSDlg.h"
//#include "selectappdlg.h"
#include "QueryVoiceDlg.h"
#include "addappdlg.h"
#include "stationdlg.h"

//REG
#include "hdb.h"
int SyncSetMaxRecordID(DatabaseID dbid, RecordID max_rec_id);
//REG

int OpenProfile(CDaoWorkspace *wrk_space);
int SyncCrashEnq();
int sync_vox_state;
//CSyncDispDlg *pDispDlg;

CSyncDispDlg *m_DispDlg;
BOOL TermFromDesktop;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IMG_BK_COLOR	GetSysColor(COLOR_BTNFACE)

BOOL bRun = TRUE;
BOOL bIsSync = FALSE;
BOOL recycle_pda_emailmsg = FALSE;
BOOL recycle_pda_email = FALSE;
BOOL recycle_pda_pb = FALSE;
BOOL recycle_pda_vox = FALSE;
BOOL recycle_pda_memo = FALSE;
BOOL recycle_pda_sketch = FALSE;
BOOL recycle_pda_todo = FALSE;
BOOL recycle_pda_anni = FALSE;
BOOL recycle_pda_exp = FALSE;
BOOL recycle_pda_sch = FALSE;
BOOL bStop;
CString pda_sync_id;
extern int station_num;
extern BOOL m_sound;
int sys_crashed = 0;
int crash = CRASH_NO;
unsigned char *install_path = NULL;
int miss_user_action;
int doshow;
BOOL TermFromNoSize = FALSE;

extern BOOLEAN  g_bTimeOut;  // in portctrl.c
extern BOOL shown_timeout;
extern CSyncDispDlg *pDispDlg;
extern int sync_init_by;
extern CString szUserPath;


#define MSG_HOTSYNC_START	WM_USER + 1000
#define MSG_HOTSYNC_END		WM_USER + 1001
#define WM_STOP_FROM_DESKTOP WM_USER + 1010

/////////////////////////////////////////////////////////////////////////////
// CSyncDispDlg dialog

CSyncDispDlg::CSyncDispDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSyncDispDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSyncDispDlg)
	m_RemainRec = _T("");
	//}}AFX_DATA_INIT
}


CSyncDispDlg::CSyncDispDlg(CVPSyncDlg *dlg)
{
	m_pParent = dlg;
}

BOOL CSyncDispDlg::Create()
{
	return CDialog::Create(CSyncDispDlg::IDD);
}

void CSyncDispDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSyncDispDlg)
	DDX_Control(pDX, IDC_DISP_DIR_LIST, m_List);
	DDX_Control(pDX, IDC_PERCENT, m_Percent);
	DDX_Control(pDX, ID_STOP, m_btnStop);
	DDX_Text(pDX, IDC_REMAIN_REC, m_RemainRec);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSyncDispDlg, CDialog)
	//{{AFX_MSG_MAP(CSyncDispDlg)
	ON_WM_TIMER()
	ON_BN_CLICKED(ID_STOP, OnStop)
	ON_WM_PAINT()
	ON_MESSAGE(WM_STOP_FROM_DESKTOP, OnStopFormDesktop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSyncDispDlg message handlers

void CSyncDispDlg::SetStatusMessage(CString msg)
{
//	msg += "                                                                                                                                                                ";
	((CStatic*) GetDlgItem(IDC_SYNCMSG))->SetWindowText(msg);
//	Invalidate();
	DoEvents();
}

int CSyncDispDlg::GetPDAUserName(CString *lastname, CString *firstname)
{
	if(SyncUserInfoReq(lastname, firstname))
 	{
 		DoEvents();
 		return 1;
 	}
 
 	lastname->TrimRight();
 	firstname->TrimRight();
 
 	return 0;
}


int CSyncDispDlg::ShowTimeOut()
{
	CTimeOutDlg dlg;
	dlg.DoModal();

	shown_timeout = FALSE;

	return 0;
}


void CSyncDispDlg::SendMsgToDesktop(UINT msg)
{
//for desktop version 1.x
/*	HWND h_wnd;
	h_wnd = ::FindWindow(NULL, "FormPopupMenu");
	
	if(!h_wnd)   // desktop not start
		return;

	ShowWindow(SW_HIDE);
	::SendMessage(h_wnd, msg, 0, 0);
*/
}

void UpdateRegistryUser(CString user)
{

	char *value;

	value = new char[user.GetLength() + 1];
	
	user.TrimRight();

	value[0] = 0;
	for(int i=0;i<user.GetLength();i++)
		value[i] = user[i];
	value[i] = 0;

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	RegSetValueEx(  hSubKey2,           // handle to key to set value for
	  "LastUser", // name of the value to set
		0,      // reserved  DWORD dwType,        // flag for value type
		REG_SZ,
		(unsigned char*)value,  // address of value data
		strlen(value));         // size of value data); 
	
	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

	delete []value;

}

int CSyncDispDlg::GetLastUserSetting()	// returns 1 if fail
{

	DWORD dwType;
	DWORD dwSize;
	unsigned char *pBuffer;
	int result = 0;
	//char m_pLastUser[100];

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	if(RegQueryValueEx(hSubKey2, "LastUser", NULL, &dwType, NULL, &dwSize) != ERROR_SUCCESS)
		result = 1;
	else
	{
		pBuffer = (unsigned char *) malloc(dwSize+1);
		if(RegQueryValueEx(hSubKey2, "LastUser", NULL, &dwType, pBuffer, &dwSize) == ERROR_SUCCESS)
		{
			pBuffer[dwSize] = 0;
			m_pLastUser = (char*) pBuffer;
			if (!strcmp(m_pLastUser, ""))
			{
				return 1;
			}
			result = 0;
		}
		else
			result = 1;
		free(pBuffer);
	}

	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

//	if(result)
//	  ShowErrDlg("Problem with registry setting, please configure the setting again.");

	return result;
}
 
int CSyncDispDlg::GetAppPathSetting()	// returns 1 if fail
{

	DWORD dwType;
	DWORD dwSize;
	int result = 0;
	//char m_pLastUser[100];

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	if(RegQueryValueEx(hSubKey2, "AppPath", NULL, &dwType, NULL, &dwSize) != ERROR_SUCCESS)
		result = 1;
	else
	{
		if(install_path)
			free(install_path);
		install_path = (unsigned char *) malloc(dwSize+1);
		if(RegQueryValueEx(hSubKey2, "AppPath", NULL, &dwType, install_path, &dwSize) == ERROR_SUCCESS)
		{
			install_path[dwSize] = 0;
			result = 0;
		}
		else
		{
			result = 1;
		    free(install_path);
		    install_path = NULL;
		}
	}

	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

	return result;
}
 

void CSyncDispDlg::CheckNewInstall(CDaoWorkspace *wrk_space)
{
	int total_user = 0;
	CDaoRecordset *pRs;

 	OpenProfile(wrk_space, FALSE);

	if(dbProfile)
	{
	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenSnapshot, "Select * From Userdata", 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", "Select * From Userdata");
		delete pRs;
		pRs = NULL;
	}
	if(pRs)
	{
		total_user = pRs->GetRecordCount();
		pRs->Close();
		delete pRs;
	}
	}

	if(dbProfile)
	 {
		 CloseDatabase(dbProfile);
		 dbProfile = NULL;
	 }
	

	if(ExistFile("profile.bak") &&  (total_user == 0) && (GetLastUserSetting() == 1))	// profile.bak exists but registry doesnt exist
	 {
		 CFirstSyncDlg fsdlg;
		 fsdlg.DoModal();
		 if(fsdlg.return_value == 1)	// retore data
		 {					
			int nCopyReturn = CopyFile ("profile.bak", "profile.mdb", FALSE);
			CString str;
			str.LoadString(IDS_RESTOREDATA);
			if(!nCopyReturn)  // error
				ShowErrDlg(str);
		 }	 
	 }

}


int CSyncDispDlg::GetVTOSVersion()
{

/*
Fact:
This version of V-Sync require VTOS 1.1.07 and later, however,
VTOS prior to 1.1.07 cannot answer the GetVersion reques,
so, the return string is NULL.
*/
	CString os_ver;
	CString ref_os;

	ref_os = "1.2";
	os_ver = SyncGetVTOSVer();

	if(os_ver.IsEmpty())
		goto invalid_os;

//	os_ver = os_ver.Left(3);
//	ref_os = ref_os.Left(3);
	if(atof(os_ver) < atof(ref_os))
		goto invalid_os;

/*
/* NOTE: Should check the returned OS version number if V-Sync is not compatible with VTOS 1.1.07 
/*																							     */
	return 1;

invalid_os:
	CInvalidOSDlg dlg;
	dlg.DoModal();
	return 0;
}


void CSyncDispDlg::SyncStart()
{
//	CDaoWorkspace wrk_space;
	//CDaoDatabase* dbProfile;
	CString FirstName, LastName;
	COleDateTime cur_t;
	BOOL old_bStop;
	CRect win_size;
	int reset_mode = 0;
	CPoint scr_size(GetSystemMetrics(SM_CXFULLSCREEN),GetSystemMetrics(SM_CYFULLSCREEN));
	CFile profile;
	GetWindowRect(&win_size);
	bStop = FALSE;
	m_Percent.SetRange(0,100);

	BringWindowToTop();

	TermFromDesktop = FALSE;
	TermFromNoSize = FALSE;
	pda_sync_id.Empty();

	m_DispDlg = this;

   /* Set the current working directory: */
	if(!install_path)
	   if(!GetAppPathSetting())
	   {
		   _chdrive( _tolower(install_path[0]) - 'a' + 1);
		   _chdir((char*)install_path);
	   }

	bIsSync = TRUE;
	CString str;
	SendMsgToDesktop(MSG_HOTSYNC_START);
	if(TermFromDesktop) goto terminate;
	str.LoadString(IDS_SYNCING);
	m_pParent->SetTrayTip(str.GetBuffer(str.GetLength()));

	ShowWindow(SW_SHOW);

	pCommCtrl->Send(ST_ACK);
	// init. database engine
	str.LoadString(IDS_INIT);
	SetStatusMessage(str);
	DoEvents();

	g_bTimeOut = FALSE;
	bRun = TRUE;
	m_dup_action = 0;

	 wrk_space.Create(_T("PDAWorkspace"),_T("Admin"),_T(""));
	 wrk_space.SetDefaultUser(_T("admin"));
	 wrk_space.SetDefaultPassword(_T(""));

	 SendMsgToDesktopV2(MSG_HOTSYNC_START,&wrk_space);
	if(TermFromDesktop) goto terminate;
	 
	 if(dbProfile)
	 {
		 CloseDatabase(dbProfile);
		 dbProfile = NULL;
	 }
	 if(dbCurrent)
	 {
		 CloseDatabase(dbCurrent);
		 dbCurrent = NULL;
	 }
	 if(dbArchive)
	 {
		 CloseDatabase(dbArchive);
		 dbArchive = NULL;
	 }
	 if(dbRecycle)
	 {
		 CloseDatabase(dbRecycle);
		 dbRecycle = NULL;
	 }

	if(TermFromDesktop) goto terminate;

	 CheckNewInstall(&wrk_space);
 
	pCommCtrl->Send(ST_ACK);
	// get user info
	str.LoadString(IDS_REQUESTOWNER);
	SetStatusMessage(str);
	DispStep1();
	CHKTERM

//	not use as many complain
//	if(!GetVTOSVersion())
//		goto terminate;

	while(1)
	{
		if(sync_init_by == INIT_BY_PC)
		{
			shown_timeout = FALSE;
			int ret = SyncShow1();
			shown_timeout = TRUE;
			if(!bRun)	// user click 'STOP' button
				goto terminate2;
			if(ret)
			{	
				CStartFailDlg s_f_dlg;
				AlertSound(MB_ICONEXCLAMATION);
				s_f_dlg.DoModal();
				if(s_f_dlg.result == 0)
					goto terminate2;
				SyncReq();
				Sleep(100);
				pCommCtrl->Send(ST_ACK);
			}
			else
				break;
		}
		else  // init by PDA
		{
			if(SyncShow1())
				goto terminate2;
			break;
		}
	}
	
	if(SyncLogMsg(LOG_CLR_MSG))
		goto terminate2;

	crash = SyncCrashEnq();
		
	cur_t = COleDateTime::GetCurrentTime();
	CreateLog();
	WriteLog((CString)"V-Sync  " + cur_t.Format("%b %d %Y  %I:%M:%S %p"));
	if(SyncLogMsg(LOG_MSG_DATE))
		goto terminate2;

	//	SyncIdleMode();
	CHKTERM;

	Sleep(100);

	if(GetPDAUserName(&FirstName, &LastName))
	{
		// error in get user name
		str.LoadString(IDS_PROBLEMUSER);
			ShowErrDlg(str);
			goto terminate;
	}
	CHKTERM;

	str.LoadString(IDS_PDAUSER);
	m_szSyncMsg = str + ": ";
	m_szSyncMsg += 	FirstName + (CString) " " +  LastName;
	SetStatusMessage(m_szSyncMsg);
	((CStatic*) GetDlgItem(IDC_USER_NAME))->SetWindowText(FirstName + (CString) " " +  LastName);

	int ret_v;
	miss_user_action = 0;

	pda_sync_id = SyncGetPDAID();
	CHKTERM;
	if(pda_sync_id.GetLength() > 20)
		pda_sync_id = pda_sync_id.Left(20);

	ret_v = InitUser(FirstName, LastName, &wrk_space);

	if(!ret_v){
		if(crash == CRASH_NO){
		if(!IsUserExist2(FirstName + ' ' + LastName, pda_sync_id)) // && (crash == CRASH_NO))
		{
//			crash = CRASH_YES;
			ret_v = 1;
			reset_mode = 1;  // user name found in PC but not same pda_sync_id as the one in PC

		}
		}
	}

	if(ret_v)
	{
		if(ret_v == 1)	// unknown user
		{
			CFindUserDlg nu_dlg;
			nu_dlg.nameinfo.Name1st = FirstName;
			nu_dlg.nameinfo.Name2nd = LastName;
			nu_dlg.m_szMsg.Empty();
			nu_dlg.m_resetmode = reset_mode;
			if(!FirstName.IsEmpty())
			{
				nu_dlg.m_szMsg += FirstName;
				nu_dlg.m_szMsg += ' ';
			}
			nu_dlg.m_szMsg += LastName;
			AlertSound(MB_ICONQUESTION);
			nu_dlg.DoModal();
			miss_user_action = nu_dlg.m_Action;
			if(nu_dlg.m_Action == 0)
			{
				goto terminate;    
			}
			RemoveNULL(&nu_dlg.nameinfo.Name1st);
			RemoveNULL(&nu_dlg.nameinfo.Name2nd);
			FirstName = nu_dlg.nameinfo.Name1st;
			LastName = nu_dlg.nameinfo.Name2nd;

	sync_vox_state = 0;
	str.LoadString(IDS_PDAUSER);
	m_szSyncMsg = str + ": ";
	m_szSyncMsg += 	FirstName + (CString) " " +  LastName;
	SetStatusMessage(m_szSyncMsg);
	((CStatic*) GetDlgItem(IDC_USER_NAME))->SetWindowText(FirstName + (CString) " " +  LastName);


			if(InitUser(FirstName, LastName, &wrk_space))
			{
				goto terminate;  // try to open after create
			}

			if((crash == CRASH_NO)  // user has been delete from PC but PDA not reset
				&& (nu_dlg.m_Action == 1))
				m_dup_action = 1;

			if(nu_dlg.m_Action > 1)
			{
				crash = CRASH_YES;
				sys_crashed = RESTORE_PC;
			}
			
//			if(nu_dlg.m_Action == 3)
				//m_dup_action = 1;

			SyncSetPDAID(FirstName + (CString) " " +  LastName);
		}
		else
		{
			goto terminate;  // error reading db
		}
	}
	else
	{
		if(crash == CRASH_YES)
		{
		  CPDACrashDlg aa;
		  if( aa.DoModal() != IDOK)  /* don't update crash */
		  {
			  CDelRecDlg dlg;
			  if(dlg.DoModal() != IDOK)
			  {
				  str.LoadString(IDS_TERMBYUSER);
				  WriteLog(str);
				  goto terminate2;
			  }
			  else
				  sys_crashed = NOT_RESTORE_PC;
		  }
		  else
		  {
			  str.LoadString(IDS_RESTOREPC);
			  WriteLog(str);
			  sync_vox_state = 1;
		  }
		  SyncSetPDAID(FirstName + (CString) " " +  LastName);
		}
	}

	switch(CheckStationNum(FirstName + (CString) " " +  LastName))
	{
	case 0:
		break;
	case 1:
		sys_crashed = NOT_RESTORE_PC;
		break;
	case 2:
		sys_crashed = RESTORE_PC;
		break;
	case 3:
		goto terminate2;
		break;
	default:
		break;
	}

	if(crash == CRASH_YES)
	{
		str.LoadString(IDS_PREPARERESTORE);
		SetStatusMessage(str);
		ResetAllDBLastSyncRecIDandDate();
		CHKTERM;
	}

		if(m_dup_action)
		{
			ValidDupPDANextPCID();
			sys_crashed = NOT_RESTORE_PC;
	//		ValidDupNextPCID();
		}

	BringWindowToTop();

	m_Username = FirstName + (CString) " " +  LastName;
	m_Username.TrimRight();

	UpdateRegistryUser(m_Username);		
	if(BackupDatabase())  // err in database backup 3fffffff
	{
		CBackupErrDlg be_dlg;
		str.LoadString(IDS_PROBLEMBACKUP);
		WriteLog(str);
		if(be_dlg.DoModal()!=IDOK)
			goto terminate;
	}

///////////////////////////////////////
	/////////////
	///////////////////////////////

	// Off expired alarm in PC b4 sync
//	_spawnlp( _P_WAIT, "offalarm.exe", "dummy0", "dummy1", NULL );

	// If windows link installed, launch it b4 sync
	m_btnStop.EnableWindow(FALSE);
	LaunchExternal(VTECH_LAUNCH_ONCONNECT,m_Username);
	m_btnStop.EnableWindow(TRUE);
	m_btnStop.RedrawWindow();

	cur_t = COleDateTime::GetCurrentTime();
	SyncIdleMode();
	if(SyncClockSet(DBDate2RTM(cur_t)))
		goto terminate;
		
	// check & set DST	
	SyncSetDST(); CHKTERM;

	//select the mode to update system database
	DispStep2();
	CHKTERM;

//	SyncIdleMode();
	SyncShow2();
	CHKTERM;

	ValidDBLastSyncID();

	if(crash == CRASH_YES)
	{
	DispStep3();
	CHKTERM;
	SyncIdleMode();
	SyncShow3();
	if(UpdateSystem())
		bRun = FALSE;

	CHKTERM;

	DispStep2();
	CHKTERM;

//	SyncIdleMode();
	SyncShow2();
	CHKTERM;
	}

	if(TermFromDesktop) goto terminate;
	if(UploadSysSettings())
		bRun = FALSE;

	if(TermFromDesktop) goto terminate;
	if(UpdateSch())
		bRun = FALSE;

	if(TermFromDesktop) goto terminate;
	if(UpdateSchRep())
		bRun = FALSE;

	if(TermFromDesktop) goto terminate;
	if(UpdateSchExcep())
		bRun = FALSE;

//	Sleep(20);	
	if(TermFromDesktop) goto terminate;
	if(UpdateExpenseType())
		bRun = FALSE;
	
	if(TermFromDesktop) goto terminate;
	if(UpdateExpense())
		bRun = FALSE;

//	Sleep(20);
	if(TermFromDesktop) goto terminate;
	if(UpdateAnni())
		bRun = FALSE;

//	Sleep(20);
	if(TermFromDesktop) goto terminate;
	if (UpdatePhoneBook())
		bRun = FALSE;

//	Sleep(20);
	if(TermFromDesktop) goto terminate;
	if(UpdateEmail())
		bRun = FALSE;

//	Sleep(20);
	if(TermFromDesktop) goto terminate;
	if(UpdateEmailMsg())
		bRun = FALSE;

//	Sleep(20);

	if(TermFromDesktop) goto terminate;
	if(UpdateMemo())
		bRun = FALSE;
//	Sleep(20);

	if(TermFromDesktop) goto terminate;
	if(UpdateSketch())
		bRun = FALSE;
		
//	Sleep(20);
	if(TermFromDesktop) goto terminate;
	if(UpdateToDoList())
		bRun = FALSE;

//	Sleep(20);
	if(TermFromDesktop) goto terminate;
	old_bStop = bStop;
	if(UpdateVoiceMemo())
		bRun = FALSE;

	if(bStop != old_bStop) /* user click stop to stop voice */
	{
		CQueryVoiceDlg voxdlg;
		voxdlg.m_szUsername = FirstName + (CString) " " +  LastName;
		voxdlg.DoModal();
	}

	if(TermFromDesktop) goto terminate;

//REG
	if(InstallDB())
		bRun = FALSE;
//REG
	
	if(InstallApp())
		bRun = FALSE;


	if(crash != CRASH_YES)
	{

//	Sleep(20);
	DispStep3();
	CHKTERM;
	SyncIdleMode();
	SyncShow3();

	if(TermFromDesktop) goto terminate;
	if(UpdateSystem())
		bRun = FALSE;
	}

//set clock again to ensure not time lagging
	cur_t = COleDateTime::GetCurrentTime();
	SyncIdleMode();
	SyncClockSet(DBDate2RTM(cur_t));

terminate:
  // if WindowsLink installed, launch after sync
	m_btnStop.EnableWindow(FALSE);
	LaunchExternal(VTECH_LAUNCH_ONDISCONNECT, m_Username);
	m_btnStop.EnableWindow(TRUE);
	m_btnStop.RedrawWindow();

	BringWindowToTop();
	str.LoadString(IDS_CLOSECONNECT);
	SetStatusMessage(str);
	Sleep(100);
	DoEvents();
//	if(SyncIdleMode())
//		goto terminate2;
//	if(SyncShowRdy())
//		goto terminate2;
	SyncEnd();
	CloseLog();
	sys_crashed = 0;

terminate2:
	m_ComBuffer.Reset();
	if(m_sound)
	Beep(500,500);

	if(dbProfile)
	{
	  CloseDatabase(dbProfile);
	  dbProfile = NULL;
	}
	if(dbAppDB)
	{
  	  CloseDatabase(dbAppDB);
	  dbAppDB = NULL;
	}
	if(dbCurrent)
	{
	  CloseDatabase(dbCurrent);
	  dbCurrent = NULL;
	}
	if(dbArchive)
	{
	  CloseDatabase(dbArchive);
	  dbArchive = NULL;
	}
	if(dbRecycle)
	{
	  CloseDatabase(dbRecycle);
	  dbRecycle = NULL;
	}
	wrk_space.Close();

	SetComHandleEvent(ComWaitForStart);
	bRun = FALSE;
	bIsSync = FALSE;
	TRACE("\nSync End");
	sync_init_by = INIT_BY_PC;
	str.LoadString(IDS_IDLE);
	m_pParent->SetTrayTip(str.GetBuffer(str.GetLength()));

	if(!TermFromDesktop)
	{
		SendMsgToDesktop(MSG_HOTSYNC_END);
		SendMsgToDesktopV2(MSG_HOTSYNC_END,&wrk_space);
	}
	pDispDlg = NULL;
	DoEvents();
	::PostMessage(m_pParent->m_hWnd, WM_DLG_QUIT, 0, 0);
}

int CSyncDispDlg::UpdateSystem()
{

		CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString str1,str2;
	CString str;
	
	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = 'System'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

//	if(fielddata.lVal == 3)
//		fielddata.lVal = 1;

	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	str.LoadString(IDS_RESTORESYS);
	SetStatusMessage(str);
	DoEvents();
	UpdateDatabasePCOvrPDAJot();	
		break;
	default:			// PDA ovr PC
	str.LoadString(IDS_BACKSYS);
	SetStatusMessage(str);
	DoEvents();
	UpdateDatabasePDAOvrPCJot();
		break;
	}

	delete rs;
	rs=  NULL;

	SyncIdleMode();
	CHKTERM;

	str1.LoadString(IDS_SYSTEM);
	str2.LoadString(IDS_OK);
	if(fielddata.lVal)
		WriteLog(str1 + " " + str2);

	SyncLogMsg(LOG_MSG_SYS);
	CHKTERM;


//	
	
	return 0;
terminate:
	if(rs)
		delete rs;

	str.LoadString(IDS_FAIL);
	if(fielddata.lVal)
	  WriteLog(str1 + " " + str2);

	SyncIdleMode();
	SyncLogMsg(LOG_MSG_SYS_F);
	return 1;
}

int CSyncDispDlg::UpdateSch()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_SCHEDULER);
	GetSyncCount(0);

	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += SCHDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

//	if(fielddata.lVal == 3)
//		fielddata.lVal = 1;

	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	str.LoadString(IDS_SYNC_SCHEDULER);
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDASch();
		break;
	case 2:			// PDA ovr PC
	str.LoadString(IDS_SYNC_SCHEDULER);
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCSch();
		break;
	default:						// sync both

	str.LoadString(IDS_SYNC_SCHEDULER);
	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, SCHDB);
		result = UpdateDatabasePCPDASyncSch();
		break;
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(SCHDB);
		SyncIdleMode();
//		SyncLogMsg(LOG_MSG_SCH);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);

	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_SCH_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateSchRep()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_SCHREPEAT);
	GetSyncCount(0);
	
	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += SCHDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

//	if(fielddata.lVal == 3)
//		fielddata.lVal = 1;

	str.LoadString(IDS_SYNC_SCHEDULER);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDASchRep();
		break;
	case 2:			// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCSchRep();
		break;
	default:						// sync both

	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, SCHREPDB);
		result = UpdateDatabasePCPDASyncSchRep();
		break;
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(SCHREPDB);
		SyncIdleMode();
//		SyncLogMsg(LOG_MSG_SCH);
//		WriteLog("SchRepeat OK");
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_SCH_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateSchExcep()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1, str2;

	str1.LoadString(IDS_SCHEXCEPTION);
	str2.LoadString(IDS_SCHEDULER);
	GetSyncCount(0);
	
	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += SCHDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

//	if(fielddata.lVal == 3)
//		fielddata.lVal = 1;

	str.LoadString(IDS_SYNC_SCHEDULER);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDASchExcep();
		break;
	case 2:			// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCSchExcep();
		break;
	default:						// sync both

	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, SCHEXCEPDB);
		result = UpdateDatabasePCPDASyncSchExcep();
		break;
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(SCHEXCEPDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_SCH);
		str.LoadString(IDS_OK);
		WriteLog(str2 + (CString)" " + str);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_SCH_F);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" "+ str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateExpenseType()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_EXPENSETYPE);
	GetSyncCount(0);
	
	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += EXPDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

//	if(fielddata.lVal == 3)
//		fielddata.lVal = 1;

	str.LoadString(IDS_SYNC_EXPENSE);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDAExpenseType();
		break;
	case 2:			// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCExpenseType();
		break;
	default:						// sync both

	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, EXPENSETYPEDB);
		result = UpdateDatabasePCPDASyncExpenseType();
		break;
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(EXPENSETYPEDB);
		SyncIdleMode();
//		SyncLogMsg(LOG_MSG_EXP);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str +": " + szCount);
		str.LoadString(IDS_SYNCTOPC);
		szCount = Str_ul(GetSyncCount(2));
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_EXP_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::InstallProg(CString filename)
{

 	 CFile app_file;
	 CFileException e;
	 int header_len;
	 char data_buf[100];
	 int attribute;
	 char app_name[30];
	 char *extra_data = NULL;
	 int extra_data_len;
	 CString progcode;
	 char *code_ptr;
	 int progcode_len;
	 char icon_data[1000];
	 int return_code = 0;
	CString str1,str2;

/*
	| Header Len |       VTech declaration        | Attribute | extra info | prog code |
		 4             strlen(APP_HEADER_MSG) + 1        4        varies       varies

*/

#define APP_HEADER_MSG	(char*) "VTech Helio App Inf V1.0   "
#define APP_HEADER_MSG_SIZE	(strlen(APP_HEADER_MSG) + 1)

	 CString str;
	if(!app_file.Open(filename, CFile::modeRead|CFile::shareDenyWrite, &e))
	{
		str.LoadString(IDS_ERROROPENAPP);
		WriteLog(str + " [" + filename + "]");
		app_file.Close();
		return 0;
	}

	if(app_file.GetLength() < ICON_BMP_SIZE + 4 + 50)  // len too short
	{
		str.LoadString(IDS_ERROROPENAPP);
		WriteLog("[" + filename + "] " + str);
		TRY {
		app_file.Rename(filename, filename + ".err");
		}
		CATCH( CFileException, e )
		{
			TRACE("\nCannot rename app file");
		}
		END_CATCH
		goto inst_finish;
	}

//	app_file.Read(icon_data, ICON_BMP_SIZE);

	app_file.Read(&header_len, 4);
	if((header_len > 1000) || (header_len < APP_HEADER_MSG_SIZE + 4 + 20) || header_len > app_file.GetLength())
	{
		str.LoadString(IDS_ERROROPENAPP);
		WriteLog("[" + filename + "] " + str);
		TRY {
		app_file.Rename(filename, filename + ".err");
		}
		CATCH( CFileException, e )
		{
			TRACE("\nCannot rename app file");
		}
		END_CATCH
		goto inst_finish;
	}

	app_file.Read(data_buf, APP_HEADER_MSG_SIZE);
	
	if(strcmp(APP_HEADER_MSG, data_buf) != 0)  // not a valid prg
	{
		str.LoadString(IDS_ERROROPENAPP);
		WriteLog("[" + filename + "] " + str);
		TRY {
		app_file.Rename(filename, filename + ".err");
		}
		CATCH( CFileException, e )
		{
			TRACE("\nCannot rename app file");
		}
		END_CATCH

		goto inst_finish;
	}

	app_file.Read(&attribute, 4);

	app_file.Read(app_name, 20);
	app_name[19] = 0x00; /* force app name len < 20 */

	extra_data_len = header_len - APP_HEADER_MSG_SIZE - 4 - 20;
	if(extra_data_len)
	{
		extra_data = new char[extra_data_len];
	    app_file.Read(extra_data, extra_data_len);
	}


	app_file.Read(icon_data, ICON_BMP_SIZE);

	progcode_len = app_file.GetLength() - header_len - 4 - ICON_BMP_SIZE;
	code_ptr = progcode.GetBufferSetLength(progcode_len);
	app_file.Read(code_ptr, progcode_len);

	progcode.ReleaseBuffer(progcode_len);

	str.LoadString(IDS_INSTALLING);
	SetStatusMessage(str + " " + (CString) app_name);
	DoEvents();

	str1.LoadString(IDS_INSTALLAPP);
	switch( AppInst(app_name, attribute, icon_data, extra_data, extra_data_len, progcode, progcode_len) )
	{
	case 0:  /* OK */
		str.LoadString(IDS_OK);
		WriteLog((CString)app_name + " " + str);
		app_file.Close();
		DeleteFile(filename.Left(filename.GetLength() - 4) + ".apo");
		app_file.Rename(filename, filename.Left(filename.GetLength() - 4) + ".apo"); 
		break;
	
	case ERR_APP_MAX_MEET:
		str2.LoadString(IDS_INSTALLFAIL1);
		WriteLog(str1 + (CString)" "  + (CString)app_name + (CString)" " + str2);
		break;
	case ERR_APP_EXIST:
		str2.LoadString(IDS_INSTALLFAIL2);
		WriteLog(str1 + (CString)" "  + (CString)app_name + (CString)" " + str2);
		break;

	case ERR_PDA_NOT_ENOUGH_SPACE:
		str2.LoadString(IDS_INSTALLFAIL3);
		WriteLog(str1 + (CString)" "  + (CString)app_name + (CString)" " + str2);
		break;

	default:
		str2.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" "  + (CString)app_name + (CString)" " + str2);
		break;
	}
	
	str.LoadString(IDS_INSTALLAPP);
	SetStatusMessage(str);
	DoEvents();

inst_finish:
	if(extra_data)
		delete []extra_data;
	
	return return_code;
}



int CSyncDispDlg::InstallApp()
{
	char root_path[120];
	CString sub_path;
	CListBox *pList;
	CString f_buf;
	CString app_file_name;
	int j;
//	CAddAppDlg ri_dlg;
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	CString str;

	CHKTERM;


//	 ri_dlg.DoModal();

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = 'Install'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 1;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 0;

	if(fielddata.lVal == 3)
		fielddata.lVal = 1;

	delete rs;
	rs=  NULL;

	if(fielddata.lVal == 0)
		return 0 ;  /* not sync */


	pList = (CListBox*)GetDlgItem(IDC_DISP_DIR_LIST);
	// copy all link files

	sub_path = szUserPath + "Acc\\";

	_getdcwd (_getdrive(), root_path, 100);
	if ( _chdir((CString)root_path + (CString)"\\" + sub_path))
	{
//	   ShowErrDlg("     Cannot found directory [Acc]!");
	   return 0;
	}

	 if((sys_crashed == RESTORE_PC) ||
		 (sys_crashed == NOT_RESTORE_PC))
	 {
		 int retry = 3;	 
		 doshow = 0;
		 CAddAppDlg *ri_dlg;

		 pCommCtrl->CloseConnection();

		 do
		 {
			ri_dlg = new(CAddAppDlg);
			ri_dlg->Create(CAddAppDlg::IDD);
			ri_dlg->path = (CString)root_path + (CString)"\\" + sub_path;
		 //	 ShowInstallAppDlg((CString)root_path + (CString)"\\" + sub_path);
		     ri_dlg->DoModal(); 
		     delete ri_dlg;
		 }
  		  while((doshow == 0) && (retry--));

//	 ri_dlg.DoModal();
	 pCommCtrl->OpenConnection();

	 }

	pList->ResetContent();
	pList->Dir(0, "*.app");

	_chdir (root_path);

	if(!pList->GetCount())
		return 0;  /* no app to install */

	str.LoadString(IDS_INSTALLAPP);
	SetStatusMessage(str);
	DoEvents();
	SyncIdleMode();
	CHKTERM;
	SyncAppInstMode();
	CHKTERM;

	for(j=0;j<pList->GetCount();j++)
	{
	   pList->GetText(j, f_buf);	
	   app_file_name = (CString) root_path + (CString)"\\" + (CString) sub_path + (CString)f_buf;
	   if(InstallProg(app_file_name))
	   {
		   SyncIdleMode();
		   return 1;
	   }
	}

	return 0;
terminate:
	return 1;
}

int CSyncDispDlg::UpdateExpense()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_EXPENSE);
	GetSyncCount(0);
	
	CHKTERM;


	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += EXPDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

//fielddata.lVal = 2;

	str.LoadString(IDS_SYNC_EXPENSE);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePCOvrPDAExpense();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCExpense();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, EXPDB);
		result = UpdateDatabasePCPDASyncExpense();
		break;
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(EXPDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_EXP);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 +(CString)" " + str);

		UpdateAllCurrencies();
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_EXP_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateToDoList()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_TODOLIST);
	GetSyncCount(0);
	
	CHKTERM;


	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += TODODB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;


	str.LoadString(IDS_SYNC_TODO);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePCOvrPDAToDo();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCToDo();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, TODODB);
		result = UpdateDatabasePCPDASyncToDo();
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(TODODB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_TD);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str );
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_TD_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateSketch()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_SKETCH1);
	GetSyncCount(0);
	
	CHKTERM;


	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += SKTDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;


	str.LoadString(IDS_SYNC_SKETCH);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDASketch();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCSketch();
		break;
	default:						// sync both

	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, SKTDB);
		result = UpdateDatabasePCPDASyncSketch();
	}

	delete rs;
	ClrRemain();

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(SKTDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_SK);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_SK_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateAnni()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;
	
	str1.LoadString(IDS_ANNIVERSARIES);
	GetSyncCount(0);
	CHKTERM;


	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += ANNIDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;


	str.LoadString(IDS_SYNC_ANNI);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA

	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePCOvrPDAAnni();
		break;
	case 2:							// PDA ovr PC

	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCAnni();
		break;
	default:						// sync both

	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, ANNIDB);
		result = UpdateDatabasePCPDASyncAnni();
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(ANNIDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_ANN);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_ANN_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}



int CSyncDispDlg::UpdateEmailMsg()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_EMAILMESSAGE);
	GetSyncCount(0);
	
	CHKTERM;


	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += EMSGDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else
	if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;


	str.LoadString(IDS_SYNC_EMAILM);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();


		result = UpdateDatabasePCOvrPDAEMailMsg();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();


		result = UpdateDatabasePDAOvrPCEMailMsg();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();


		ValidRecordModiDate(dbCurrent, EMSGDB);
		result = UpdateDatabasePCPDASyncEMailMsg();
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(EMSGDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_EM);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_EM_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateMemo()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_MEMO);
	GetSyncCount(0);
	
	CHKTERM;


	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += MEMODB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;

	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else
	if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;


	str.LoadString(IDS_SYNC_MEMO);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();


		result = UpdateDatabasePCOvrPDAMemo();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();


		result = UpdateDatabasePDAOvrPCMemo();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();


		ValidRecordModiDate(dbCurrent, MEMODB);
		result = UpdateDatabasePCPDASyncMemo();
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(MEMODB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_MEMO);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str);
	}
	else if(result)
	{
		SyncIdleMode();
		
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_MEMO_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateEmail()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str.LoadString(IDS_EMAIL);
	GetSyncCount(0);
	
	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += EMDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if (sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;

	str.LoadString(IDS_SYNC_EMAILA);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePCOvrPDAEMail();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCEMail();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, EMDB);
		result = UpdateDatabasePCPDASyncEMail();
	}

	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(EMDB);
		SyncIdleMode();
	//	SyncLogMsg(LOG_MSG_EM);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
	}
	else if(result)
	{
		if(!SyncIdleMode())
			SyncLogMsg(LOG_MSG_EM_F);
		szCount = Str_ul(GetSyncCount(1));
		str .LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	//	SyncIdleMode();
	}

	return result;
terminate:
	if(rs)
		delete rs;
	return 1;

}


int CSyncDispDlg::UpdatePhoneBook()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_PHONEBOOK);
	GetSyncCount(0);


	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += PBDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 2;
	else
	    fielddata = rs->GetFieldValue(0);	/* Sync Option */

	rs->Close();

	CHKTERM;
//	Sleep(10);
	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if(sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;


	str.LoadString(IDS_SYNC_PB);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDAPhoneBook();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCPhoneBook();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, PBDB);
		result = UpdateDatabasePCPDASyncPhoneBook();
	}
 
	delete rs;

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(PBDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_PB);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str);
	}
	else if(result)
	{
		Sleep(50);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_PB_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}


	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


int CSyncDispDlg::UpdateVoiceMemo()
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	int result;
	CString szCount;
	CString str, str1;

	str1.LoadString(IDS_VOICEMEMO);
	GetSyncCount(0);
	
	CHKTERM;

	szSql = "select SyncOption, LastPDA from ApplicationDB ";
	szSql += " where DatabaseName = '";
	szSql += VOXDB;
	szSql += '\'';

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto terminate;  // should never occur
	}

	if(rs->IsBOF())
		fielddata.lVal = 3;
	else
		fielddata = rs->GetFieldValue(0);	/* Sync Option */
	
	rs->Close();

	CHKTERM;


	if(sync_vox_state == 0)
	{
	if(sys_crashed == RESTORE_PC)
		fielddata.lVal = 1;
	else if (sys_crashed == NOT_RESTORE_PC)
		fielddata.lVal = 2;
	}

	str.LoadString(IDS_SYNC_VOICE);
	switch(fielddata.lVal)
	{
	case 0:	// do not sync
		result = 0;
		break;
	case 1:							// PC ovr PDA
	SetStatusMessage(str);
	DoEvents();
		result = UpdateDatabasePCOvrPDAVox();
		break;
	case 2:							// PDA ovr PC
	SetStatusMessage(str);
	DoEvents();

		result = UpdateDatabasePDAOvrPCVox();
		break;
	default:						// sync both
	SetStatusMessage(str);
	DoEvents();

		ValidRecordModiDate(dbCurrent, VOXDB);
		result = UpdateDatabasePCPDASyncVox();
	}

	delete rs;
	ClrRemain();

	if(TermFromNoSize)
		result = 1;

	if((!result) && fielddata.lVal)
	{
		UpdateLastSyncDate(VOXDB);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_VOX);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_OK);
		WriteLog(str1 + (CString)" " + str);
	}
	else if(result)
	{
		Sleep(50);
		SyncIdleMode();
		SyncLogMsg(LOG_MSG_VOX_F);
		szCount = Str_ul(GetSyncCount(1));
		str.LoadString(IDS_SYNCTOPDA);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		szCount = Str_ul(GetSyncCount(2));
		str.LoadString(IDS_SYNCTOPC);
		WriteLog(str1 + (CString)" " + str + ": " + szCount);
		str.LoadString(IDS_FAIL);
		WriteLog(str1 + (CString)" " + str);
	}


	return result;
terminate:
	if(rs)
		delete rs;
	return 1;
}


BOOL CSyncDispDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
   CMenu* mnu = this->GetSystemMenu(FALSE);
//   mnu->EnableMenuItem( SC_CLOSE, MF_BYCOMMAND|MF_GRAYED);
   //	CenterWindow();
	m_brush.CreateSolidBrush(GetSysColor(COLOR_WINDOW));
	m_iSyncState = 0;
	total_ani = 4;
	shown_timeout = TRUE;

	LoadImageList();
	InitDisp();
	m_TmrStart = SetTimer(100, 100, NULL);
	m_TmrAni = SetTimer(100,300,NULL);
	bRun = TRUE;
	pdatimeout = FALSE;
	shown_timeout = TRUE;
	pDispDlg = this;

	// TODO: Add extra initialization here
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSyncDispDlg::LoadImageList()
{
	CBitmap bm;
	BITMAP tmpBM;

#define DISP_1_OFF	0
#define DISP_1_ON	1
#define DISP_2_OFF	2
#define DISP_2_ON1	3
#define DISP_2_ON2  4
#define DISP_2_ON3	5
#define DISP_2_ON4	6
#define DISP_3_OFF	7
#define DISP_3_ON	8
#define DISP_BACK_MASK	9


	bm.LoadBitmap(IDB_STEP1_OFF);   // 0
	bm.GetBitmap(&tmpBM);
	m_ImageList.Create(tmpBM.bmWidth ,tmpBM.bmHeight,ILC_COLOR24|ILC_MASK, 0,1);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP1_ON);	//1
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP2_OFF);	//2
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP2_ON1);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP2_ON2);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP2_ON3);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP2_ON4);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP3_OFF);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(IDB_STEP3_ON);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();
	bm.LoadBitmap(DISP_BACK_MASK);
	m_ImageList.Add(&bm, RGB(0,0,255));
	bm.DeleteObject();	
}




void CSyncDispDlg::DoEvents()
{

	MSG msg;

	// Process existing messages in the application's message queue.
	// When the queue is empty, do clean up and return.
	while (::PeekMessage(&msg,NULL,0,0,PM_NOREMOVE) && bRun)
	{
		if (!AfxGetThread()->PumpMessage())
			return;
	}

	if((g_bTimeOut) && bRun)
	{
		ShowTimeOut();
		bRun = FALSE;
	}
}

void CSyncDispDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	if(nIDEvent == m_TmrStart)
	{
		bRun = TRUE;
		KillTimer(m_TmrStart);
		SyncStart();
	}	
	else if (nIDEvent == m_TmrAni)
		ShowAni();
	else
   	     CDialog::OnTimer(nIDEvent);


}

void CSyncDispDlg::ShowAni()
{

	switch (m_iSyncState)
	{
	case 0:
		AniShowStep1();
		break;
	case 1:
		AniShowStep2();
		break;
	case 3:
		AniShowStep3();
		break;
	}
}

void CSyncDispDlg::AniShowStep1()
{
	
}

void CSyncDispDlg::AniShowStep2()
{
	RECT pm;
	if((++Ani_Image) >= total_ani)
		Ani_Image = 0;

	m_Image[0] = DISP_1_OFF;
	m_Image[2] = DISP_3_OFF;

	((CStatic*)GetDlgItem(IDC_STEP2))->GetWindowRect(&pm);
	ScreenToClient(&pm);

	

	CDC *pDC = GetDC();
	m_ImageList.SetBkColor(IMG_BK_COLOR);
	m_ImageList.Draw(pDC, DISP_BACK_MASK, CPoint(pm.left, pm.top), ILD_NORMAL);
	m_Image[1] = DISP_2_ON1 + Ani_Image;
	m_ImageList.Draw(pDC, m_Image[1], CPoint(pm.left, pm.top), ILD_TRANSPARENT);
	ReleaseDC(pDC);

	DoEvents();
}

/*
void CSyncDispDlg::DrawImage(int image_index, CPoint &point, int style)
{
//	m_ImageList.Draw(pDC, DISP_BACK_MASK, CPoint(pm.left, pm.top), ILD_NORMAL);


}
*/

void CSyncDispDlg::AniShowStep3()
{
}


void CSyncDispDlg::DispStep1()
{
	m_iSyncState = 0;
//	((CStatic*)GetDlgItem(IDC_STEP1))->SetBitmap(m_hBmpStep1[1]);
}

void CSyncDispDlg::DispStep2()
{
	m_iSyncState = 1;
	CDC *pDC = GetDC();
	RECT pm;

	((CStatic*)GetDlgItem(IDC_STEP1))->GetWindowRect(&pm);
	ScreenToClient(&pm);
	m_ImageList.Draw(pDC, m_Image[DISP_1_OFF], CPoint(pm.left, pm.top), ILD_TRANSPARENT);

//	((CStatic*)GetDlgItem(IDC_STEP2))->GetWindowRect(&pm);
//	ScreenToClient(&pm);
//	m_ImageList.Draw(pDC, m_Image[DISP_2_OFF], CPoint(pm.left, pm.top), ILD_TRANSPARENT);

	Ani_Image = 100;   // next will start at first frame
	m_TmrAni = SetTimer(101, 1000, NULL);
	DoEvents();
}

void CSyncDispDlg::DispStep3()
{

	m_iSyncState = 2;
	KillTimer(m_TmrAni);
/*
	((CStatic*)GetDlgItem(IDC_STEP2))->SetBitmap(m_hBmpStep2[0]);
	((CStatic*)GetDlgItem(IDC_STEP3))->SetBitmap(m_hBmpStep3[1]);
	DoEvents();
*/
}

void CSyncDispDlg::InitDisp()
{
	m_Image[0] = DISP_1_OFF;
	m_Image[1] = DISP_2_OFF;
	m_Image[2] = DISP_3_OFF;
}

void CSyncDispDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
//	bRun = FALSE;
//	CDialog::OnCancel();
}


void CSyncDispDlg::OnOK()
{
	if(!bRun)
		CDialog::OnOK();
}

//////////////////////////////////////////////
/////////////   EMail Message
//////////////////////////////////////////////
int CSyncDispDlg::UpdateDatabasePDAOvrPCEMailMsg()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_EMSGDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	if(EMailUpdateTimeIndex(dbid))
		return 1;

	EMailMsgArchivePDAOvrPC(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 12000)
		return 1;
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);

		DoEvents();
#ifdef xxxxxxxxxxxxxxxxxxx
		if(DBIsExistRecord(dbCurrent, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			EMailMsgMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		DoEvents();
#endif
		EMailMsgAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += EMSGDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			//EMailMsgMoveRecord(dbCurrent, dbRecycle, recid);
			EMailMsgDeletePCRecord(dbCurrent, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:
	SyncEmailMsg();

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	UpdateLastRecID(EMSGDB, 1000);
	return 0;

terminate:
	if(rs)
		delete rs;

	return 1;
}



int CSyncDispDlg::UpdateDatabasePCOvrPDAEMailMsg()
{
	DatabaseID dbid;
	int total_rec; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();

	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EMSGDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;
	
	CHKTERM;

	if(EMailUpdateTimeIndex(dbid) != 0)
		return 1;

	EMailMsgArchivePCOvrPDA(dbid);
	CHKTERM;

	total_rec = 0;

	CHKTERM;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record) != 0)
		return 1;		// error

	CHKTERM;

	if(total_rec > 12000)
		return 1;
/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(recycle_pda_emailmsg != 0)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	          EMailMsgAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  rec_content.Empty();
		   }
#endif
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       EMailMsgAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  rec_content.Empty();
		   }
		   else
		   {

		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(abs(DBCompDate(dbCurrent, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date)) < RTM_TORENCE)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		   /* then add to PDA */
		  PDAEMailMsgAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		  UpdateLastSyncPCRecID(EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += EMSGDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat

	szSql += " order by RecordID DESC";
	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDAEMailMsgAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			UpdateLastSyncPCRecID(EMSGDB, (rs->GetFieldValue(0)).lVal);
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

nextstate:

	SyncEmailMsg();
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);
	UpdateLastRecID(EMSGDB, 1000);

	return 0;

terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncEMailMsg()
{
	DatabaseID dbid;
	int total_rec;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;


   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 5;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 290;
   missrec_dlg.row_height[1] = 290;
   missrec_dlg.row_height[2] = 290;
   missrec_dlg.row_height[3] = 570;
   missrec_dlg.row_height[4] = 290;

   CString str;
	str.LoadString(IDS_MODIFYDATE);
   missrec_dlg.m_Content[0][0] = str;
   str.LoadString(IDS_FOLDER);
   missrec_dlg.m_Content[1][0] = str;
   str.LoadString(IDS_FROM);
   missrec_dlg.m_Content[2][0] = str;
   str.LoadString(IDS_TO);
   missrec_dlg.m_Content[3][0] = str;
   str.LoadString(IDS_SUBJECT);
   missrec_dlg.m_Content[4][0] = str;



   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 5;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 290;
   duprec_dlg.row_height[1] = 290;
   duprec_dlg.row_height[2] = 290;
   duprec_dlg.row_height[3] = 570;
   duprec_dlg.row_height[4] = 290;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_FOLDER);
   duprec_dlg.m_ContentPC[1][0] = str;
   str.LoadString(IDS_FROM);
   duprec_dlg.m_ContentPC[2][0] = str;
   str.LoadString(IDS_TO);
   duprec_dlg.m_ContentPC[3][0] = str;
   str.LoadString(IDS_SUBJECT);
   duprec_dlg.m_ContentPC[4][0] = str;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_FOLDER);
   duprec_dlg.m_ContentPDA[1][0] = str;
   str.LoadString(IDS_FROM);
   duprec_dlg.m_ContentPDA[2][0] = str;
   str.LoadString(IDS_TO);
   duprec_dlg.m_ContentPDA[3][0] = str;
   str.LoadString(IDS_SUBJECT);
   duprec_dlg.m_ContentPDA[4][0] = str;


	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_EMSGDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	EMailUpdateTimeIndex(dbid);
//		return 1;

	GetLastSyncRecID(EMSGDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(EMSGDB, &last_sync_date);
	total_rec = 0;

	EMailMsgArchivePCOvrPDA(dbid);
	CHKTERM;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 12000)
		return 1;


//goto chkboth;
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
		  TRACE("\n%d" ,((RecordHeader)(record[i].rec_header)).rec_id);
	   if(!DBIsExistRecord(dbCurrent, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  EMailMsgAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should  delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			   if(recycle_pda_emailmsg)
			  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  EMailMsgAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
#endif
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			   int action;

			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
					  rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
				   }
 				   action = missrec_act;
			   }
			   else
			   {
				      rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
					  missrec_dlg.total_rows = 5;
					  missrec_dlg.total_cols = 2;

					  CString str;
			          switch(((RecordHeader)(record[i].rec_header)).cat)
					  {
				     case INBOX + 1:
						 str.LoadString(IDS_INBOX);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     case OUTBOX + 1:
						 str.LoadString(IDS_OUTBOX);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     case DRAFT + 1:
						 str.LoadString(IDS_DRAFT);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     case SENT + 1:
						 str.LoadString(IDS_SENT);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     default:
					   continue;
					  }

				str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;

			   missrec_dlg.m_Content[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   missrec_dlg.m_Content[0][1].Remove('#');

				   
			   fielddata.Empty(); // from
			   PDADataGetField(2, &rec_content, &fielddata);
			   fielddata.Replace('\n', ',');
			   missrec_dlg.m_Content[2][1] = fielddata;
			   RemoveNULL(&missrec_dlg.m_Content[2][1]);
			   str.LoadString(IDS_DEFAULTUSER);
			   if(fielddata.IsEmpty() && (((RecordHeader)(record[i].rec_header)).cat == DRAFT + 1))
				   missrec_dlg.m_Content[2][1] = str;
		    
			   fielddata.Empty();  // to
			   PDADataGetField(3, &rec_content, &fielddata);
			   fielddata.Replace('\n', ',');
			   if(fielddata.IsEmpty())
				   missrec_dlg.m_Content[3][1] = " ";
			   else
				   missrec_dlg.m_Content[3][1] = fielddata;

			   fielddata.Empty(); // subject
			   PDADataGetField(6, &rec_content, &fielddata);
			   str.LoadString(IDS_NOSUBJECT);
			   if((fielddata.IsEmpty()) || (fielddata[0] == '\0'))
				   fielddata = str;
			   missrec_dlg.m_Content[4][1] = fielddata;
			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					   EMailMsgDeletePCRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
					   EMailMsgDeletePCRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id);
					   EMailMsgAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }
}
	   }  // Rec not found in PC
	}


/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += EMSGDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, not condiser cat

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += EMSGDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}


////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{

			CHKTERM;
//			if((rs_pc->GetFieldValue(0)).lVal <= last_pc_recid)
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAEMailMsgAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
//				EMailMsgMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
				EMailMsgDeletePCRecord(dbCurrent,(rs_pc->GetFieldValue("RecordID")).lVal);
			}
			else
			{
			/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */
			int action;
			if(missrec_act)
				action = missrec_act;
			else
			{
				CString str;
 	          switch((rs_pc->GetFieldValue("Category")).lVal)
					  {
				     case INBOX + 1:
						 str.LoadString(IDS_INBOX);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     case OUTBOX + 1:
						 str.LoadString(IDS_OUTBOX);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     case DRAFT + 1:
						 str.LoadString(IDS_DRAFT);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     case SENT + 1:
						 str.LoadString(IDS_SENT);
					   missrec_dlg.m_Content[1][1] = str;
					   break;
				     default:
					   rs_pc->MoveNext();
					   continue;
					  }	   
				str.LoadString(IDS_MISS_PDA);
				missrec_dlg.WndTitle = str;
				str.LoadString(IDS_Q_SELECTACTION_PDA);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPC);
			   missrec_dlg.m_szMissLabel = str;
	   
			   missrec_dlg.m_Content[0][1] = ValidDBDate(&COleDateTime((rs_pc->GetFieldValue("ModifyDate"))));
				   
			   // from
			   missrec_dlg.m_Content[2][1] = (LPSTR)(rs_pc->GetFieldValue("MailFrom")).bstrVal;
			   missrec_dlg.m_Content[2][1].TrimLeft();
			   RemoveNULL(&missrec_dlg.m_Content[2][1]);
			   str.LoadString(IDS_DEFAULTUSER);
			   if(missrec_dlg.m_Content[2][1].IsEmpty() && (rs_pc->GetFieldValue("Category").lVal == DRAFT + 1))
					missrec_dlg.m_Content[2][1] = str;

			   // to
			   missrec_dlg.m_Content[3][1] = (LPSTR)(rs_pc->GetFieldValue("MailTo")).bstrVal;;
			   if(missrec_dlg.m_Content[3][1].IsEmpty())
				   missrec_dlg.m_Content[3][1] = " ";

			   // subject
			   CString subject1 = ((LPSTR)(rs_pc->GetFieldValue("Subject")).bstrVal);
				str.LoadString(IDS_NOSUBJECT);
			   if(subject1.IsEmpty())
					duprec_dlg.m_ContentPC[4][1] = str;
			   else
			        duprec_dlg.m_ContentPC[4][1] = subject1;

				str.LoadString(IDS_SYNCTOPDA);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDAEMailMsgAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				   break;
				   case DEL_REC:
		   			   //EMailMsgMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   EMailMsgDeletePCRecord(dbCurrent, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;
			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;
//			if(((RecordHeader)(record[i].rec_header)).rec_id < 1003)
//			{
//
//			}
//			else

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
				TRACE("nnn");
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	CHKTERM;
			  SyncDBUpMode(); CHKTERM;
			  //EMailMsgMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  EMailMsgAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDAEMailMsgAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
			   int action;

			if (abs(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(record[i].rec_header.modi_date))) > 2)
			   {

			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 	  	              SyncIdleMode(); CHKTERM;
                      SyncDBUpMode(); CHKTERM;
				   }
					action = duprec_act;
			   }
			   else
			   {
				   ///////////////// prepare PDA content
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
					  SyncIdleMode();	CHKTERM;
					  SyncDBUpMode(); CHKTERM;

// RTM xx = DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate"))));
 //RTM yy = _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date);

					  CString str;
			          switch(((RecordHeader)(record[i].rec_header)).cat)
					  {
				     case INBOX + 1:
						 str.LoadString(IDS_INBOX);
					   duprec_dlg.m_ContentPDA[1][1] = str;
					   break;
				     case OUTBOX + 1:
						 str.LoadString(IDS_OUTBOX);
					   duprec_dlg.m_ContentPDA[1][1] = str;
					   break;
				     case DRAFT + 1:
						 str.LoadString(IDS_DRAFT);
					   duprec_dlg.m_ContentPDA[1][1] = str;
					   break;
				     case SENT + 1:
						 str.LoadString(IDS_SENT);
					   duprec_dlg.m_ContentPDA[1][1] = str;
					   break;
				     default:
					   continue;
					  }

				str.LoadString(IDS_MODIFY);
               duprec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_MODIFY);
			   duprec_dlg.m_szDupMsg = str;

			   duprec_dlg.m_ContentPDA[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   duprec_dlg.m_ContentPDA[0][1].Remove('#');
			   
		   
			   fielddata.Empty(); // from
			   PDADataGetField(2, &rec_content, &fielddata);
			   fielddata.Replace('\n', ',');
			   duprec_dlg.m_ContentPDA[2][1] = fielddata;
			   RemoveNULL(&duprec_dlg.m_ContentPDA[2][1]);
			   str.LoadString(IDS_DEFAULTUSER);
			   if(duprec_dlg.m_ContentPDA[2][1].IsEmpty() && (((RecordHeader)(record[i].rec_header)).cat == DRAFT + 1))
						duprec_dlg.m_ContentPDA[2][1] = str;

			   fielddata.Empty();  // to
			   PDADataGetField(3, &rec_content, &fielddata);
			   fielddata.Replace('\n', ',');
			   duprec_dlg.m_ContentPDA[3][1] = fielddata;
			   if(duprec_dlg.m_ContentPDA[3][1].IsEmpty())
				   duprec_dlg.m_ContentPDA[3][1] = " ";

			   fielddata.Empty(); // subject
			   PDADataGetField(6, &rec_content, &fielddata);
			   str.LoadString(IDS_NOSUBJECT);
			   if((fielddata.IsEmpty()) || (fielddata[0] == '\0'))
				   fielddata = str;
			   duprec_dlg.m_ContentPDA[4][1] = fielddata;
             
			    ///////////////////  Prepare PC content

 	          switch((rs_both->GetFieldValue("Category")).lVal)
					  {
				     case INBOX + 1:
						 str.LoadString(IDS_INBOX);
					   duprec_dlg.m_ContentPC[1][1] = str;
					   break;
				     case OUTBOX + 1:
						 str.LoadString(IDS_OUTBOX);
					   duprec_dlg.m_ContentPC[1][1] = str;
					   break;
				     case DRAFT + 1:
						 str.LoadString(IDS_DRAFT);
					   duprec_dlg.m_ContentPC[1][1] = str;
					   break;
				     case SENT + 1:
						 str.LoadString(IDS_SENT);
					   duprec_dlg.m_ContentPC[1][1] = str;
					   break;
				     default:
					   continue;
					  }	   



			   COleDateTime modi_date;
			   modi_date = ((rs_both->GetFieldValue("ModifyDate")));
			   if(modi_date.GetStatus() == COleDateTime::valid)
			   {
				   duprec_dlg.m_ContentPC[0][1] = COleDateTime((rs_both->GetFieldValue("ModifyDate"))).Format("%b %d %Y %H:%M:%S");
			   }
			   else
				   duprec_dlg.m_ContentPC[0][1] = ""; //"[Unknown]";
				   
			   // from
			   duprec_dlg.m_ContentPC[2][1] = (LPSTR)(rs_both->GetFieldValue("MailFrom")).bstrVal;
			   duprec_dlg.m_ContentPC[2][1].TrimLeft();
			   RemoveNULL(&duprec_dlg.m_ContentPC[2][1]);
			   str.LoadString(IDS_DEFAULTUSER);
			   if(duprec_dlg.m_ContentPC[2][1].IsEmpty() &&  (rs_both->GetFieldValue("Category").lVal == DRAFT + 1))
				   duprec_dlg.m_ContentPC[2][1] = str;

			   // to
			   duprec_dlg.m_ContentPC[3][1] = (LPSTR)(rs_both->GetFieldValue("MailTo")).bstrVal;
			   if(duprec_dlg.m_ContentPC[3][1].IsEmpty())
				   duprec_dlg.m_ContentPC[3][1] = " ";

			   // subject
			   CString subject = ((LPSTR)(rs_both->GetFieldValue("Subject")).bstrVal);
				str.LoadString(IDS_NOSUBJECT);
			   if(subject.IsEmpty())
					duprec_dlg.m_ContentPC[4][1] = str;
			   else
			        duprec_dlg.m_ContentPC[4][1] = subject;
			   duprec_dlg.DoModal();

			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDAEMailMsgAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   break;
				   case SYNC_TO_PC:
		   			   //EMailMsgMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   //CHKTERM;
					   EMailMsgAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			} // if
		  rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}


	if(record)
	{
	   free(record);
	   record = NULL;
	}

	CHKTERM;

	SyncEmailMsg();
	UpdateLastRecID(EMSGDB, last_pda_recid);
	
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}

/*
HBRUSH CSyncDispDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	if(nCtlColor == CTLCOLOR_EDIT)
	{
		//pDC->SetBkMode(TRANSPARENT);
		pDC->SetBkColor(RGB(255,255,132));
		pDC->SetTextColor(GetSysColor(COLOR_WINDOWTEXT));
		return (HBRUSH) m_brush.GetSafeHandle();
	}
	else return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
}
*/

void CSyncDispDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	CStopQueryDlg dlg;
	AlertSound(MB_ICONQUESTION);
	if( dlg.DoModal() != IDOK)
		return;
	bRun = FALSE;
	bStop = TRUE;
	pdatimeout = TRUE;
	shown_timeout = FALSE;
	CString str;
	str.LoadString(IDS_TERMBYUSER);
	WriteLog(str);
//	Invalidate();
	sync_init_by = INIT_BY_PC;

	str.LoadString(IDS_IDLE);
	m_pParent->SetTrayTip(str.GetBuffer(str.GetLength()));
	SendMsgToDesktop(MSG_HOTSYNC_END);
	SendMsgToDesktopV2(MSG_HOTSYNC_END,&wrk_space);

	OnOK();
}

void CSyncDispDlg::OnStopFormDesktop()
{
	// TODO: Add your control notification handler code here

//	bRun = FALSE;
//	bStop = TRUE;
//	pdatimeout = TRUE;
//	shown_timeout = FALSE;
//	WriteLog("Terminated by user");
//	Invalidate();
//	sync_init_by = INIT_BY_PC;
//	m_pParent->SetTrayTip((char*)"V-Sync: Idle");
//	SendMsgToDesktop(MSG_HOTSYNC_END);
//OnCancel();
}

void CSyncDispDlg::CreateLog() 
{
	msgLog.Empty();
}

void CSyncDispDlg::WriteLog(CString msg) 
{
	msgLog += msg;
	msgLog += "\r\n";
}

void CSyncDispDlg::CloseLog()
{
	CFile logfile;
	CFileException e;
	CString buf;
	LPSTR p;

	msgLog += "\r\n\r\n";

	logfile.Open(szUserPath + (CString)"\\sync.log", CFile::modeRead|CFile::shareDenyNone, &e);

	if(e.m_cause == CFileException::none)  //  open file ok
	{
		int flen = logfile.GetLength();
		p = buf.GetBuffer(flen);
		logfile.Read(p, flen);
		buf.ReleaseBuffer(flen);
		TRY
		{
			logfile.Close();
		}
		CATCH(CFileException, e0)
		{
		}
		END_CATCH
	}

	msgLog += buf;

	TRY
	{
		CFile::Remove(szUserPath + (CString)"\\sync.bak");
	}
	CATCH( CFileException, e1 )
	{
	}
	END_CATCH

	TRY
	{
		CFile::Rename(szUserPath + (CString)"\\sync.log", szUserPath + (CString)"\\sync.bak");
	}
	CATCH( CFileException, e2 )
	{
	}
	END_CATCH

	TRY
	{
		logfile.Open(szUserPath + (CString)"\\sync.log", CFile::modeCreate|CFile::modeWrite|CFile::shareDenyNone, &e);
	}
	CATCH( CException, e3 )
	{
		return;
	}
	END_CATCH

	p = msgLog.GetBuffer(msgLog.GetLength());

	TRY
	{
		logfile.Write(p, msgLog.GetLength());
	}
	CATCH( CException, e4)
	{
	}
	END_CATCH

	TRY
	{
		logfile.Close();
	}
	CATCH( CException, e4)
	{
	}
	END_CATCH

	msgLog.ReleaseBuffer(msgLog.GetLength());
}



void CSyncDispDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CDC *pDC = GetDC();
	
	// TODO: Add your message handler code here
	RECT pm;

	((CStatic*)GetDlgItem(IDC_STEP1))->GetWindowRect(&pm);
	ScreenToClient(&pm);
	m_ImageList.Draw(pDC, m_Image[0], CPoint(pm.left, pm.top), ILD_TRANSPARENT);


	((CStatic*)GetDlgItem(IDC_STEP2))->GetWindowRect(&pm);
	ScreenToClient(&pm);
	m_ImageList.Draw(pDC, m_Image[1], CPoint(pm.left, pm.top), ILD_TRANSPARENT);

	((CStatic*)GetDlgItem(IDC_STEP3))->GetWindowRect(&pm);
	ScreenToClient(&pm);
	m_ImageList.Draw(pDC, m_Image[2], CPoint(pm.left, pm.top), ILD_TRANSPARENT);

	ReleaseDC(pDC);

	// Do not call CDialog::OnPaint() for painting messages
}


void CSyncDispDlg::SendMsgToDesktopV2(UINT msg, CDaoWorkspace *wrk_space)
{
	CDaoDatabase* pDBProgram = NULL;
	CDaoRecordset* pRs = NULL;
	int nReturn;
	int nCount;
	CString szProgramName;
	CString szProgramPath;
	HWND hWnd;
	CWnd* pWnd;

//	if(msg == MSG_HOTSYNC_START)
//	{
		pDBProgram = new CDaoDatabase(wrk_space);
		nReturn = OpenDatabase(pDBProgram, "Program.mdb");

		if((nReturn) && pDBProgram)
		{
			delete pDBProgram;
			pDBProgram = NULL;
			return;
		}

		pRs = new CDaoRecordset (pDBProgram);   
		pRs->Open(dbOpenSnapshot,"Select * from ProgramInfo",0);
		if(!pRs->IsBOF())
			pRs->MoveLast();
		nCount = pRs->GetRecordCount();

		//for the LaunchBar
		CString str;
		str.LoadString(IDS_HELIODESKTOPLAUNCH);
		szProgramName = str;
		hWnd = ::FindWindow(NULL,szProgramName);
		if(hWnd != NULL)
		{
			::SendMessage(hWnd,msg,0,0);
		}

		if(nCount == 0)
		{
			delete pRs;
			delete pDBProgram;
			return;
		}
		pRs->MoveFirst();

		while(!pRs->IsEOF())
		{
			str.LoadString(IDS_HELIODESKTOP);
			szProgramName = str;
			szProgramName += " - ";
			szProgramName += (CString)pRs->GetFieldValue(3).pbVal;	// column for localization
			szProgramPath = (CString)pRs->GetFieldValue("ProgramPath").pbVal;
			hWnd = ::FindWindow(NULL,szProgramName);
		
			if(hWnd == NULL) //try the archive also
			{
				str.LoadString(IDS_ARCHIVE);
				szProgramName += " (";
				szProgramName += str;
				szProgramName += ")";
				hWnd = ::FindWindow(NULL,szProgramName);
			}

			if(hWnd != NULL)
			{
				::SendMessage(hWnd,msg,0,0);
				szDesktopProgramPath = szProgramPath;
				break;
			}
			pRs->MoveNext();
		}

		delete pRs;
		delete pDBProgram;

		pWnd = FindWindow(NULL,"V-Sync Logfile");
		if(pWnd != NULL)
		{
			pWnd->SendMessage(WM_CLOSE,0,0);
		}
				
		return;
//	}
//	else if(msg == MSG_HOTSYNC_END)
//	{
//		WinExec(szDesktopProgramPath, SW_SHOW);
//		szDesktopProgramPath = "";
//		return;
//	}
}

int CSyncDispDlg::UploadSysSettings()
{
	CString rec_content;
	CString dbheader;
	DatabaseID dbid;
	int total_rec;
	RecStruct *record = NULL;
	CFileException e;
	char* data;
	int i, j;

	CString szSql;
	CString content;
	int z;
	CString szData;
	CDaoRecordset* rsSystem = NULL;
	bool NoSystemSetting = false;

	ClockSettings* clock;
	CountrySettings* country;
	KeyMappingSettings* key;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	rsSystem = new CDaoRecordset(dbAppDB);
	try
	{
		rsSystem->Open(dbOpenDynaset, "Select * from SystemSetting",0);
	}
	catch (CException *e)
	{
		e->Delete();
		NoSystemSetting = true;
		delete rsSystem;
		rsSystem = NULL;

	}
	if(!rsSystem->IsBOF())
		rsSystem->MoveLast();
	rsSystem->MoveFirst();

	for(i=0;i<total_rec;i++)
	{
		if(record[i].rec_header.rec_id == SYS_SOUND)
			continue;

		if(record[i].rec_header.rec_id == SYS_PASSWORD)
			continue;

		if(record[i].rec_header.rec_id == SYS_MODEM)
			continue;

		if(record[i].rec_header.rec_id == SYS_SYSINFO)
			continue;

		if(record[i].rec_header.rec_id == SYS_OWNINFO)
			continue;

		if(record[i].rec_header.rec_id == SYS_SND_EFFECT)
			continue;

		if(record[i].rec_header.rec_id == SYS_PDA_USERID)
			continue;


		rec_content.Empty();
   	    SyncIdleMode();
	    CHKTERM;
		SyncDBEnqMode();
	    CHKTERM;

		if(SyncReadRec(dbid, record[i].rec_header.rec_id, (char*) &record[i].rec_header, &rec_content) == 0)
		{
	
			CHKTERM;
//system setting for new desktop///////////////////////////////////////
			if(!NoSystemSetting)
			{

			if(record[i].rec_header.rec_id == SYS_CLOCK)
			{
				rsSystem->FindFirst("SystemSettingItem = 'CLOCK' AND SystemSettingSubItem = 'AUTOTIMEOFF'");
				PDADataGetField(1, &rec_content, &szData);
				data = szData.GetBuffer(szData.GetLength());
				clock = (ClockSettings*)data;

				content = LongToString((int)clock->auto_off_time);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)clock->home_country);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)clock->visit_country);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)clock->home_dst_active);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();
			
				content = LongToString((int)clock->visit_dst_active);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();			
			
			}			

			if(record[i].rec_header.rec_id == SYS_COUNTRY)
			{
				rsSystem->FindFirst("SystemSettingItem = 'COUNTRY' AND SystemSettingSubItem = 'REGIONALSETTING'");
				PDADataGetField(1, &rec_content, &szData);
				data = szData.GetBuffer(szData.GetLength());
				country = (CountrySettings*)data;

				content = LongToString((int)country->region);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)country->time_fmt);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)country->date_fmt);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)country->start_of_week);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)country->nums);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)country->units);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

			}			

			if(record[i].rec_header.rec_id == SYS_EMAIL1 || record[i].rec_header.rec_id == SYS_EMAIL2
				|| record[i].rec_header.rec_id == SYS_EMAIL3 || record[i].rec_header.rec_id == SYS_EMAIL4)
			{

				if(record[i].rec_header.rec_id == SYS_EMAIL1)
					rsSystem->FindFirst("SystemSettingItem = 'EMAIL1' AND SystemSettingSubItem = 'ISPNAME'");
				else if(record[i].rec_header.rec_id == SYS_EMAIL2)
					rsSystem->FindFirst("SystemSettingItem = 'EMAIL2' AND SystemSettingSubItem = 'ISPNAME'");
				else if(record[i].rec_header.rec_id == SYS_EMAIL3)
					rsSystem->FindFirst("SystemSettingItem = 'EMAIL3' AND SystemSettingSubItem = 'ISPNAME'");
				else if(record[i].rec_header.rec_id == SYS_EMAIL4)
					rsSystem->FindFirst("SystemSettingItem = 'EMAIL4' AND SystemSettingSubItem = 'ISPNAME'");

				//for auto_ip, apop, del_mail option
				bool Auto_ip;
				CString apop;
				CString del_mail;
				CString Auto;
				Auto.LoadString(IDS_AUTO);
				PDADataGetField(1, &rec_content, &szData);
				if(szData[0] == 0x01)
					Auto_ip = true;
				else
					Auto_ip = false;
				if(szData[1] == 0x01)
					apop.LoadString(IDS_ON);
				else
					apop.LoadString(IDS_OFF);

				if(szData[2] == 0x01)
					del_mail.LoadString(IDS_ON);
				else
					del_mail.LoadString(IDS_OFF);
				//////////////////////////////////////


				for(z =2;z <11;z++)
				{
					PDADataGetField(z, &rec_content, &szData);
//					RemoveNULL(&szData);
					rsSystem->Edit();
					if(szData != "")
						rsSystem->SetFieldValue("SystemValue",(LPCTSTR)szData);
					else
						rsSystem->SetFieldValueNull("SystemValue");
					rsSystem->Update();
					rsSystem->MoveNext();
				}
				//DNS1
				content = "";
				for(z = 0; z < 4; z++)
				{
					PDADataGetField(11 + z, &rec_content, &szData);
					RemoveNULL(&szData);
					content += szData;
					if(z != 3)
						content += " - ";
				}
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)content);
				else
					rsSystem->SetFieldValueNull("SystemValue");
				rsSystem->Update();
				rsSystem->MoveNext();
				//DNS2
				content = "";
				for(z = 0; z < 4; z++)
				{
					PDADataGetField(15 + z, &rec_content, &szData);
					RemoveNULL(&szData);
					content += szData;
					if(z != 3)
						content += " - ";
				}
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)content);
				else
					rsSystem->SetFieldValueNull("SystemValue");
				rsSystem->Update();
				rsSystem->MoveNext();
				//ip address
				content = "";
				if(!Auto_ip)
				{
					for(z = 0; z < 4; z++)
					{
						PDADataGetField(19 + z, &rec_content, &szData);
						RemoveNULL(&szData);
						content += szData;
						if(z != 3)
							content += " - ";
					}
				}
				else
					content = "0";
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)content);
				else
					rsSystem->SetFieldValueNull("SystemValue");
				rsSystem->Update();
				rsSystem->MoveNext();
				//apop
				rsSystem->Edit();
				rsSystem->SetFieldValue("SystemValue",(LPCTSTR)apop);
				rsSystem->Update();
				rsSystem->MoveNext();			
				//del mail
				rsSystem->Edit();
				rsSystem->SetFieldValue("SystemValue",(LPCTSTR)del_mail);
				rsSystem->Update();
				rsSystem->MoveNext();			
			}			

			if(record[i].rec_header.rec_id == SYS_KEY_MAPPING)
			{
				rsSystem->FindFirst("SystemSettingItem = 'KEY_MAPPING' AND SystemSettingSubItem = 'BUTTON1'");
				PDADataGetField(1, &rec_content, &szData);
				data = szData.GetBuffer(szData.GetLength());
				key = (KeyMappingSettings*)data;

				content = LongToString((int)key->key1);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)key->key2);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)key->key3);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)key->key4);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();

				content = LongToString((int)key->key5);
				rsSystem->Edit();
				if(content != "")
					rsSystem->SetFieldValue("SystemValue",(LPCTSTR)(content));
				rsSystem->Update();
				rsSystem->MoveNext();			}
			}

///////////////////////////////////////////////////////////////////////////			
		}
		CHKTERM;
	}

	if(rsSystem)
		delete rsSystem;

	if(record)
		free(record);
	return 0;
terminate:
	if(record)
		free(record);
	return 1;

}

CString CSyncDispDlg::LongToString(int iInput)
{
	char buffer[20];
	itoa(iInput,buffer,10);
	return (CString)buffer;
}

int CSyncDispDlg::CheckStationNum(CString username)
{
	//return 0	do nothing
	//return 1	PDA overwrite PC
	//return 2	PC overwrite PDA
	//return 3	stop sync


	//first char of station_num represent station 1
	//second char of the station_num represent station 2

	CDaoRecordset* pRs;
	CString szSql;
	CString pda_station_num;
	CString pc_station_num;
	CString new_station_num;
	
	pda_station_num = SyncGetStationNo();
	
	pRs = new CDaoRecordset(dbProfile);
	szSql = "Select * from userdata where username = '";
	szSql += username;
	szSql += "'";

	pRs->Open(dbOpenDynaset,szSql,0);

	if(!pRs->IsBOF())
	{
		pc_station_num = (CString)pRs->GetFieldValue("StationNo").pbVal;
	}
	else
	{
		pc_station_num = "";
	}
	
	if(pda_station_num == "" && pc_station_num == "")
	{
		//both side is hard reset
		SyncSetStationNo(username,"11");
		station_num = 1;
		return 0;
	}
	else if(pda_station_num == "" && pc_station_num != "")
	{
		//pda is hard reset
		SyncSetStationNo(username,pc_station_num);
		return 2;
	}
	else if(pda_station_num != "" && pc_station_num == "")
	{
		//only one station set, this pc is the station 2
		if(pda_station_num == "11")
		{
			SyncSetStationNo(username,"12");
			station_num = 2;
			ResetStationRecordID(2);
			return 1;
		}
		
		//pc is a new station
		CStationDlg dlg;
		dlg.m_station = 0;
		if(dlg.DoModal() == IDCANCEL)
			return 3;
		if(dlg.m_station == 0)
		{
			//set the current pc to station 1
			new_station_num = (CString)char(pda_station_num[0] + 1);
			new_station_num += pda_station_num[1];
			SyncSetStationNo(username,new_station_num);
			station_num = 1;
			return 1;
		}
		else
		{
			//set the current pc to station 2
			new_station_num = pda_station_num[0];
			new_station_num += (CString)char(pda_station_num[1] + 1);
			SyncSetStationNo(username,new_station_num);
			station_num = 2;
			ResetStationRecordID(2);
			return 1;
		}

	}
	else //if(station_num != "" && pc_station_num != "")
	{
		if(pda_station_num[0] == pc_station_num[0] || pda_station_num[1] == pc_station_num[1])
		{
			//update the station no in pda to the greater one
			if(pda_station_num[0] < pc_station_num[0] || pda_station_num[1] < pc_station_num[1])
				SyncSetStationNo(username,pc_station_num);

			//one of the station is matched,continue
			return 0;
		}
		else
		{
			//pc is a new station
			CStationDlg dlg;
			dlg.m_station = 0;
			if(dlg.DoModal() == IDCANCEL)
				return 3;
			if(dlg.m_station == 0)
			{
				//set the current pc to station 1
				new_station_num = (CString)char(pda_station_num[0] + 1);
				new_station_num += pda_station_num[1];
				SyncSetStationNo(username,new_station_num);
				station_num = 1;
				return 1;
			}
			else
			{
				//set the current pc to station 2
				new_station_num = pda_station_num[0];
				new_station_num += (CString)char(pda_station_num[1] + 1);
				SyncSetStationNo(username,new_station_num);
				station_num = 2;
				ResetStationRecordID(2);
				return 1;
			}
		}
	}

	return 0;
}

void CSyncDispDlg::ResetStationRecordID(int station)
{
	
	CString szSql;

	if(station == 1)
		return;

	szSql = "Update ApplicationDB Set lastpc = 1610612735, newpc = 1610612735 where databaseid >= 0";
	dbAppDB->Execute(szSql,0);

	szSql = "Update ApplicationDB Set EmailNewPCDraft = 1610612735, EmailLastSyncDraft = 1610612735";
	szSql += " ,EmailNewPCSent = 1610612735 where databasename = 'Scheduler'";
	dbAppDB->Execute(szSql,0);

}

//REG
int CSyncDispDlg::InstallDB()
{
	char root_path[120];
	CString sub_path;
	CString hdb_file_name;
	WIN32_FIND_DATA FileData;
	HANDLE hSearch;
	
	SetStatusMessage("Install Databases...");
	DoEvents();
	
	SyncIdleMode();
	CHKTERM;
	SyncDBInstMode();
	CHKTERM;
	
	//grab all .hdb files in (CString) root_path + (CString)"\\" + (CString) sub_path
	sub_path = szUserPath + "Acc\\";

	_getdcwd (_getdrive(), root_path, 100);

	//for each file
	hSearch = ::FindFirstFile(root_path + (CString)"\\" + sub_path + (CString)"\\*.hdb", &FileData);
	if (hSearch != INVALID_HANDLE_VALUE)
	{
		while (1)
		{
			hdb_file_name = (CString) root_path + (CString)"\\" + (CString) sub_path + FileData.cFileName;
			if(InstallDBFile(hdb_file_name))
			{
			   SyncIdleMode();
			   ::FindClose (hSearch);
			   return 1;
			}
			if (!::FindNextFile (hSearch, &FileData))
				break;
		}
		::FindClose (hSearch);
	}
	return 0;
terminate:
	return 1;
}

int CSyncDispDlg::InstallDBFile(CString filename)
{

	CFile db_file;
	CFileException e;
	CString db_name;
	CString db_owner;
	USHORT version;
	CString data;
	int return_code;

	if(!db_file.Open(filename, CFile::modeReadWrite|CFile::shareDenyWrite, &e))
	{
		WriteLog("Cannot open database file [" + filename + "]");
		db_file.Close();
		return 0;
	}

	HDBHeader HDBHeaderBuf;

	//read DB File Header
	db_file.Read((void*)&HDBHeaderBuf,sizeof(HDBHeader));
	//get db_name, version, owner

	db_name = HDBHeaderBuf.name;
	db_owner = HDBHeaderBuf.owner;
	version = HDBHeaderBuf.version;

	SetStatusMessage("Adding " + (CString) db_name + " database ...");
	DoEvents();

	SyncIdleMode();
	SyncDBInstMode();
	
	data.Empty();
	//make sure that there is a name and 
	if(db_name.GetLength() == 0)
	{
		WriteLog("Create database "  + (CString)db_name + " fail - No database name");
		db_file.Close();
		return 1;
	}

	return_code = SyncDBNew(db_name, version, db_owner);
	switch(return_code)
	{
		case 0:
			WriteLog("Create database "  + (CString)db_name + " succeeded");
			break;
		case ERR_DB_EXIST:
			WriteLog("Create database "  + (CString)db_name + " fail - Database already in PDA");
			break;
		case ERR_PDA_NOT_ENOUGH_SPACE:
			WriteLog("Create database "  + (CString)db_name + " fail - Not enough space in PDA");
			break;
		default:
			WriteLog("Create database "  + (CString)db_name + " fail");
			break;
	}
	
	if(return_code)
	{
		db_file.Close();
		DeleteFile(filename.Left(filename.GetLength() - 4) + ".hdx");
		db_file.Rename(filename, filename.Left(filename.GetLength() - 4) + ".hdx");
		return return_code;
	}

	//switch to database enquiry mode
	SyncIdleMode();
	SyncDBEnqMode();
	
	DatabaseID dbid;
	//database info query for header info
	return_code = SyncDBInfo(db_name,&dbid,&data);
	if(return_code)
	{
		//delete db from device, failed
		WriteLog("Install database "  + (CString)db_name + " fail - Error updating DB info");
	}

//REG	08/21/00
	SyncIdleMode();
	SyncDBInstMode();
//REG	08/21/00

	//now install all records, fields, etc....
	DBHeader DBHeaderBuf;
	memcpy(&DBHeaderBuf,data,sizeof(DBHeader));
	data.Empty();
	//copy over header info (don't need rest of it as we already know name and owner)
	
	//get record listexi
	HDBRecordHeader *HDBRecordList = (HDBRecordHeader*)malloc(sizeof(HDBRecordHeader) * HDBHeaderBuf.record_count);	
	db_file.Read((void*)HDBRecordList,sizeof(HDBRecordHeader)*HDBHeaderBuf.record_count);
	
	//add records to DB
	UINT byte_count;
	BYTE* record_buffer;
	BYTE* buf_ptr;
	int i,j,k;
	UINT* size_array;
	UINT  len,decoded_len,decoded_byte_count;
	RecordHeader RecordHeaderBuf;

	for(i=0;i<HDBHeaderBuf.record_count;i++)
	{
		RecordHeaderBuf.attribute = HDBRecordList[i].attribute;
		RecordHeaderBuf.cat = HDBRecordList[i].category;
		RecordHeaderBuf.modi_date = HDBRecordList[i].modify_date;
		RecordHeaderBuf.rec_id = HDBRecordList[i].id;
		RecordHeaderBuf.total_field = HDBRecordList[i].total_field;

		db_file.Seek(HDBRecordList[i].offset,CFile::begin);
		RecordHeaderBuf.size = (i==(HDBHeaderBuf.record_count - 1)) ? db_file.GetLength() - HDBRecordList[i].offset : HDBRecordList[i+1].offset-HDBRecordList[i].offset;
		record_buffer = (BYTE*)malloc(RecordHeaderBuf.size);
		db_file.Read(record_buffer,RecordHeaderBuf.size);

		size_array = (UINT*)malloc(sizeof(UINT)*HDBRecordList[i].total_field);
		buf_ptr = record_buffer;
		decoded_len = 0;
		for(j=0;j<HDBRecordList[j].total_field;j++)
		{
			buf_ptr += decoded_len;
			DeFieldSize(buf_ptr,decoded_len,decoded_byte_count);
			//buf_ptr now points to beginning of field data
			size_array[j] = decoded_len;
			//buf_ptr points to start of next field (data & len)
		}
		
		//append record data to RecordData
		data.GetBufferSetLength(RecordHeaderBuf.size);
		buf_ptr = (BYTE*)data.GetBufferSetLength(RecordHeaderBuf.size);
		for(j=0;j<RecordHeaderBuf.size;j++)
			buf_ptr[j] = record_buffer[j];

		//pad
		if(RecordHeaderBuf.size%4)
			RecordHeaderBuf.size += 4 - (RecordHeaderBuf.size % 4);

		if(HDBRecordList[i].id == 0)
		{
			//add a new record and use its id (copy back to .hdb)
			//update rec
			return_code = SyncRecNew(DBHeaderBuf.dbid,&RecordHeaderBuf,&data);
		}
		else
			return_code = SyncRecAdd(DBHeaderBuf.dbid,HDBRecordList[i].id,RecordHeaderBuf.total_field,size_array,&RecordHeaderBuf,&data);

		if(return_code)
		{
//REG	08/21/00
//			would like to delete file but func does not work
//			SyncDBDel(DBHeaderBuf.dbid);
			free(record_buffer);
			free(size_array);
			WriteLog("Error adding record");
			db_file.Close();
			DeleteFile(filename.Left(filename.GetLength() - 4) + ".hdx");
			db_file.Rename(filename, filename.Left(filename.GetLength() - 4) + ".hdx");
//REG	08/21/00
			return 1;
		}

		free(record_buffer);
		free(size_array);
		data.Empty();
	}

	//switch to database enquiry mode
	SyncIdleMode();
	SyncDBEnqMode();
	
//	DatabaseID dbid;
//	//database info query for header info
//	return_code = SyncDBInfo(db_name,&dbid,&data);
//	if(return_code)
//	{
//		//delete db from device, failed
//		WriteLog("Install database "  + (CString)db_name + " fail - Error updating DB info");
//	}
//
//	memcpy(&DBHeaderBuf,data,sizeof(DBHeader));
//	data.Empty();

	//update dbid
	HDBHeaderBuf.appid = DBHeaderBuf.owner;
	HDBHeaderBuf.backup_date = DBHeaderBuf.backup_date;
	HDBHeaderBuf.creation_date = DBHeaderBuf.create_date;
	HDBHeaderBuf.id = DBHeaderBuf.dbid;
	HDBHeaderBuf.version = DBHeaderBuf.version;

	int total_rec;
	RecStruct* record;

	//record info query for record info
	SyncRecInfoReq(dbid, &total_rec, &record);
	for(i=0;i<total_rec;i++)
	{
		HDBRecordList[i].attribute = record[i].rec_header.attribute;
		HDBRecordList[i].category = record[i].rec_header.cat;
		HDBRecordList[i].modify_date = record[i].rec_header.modi_date;
		HDBRecordList[i].id = record[i].rec_header.rec_id;
		HDBRecordList[i].total_field = record[i].rec_header.total_field;
	}

	//write data back to file		
	db_file.SeekToBegin();
	db_file.Write(&HDBHeaderBuf,sizeof(HDBHeaderBuf));
	db_file.Write((void*)HDBRecordList,sizeof(HDBRecordHeader)*HDBHeaderBuf.record_count);
	db_file.Close();
	DeleteFile(filename.Left(filename.GetLength() - 4) + ".hdo");
	db_file.Rename(filename, filename.Left(filename.GetLength() - 4) + ".hdo");
	
	WriteLog("Install database " + (CString)db_name + " OK ");

	SetStatusMessage("Adding database " + (CString) db_name + " complete");
	DoEvents();

	return return_code;
}
//REG

//DEL BOOL CSyncDispDlg::MyTaskBarAddIcon(HWND hwnd, UINT uID, HICON hicon, LPSTR lpszTip)
//DEL {
//DEL // MyTaskBarAddIcon - adds an icon to the taskbar status area. 
//DEL // Returns TRUE if successful, or FALSE otherwise. 
//DEL // hwnd - handle to the window to receive callback messages. 
//DEL // uID - identifier of the icon. 
//DEL // hicon - handle to the icon to add. 
//DEL // lpszTip - tooltip text. 
//DEL     BOOL res; 
//DEL     NOTIFYICONDATA tnid; 
//DEL  
//DEL     tnid.cbSize = sizeof(NOTIFYICONDATA); 
//DEL     tnid.hWnd = hwnd; 
//DEL     tnid.uID = uID; 
//DEL     tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP; 
//DEL     tnid.uCallbackMessage = MYWM_NOTIFYICON; 
//DEL     tnid.hIcon = hicon; 
//DEL     if (lpszTip) 
//DEL         lstrcpyn(tnid.szTip, lpszTip, sizeof(tnid.szTip)); 
//DEL     else 
//DEL         tnid.szTip[0] = '\0'; 
//DEL  
//DEL     res = Shell_NotifyIcon(NIM_ADD, &tnid); 
//DEL  
//DEL     if (hicon) 
//DEL         DestroyIcon(hicon); 
//DEL  
//DEL     return res; 
//DEL 
//DEL }

//DEL BOOL CSyncDispDlg::MyTaskBarDeleteIcon(HWND hwnd, UINT uID)
//DEL {
//DEL // MyTaskBarDeleteIcon - deletes an icon from the taskbar 
//DEL //     status area. 
//DEL // Returns TRUE if successful, or FALSE otherwise. 
//DEL // hwnd - handle to the window that added the icon. 
//DEL // uID - identifier of the icon to delete. 
//DEL     BOOL res; 
//DEL     NOTIFYICONDATA tnid; 
//DEL  
//DEL     tnid.cbSize = sizeof(NOTIFYICONDATA); 
//DEL     tnid.hWnd = hwnd; 
//DEL     tnid.uID = uID; 
//DEL          
//DEL     res = Shell_NotifyIcon(NIM_DELETE, &tnid); 
//DEL     return res;
//DEL }

// On_MYWM_NOTIFYICON - processes callback messages for taskbar icons. 
// wParam - first message parameter of the callback message. 
// lParam - second message parameter of the callback message. 
//DEL void CSyncDispDlg::On_MYWM_NOTIFYICON(WPARAM wParam, LPARAM lParam) 
//DEL { 
//DEL     UINT uID; 
//DEL     UINT uMouseMsg; 
//DEL  
//DEL     uID = (UINT) wParam; 
//DEL     uMouseMsg = (UINT) lParam; 
//DEL  
//DEL     if (uMouseMsg == WM_LBUTTONDOWN) {
//DEL //        switch (uID) { 
//DEL //            case IDR_MAINFRAME: 
//DEL  
//DEL //                break; 
//DEL   
//DEL //            default: 
//DEL //                break; 
//DEL //        } 
//DEL      } 
//DEL      return; 
//DEL } 

