#include "stdafx.h"
#include "syncfx.h"
#include "PortCtrl.h"
#include "SyncDB.h"
#include "resource.h"
#include "SyncDispDlg.h"
#include <winbase.h>
#include "voice.h"
#include "sysetup.h"
#include "All_DB.h"

void DoAllEvents();
extern CSyncDispDlg *m_DispDlg;
extern BOOL bRun;
extern  BOOL shown_timeout;
extern BOOL bStop;
extern BOOL TermFromNoSize;

#define  TRAN_PACKET_SIZE	2048


//////////////////////////////////////////////////////////////////////////
//				Sync Request
//////////////////////////////////////////////////////////////////////////
/****************************************************
		PDA Sync Req
		PDA send ST_FLG
		PC  send ST_ACK/ST_NAK
*****************************************************/
int SyncReq()
{
	 pCommCtrl->Send(ST_FLG);  /* should always success */
	 return 0;
}


int SyncCrashEnq()
{
	char index;
	pCommCtrl->Send(CRASH_ENQ);
	if(!ComWaitFor(CRASH_YES, CRASH_NO, &index, TRUE))
		return 3;
	return index;
}


int SyncSetAnnAlm()
{
	char index;
	pCommCtrl->Send(SET_ANN_ALARM);
	if(!ComWaitFor(ACK, NAK, &index, TRUE))
		return 3;
	return index;
}


int SyncSetSchAlm()
{
	char index;
	pCommCtrl->Send(SET_SCH_ALARM);
	if(!ComWaitFor(ACK, NAK, &index, TRUE))
		return 3;
	return index;
}

int SyncSetToDoAlm()
{
	char index;
	pCommCtrl->Send(SET_TODO_ALARM);
	if(!ComWaitFor(ACK, NAK, &index, TRUE))
		return 3;
	return index;
}



int SyncClearPdaCrash()
{
	pCommCtrl->Send(CLEAR_CRASH);
	if(!ComWaitFor(ACK, TRUE))
		return 1;
	return 0;
}


/****************************************************
		PC req PDA for user info
		PC send USER_REQ
		PDA send ACK + Len + Last Name + 0x00 First Name + 0x00 + CS
*****************************************************/
int SyncUserInfoReq(CString *lastname, CString *firstname)
{
	int retry = CSERR_RETRY;
	CString data;
	CString chksum;
	int i = 0, length;
	char *ptr;

	while(retry--)
	{
		m_ComBuffer.Empty();
		Sleep(50);
		pCommCtrl->Send(USER_REQ);
		if(!ComWaitFor(ACK, TRUE))   /* wait for ACK, then clear the buffer up to ACK */
		{
			if(!retry)
				return 2;		   /* time out */
			else
				continue;
		}
		if(!ComWaitForLength(4))  /* length */
			return 2;		// time out
		ptr = (char*) &length;

		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if(length > 220)
		{
			TRACE("\nUserInfoReq: Length too large ");
			return 2;
		}


		if(!ComWaitForLength(4+length))  /* length + data + cs*/
		{
			TRACE("\n %d ",m_ComBuffer.GetLength());
			return 2;
		}

		ComRemoveBuffer(4);   // remove the length
		i = m_ComBuffer.Find((char)0x00);
		if(i == -1)  // not found
			(*lastname) = '\0';
		else
			(*lastname) = m_ComBuffer.Left(i+1);

		ComRemoveBuffer(lastname->GetLength());

		i = m_ComBuffer.Find((char)0x00);
		if(i == -1)  // not found
			(*firstname) = '\0';
		else
			(*firstname) = m_ComBuffer.Left(i+1);

		ComRemoveBuffer(firstname->GetLength());

		i = lastname->GetLength();  // cut out any 0x00
		if(i>1)
		{
			if(lastname->GetAt(i-1) == 0x00)
				*lastname = lastname->Left(i-1);
		}
		else if(i)   // ==1
		{
			if (lastname->GetAt(0) == 0x00)
				lastname->Empty();
		}

		ComRemoveBuffer(lastname->GetLength() + 12);

		i = firstname->GetLength();  // cut out any 0x00
		if(i>1)
		{
			if(firstname->GetAt(i-1) == 0x00)
				*firstname = firstname->Left(i-1);
		}
		else if(i)   // ==1
		{
			if (firstname->GetAt(0) == 0x00)
				firstname->Empty();
		}

		break;
	}
	return 0;
}


/****************************************************
		PC req PDA for VTOS version
		This API only avail in VTOS 1.1.07 and later,
		otherwise, PDA will not response to this request
		and PC will timeout
		PC send OS_VER_REQ
		PDA send OS_VER_ACK + Len + VTOS version + 0x00 + CS
*****************************************************/
CString SyncGetVTOSVer()
{

		CString result;
		char *ptr;
		int length;
		int i;

		result.Empty();

		m_ComBuffer.Empty();

		pCommCtrl->Send(OS_VER_REQ);

		/* VTOS prior to 1.1.07 cannot response to this request and PC will time out */
		shown_timeout = FALSE;
		if(!ComWaitFor(OS_VER_ACK, TRUE))   /* wait for ACK, then clear the buffer up to ACK */
		{
			/* 2 reasons for this happen:
			   1: time out
			   2: VTOS is prior to 1.1.07
			   Assume incorrect VTOS version for this case
			*/			    
				shown_timeout = TRUE;
				return result;		   /* time out */
		}

		shown_timeout = TRUE;

		if(!ComWaitForLength(4))  /* length */
			return result;		// time out

		ptr = (char*) &length;

		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if(length > 220)
		{
			TRACE("\nGetOSVer: Length too large ");
			return result;
		}


		if(!ComWaitForLength(4+length))  /* length + data + cs*/
		{
			return result;
		}

		ComRemoveBuffer(4);   // remove the length
		i = m_ComBuffer.Find((char)0x00);
		if(i == -1)  // not found
		{
			result.Empty();
			return result;
		}

		if(m_ComBuffer.GetLength() > 2)  /* the last 2 byte is CS */
			result = m_ComBuffer.Left(m_ComBuffer.GetLength() - 2);
		else
			result = m_ComBuffer.data;

		return result;

}


int SyncShowRdy()
{
	pCommCtrl->Send(SHOW_STATE_RDY);
	if(!ComWaitFor(ACK, TRUE))
		return 1;
	return 0;
}

int SyncShow1()
{
	pCommCtrl->Send(SHOW_STATE_1);
	if(!ComWaitFor(ACK, TRUE))
		return 1;
	return 0;
}

int SyncShow2()
{
	pCommCtrl->Send(SHOW_STATE_2);
	if(!ComWaitFor(ACK, TRUE))
		return 1;
	return 0;
}

int SyncShow3()
{
	pCommCtrl->Send(SHOW_STATE_3);
	if(!ComWaitFor(ACK, TRUE))
		return 1;
	return 0;
}



/****************************************************
		User inform. update
*****************************************************/
int SyncUserUpdate(CString data)
{
	int retry = CSERR_RETRY;
	int length;
	char *ptr;
	short CS;
	char index;

while (retry--)
{
	m_ComBuffer.Empty();
	pCommCtrl->Send(USERWR_REQ);
	if (!ComWaitFor(USER_ACK, TRUE))
		return 1;		// time out

	pCommCtrl->Send(ACK);
	length = data.GetLength() + 2;  // 2-> CS
	ptr = (char*)&length;
	pCommCtrl->Send(ptr[0]);             // send length
	pCommCtrl->Send(ptr[1]);
	pCommCtrl->Send(ptr[2]);
	pCommCtrl->Send(ptr[3]);

	CS = 0;

	for(int i=0; i<data.GetLength(); i++)  // send data
	{
		CS ^= data[i];
		pCommCtrl->Send(data[i]);
	}

	ptr = (char*)&CS;
	pCommCtrl->Send(ptr[0]);
	pCommCtrl->Send(ptr[1]);

	if(!ComWaitFor(ACK, NAK, &index, TRUE))
			return 2;		// time out

	if(index == NAK)
	{
		if(!retry)
			return 1;
		else
			continue;
	}
	else
 		break;
}
return 0;
}


/****************************************************
		PDA system clock query
*****************************************************/
int SyncClockQuery(RTM *clk)
{
	int retry = CSERR_RETRY;
	char *ptr;
	
	while(retry--)
	{
		pCommCtrl->Send(CLK_REQ);
		if(!ComWaitFor(CLK_ACK,TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}
		if(!ComWaitForLength(6))
			return 2;		// time out

		ptr = (char*) clk;

		for(int i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		// ignore the check sum since packet too small
		ComRemoveBuffer(6);

		break;
	}
	return 0;
}


/****************************************************
		PDA system clock set
*****************************************************/
int SyncClockSet(RTM clk)
{
	int retry = CSERR_RETRY;
	char *ptr;
	short CS;
	char index;
	int i;

	while(retry--)
	{
		pCommCtrl->Send(CLKSET_REQ);

		if(!ComWaitFor(CLKSET_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}
		ptr = (char*) &clk;
		CS = 0;

		for(i=0;i<sizeof(RTM);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, NAK, &index, TRUE))
				return 2;	// time out

		if(index == NAK)
		{
			if(!retry)
				return 2;	// time out
			else
				continue;
		}

		break;
	}
	return 0;
}



int SyncSetDST()
{
	int total_rec = 0;
	DatabaseID dbid;
	RecStruct *record = NULL;
	CString dbheader;
	CString rec_content;
	unsigned int size_array[3];
	CTime time1;
	CTime time3;
	time3 = time1.GetCurrentTime ();
	CTime time2 (time3.GetYear (), time3.GetMonth (), time3.GetDay (), 10, 0, 0, 0);

	SyncIdleMode(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;

	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of sysetup database in PDA */
		return 1;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))  /* read record header */
		return 1;		// error
	CHKTERM;
	
	SyncReadRec(dbid, SYS_CLOCK, (char*) &record[0].rec_header, &rec_content);
	CHKTERM;
	
	/* rec_content : byte 3 : auto off time
						  4 : home country
					...   6 : home DST
	*/
	
	
	/* To DO: find an algorithm to check if DST is active in Windows or not
	
	if DST set in win,
	add code:
	           rec_content[6] = 1;  // set DST
	else
	add code:
	           rec_content[6] = 0;  // reset DST
	           
    */
    
    // Note: I assume DST on 
	
	if (time2.GetHour () == 11)
	    rec_content.SetAt (6, 1);
	else
		rec_content.SetAt (6, 0);
   
    size_array[0] = 1; // field 1 (type) size = 1
    size_array[1] = sizeof(ClockSettings);  // clocksettings defined in sysetup.h
    
   /* or maybe
	size_array[1] = 5;
	I am not sure
   */
    
    SyncIdleMode(); CHKTERM;
    SyncDBUpMode(); CHKTERM;
    
    PDADeleteRecord(dbid, SYS_CLOCK); /* del old rec in PDA */
	SyncRecAdd(dbid, SYS_CLOCK, 2, size_array, &record[0].rec_header, &rec_content);   /* add the new record */
	
	SyncIdleMode();
	
	if(record)
	  free(record);
	return 0;
terminate:

	if(record)
	   free(record);
	return 1;
}

/****************************************************
		PC req PDA goto IDLE mode
		PC send IDLE_MODE_REQ
		PDA send IDLE_MODE_ACK
*****************************************************/
int SyncIdleMode()
{
	pCommCtrl->Send(IDLE_MODE_REQ);
	if(!ComWaitFor(IDLE_MODE_ACK, TRUE))
		return 1;	// fail
	else
		return 0;  // OK
}


//////////////////////////////////////////////////////////////////////
//			Message log in PDA
//////////////////////////////////////////////////////////////////////
/****************************************************
			Message log mode
*****************************************************/
int SyncMsgLogMode()
{
	pCommCtrl->Send(MSG_LOG_REQ);
	if(!ComWaitFor(MSG_LOG_ACK, TRUE))
	{
		TRACE("\nMSG_LOG_ACK: Time out");
		return 1;
	}
	else
		return 0;
}


int SyncLogMsg(char id)
{
//	if(SyncMsgLogMode())
//		return 1;
	pCommCtrl->Send(id);
	if(!ComWaitFor(ACK, TRUE))
	{
		return 1;
	}
	return 0;
}


/******************************************************
			Send message
*******************************************************/
int SyncSetLogMsg(char type, char header, CString data)
{
	int retry = CSERR_RETRY;
	int length;
	char *ptr;
	short CS;
	int i;

	if((type != MSG_LOGONLY) && (type != MSG_SCRONLY) &&
	   (type != MSG_LOGSCR))
	   {
		   TRACE("\nillegal type in msg log");
	       return 1;
	}
	pCommCtrl->Send(type);

	if(!ComWaitFor(MSG_ACK, TRUE))
	{
			return 2;  // time out
	}

	pCommCtrl->Send(MSG_SEQ);
	length = 1 + data.GetLength() + 2;  /* header + data length + CS */
	ptr = (char*) &length;

	for(i=0;i<4;i++)
		pCommCtrl->Send(ptr[i]);

	CS = 0;

	CS ^= header;

	pCommCtrl->Send(header);

	for(i=0;i<data.GetLength();i++)
	{
		CS ^= data[i];
		pCommCtrl->Send(data[i]);
	}

	ptr = (char*) &CS;
	pCommCtrl->Send(ptr[0]);
	pCommCtrl->Send(ptr[1]);

	return 0;

}


//////////////////////////////////////////////////////////////////////
//			Database Enquiry
//////////////////////////////////////////////////////////////////////
/****************************************************
			General information enquiry
*****************************************************/
int SyncDBEnqMode()
{
	pCommCtrl->Send(DBENQ_MODE_REQ);
	if(!ComWaitFor(DBENQ_MODE_ACK, TRUE))
	{
		TRACE("\nDBENQ_MODE_ACK: Time out");
		return 1;
	}
	else
		return 0;
}

int SyncDBGenInfo(int *total_db, CString *name)
{
	int retry = CSERR_RETRY;
	int length;
	char *ptr;
	int i;
	
	while(retry--)
	{
		pCommCtrl->Send(GENINF_REQ);
		if(!ComWaitFor(GENINF_ACK, TRUE))
		{
			if(!retry)
				return 2;  // time out
			else
				continue;
		}

		if(!ComWaitForLength(4))	// packet length
			return 2;		// time out

		ptr = (char*) &length;

		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		ComRemoveBuffer(4);		// remove packet len

		if(!ComWaitForLength(length))
			return 2;		// time out

	    if(length >= 6)		// min len is 6  -> 4(Number of DB) + CS(2 byte)
		{
			ptr = (char*) total_db;
			
			for(i=0;i<4;i++)		// total db
				ptr[i] = m_ComBuffer[i];

			for(i=4;i<m_ComBuffer.GetLength()-2;i++)	// copy the name
				(*name) += m_ComBuffer[i];
			// ignore CS
			ComRemoveBuffer(length);
			return 0;
		}
	
		ComRemoveBuffer(length);
		break;
	}
	return 1;		// error
}
	
/****************************************************
			Database Inform Enq
*****************************************************/
int SyncDBInfo(CString db_name, DatabaseID *dbid,  CString *db_header)
{
	int retry = CSERR_RETRY;
	int i=0;
	char index;
	short CS;
	char *ptr;
	int len;

	while(retry--)
	{
		pCommCtrl->Send(DBINFO_REQ);
		if(!ComWaitFor(DBINFO_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		pCommCtrl->Send(DBID_REQ);
		CS = 0;
		ptr = (char*) &CS;
		for(i=0;i< db_name.GetLength(); i++)
		{
			CS ^= db_name[i];
			pCommCtrl->Send(db_name[i]);
			Sleep(1);
		}

		CS ^= (char) 0;
		pCommCtrl->Send(0);

		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(DBINFO_DATA_ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)
		{
			if(!retry)
				return 1;		// CS error, DB not found ...
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;			// time out;

		ptr = (char*) &len;
		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if(!ComWaitForLength(len+4))
//		if(!ComWaitForLength(len))
			return 2;

		ptr = (char*) dbid;
		for(i=4;i<8;i++)
			ptr[i-4] = m_ComBuffer[i];

		db_header->Empty();
		for(i=8;i<len - 2;i++)
			(*db_header) += m_ComBuffer[i];

		//skip CS
		ComRemoveBuffer(len+4);

		Sleep(10);

//		pCommCtrl->Send(ACK);

//		if(!ComWaitFor(ACK, TRUE))
//			return 2;		// time out

		break;
	}
	return 0;
}




/****************************************************
			Read record inform
*****************************************************/
int SyncRecInfoReq(DatabaseID dbid, int *total_rec, RecStruct **record)
{
	char *ptr;
	int i;
	char index;
	int retry = CSERR_RETRY;
	short CS;

	*total_rec = 0;

	while(retry--)
	{
		pCommCtrl->Send(RECINFO_REQ);
		if(!ComWaitFor(RECINFO_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &dbid;
		CS = 0;
		pCommCtrl->Send(RECINFO_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}
		ptr = (char*)&CS;

		pCommCtrl->Send(ptr[0]);

		ComRemoveBuffer(100);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(RECINFO_DATA_ACK, NAK, &index, TRUE))
			return 2;		// time out

//		for(i=0;i<m_ComBuffer.GetLength();i++)
//			TRACE(" %d ", m_ComBuffer[i]);

		if(index==NAK)
		{
			if(!retry)
				return 1;	// CS err, inv id...
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;		// time out;

		ptr = (char*) total_rec;

		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if((*total_rec < 0) || (*total_rec > 5000))  // illegal value
		{
			Sleep(500);		// suspend 1 sec
			TRACE("\nError");
			m_ComBuffer.Empty();		// empty the buffer;
			return 1;			// error
		}

		if(!ComWaitForLength( 4 + (*total_rec) * (RECHEADER_SIZE)+ 2))
			return 2;		// time out;

		if(*total_rec)
		{
			*record = (RecStruct*) malloc( sizeof(RecStruct) * (*total_rec));
			if(*record == NULL)
				return 1;

			for(i=4;i< ((*total_rec) * (RECHEADER_SIZE) + 4); i++)
				((char*)(*record))[i-4] = m_ComBuffer[i];
		}

		// skip CS
		ComRemoveBuffer(4 + (*total_rec) * (RECHEADER_SIZE)+ 2);

		break;
	}
	return 0;
}


int SyncSetMaxRecordID(DatabaseID dbid, RecordID recid)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	short CS;
	int i;

	while(retry--)
	{
		pCommCtrl->Send(MAX_RECID_REQ);
		if(!ComWaitFor(MAX_RECID_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

	//	pCommCtrl->Send(RECDATA_SEQ);
		ptr = (char*) &dbid;

		CS = 0;
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

//xxx		Sleep(5);

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
//xxx			Sleep(2);
			pCommCtrl->Send(ptr[i]);
		}
 
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_DATA,REC_NAK,  &index, TRUE))
				return 2;		// time out
	}

	return 0;
}


int SyncReasignRecordID(DatabaseID dbid, unsigned int offset, RecordID exclude_recid)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	short CS;
	int i;

	while(retry--)
	{
		pCommCtrl->Send(REASIGN_RECID_REQ);
		if(!ComWaitFor(REASIGN_RECID_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

	//	pCommCtrl->Send(RECDATA_SEQ);
		ptr = (char*) &dbid;

		CS = 0;
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

//xxx		Sleep(5);

		ptr = (char*) &offset;
		for(i=0;i<sizeof(unsigned int);i++)
		{
			CS ^= ptr[i];
//xxx			Sleep(2);
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &exclude_recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
//xxx			Sleep(2);
			pCommCtrl->Send(ptr[i]);
		}
		
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

//		Sleep(500);

//		if(!ComWaitFor(REC_DATA,REC_NAK,  &index, TRUE))
//				return 2;		// time out
		int retry_t = 3;
		shown_timeout = FALSE;
		do
		{
			if(!ComWaitFor(REC_ACK, REC_DATA, REC_NAK,REC_NAK, &index, TRUE))
			{
				if(retry_t--)					
				{
				   shown_timeout = TRUE;
				   return 2;		// time out
				}
				else
				{
					pdatimeout = FALSE;
					bRun = TRUE;
				}
			}
		}
		while((index != REC_DATA) && (index != REC_NAK)) ;
	}

	shown_timeout = TRUE;

	return 0;
}


// reasign the scheduler's appt number in PDA 
int SyncSetPDASchApptNum(unsigned int offset)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	short CS;
	int i;

	while(retry--)
	{
		pCommCtrl->Send(SCH_CHG_APPNUM_REQ);
		if(!ComWaitFor(SCH_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &offset;
		for(i=0;i<sizeof(unsigned int);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}
		
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);
	
		index = 0;

		do
		{
			if(!ComWaitFor(REC_ACK, ACK, NAK, NAK, &index, TRUE))
				return 2;		// time out
		}
		while((index != ACK) && (index != NAK)) ;

	}

	return 0;

}


/****************************************************
			Read Sch record inform
			rec header + date (field 0) + modi
*****************************************************/
int SyncSchRecInfoReq(DatabaseID dbid, int *total_rec, SchRecStruct *record)
{
	char *ptr;
	int i;
	char index;
	int retry = CSERR_RETRY;
	short CS;
	RecStruct *rec_data;

	*total_rec = 0;

	while(retry--)
	{
		pCommCtrl->Send(SCHRECINFO_REQ);
		if(!ComWaitFor(SCHRECINFO_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &dbid;
		CS = 0;
		pCommCtrl->Send(RECINFO_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}
		ptr = (char*)&CS;

		pCommCtrl->Send(ptr[0]);

		ComRemoveBuffer(100);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(RECINFO_DATA_ACK, NAK, &index, TRUE))
			return 2;		// time out

//		for(i=0;i<m_ComBuffer.GetLength();i++)
//			TRACE(" %d ", m_ComBuffer[i]);

		if(index==NAK)
		{
			if(!retry)
				return 1;	// CS err, inv id...
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;		// time out;

		ptr = (char*) total_rec;

		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if((*total_rec < 0) || (*total_rec > 5000))  // illegal value
		{
			Sleep(500);		// suspend 1 sec
			TRACE("\nError");
			m_ComBuffer.Empty();		// empty the buffer;
			return 1;			// error
		}

/*  rec header + cs + field 0 data + modi + cs */

		if(*total_rec == 0)
			return 0;

		if(!ComWaitForLength( 4 + (*total_rec) * (RECHEADER_SIZE + 4)+ 4 ))
			return 2;		// time out;

		if(*total_rec)
		{
			//*record = (SchRecStruct*) malloc( sizeof(SchRecStruct) * (*total_rec));
			rec_data = (RecStruct*) malloc( sizeof(RecStruct) * (*total_rec));
			if(record == NULL)
				return 1;

			for(i=4;i< ((*total_rec) * (RECHEADER_SIZE) + 4); i++)
			{
				((char*)(rec_data))[i-4] = m_ComBuffer[i];
			}


			i+=2;

			for(i=0;i<*total_rec;i++)
			{
				record[i].date[0] = m_ComBuffer[4 + (*total_rec) * (RECHEADER_SIZE) + 2 + i*4];
				record[i].date[1] = m_ComBuffer[4 + (*total_rec) * (RECHEADER_SIZE) + 2 + i*4+ 1];
				record[i].date[2] = m_ComBuffer[4 + (*total_rec) * (RECHEADER_SIZE) + 2 + i*4 + 2];
				record[i].modi = m_ComBuffer[4 + (*total_rec) * (RECHEADER_SIZE) + 2 + i*4 + 3];
			}

			for(i=0;i<*total_rec;i++)
				record[i].rec_header = rec_data[i].rec_header ;


	//		free(rec_data);

		}

		// skip CS
		ComRemoveBuffer( 4 + (*total_rec) * (RECHEADER_SIZE + 4)+ 4 );

		break;
	}
	return 0;
}

/****************************************************
			Read Archive record inform
*****************************************************/
int SyncRecArcInfoReq(DatabaseID dbid, int *total_rec, RecStruct **record)
{
	char *ptr;
	int i;
	char index;
	int retry = CSERR_RETRY;
	short CS;

	*total_rec = 0;

	while(retry--)
	{
		pCommCtrl->Send(RECARCINFO_REQ);
		if(!ComWaitFor(RECARCINFO_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &dbid;
		CS = 0;
		pCommCtrl->Send(RECARCINFO_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}
		ptr = (char*)&CS;

		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(RECARCINFO_DATA_ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index==NAK)
		{
			if(!retry)
				return 1;	// CS err, inv id...
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;		// time out;

		ptr = (char*) total_rec;

		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if((*total_rec < 0) || (*total_rec > 5000))  // illegal value
		{
			Sleep(500);		// suspend 1 sec
			TRACE("\nError");
			m_ComBuffer.Empty();		// empty the buffer;
			return 1;			// error
		}

		if(!ComWaitForLength( 4 + (*total_rec) * (RECHEADER_SIZE)+ 2))
			return 2;		// time out;

		if(*total_rec)
		{
			CString a;
//			a.Format("\nTotal Rec = %d ", *total_rec);
//			AfxMessageBox(a);
			*record = (RecStruct*) malloc( sizeof(RecStruct) * (*total_rec));
			if(*record == NULL)
				return 1;

			for(i=4;i< ((*total_rec) * (RECHEADER_SIZE) + 4); i++)
				((char*)(*record))[i-4] = m_ComBuffer[i];
		}

		// skip CS
		ComRemoveBuffer(4 + (*total_rec) * (RECHEADER_SIZE)+ 2);

		break;
	}
	return 0;
}


/****************************************************
			Read modified record
*****************************************************/
int SyncReadRecInfo(DatabaseID dbid, RTM date, int *total_rec, RecStruct **record)
{
	int retry = CSERR_RETRY;
	short CS;
	int i;
	char index;
	char *ptr;
	unsigned int modidate;

	modidate = _rtm2date32(date);
	while(retry--)
	{
		m_ComBuffer.Empty();
		pCommCtrl->Send(MODIREC_REQ);
		if(!ComWaitFor(MODIREC_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &dbid;
		CS = 0;
		pCommCtrl->Send(RECINFO_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &modidate;
		for(i=0;i<4;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(RECINFO_DATA_ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index==NAK)
		{
			if(!retry)
				return 1;	// CS error, id not found
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 1;

		ptr = (char*) total_rec;
		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if((*total_rec < 0) || (*total_rec > 5000))  // illegal value
		{
			Sleep(500);		// suspend 1 sec
			TRACE("\nError");
			m_ComBuffer.Empty();		// empty the buffer;
			return 1;			// error
		}

		if(!ComWaitForLength( 4 + (*total_rec) * (RECHEADER_SIZE)+ 2))
			return 2;		// time out;

		if(*total_rec)
		{
			*record = (RecStruct*) malloc( sizeof(RecStruct) * (*total_rec));
			if(*record == NULL)
				return 1;

			for(i=4;i< ((*total_rec) * (RECHEADER_SIZE) + 4); i++)
				((char*)(*record))[i-4] = m_ComBuffer[i];
		}

		// skip CS
		ComRemoveBuffer(4 + (*total_rec) * (RECHEADER_SIZE)+ 2);

		break;
	}
	return 0;
}


/****************************************************
			Send a specific record
*****************************************************/
int SyncReadRec(DatabaseID dbid, RecordID recid, char *header, CString *content)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	short CS;
	int pack_len, i;
	int wait_remain;
	int this_size;
	BOOL cont;
	CString tmp_buffer;
	int rec_count;
	LPSTR str_buf;

	while(retry--)
	{
		pCommCtrl->Send(RECDATA_REQ);
		if(!ComWaitFor(RECDATA_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		pCommCtrl->Send(RECDATA_SEQ);
		ptr = (char*) &dbid;

		CS = 0;
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

//xxx		Sleep(5);

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
//xxx			Sleep(2);
			pCommCtrl->Send(ptr[i]);
		}
 
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_DATA,REC_NAK,  &index, TRUE))
				return 2;		// time out

		if(index == REC_NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;		// time out

		ptr = (char*) &pack_len;
		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if(pack_len < 0)  // illegal value
		{
			Sleep(500);		// suspend 1 sec
			TRACE("\nError");
			pCommCtrl->Send(REC_NAK);
			m_ComBuffer.Empty();		// empty the buffer
			return 1;			// error
		}

		ComRemoveBuffer(4);
		pCommCtrl->Send(REC_ACK);


		wait_remain = pack_len;
		cont = TRUE;
	
		rec_count = 0;		
//		tmp_ptr = tmp_buffer.GetBufferSetLength(pack_len);
		str_buf = content->GetBufferSetLength((int)pack_len);

		while((wait_remain > 0) && (cont))
		{
			if(wait_remain >= TRAN_PACKET_SIZE)
				this_size = TRAN_PACKET_SIZE;
			else
				this_size = wait_remain;

			shown_timeout = FALSE;
			if(!ComWaitForLength(this_size))
			{
				if(bStop)
				{
					Sleep(500);
					pCommCtrl->Send(NAK);
					m_DispDlg->m_Percent.ShowWindow(SW_HIDE);
					cont = FALSE;  // time out
					m_ComBuffer.Empty();
					break;
				}

				bRun = 1;
				pdatimeout = FALSE;
				m_ComBuffer.Empty();
				pCommCtrl->Send(REC_NAK);
			//	pCommCtrl->Send(REC_NAK);
				shown_timeout = TRUE;
				if(!ComWaitForLength(this_size))
				{
			//		pCommCtrl->Send(NAK);
					pCommCtrl->Send(NAK);
					cont = FALSE;  // time out
					break;
				}
			}


			DoAllEvents();
			if(!bRun)
				cont = FALSE;

			if(rec_count==0)
			{
				for(i=0;i<RECHEADER_SIZE ; i++)
			 	   header[i] = m_ComBuffer[i];

			
				for(i=RECHEADER_SIZE;i<this_size;i++)
					str_buf[i-RECHEADER_SIZE] =  m_ComBuffer[i];

				rec_count = this_size;
			}
			else
			{
			    for(i=0;i<this_size;i++)
				    str_buf[rec_count++ - RECHEADER_SIZE] = m_ComBuffer[i];
			}

			m_ComBuffer.Empty();
			pCommCtrl->Send(ACK);

			wait_remain -= this_size;
		}


//		if(!ComWaitForLength(pack_len))
//			return 2;		// time out;


		TRACE("\nReadRecEnd");

		if((pack_len > 2) && cont)
		{
//			*content = (char*) malloc(*len);
			
//			for(i=4 + RECHEADER_SIZE; i < (int)pack_len +4 ; i++)
//				(*content) +=  m_ComBuffer[i];
#ifdef xxxxxxxxxxxx
			str_buf = content->GetBufferSetLength((int)pack_len - RECHEADER_SIZE);
			for(i= RECHEADER_SIZE; i < (int)pack_len ; i++)
				str_buf[i-RECHEADER_SIZE] =  m_ComBuffer[i];
#endif
		}
		// skip CS
		content->ReleaseBuffer(pack_len - RECHEADER_SIZE );
		ComRemoveBuffer(this_size);
		break;
	}

	if(!bStop)
		shown_timeout = TRUE;
	return 0;
}
		

int SyncReadRecLarge(DatabaseID dbid, RecordID recid, char *header, CString *content)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	short CS;
	int pack_len, i;
	int wait_remain;
	int this_size;
	BOOL cont;
	CString tmp_buffer;
	int rec_count;
	LPSTR str_buf;
	float percent;
	int timeout_num = 0;

	while(retry--)
	{
		pCommCtrl->Send(RECDATA_REQ);
		if(!ComWaitFor(RECDATA_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		pCommCtrl->Send(RECDATA_SEQ);
		ptr = (char*) &dbid;

		CS = 0;
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

//xxx		Sleep(5);

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
//xxx			Sleep(2);
			pCommCtrl->Send(ptr[i]);
		}
 
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_DATA,REC_NAK,  &index, TRUE))
				return 2;		// time out

		if(index == REC_NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;		// time out

		ptr = (char*) &pack_len;
		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if(pack_len < 0)  // illegal value
		{
			Sleep(500);		// suspend 1 sec
			TRACE("\nError");
			pCommCtrl->Send(REC_NAK);
			m_ComBuffer.Empty();		// empty the buffer
			return 1;			// error
		}

if(VoxChkSize(recid, pack_len))
	{

		ComRemoveBuffer(4);
		pCommCtrl->Send(REC_ACK);

		wait_remain = pack_len;
		cont = TRUE;
	
		rec_count = 0;		
//		tmp_ptr = tmp_buffer.GetBufferSetLength(pack_len);
		str_buf = content->GetBufferSetLength((int)pack_len);

		while((wait_remain > 0) && (cont))
		{
			if(wait_remain >= TRAN_PACKET_SIZE)
				this_size = TRAN_PACKET_SIZE;
			else
				this_size = wait_remain;

			TRACE("\nWait for %d ", this_size);

			shown_timeout = FALSE;
			if(!ComWaitForLength(this_size))
			{
				if(bStop)
				{
					Sleep(500);
					pCommCtrl->Send(NAK);
					m_DispDlg->m_Percent.ShowWindow(SW_HIDE);
					cont = FALSE;  // time out
					m_ComBuffer.Empty();
					break;
				}
				bRun = 1;
				pdatimeout = FALSE;
				m_ComBuffer.Empty();
				pCommCtrl->Send(REC_NAK);
			//	pCommCtrl->Send(REC_NAK);
				shown_timeout = TRUE;
				if(!ComWaitForLength(this_size))
				{
			//		pCommCtrl->Send(NAK);
					pCommCtrl->Send(NAK);
					m_DispDlg->m_Percent.ShowWindow(SW_HIDE);
					cont = FALSE;  // time out
					break;
				}
			}


			if(pack_len > 8192)
			{
				m_DispDlg->m_Percent.ShowWindow(SW_SHOW);

				/*
				if(pack_len > 132000)
				{
					percent = ((float)pack_len - (float)wait_remain) / (float)pack_len * 100.0;
					
					sprintf(str, "%f:2%%", percent);
					if(percent >= 10.0)
					{
						str[5] = '%';
						str[6] = 0;
					}
					else
					{
						str[4] = '%';
						str[5] = 0;
					}
					
				}
				else */
				{
			 	   percent = ((float)pack_len - (float)wait_remain) / (float)pack_len * 100.0;
				 //  sprintf(str, "%d%%", (int)percent);
				}
				if(percent < 0)
					percent = 0;
				else if(percent > 100)
					percent = 100;
				m_DispDlg->m_Percent.SetPos((int)percent);
				//m_DispDlg->UpdateData(FALSE);
				//m_DispDlg->Invalidate();
			}

			DoAllEvents();


			if(rec_count==0)
			{
				for(i=0;i<RECHEADER_SIZE ; i++)
			 	   header[i] = m_ComBuffer[i];

			
				for(i=RECHEADER_SIZE;i<this_size;i++)
					str_buf[i-RECHEADER_SIZE] =  m_ComBuffer[i];

				rec_count = this_size;
			}
			else
			{
			    for(i=0;i<this_size;i++)
				    str_buf[rec_count++ - RECHEADER_SIZE] = m_ComBuffer[i];
			}

			m_ComBuffer.Empty();
		//	pCommCtrl->Send(ACK);
			pCommCtrl->Send(ACK);

//			pCommCtrl->Send(APP_ACK);

			TRACE(" Send ack ");

			wait_remain -= this_size;

			TRACE("\nRemain %d ", wait_remain);
		}


//		if(!ComWaitForLength(pack_len))
//			return 2;		// time out;


		TRACE("\nReadRecEnd");

		if((pack_len > 2) && cont)
		{
//			*content = (char*) malloc(*len);
			
//			for(i=4 + RECHEADER_SIZE; i < (int)pack_len +4 ; i++)
//				(*content) +=  m_ComBuffer[i];
#ifdef xxxxxxxxxxxx
			str_buf = content->GetBufferSetLength((int)pack_len - RECHEADER_SIZE);
			for(i= RECHEADER_SIZE; i < (int)pack_len ; i++)
				str_buf[i-RECHEADER_SIZE] =  m_ComBuffer[i];
#endif
		}
		// skip CS
		content->ReleaseBuffer(pack_len - RECHEADER_SIZE );
		ComRemoveBuffer(this_size);
		break;
}
else // chk vox size fail
{
		content->Empty();
		pCommCtrl->Send(REC_NAK);
		m_ComBuffer.Empty();		// empty the buffer
}
}
	if(!bStop)
		shown_timeout = TRUE;
	m_DispDlg->m_Percent.ShowWindow(SW_HIDE);
	m_DispDlg->m_Percent.SetPos(0);
	return 0;
}
		



/****************************************************
			Application Enq
*****************************************************/
int SyncAppEnq(CString name, BOOL *found)
{
	int retry = CSERR_RETRY;
	short CS = 0;
	char *ptr;
	char index;

	while(retry--)
	{
		pCommCtrl->Send(APP_REQ);
		if(!ComWaitFor(APP_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		pCommCtrl->Send(APP_SEQ);
		for(int i=0; i<name.GetLength(); i++)
		{
			CS ^= name[i];
			pCommCtrl->Send(name[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index==NAK)
		{
			if(!retry)
				return 1;  //CS error
			else
				continue;
		}

		break;
	}
	return 0;
}


//////////////////////////////////////////////////////////////////////
//			Database update
//////////////////////////////////////////////////////////////////////
/****************************************************
			Set to update mode
*****************************************************/
int SyncDBUpMode()
{
	pCommCtrl->Send(DBUP_MODE_REQ);
	if(!ComWaitFor(DBUP_MODE_ACK, TRUE))
	{
		TRACE("\nDBUP_MODE_ACK: Time out");
		return 1;
	}
	else
		return 0;
}


/****************************************************
			Delete record
*****************************************************/
int SyncRecDel(DatabaseID dbid, RecordID recid)
{
	int retry = CSERR_RETRY;
	char index;
	char *ptr;
	short CS;
	int i;

	while(retry--)
	{
		pCommCtrl->Send(DELREC_REQ);
		if(!ComWaitFor(DELREC_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &dbid;
		CS = 0;
//		pCommCtrl->Send(DELREC_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

//xxx		Sleep(5);

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(DELREC_ACK, REC_NAK, NAK, NAK, &index, TRUE))
			return 2;		// time out
		
		if(index==NAK)
		{
			if(!retry)
				return 3;	// db miss, CS error
			else
				continue;
		}
		if(index==REC_NAK)
			return 4;

		break;
	}
	return 0;
}

/****************************************************
			Read Field
*****************************************************/
int SyncReadField(DatabaseID dbid, RecordID recid, unsigned short fieldnum, CString *fielddata)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	short CS;
	int pack_len, i;

	while(retry--)
	{
		fielddata->Empty();
		pCommCtrl->Send(RECFIELD_REQ);
		if(!ComWaitFor(RECFIELD_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}

		ptr = (char*) &dbid;

		CS = 0;
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &fieldnum;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor( RECFIELD_DATA,REC_NAK, &index, TRUE))
				return 2;		// time out

		if(index == REC_NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		if(!ComWaitForLength(4))
			return 2;		// time out

		ptr = (char*) &pack_len;
		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[i];

		if(pack_len < 0)  // illegal value
		{
			TRACE("\nError");
			m_ComBuffer.Empty();		// empty the buffer;
			return 1;			// error
		}

		if(!ComWaitForLength(pack_len))
			return 2;		// time out;

//data in buffer:  packlen + field data + cs
		if(pack_len > 2)
		{
			for(i=4; i < (int)pack_len +4 -6; i++)
				(*fielddata) +=  m_ComBuffer[i];
		}

		// skip CS
		ComRemoveBuffer(4 + pack_len);
		break;
	}
	return 0;
}



/****************************************************
			Add Record
*****************************************************/
int SyncRecAdd(DatabaseID dbid, RecordID recid, unsigned short num_field, unsigned int *size_array, RecordHeader* header, CString *data)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	int i;
	short CS;
	int total_size = 0;

    int endata, byte_use;
    unsigned int dum;

	while(retry--)
	{
		pCommCtrl->Send(ADDREC_REQ);
		if(!ComWaitFor(ADDREC_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}
		ptr = (char*)&dbid;
		CS = 0;
		pCommCtrl->Send(ADDREC_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
//			TRACE(" %d ", ptr[i]);
		}
//		Delay();

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
//			Sleep(1);
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &num_field;
		for(i=0;i<2;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}


		if(!ComWaitFor(ACK, NAK, REC_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		ptr = (char*) size_array;
//		Sleep(1);
		for(i=0;i<4*num_field;i++)
		{
			CS ^= ptr[i];
 			pCommCtrl->Send(ptr[i]);
		}
//		Sleep(4);

		for(i=0;i<num_field;i++)
		{
		   total_size += size_array[i];
	       dum = size_array[i];
	       EnFieldSize(endata, dum, byte_use);
		   total_size += byte_use;
		}

//		Sleep(5);
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);


		if(!ComWaitFor(ADDREC_ACK, NAK, REC_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)		// db miss or cs err
		{
			if(!retry)
				return 3;
			else
				continue;
		}

		if(index == REC_NAK)
			return 4;

		if(index == REC_SIZE_NAK)
		{
//			TermFromDesktop = TRUE;
			if(TermFromNoSize == FALSE)
			{
				HWND hWnd = ::FindWindow(NULL,"VSync");
				::SendMessage(hWnd,WM_CLOSE,0,0);
				TermFromNoSize = TRUE;
				CString str;
				str.LoadString(IDS_MEMORYLOW_PDA);
				::AfxMessageBox(str,MB_OK);
			}
			return 5;
		}

		pCommCtrl->Send(ADDREC_ST);

		CS = 0;
		ptr = (char*) header;


		for(i=0;i<RECHEADER_SIZE;i++)
		{
			CS ^= ptr[i];
//			Sleep(1);
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)		// cs error in header
		{
			if(!retry)
				return 3;
			else
				continue;
		}
		TRACE("\nrec_id %d total len: %d", recid, data->GetLength());
		CS = 0;   	 
//		for(i=0;i<data->GetLength();i++)

		for(i=0;i<total_size;i++)
		{
			pCommCtrl->Send(data->GetAt(i));
			CS ^= data->GetAt(i);
//			if((i % 3000) == 0)
//				DoAllEvents();
		}
//		TRACE(" End");
		ComEmptyBuffer();

		/*
		for(i=0;i<total_size;)
		{
			CString data;
			if(total_size - i >= 8)
			{
				for(int j=0;j<8;j++)
					data += total_size[i+j];
			}
			else
			{
				for(int k=0

			pCommCtrl->SendLong(data);
			CS ^= data->GetAt(i);
			if(i/8 * 8== i)
			{
			  if(!ComWaitFor(ACK, NAK, &index, TRUE))
			 	 return 2;		// time out
			}
			ComEmptyBuffer();
		}
*/
		ptr = (char*) &CS;
//		Sleep(2);
		pCommCtrl->Send(ptr[0]);
//		Sleep(1);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_ACK, NAK, &index, TRUE))
			return 2;		// time out
	
		if(index == NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		break;
	}
//	TRACE("\nAR End");
	return 0;
}


/****************************************************
			Add/Replace  a cat in PDA
*****************************************************/
int SyncRecAddCat(DatabaseID dbid, RecordID recid, unsigned short num_field, unsigned int *size_array, RecordHeader* header, CString *data)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	int i;
	short CS;
	int total_size = 0;

    int endata, byte_use;
    unsigned int dum;

	while(retry--)
	{
		pCommCtrl->Send(ADDCAT_REQ);
		if(!ComWaitFor(ADDCAT_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}
		ptr = (char*)&dbid;
		CS = 0;
		pCommCtrl->Send(ADDREC_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
//			TRACE(" %d ", ptr[i]);
		}
//		Delay();

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
//			Sleep(1);
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &num_field;
		for(i=0;i<2;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}


		if(!ComWaitFor(ACK, NAK, REC_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		ptr = (char*) size_array;
//		Sleep(1);
		for(i=0;i<4*num_field;i++)
		{
			CS ^= ptr[i];
 			pCommCtrl->Send(ptr[i]);
		}
//		Sleep(4);

		for(i=0;i<num_field;i++)
		{
		   total_size += size_array[i];
	       dum = size_array[i];
	       EnFieldSize(endata, dum, byte_use);
		   total_size += byte_use;
		}

//		Sleep(5);
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);


		if(!ComWaitFor(ADDREC_ACK, NAK, REC_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)		// db miss or cs err
		{
			if(!retry)
				return 3;
			else
				continue;
		}

		if(index == REC_NAK)
			return 4;

		if(index == REC_SIZE_NAK)
		{
//			TermFromDesktop = TRUE;
			if(TermFromNoSize == FALSE)
			{
				HWND hWnd = ::FindWindow(NULL,"VSync");
				::SendMessage(hWnd,WM_CLOSE,0,0);
				TermFromNoSize = TRUE;
				CString str;
				str.LoadString(IDS_MEMORYLOW_PDA);
				::AfxMessageBox(str,MB_OK);
			}
			return 5;
		}

		pCommCtrl->Send(ADDREC_ST);

		CS = 0;
		ptr = (char*) header;


		for(i=0;i<RECHEADER_SIZE;i++)
		{
			CS ^= ptr[i];
//			Sleep(1);
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)		// cs error in header
		{
			if(!retry)
				return 3;
			else
				continue;
		}
		TRACE("\nrec_id %d total len: %d", recid, data->GetLength());
		CS = 0;   	 
//		for(i=0;i<data->GetLength();i++)

		for(i=0;i<total_size;i++)
		{
			pCommCtrl->Send(data->GetAt(i));
			CS ^= data->GetAt(i);
//			if((i % 3000) == 0)
//				DoAllEvents();
		}
//		TRACE(" End");
		ComEmptyBuffer();

		/*
		for(i=0;i<total_size;)
		{
			CString data;
			if(total_size - i >= 8)
			{
				for(int j=0;j<8;j++)
					data += total_size[i+j];
			}
			else
			{
				for(int k=0

			pCommCtrl->SendLong(data);
			CS ^= data->GetAt(i);
			if(i/8 * 8== i)
			{
			  if(!ComWaitFor(ACK, NAK, &index, TRUE))
			 	 return 2;		// time out
			}
			ComEmptyBuffer();
		}
*/
		ptr = (char*) &CS;
//		Sleep(2);
		pCommCtrl->Send(ptr[0]);
//		Sleep(1);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_ACK, NAK, &index, TRUE))
			return 2;		// time out
	
		if(index == NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		break;
	}
//	TRACE("\nAR End");
	return 0;
}




/****************************************************
			Add Record
*****************************************************/
int SyncRecAddLarge(DatabaseID dbid, RecordID recid, unsigned short num_field, unsigned int *size_array, RecordHeader* header, CString *data)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	int i;
	short CS;
	int total_size = 0;

    int endata, byte_use;
    unsigned int dum;
	float percent;

	while(retry--)
	{
		pCommCtrl->Send(ADDREC_LARGE_REQ);
		if(!ComWaitFor(ADDREC_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}
		ptr = (char*)&dbid;
		CS = 0;
		pCommCtrl->Send(ADDREC_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &recid;
		for(i=0;i<sizeof(RecordID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &num_field;
		for(i=0;i<2;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}


		if(!ComWaitFor(ACK, NAK, REC_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		ptr = (char*) size_array;
		for(i=0;i<4*num_field;i++)
		{
			CS ^= ptr[i];
 			pCommCtrl->Send(ptr[i]);
		}

		for(i=0;i<num_field;i++)
		{
		   total_size += size_array[i];
	       dum = size_array[i];
	       EnFieldSize(endata, dum, byte_use);
		   total_size += byte_use;
		}


		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);


		if(!ComWaitFor(ADDREC_ACK, NAK, REC_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)		// db miss or cs err
		{
			if(!retry)
				return 3;
			else
				continue;
		}

		if(index == REC_NAK)
			return 4;

		if(index == REC_SIZE_NAK)
		{
//			TermFromDesktop = TRUE;
			if(TermFromNoSize == FALSE)
			{
				HWND hWnd = ::FindWindow(NULL,"VSync");
				::SendMessage(hWnd,WM_CLOSE,0,0);
				TermFromNoSize = TRUE;
				CString str;
				str.LoadString(IDS_MEMORYLOW_PDA);
				::AfxMessageBox(str,MB_OK);
			}
			return 5;
		}

		pCommCtrl->Send(ADDREC_ST);

		CS = 0;
		ptr = (char*) header;


		for(i=0;i<RECHEADER_SIZE;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)		// cs error in header
		{
			if(!retry)
				return 3;
			else
				continue;
		}
		TRACE("\nrec_id %d total len: %d", recid, data->GetLength());
		CS = 0;   	 

	int data_remain = total_size;
	int this_size;
	int acc = 0;
	BOOL abort = 0;

//	m_DispDlg->m_Percent.SetRange(0,100);
	if(data_remain > 8192)
		m_DispDlg->m_Percent.ShowWindow(SW_SHOW);

	while((data_remain > 0) && (!abort))
	{
	 if(data_remain >= TRAN_PACKET_SIZE)
		this_size = TRAN_PACKET_SIZE;
	 else
		this_size = data_remain;

	 for(i=0;i<this_size;i++)
	 {
		 pCommCtrl->Send(data->GetAt(acc+i));
		 CS ^= data->GetAt(acc+i);
		 if(!(i%1000))
			DoAllEvents();
	 }

	 DoAllEvents();
	 TRACE(" ");

	 acc += this_size;
	 data_remain -= this_size;

	 if(total_size)
	 {
		percent = ((float)total_size - (float)data_remain) / (float)total_size * 100.0;
	 if(percent < 0)
		 percent = 0;
	 else if(percent >= 100)
		 percent = 99;

//	 sprintf( (char*) str, "%d%%", (int)percent);
	 
//	 m_DispDlg->m_Percent = str;
	 m_DispDlg->m_Percent.SetPos((int)percent);
//	 m_DispDlg->UpdateData(FALSE);
//	 m_DispDlg->Invalidate(); 
	 m_DispDlg->DoEvents();
	 }

	 if(this_size >= TRAN_PACKET_SIZE)
	 {
	 if(!ComWaitFor(ACK, NAK, &index, TRUE))
		 abort = 1;
	 else
	 {
		 if(index == NAK)
			 abort = ERR_PDA_RECEIVE_ERR;
	 }
	 }
	}

		ComEmptyBuffer();

		ptr = (char*) &CS;

		pCommCtrl->Send(ptr[0]);

		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(REC_ACK, NAK, &index, TRUE))
			return 2;		// time out
	
		if(index == NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		break;
	}

	m_DispDlg->m_Percent.ShowWindow(SW_HIDE);
	m_DispDlg->m_Percent.SetPos(0);
	return 0;
}





/****************************************************
			Delete database
*****************************************************/
int SyncDBDel(DatabaseID dbid)
{
	int retry = CSERR_RETRY;
	short CS;
	char *ptr;
	char index;
	int i;

	while(retry--)
	{
		pCommCtrl->Send(DELDB_REQ);
		if(!ComWaitFor(DELDB_ACK, TRUE))
		{
			if(!retry)
				return 2;	// time out
			else
				continue;
		}

		CS = 0;
		ptr = (char*) &dbid;
		pCommCtrl->Send(DELDB_SEQ);
		
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, NAK, &index, TRUE))
				return 2;		// time out

		if(index == NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		break;
	}
	return 0;
}


/****************************************************
			Create database
*****************************************************/
int SyncDBNew(CString name, DBHeader *header)
{
	int retry = CSERR_RETRY;
	char index;
	char *ptr;
	short CS;
	int length, i;

	while(retry--)
	{
		pCommCtrl->Send(NEWDB_REQ);
		if(!ComWaitFor(NEWDB_ACK, TRUE))
		{
			if(!retry)
				return 2;	// time out
			else
				continue;
		}

		CS = 0;
		length = name.GetLength() + 2;
		ptr = (char*) &length;

		for(i=0;i<4;i++)
			pCommCtrl->Send(ptr[i]);

		pCommCtrl->Send(NEWDB_SEQ);
		for(i=0;i<name.GetLength();i++)
		{
			CS ^= name[i];
			pCommCtrl->Send(name[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, NAK, REC_SIZE_NAK, REC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)
		{
			if(!retry)
				return 1;		// cs error
			else
				continue;
		}

		if(index == REC_SIZE_NAK)
		{
//			TermFromDesktop = TRUE;
			if(TermFromNoSize == FALSE)
			{
				HWND hWnd = ::FindWindow(NULL,"VSync");
				::SendMessage(hWnd,WM_CLOSE,0,0);
				TermFromNoSize = TRUE;
				CString str;
				str.LoadString(IDS_MEMORYLOW_PDA);
				::AfxMessageBox(str,MB_OK);
			}
			return 5;		// not enough mem in PDA
		}

		CS = 0;
		ptr = (char*) header;
//		pCommCtrl->Send(NEWDB_ST);
		pCommCtrl->Send(NEWDB_NAK);
		for(i=0;i<DBHEADER_SIZE;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, NAK, &index, TRUE))
			return 2;		// time out

		if(index == NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		break;
	}
	return 0;
}

//REG
/****************************************************
			Create database
*****************************************************/
int SyncDBNew(CString name, USHORT version, CString owner)
{
	int retry = CSERR_RETRY;
	char index;
	char *ptr;
	short CS;
	int length, i;

	while(retry--)
	{
		ComEmptyBuffer();

		pCommCtrl->Send(NEWDB_REQ);
		if(!ComWaitFor(NEWDB_ACK, TRUE))
		{
			if(!retry)
				return 2;	// time out
			else
				continue;
		}

		CS = 0;

		pCommCtrl->Send(NEWDB_SEQ);
		length = name.GetLength() + owner.GetLength() + 6; //USHORT (2) + 2 NULL chars + CS = 6

		ptr = (char*) &length;
		for(i=0;i<4;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}
		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, TRUE))
		{
			if(!retry)
				return 2;	// time out
			else
				continue;
		}
		for(i=0;i<name.GetLength();i++)
		{
			CS ^= name[i];
			pCommCtrl->Send(name[i]);
		}
		pCommCtrl->Send('\0');

		ptr = (char*) &version;
		for(i=0;i<2;i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		for(i=0;i<owner.GetLength();i++)
		{
			CS ^= owner[i];
			pCommCtrl->Send(owner[i]);
		}
		pCommCtrl->Send('\0');

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(NEWDB_EXIST_NAK, NEWDB_SIZE_NAK, NEWDB_NAK, NEWDB_ACK, &index, TRUE))
			return 2;		// time out

		if(index == NEWDB_NAK)
		{
			if(!retry)
				return 1;		// cs error
			else
				continue;
		}

		if(index == NEWDB_SIZE_NAK)
			return ERR_PDA_NOT_ENOUGH_SPACE;		// not enough mem in PDA
		
		if(index == NEWDB_EXIST_NAK)
			return ERR_DB_EXIST;					// already exists

		if(index == NEWDB_ACK)						//success
			return 0;
/**
		//wait for length of header + cs
		if(!ComWaitForLength(4))
			return 2;
		
		//copy over
		ptr = (char*) &length;
		for(i=0;i<4;i++)
			ptr[i] = m_ComBuffer[4];  //memcpy

		//wait for rest of data
		if(!ComWaitForLength(length+4))
			return 2;
		
		//copy over, ignore trailing CS
		header->Empty();
		for(i=4;i<length;i++)
			(*header) += m_ComBuffer[i];
		
		//clear buffer
		ComRemoveBuffer(length+4);
**/
//		Sleep(10);
//		break;
	}
	return 0;
}

/****************************************************
			Add New Record
*****************************************************/
int SyncRecNew(DatabaseID dbid, RecordHeader* header, CString *data)
{
	int retry = CSERR_RETRY;
	char *ptr;
	char index;
	int i;
	short CS;
	int total_size = 0;

    int endata, byte_use;
    unsigned int dum;

	while(retry--)
	{
		pCommCtrl->Send(NEWREC_REQ);
		if(!ComWaitFor(NEWREC_ACK, TRUE))
		{
			if(!retry)
				return 2;		// time out
			else
				continue;
		}
		ptr = (char*)&dbid;
		CS = 0;
		pCommCtrl->Send(NEWREC_SEQ);
		for(i=0;i<sizeof(DatabaseID);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) header;
		for(i=0;i<sizeof(RecordHeader);i++)
		{
			CS ^= ptr[i];
			pCommCtrl->Send(ptr[i]);
		}

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);
		
		if(!ComWaitFor(NEWREC_ACK, NEWREC_NAK, NEWREC_INV_NAK, NEWREC_SIZE_NAK, &index, TRUE))
			return 2;		// time out

		if(index == NEWREC_NAK)		// db miss or cs err
		{
			if(!retry)
				return 3;
			else
				continue;
		}

		if(index == NEWREC_NAK)
			return 4;

		if(index == NEWREC_SIZE_NAK)
		{
//			TermFromDesktop = TRUE;
			if(TermFromNoSize == FALSE)
			{
				HWND hWnd = ::FindWindow(NULL,"VSync");
				::SendMessage(hWnd,WM_CLOSE,0,0);
				TermFromNoSize = TRUE;
				CString str;
				str.LoadString(IDS_MEMORYLOW_PDA);
				::AfxMessageBox(str,MB_OK);
			}
			return 5;		// not enough mem in PDA
		}

		//wait for rec header + cs
		if(!ComWaitForLength(sizeof(RecordHeader)))
			return 2;
		CString buf;
		//copy over
		ptr = (char*) header;
		for(i=0;i<sizeof(RecordHeader);i++)
			ptr[i] = m_ComBuffer[i];
		
		//clear buffer
		ComRemoveBuffer(sizeof(RecordHeader));
		
		ptr = data->GetBuffer(header->size);
		for(i=0;i<header->size;i++)
		{
			pCommCtrl->Send(ptr[i]);
			CS ^= ptr[i];
		}
		ComEmptyBuffer();

		ptr = (char*) &CS;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(NEWREC_ACK, NEWREC_NAK, &index, TRUE))
			return 2;		// time out
	
		if(index == NEWREC_NAK)
		{
			if(!retry)
				return 1;
			else
				continue;
		}

		break;
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////
//			DB Install
//////////////////////////////////////////////////////////////////////
/****************************************************
		PC req PDA goto DB Install mode
		PC send DBUP_MODE_REQ
		PDA send DBUP_MODE_ACK
*****************************************************/
int SyncDBInstMode()
{
	pCommCtrl->Send(DBUP_MODE_REQ);
	if(!ComWaitFor(DBUP_MODE_ACK, TRUE))
	{
		TRACE("\nDBUP_MODE_ACK: Time out");
		return 1;
	}
	else
		return 0;
}
//REG
	
//////////////////////////////////////////////////////////////////////
//			App Install
//////////////////////////////////////////////////////////////////////
/****************************************************
		PC req PDA goto App Install mode
		PC send NEWAPP_MODE_REQ
		PDA send NEW_APP_MODE_ACK
*****************************************************/
int SyncAppInstMode()
{
	pCommCtrl->Send(NEWAPP_MODE_REQ);
	if(!ComWaitFor(NEWAPP_MODE_ACK, TRUE))
		return 1;
	else
		return 0;
}


/****************************************************
		PC req PDA for New application
		PC send NEWAPP_REQ
		PDA send NEWAPP_ACK
		PC send NEWAPP_SEQ + size(4) + resource offset(4) +
		   Type(1) + attribute(1) + Name + 0x00 + CS
*****************************************************/
int AppInst(char app_name[20], int attribute, char *icon_data, char *extra_data, int extra_data_len, CString &progcode, int progcode_len)
{
	char index;
	int i;
	int value, value2;
	short cs;
	char *ptr;
	char *prog_ptr;
	int data_remain = progcode_len;
	int this_size;

	pCommCtrl->Send(NEWAPP_REQ);
	if(!ComWaitFor(ADDAPP_ACK, REC_SIZE_NAK, &index, TRUE))
			return 1;

	if(index != ADDAPP_ACK)
			return ERR_APP_MAX_MEET;

	cs = 0;
	/* send app name */
	for(i=0;i<20;i++)
	{
		cs ^= app_name[i];
		pCommCtrl->Send(app_name[i]);
	}
	
	ptr = (char*) &cs;
	pCommCtrl->Send(ptr[0]);
	pCommCtrl->Send(ptr[1]);
	
	if(!ComWaitFor(ACK, NAK, &index, TRUE))
	{
		return 1;
	}
	
	if(index == NAK)
		return ERR_APP_EXIST;

	prog_ptr = progcode.GetBuffer(progcode_len);


	/* send prog len, res offset, bss size , attri , cs */
	/*        4            4          4         2      2 */

	cs = 0;

//	ptr = prog_ptr + 4;
//	value = *(int*)ptr;  // packet len
	value = progcode_len;
	ptr = (char*) &value;
	pCommCtrl->Send(ptr[0]);
	cs ^= ptr[0];
	pCommCtrl->Send(ptr[1]);
	cs ^= ptr[1];
	pCommCtrl->Send(ptr[2]);
	cs ^= ptr[2];
	pCommCtrl->Send(ptr[3]);
	cs ^= ptr[3];

	ptr = prog_ptr + 4;    // prog len
	value = *(int*) ptr;
//	value &= 0x000FFFFF;
	ptr = (char*)&value;
	pCommCtrl->Send(ptr[0]);
	cs ^= ptr[0];
	pCommCtrl->Send(ptr[1]);
	cs ^= ptr[1];
	pCommCtrl->Send(ptr[2]);
	cs ^= ptr[2];
	pCommCtrl->Send(ptr[3]);
	cs ^= ptr[3];

	ptr = prog_ptr + ( 4 * 6);
	value = *(int*)ptr;  //res_offset
//	value &= 0x000FFFFF;
	ptr = (char*) &value;
	pCommCtrl->Send(ptr[0]);
	cs ^= ptr[0];
	pCommCtrl->Send(ptr[1]);
	cs ^= ptr[1];
	pCommCtrl->Send(ptr[2]);
	cs ^= ptr[2];
	pCommCtrl->Send(ptr[3]);
	cs ^= ptr[3];
	ptr += 4;

	ptr = prog_ptr + ( 4 * 5);
	value = *(int*)ptr;   // data size
	ptr = prog_ptr + (4 * 2);
	value2 = *(int*)ptr;
	value -= value2;
//	value &= 0x000FFFFF;
	ptr = (char*) &value;
	pCommCtrl->Send(ptr[0]);
	cs ^= ptr[0];
	pCommCtrl->Send(ptr[1]);
	cs ^= ptr[1];
	pCommCtrl->Send(ptr[2]);
	cs ^= ptr[2];
	pCommCtrl->Send(ptr[3]);
	cs ^= ptr[3];
	ptr += 4;

	ptr = (char*) &extra_data_len;  // extra data (hook table for DD )
	pCommCtrl->Send(ptr[0]);
	cs ^= ptr[0];
	pCommCtrl->Send(ptr[1]);
	cs ^= ptr[1];
	pCommCtrl->Send(ptr[2]);
	cs ^= ptr[2];
	pCommCtrl->Send(ptr[3]);
	cs ^= ptr[3];
	ptr += 4;

	ptr = (char*)&attribute;  // attribute
	pCommCtrl->Send(ptr[0]);
	cs ^= ptr[0];
	pCommCtrl->Send(ptr[1]);
	cs ^= ptr[1];

	ptr = (char*)&cs;		// cs
	pCommCtrl->Send(ptr[0]);
	pCommCtrl->Send(ptr[1]);

	progcode.ReleaseBuffer(progcode_len);

	if(!ComWaitFor(ACK, NAK, &index, TRUE))
	{
		return 1;
	}

	if(index == NAK)
		return ERR_PDA_NOT_ENOUGH_SPACE;

#define BIT_TYPE   (char)2

//	if( *((char*)&attribute) & BIT_TYPE)  /* Device driver */
//	{
//
//
//	}
//	else   // application
	{
		// send icon
		cs = 0;
		for(i=0;i<ICON_BMP_SIZE;i++)
		{
			pCommCtrl->Send(icon_data[i]);
			cs ^= icon_data[i];
		}

		// send hook table
		for(i=0;i<extra_data_len; i++)
		{
			pCommCtrl->Send(extra_data[i]);
			cs ^= extra_data[i];
		}

		ptr = (char*)&cs;
		pCommCtrl->Send(ptr[0]);
		pCommCtrl->Send(ptr[1]);

		if(!ComWaitFor(ACK, NAK, &index, TRUE))
		{
			return 1;
		}

		if(index == NAK)  //
			return ERR_PDA_ERR;  /* call MemoryInstallProg fail in PDA */

	}  // application

	/* send the prog code */

	int abort = 0;
	int acc=0;
	cs = 0;
	float percent;

	m_DispDlg->m_Percent.SetRange(0,100);
	m_DispDlg->m_Percent.SetPos(0);
	m_DispDlg->m_Percent.ShowWindow(SW_SHOW);

	while((data_remain > 0) && (!abort))
	{
	 if(data_remain >= TRAN_PACKET_SIZE)
		this_size = TRAN_PACKET_SIZE;
	 else
		this_size = data_remain;

	 for(i=0;i<this_size;i++)
	 {
		 pCommCtrl->Send(progcode[acc+i]);
		 cs ^= progcode[acc+i];
		 if(!(i % 1000))
			DoAllEvents();
	 }

	 acc += this_size;
	 data_remain -= this_size;

     percent = ((float)acc) / (float)progcode_len * 100.0;
	 if(percent < 0) percent = 0;
	 if(percent > 100) percent = 100;

	 DoAllEvents();
	 TRACE(" ");


	 m_DispDlg->m_Percent.SetPos((int)percent);

	 if(this_size >= TRAN_PACKET_SIZE)
	 {
	 if(!ComWaitFor(ACK, NAK, &index, TRUE))
		 abort = 1;
	 else
	 {
		 if(index == NAK)
			 abort = ERR_PDA_RECEIVE_ERR;
	 }
	 }
	}

	m_DispDlg->m_Percent.ShowWindow(SW_HIDE);

	if(abort)
		return abort;

	ptr = (char*)&cs;
	pCommCtrl->Send(ptr[0]);
	pCommCtrl->Send(ptr[1]);
	if(!ComWaitFor(ACK, NAK, &index, TRUE))
		return ERR_PDA_RECEIVE_ERR;
	return 0;			// OK
}


//////////////////////////////////////////////////////////////////////
//			Terminate
//////////////////////////////////////////////////////////////////////
/****************************************************
			Terminate
*****************************************************/
int SyncEnd()
{
	int retry = CSERR_RETRY;
	pCommCtrl->Send(IDLE_MODE_REQ);
	Sleep(5);
	pCommCtrl->Send(TERM_MODE_REQ);
	Sleep(5);
	pCommCtrl->Send(END_FLG);
	Sleep(5);
	pCommCtrl->Send(SHOW_STATE_RDY);
//	ComWaitFor(END_ACK, TRUE)
	return 0;
}


/* get a field from the reocrd 
   return the field size */
int PDADataGetField(int fieldnum, CString *cont, CString *fielddata)
{
	char tmp[6];
	char *ptr;
	unsigned int i;
	unsigned int field_size, byte_used;
	int pos;
	int current_field;

	current_field = 0;
	field_size = byte_used = pos = 0;
	int x = cont->GetLength() ;
	while(1)
	{
		pos += field_size + byte_used;
		tmp[0] = tmp[5] = 0;
//if(cont->GetLength() - pos >= 4)
		if( x > (pos + 4))
		{
			for(i=0;i<4;i++)
				tmp[i] = cont->GetAt(i+pos);
		}
		else
		{
			if (x-pos > 0)
			{
				//for(i=0;i<cont->GetLength()-pos;i++)
				//if( (x - pos) >0)
				for(i=0;i<x-pos;i++)
					tmp[i] = cont->GetAt(i+pos);
			}
			else
				return 0;		// field too large
		}

		ptr = tmp;	
		DeFieldSize(ptr, field_size, byte_used);

		if(field_size > 0x00700000)
		{
			fielddata->Empty();
			TRACE("\nPDADataGetField: Error in field size ");
			return 0;
		}
		
		if(current_field++ == fieldnum)
			break;	

	}

	pos += byte_used;

	fielddata->Empty();
/*
	for(i=0;i<field_size;i++)
	{
//		if((int)cont->GetAt(i+pos) < 30)
//			TRACE("\n field %d  pos: %d  char %d ", fieldnum, pos, (int)cont->GetAt(i+pos));
		(*fielddata) += cont->GetAt(i+pos);
	}
*/
	(*fielddata) = cont->Mid(pos,field_size);
	return field_size;
}		


unsigned int _rtm2date32(RTM dat)
{
	if(dat.year < 1972)	/* cannot convert year before 1972 */
		return 0;
	return ((((unsigned int) (((dat.year-1972)<<9) | (dat.mon<<5)| dat.mday)) << 16) & 0xFFFF0000) |
	       (((unsigned int) ((dat.hour<<11) | (dat.min<<5) | (dat.sec/2))) & 0x0000FFFF);
}

RTM _date322rtm(unsigned int dat)
{
	RTM dest;
	dest.sec  = (unsigned short) (dat & 0x0000001F) * 2;
	dest.min  = (unsigned short) (dat >> 5) & 0x0000003F;
	dest.hour = (unsigned short) (dat >> 11) & 0x0000001F;
	dest.mday = (unsigned short) (dat >> 16) & 0x0000001F;
	dest.mon  = ((unsigned short) (dat >> 21) & 0x0000000F); 
	dest.year = (unsigned short) ((dat >> 25) & 0x0000007F) + 1972;

	if(dest.sec < 1) dest.sec = 1;
	else if(dest.sec > 59) dest.sec = 59;
	if(dest.min > 59) dest.min = 59;
	if(dest.hour > 23) dest.hour = 23;
	if(dest.mday < 1) dest.mday = 1;
	else if(dest.mday > 31) dest.mday = 31;
	if(dest.mon < 0) dest.mon = 1;
	else if(dest.mon > 12) dest.mon = 12;
//	if(dest.year > 2037) dest.year = 2037;
	return dest;
}

RTM DBDate2RTM(COleDateTime t_)
{
	RTM res;

	res.sec = t_.GetSecond();
	res.min = t_.GetMinute();
	res.hour = t_.GetHour();
	res.mday = t_.GetDay();
	res.mon = t_.GetMonth() - 1;
	res.year = t_.GetYear();
	return res;
}

CString _date322DB(unsigned int date)
{
	COleDateTime dtime;
	RTM  rtmdate;
	
	rtmdate = _date322rtm(date);

	COleDateTime time1(rtmdate.year, rtmdate.mon + 1, rtmdate.mday, rtmdate.hour, rtmdate.min, rtmdate.sec);

//	CString szDate = time1.Format("#%x %X#");
	CString szDate = time1.Format("#%m %d %Y %X#"); //sql only accept m/d/Y
	SqlDateHandle(szDate);
	return szDate;
}

CString _date322DB2(unsigned int date)
{
	COleDateTime dtime;
	RTM  rtmdate;
	
	rtmdate = _date322rtm(date);

	COleDateTime time1(rtmdate.year, rtmdate.mon + 1, rtmdate.mday, rtmdate.hour, rtmdate.min, rtmdate.sec);

	CString szDate = time1.Format("%x %X");
	SqlDateHandle(szDate);
	return szDate;
//	return time1.Format("%b %d %Y %H:%M:%S");
}

void AddNULL(CString *x)
{
	if(x->GetLength())
	{
		if((x->GetAt(x->GetLength()-1)) != '\0')
			*x += '\0';
	}
	else
		*x += '\0';
	(*x).Replace("\r\n", "\r");
}

void RemoveNULL(CString *x)
{
	int i;
	i = x->GetLength();
	while(i)
	{
		if (x->GetAt(i-1) == '\0')
		{
			(*x) = x->Left(i-1);
			i = x->GetLength();
		}
		else
			break;
	}
	(*x).Replace("\r", "\r\n");
	(*x).Replace("\r\n\n", "\r\n");
}
		
void RemoveFrontNULL(CString *x)
{
	int i;
	i = x->GetLength();
	for(int j = 0; j < i; j++){
		if(x->GetAt(j) == '\0'){
			(*x) = x->Left(j);
			break;
		}
	}
	(*x).Replace("\r", "\r\n");
	(*x).Replace("\r\n\n", "\r\n");

/*
	while(i)
	{
		if (x->GetAt(i-1) == '\0')
		{
			(*x) = x->Left(i-1);
			i = x->GetLength();
		}
		else
			break;
	}
	(*x).Replace("\r", "\r\n");
*/
}

int GetSyncCount(int nIndex)
{
	if(nIndex == 0)
	{
		nPDA2PC = 0;
		nPC2PDA = 0;
		return 0;
	}
	else if(nIndex == 1)
		return nPDA2PC;
	else if(nIndex == 2)
		return nPC2PDA;


}