#ifndef __SYNCFX_H__
#define __SYNCFX_H__
 
#define RecordID unsigned int
#define DatabaseID unsigned int

#define WM_DLG_QUIT WM_USER + 15

typedef struct DB_HEADER_STRUCT
{
	unsigned int length;
	unsigned int dbid;
	unsigned short version;
	unsigned short owner;
	unsigned int next_rec_id;
	unsigned int create_date;
	unsigned int backup_date;
} DBHeader;

typedef struct REC_HEADER_STRUCT
{
	unsigned int size;
	unsigned int rec_id;
	unsigned int modi_date;
	unsigned short total_field;
	unsigned char cat;
	unsigned char attribute;
} RecordHeader;


typedef struct _REC_STRUCT
{
	RecordHeader rec_header;
} RecStruct;


typedef struct _SCHREC_STRUCT
{
	RecordHeader rec_header;
	char date[3];
	char modi;
} SchRecStruct;


//#define CHKTERM 	DoEvents(); if(!bRun) goto terminate; if(pdatimeout) { bRun=FALSE; goto terminate;}
#define CHKTERM 	if(!bRun) goto terminate; if(pdatimeout) { bRun=FALSE; goto terminate;}


#define DatabaseID unsigned int
#define RecordID unsigned int
#define AppID	unsigned short

#define DBHEADER_SIZE	sizeof(DBHeader)
#define RECHEADER_SIZE	sizeof(RecordHeader)


#define NormRec(rec_ptr)	( ((rec_ptr->rec_id & 0x80000000) == 0x00000000) \
				  && (((rec_ptr->attribute) & 0x04) == (BYTE) 0x00))

#define NormRecID(rec_id)	((rec_id & 0x80000000) == 0x00000000)

#define CatRec(rec_id) (((rec_id >= 0x80000000) && (rec_id < 0x800000FF)))

/* Check fragment flag of a record */
#define FragRec(rec_ptr)	((rec_ptr->attribute) & 0x20)
#define SetRecFrag(rec_ptr)	((rec_ptr->attribute) |= 0x20)
#define ClrRecFrag(rec_ptr)	((rec_ptr->attribute) &= 0xFD)

#define IsRecSecret(rec_ptr)	((BYTE)((rec_ptr->attribute) & 0x10) == (BYTE)0x10)
#define SetRecSecret(rec_ptr)   ((rec_ptr->attribute) |= 0x10)  /* upate mat after the operation */
#define ClrRecSecret(rec_ptr)   ((rec_ptr->attribute) &= 0xEF)  /* upate mat after the operation */

#define IsRecLock(rec_ptr)	((BYTE)((rec_ptr->attribute) & 0x08) == (BYTE)0x08)
#define SetRecLock(rec_ptr)	((rec_ptr->attribute) |= 0x08)  /* upate mat after the operation */
#define ClrRecLock(rec_ptr)	((rec_ptr->attribute) &= 0xF7)  /* upate mat after the operation */

#define SetRecArchive(rec_ptr)  ((rec_ptr->attribute) |= 0x04)

/* Decode the FieldSize, field_ptr will move to first char in the field*/
#define DeFieldSize(field_ptr, size, byte_use) {size = 0;               \
						byte_use = 0;           \
				    do {                                \
				      (size) |=  ((((UWORD)(*field_ptr)) >> 1) & 0x0000007F) << ((byte_use++) * 7);\
				      } while (!((*field_ptr++) & 0x01));}

/* Encode the FieldSize and number of byte use to represent it*/
/* output:  word - encoded data, byte_use - no. of byte in word that is valid for the representation */
/*          size - always 0							*/
#define EnFieldSize(word, size, byte_use) { byte_use = 0;				     \
				      do {                                  \
				       *(BYTE*)((BYTE*)(&word) + byte_use++) = ((BYTE) size) << 1;      \
				       size >>= 7;			     \
				       }				     \
				       while(size != 0);                     \
				       *(BYTE*)((BYTE*)(&word) + byte_use - 1) |= 0x01; }

typedef struct _RTM
{
	/*
	unsigned short sec;
	unsigned short min;
	unsigned short hour;
	unsigned short mday;
	unsigned short mon; 
	unsigned short year;
	*/
unsigned short msec;
unsigned short sec;
unsigned short min;
unsigned short hour;
unsigned short mday;
unsigned short mon;
unsigned short year;
unsigned short wday;
unsigned short yday;
} RTM;


unsigned int _rtm2date32(RTM dat);
RTM _date322rtm(unsigned int dat);
RTM DBDate2RTM(COleDateTime t_);
CString _date322DB(unsigned int date);
CString _date322DB2(unsigned int date);
void RemoveFrontNULL(CString *x);
void RemoveNULL(CString *x);
void AddNULL(CString *x);
extern BOOL bIsSync;

#define APP_ICON_WIDTH	48
#define APP_ICON_HEIGHT 34
#define APP_ICON_BIT_PER_PIXEL	2

#define ICON_BMP_SIZE	(APP_ICON_WIDTH * APP_ICON_HEIGHT * APP_ICON_BIT_PER_PIXEL / 8)

#define ERR_APP_MAX_MEET			10
#define ERR_APP_EXIST				11
#define ERR_PDA_NOT_ENOUGH_SPACE	12
#define ERR_PDA_ERR					13
#define ERR_PDA_RECEIVE_ERR			14

//reg
#define ERR_DB_EXIST				15
//reg

#define ST_ACK		0x01
#define ST_NAK		0x02
#define ST_FLG		0x03
#define USER_REQ	0x04
#define ACK			0x05
#define USERWR_REQ	0x06
#define USER_ACK	0x07
#define NAK			0x08
#define CLK_REQ		0x09
#define CLK_ACK		0x0a
#define CLKSET_REQ	0x0b
#define CLKSET_ACK	0x0c
#define GENINF_REQ	0x0f
#define GENINF_ACK	0x10
#define DBINFO_REQ	0x11
#define DBINFO_ACK	0x12
#define DBID_REQ	0x13
#define DBINFO_DATA_ACK	0x014
#define RECINFO_REQ	0x15
#define RECINFO_ACK	0x16
#define RECINFO_SEQ	0x17
#define RECINFO_DATA_ACK	0x18
#define MODIREC_REQ	0x19
#define MODIREC_ACK	0x1a
#define RECDATA_REQ	0x1b
#define RECDATA_ACK	0x1c
#define REC_NAK		0x1d
#define REC_DATA	0x1e
#define APP_REQ		0x1f
#define APP_ACK		0x20
#define APP_SEQ		0x21
#define DELREC_REQ	0x22
#define DELREC_ACK	0x23
#define DELREC_SEQ	0x24
#define ADDREC_REQ	0x25
#define ADDREC_ACK	0x26
#define CLKSET_SEQ	0x27
#define REC_SIZE_NAK	0x28
#define ADDREC_ST	0x29
#define DELDB_REQ	0x2a
#define DELDB_ACK	0x2b
#define DELDB_SEQ	0x2c
#define NEWDB_REQ	0x2d
#define NEWDB_ACK	0x2e
#define NEWDB_SEQ	0x2f
//#define NEWDB_ST	0x30
//REG
#define NEWDB_NAK	0x30
//REG
#define NEWAPP_REQ	0x31
#define NEWAPP_ACK	0x32
#define NEWAPP_SEQ	0x33
#define NEWAPP_ST	0x34
#define SENDDB_REQ	0x35
#define SENDDB_ACK	0x36
#define SENDDB_SEQ	0x37
#define SENDEOR_ACK	0x38
#define END_FLG		0x39
#define IDLE_MODE_REQ	0x3a
#define IDLE_MODE_ACK	0x3b
#define NEWAPP_MODE_REQ	0x3c
#define NEWAPP_MODE_ACK	0x3d
#define RECDATA_SEQ		0x3e
#define REC_ACK			0x3f
#define END_ACK			0x40
#define ADDREC_SEQ		0x41
#define DBENQ_MODE_REQ	0x43
#define DBUP_MODE_REQ	0x44
#define SYSBK_MODE_REQ	0x45
#define TERM_MODE_REQ	0x46
#define DBENQ_MODE_ACK	0x47
#define DBUP_MODE_ACK	0x48
#define SYSBK_MODE_ACK	0x49
#define TERM_MODE_ACK	0x50
#define RECARCINFO_REQ  0x51
#define RECARCINFO_ACK  0x52
#define RECARCINFO_SEQ  0x53
#define RECARCINFO_DATA_ACK     0x54
#define RECARCDATA_REQ  0x55
#define RECARCDATA_ACK  0x56
#define RECARCDATA_SEQ  0x57
#define ADDREC_CON		0x58
#define MSG_SCRONLY     0x59
#define MSG_LOGONLY     0x5a
#define MSG_LOGSCR      0x5b
#define MSG_LOG_REQ     0x5c
#define MSG_LOG_ACK     0x5d
#define MSG_SEQ         0x5e
#define MSG_ACK         0x5f
#define SHOW_STATE_RDY  0x60
#define SHOW_STATE_1    0x61
#define SHOW_STATE_2    0x62
#define SHOW_STATE_3    0x63
#define LOG_MSG_EM      0x64
#define LOG_MSG_PB      0x65
#define LOG_MSG_SCH     0x66
#define LOG_MSG_VOX     0x67
#define LOG_MSG_TD      0x68
#define LOG_MSG_ANN     0x69
#define LOG_MSG_SK      0x6a
#define LOG_MSG_EXP     0x6b
#define LOG_MSG_MEMO	0x6c
#define LOG_MSG_SYS     0x6d
#define LOG_MSG_BACKUP  0x6e
#define LOG_MSG_SYNC    0x6f

#define LOG_MSG_EM_F    0x78
#define LOG_MSG_PB_F    0x79
#define LOG_MSG_SCH_F   0x7a
#define LOG_MSG_VOX_F   0x7b
#define LOG_MSG_TD_F    0x7c
#define LOG_MSG_ANN_F   0x7d
#define LOG_MSG_SK_F    0x7e
#define LOG_MSG_EXP_F   0x7f
#define LOG_MSG_MEMO_F  ((char)0x80)
#define LOG_MSG_SYS_F  ((char)0x81)
#define LOG_MSG_BACKUP_F  ((char)0x82)
#define LOG_MSG_SYNC_F  ((char)0x83)

#define LOG_CLR_MSG     ((char)0x8d)
#define LOG_MSG_DATE	((char)0x8e)

#define RECFIELD_REQ    ((char)0x9b)
#define RECFIELD_ACK    ((char)0x9c)
#define RECFIELD_DATA   ((char)0x9d)

#define CRASH_ENQ      ((char)0x9e)
#define CRASH_YES      ((char)0x9f)
#define CRASH_NO       ((char)0xa0)

#define ADDAPP_ACK     ((char)0xa1)
#define ADDAPP_DATA_NAK ((char)0xa2)
#define ADDAPP_SPACE_NAK ((char)0xa3)
#define ADDAPP_EXIST_NAK ((char)0xa4)
#define ADDAPP_SEQ       ((char)0xa5)

#define ADDCAT_REQ	 ((char)0xaa)
#define ADDCAT_ACK	 ((char)0xab)

#define SCHRECINFO_REQ   ((char)0xb0)
#define SCHRECINFO_ACK   ((char)0xb1)

#define	ADDREC_LARGE_REQ ((char) 0xac)


#define SET_TODO_ALARM    ((char)0xad)
#define SET_ANN_ALARM    ((char)0xae)
#define SET_SCH_ALARM    ((char)0xaf)

#define MAX_RECID_REQ  ((char)0xb2)
#define MAX_RECID_ACK  ((char)0xb3)


#define REASIGN_RECID_REQ  ((char) 0xb4)
#define REASIGN_RECID_ACK  ((char) 0xb5)
#define CLEAR_CRASH		   ((char) 0xb6)

#define SCH_ACK           ((char) 0xb7)
#define SCH_CHG_APPNUM_REQ ((char) 0xb8)
#define OS_VER_REQ			((char) 0xb9)
#define OS_VER_ACK			((char) 0xbb)

#define UP_SYSTEM_CONFIRM ((char)0xba)
#define UP_SYSTEM          ((char)0xc0)
// 0xc1 use for start flag

//REG
#define NEWDB_SIZE_NAK	   ((char) 0xbc)
#define NEWDB_EXIST_NAK	   ((char) 0xbd)
#define NEWREC_REQ			((char)0xc2)
#define NEWREC_ACK			((char)0xc3)
#define NEWREC_SEQ			((char)0xc4)
#define NEWREC_NAK			((char)0xc5)
#define NEWREC_INV_NAK		((char)0xc6)
#define NEWREC_SIZE_NAK		((char)0xc7)
int SyncDBNew(CString name, USHORT version, CString owner);
int SyncRecNew(DatabaseID dbid, RecordHeader* header,CString *data);
int SyncDBInstMode();
//REG

int PDADataGetField(int fieldnum, CString *cont, CString *fielddata);

int SyncReq();
int SyncUserInfoReq(CString *, CString *);
int SyncUserUpdate(CString data);
int SyncClockQuery(RTM *clk);
int SyncClockSet(RTM clk);
int SyncIdleMode();
int SyncDBEnqMode();
int SyncDBUpMode();
int SyncDBGenInfo(int *total_db, CString *name);
int SyncDBInfo(CString db_name, DatabaseID *dbid, CString *db_header);
int SyncRecInfoReq(DatabaseID dbid, int *total_rec, RecStruct **record);
int SyncReadRecInfo(DatabaseID dbid, RTM date, int *total_rec, RecStruct **record);
int SyncReadRec(DatabaseID dbid, RecordID recid, char *header, CString *content);
int SyncAppEnq(CString name, BOOL *found);
int SyncRecDel(DatabaseID dbid, RecordID recid);
int SyncRecAdd(DatabaseID dbid, RecordID recid, unsigned short num_field, unsigned int *size_array, RecordHeader* header, CString *data);
int SyncDBDel(DatabaseID dbid);
int SyncDBNew(CString name, DBHeader *header);
int SyncReadField(DatabaseID dbid, RecordID recid, unsigned short fieldnum, CString *fielddata);
int SyncSchRecInfoReq(DatabaseID dbid, int *total_rec, SchRecStruct *record);
int SyncRecAddCat(DatabaseID dbid, RecordID recid, unsigned short num_field, unsigned int *size_array, RecordHeader* header, CString *data);
int SyncAppInstMode();
int AppInst(char app_name[20], int attribute, char *icon_data, char *extra_data, int extra_data_len, CString &progcode, int progcode_len);
int SyncEnd();
int SyncRecArcInfoReq(DatabaseID dbid, int *total_rec, RecStruct **record);
int SyncSetLogMsg(char type, char header, CString data);
int SyncMsgLogMode();
int SyncShowRdy();
int SyncShow1();
int SyncShow2();
int SyncShow3();
int SyncLogMsg(char);
int SyncRecAddLarge(DatabaseID dbid, RecordID recid, unsigned short num_field, unsigned int *size_array, RecordHeader* header, CString *data);
int SyncSetToDoAlm();
int SyncSetAnnAlm();
int SyncSetSchAlm();
int SyncReasignRecordID(DatabaseID dbid, unsigned int offset, RecordID exclude_recid);
int SyncReadRecLarge(DatabaseID dbid, RecordID recid, char *header, CString *content);
void AlertSound(UINT);
int SyncClearPdaCrash();
int SyncSetPDASchApptNum(unsigned int offset);

int SyncSetDST();

CString SyncGetVTOSVer();

extern int nPDA2PC;
extern int nPC2PDA;
int GetSyncCount(int nIndex);

#define NULL_ACT		0
#define SYNC_TO_PC		1
#define DEL_FROM_PDA	2
#define NOT_SYNC		3
#define SYNC_TO_PDA		4
#define DEL_FROM_PC		5
#define SYNC_ALL		6
#define NOT_SYNC_ALL	7
#define SYNC_REC		8
#define DEL_REC			9

#define MODI_TIME		2 // time difference in second which to determine for a modi record since last sync
#define RTM_TORENCE		3  // torence between RTM and Date32 format

#define INIT_BY_PDA 0
#define INIT_BY_PC	1

#endif

