#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "todo.h"

extern CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

CString ToDoValidDBDate(COleDateTime &t)
{
		if (t.GetStatus() != COleDateTime::valid)
			return "";
	else
		return t.Format("%Y/%m/%d");
}

CString ToDoValidDBDateForSql(COleDateTime &t)
{
	if (t.GetStatus() != COleDateTime::valid)
			return "NULL";
	else
	{
		CString szDate = t.Format("%b %d %Y %H:%M:%S");
		SqlDateHandle(szDate);
		return szDate;
//		return t.Format("%b %d %Y %H:%M:%S");
	}
}


CString ToDoGetVoxFileName(RecordID rec_id)
{
	CString name;

	name.Format("%08x.txt", rec_id);

	return name;
}


BOOLEAN ToDoCreateVoxFile(RecordID rec_id, CString *fielddata)
{
// return TRUE if OK, else FALSE
	// create a sketch file in dir Sketch\ with rec_id as name
	CString filename;
	CFileException e;
	CFile file;

	filename = "\\ToDo\\" + ToDoGetVoxFileName(rec_id);

	try
	{
		if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return TRUE;
	}

	try
	{
		file.WriteHuge(fielddata, fielddata->GetLength() );
	}

    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		return TRUE;
	}

	file.Close();

	return FALSE;

}


void ToDoConvertPDADateToPC(CString &data)
{
  // convert PDA date: YYYY/MM/DD to Sql date
	unsigned long u_val;
	CString year, mon, day, min, hr, sec, result;
	COleDateTime tTime;

	if(data.GetLength()>=4)
	{
		year = data.Left(4);
		if(year == (CString) "    ")
		{
			data = "NULL";
			return;
		}
//		if (year > "2037")
//			year = "2037";
	}
	else
	{
		data =  "NULL";
		return;
	}

	if(data.GetLength()>=7)
	{
		mon = data.Mid(5,2);
		u_val = atol(mon);
//		if((u_val<=12) && (u_val >= 1))
//			mon = MonName[u_val-1];
//		else
//			mon = MonName[0];
		if(!((u_val<=12) && (u_val >= 1)))
			mon = "1";
	}
	else
	{
//		mon = MonName[0];
		mon = "1";
	}

	if(data.GetLength() >= 10)
	{
		day = data.Mid(8,2);
		u_val = atol(day);
		if((u_val < 1) || (u_val > 31))
			day = "01";
	}
	else
	{
		day = "01";
	}

//	data = "#";
//	data += mon + " " + day + " " + year;
//	data += "#";
	tTime.SetDate(atoi(year),atoi(mon),atoi(day));
	data = tTime.Format("%x");
	SqlDateHandle(data);
	return;
}




BOOL ToDoAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	
	if (CatRec(rec_id))
		return ToDoAddCat(dbCurrent, rec_id, rec_header, rec_content);

// todo handle NewRecordWithID record

	szSql = "delete from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += TODODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	if(fielddata.GetLength())
	{  // completed
		if(fielddata[0] == (char) 0x01)
			rsCurrent->SetFieldValue("Completed",(LPCTSTR)"TRUE");
		else
			rsCurrent->SetFieldValue("Completed",(LPCTSTR)"FALSE");
	}
	else
		rsCurrent->SetFieldValue("Completed",(LPCTSTR)"FALSE");

	PDADataGetField(1, rec_content, &fielddata);
	// Status, 0 - 3
	int alm_status = 0;
	if(fielddata.GetLength())
	{
		if((int) fielddata[0] >=0 && (int) fielddata[0] <= 3)
		{
			rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)Str_ul( fielddata[0]));
			alm_status = (int) fielddata[0];
		}
		else
			rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)"0");
	}
	else
		rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)"0");

	PDADataGetField(2, rec_content, &fielddata);
	// priority  1 - 5
	if(fielddata.GetLength())
	{
		if( (int) fielddata[0] >=1  && (int) fielddata[0] <=5)
			rsCurrent->SetFieldValue("Priority",(LPCTSTR)Str_ul(fielddata[0]));
		else
			rsCurrent->SetFieldValue("Priority",(LPCTSTR)"0");
	}
	else
		rsCurrent->SetFieldValue("Priority",(LPCTSTR)"0");


	PDADataGetField(3, rec_content, &fielddata);
	// content
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)(fielddata));

	PDADataGetField(4, rec_content, &fielddata);
	// sch date, YYYY/MM/DD
	ToDoConvertPDADateToPC(fielddata);
	if(fielddata == "NULL")
		rsCurrent->SetFieldValueNull("ToDoDate");
	else
		rsCurrent->SetFieldValue("ToDoDate",(LPCTSTR)fielddata);

	PDADataGetField(5, rec_content, &fielddata);
	// alm date
	ToDoConvertPDADateToPC(fielddata);
	if(fielddata == "NULL")
		rsCurrent->SetFieldValueNull("AlarmDate");
	else
		rsCurrent->SetFieldValue("AlarmDate",(LPCTSTR)fielddata);

	if((alm_status == 2) || (alm_status == 3))
	{  // has voice
		PDADataGetField(6, rec_content, &fielddata);
		// RecordID
		char x[4];
		if(fielddata.GetLength() >= 4)
		{
			x[0] = fielddata[0];
			x[1] = fielddata[1];
			x[2] = fielddata[2];
			x[3] = fielddata[3];
		}
		rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)Str_ul( *(unsigned int*)x));
	}
	else
		rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)"0");



	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;
	return FALSE;
}


BOOL ToDoMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	
	if (CatRec(rec_id))
		return ToDoMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += TODODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	// completed item
	fielddata = rs->GetFieldValue("Completed");
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Completed",(LPCTSTR)szStr);

	// AlarmStatus
	fielddata = rs->GetFieldValue("AlarmStatus");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmStatus",(LPCTSTR)szStr);

	// Priority
	fielddata = rs->GetFieldValue("Priority");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("Priority",(LPCTSTR)szStr);
	
	// Content
	fielddata = rs->GetFieldValue("Content");
	szStr = (LPSTR) fielddata.bstrVal;
	rsCurrent->SetFieldValue("Content",(LPCTSTR)szStr);

	CString tmpdate;
	// ToDoDate
	fielddata = rs->GetFieldValue("ToDoDate");

	tmpdate = ToDoValidDBDateForSql(COleDateTime(fielddata));
	if(tmpdate != "NULL")
	{
		rsCurrent->SetFieldValue("ToDoDate",(LPCTSTR)tmpdate);
	}
	else
		rsCurrent->SetFieldValueNull("ToDoDate");

	// AlarmDate
	fielddata = rs->GetFieldValue("AlarmDate");
	tmpdate = ToDoValidDBDateForSql(COleDateTime(fielddata));
	if(tmpdate != "NULL")
	{
		rsCurrent->SetFieldValue("AlarmDate",(LPCTSTR)tmpdate);
	}
	else
		rsCurrent->SetFieldValueNull("AlarmDate");

	// VoiceID
	fielddata = rs->GetFieldValue("VoiceID");
	szStr = Str_ul(fielddata.lVal);
	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)szStr);


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	rs->Close();

	szSql = "delete from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}



BOOL ToDoAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += TODODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return FALSE;
}



BOOL ToDoMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;
	int i;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += TODODB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Content");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ExamSql((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	szSql = "delete from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return FALSE;
}

BOOL ToDoArchivePDAOvrPC(DatabaseID dbid)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 12000)
		return 1;

	for(i=0;i<total_rec;i++)
	{
	 if(((RecordHeader*)&(record[i].rec_header))->rec_id < 0x80000000)
	 {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
//		if(DBIsExistRecord(dbArchive, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
//			ToDoMoveRecord(dbArchive, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbRecycle, TODODB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, TODODB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		ToDoAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if(((RecordHeader)(record[i].rec_header)).rec_id < 0x80000000)
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	 }
	}

	if(record)
	   free(record);
	return 0;
}


BOOL ToDoArchivePCOvrPDA(DatabaseID dbid)
{ 
	return ToDoArchivePDAOvrPC(dbid);
}


BOOL PDAToDoAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[8];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += TODODB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 7;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));

   
	// completed
	if((rs->GetFieldValue("Completed")).boolVal)
		fielddata = (char)0x01;
	else
		fielddata = (char)0x00;
	//fielddata = (char) (rs->GetFieldValue("Completed")).lVal;
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	// AlarmStatus
	fielddata = (char) (rs->GetFieldValue("AlarmStatus")).lVal;
	size_array[1] = fielddata.GetLength();
	data32_2 = size_array[1];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	// Priority
	fielddata = (char) (rs->GetFieldValue("Priority")).lVal;
	size_array[2] = fielddata.GetLength();
	data32_2 = size_array[2];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	// content
	fielddata = (LPCSTR) (rs->GetFieldValue("Content")).bstrVal;
	AddNULL(&fielddata);
	size_array[3] = fielddata.GetLength();
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];
	content += fielddata;	

	// ToDO date
	COleDateTime dt;
	dt = (COleDateTime)rs->GetFieldValue("ToDoDate");
	fielddata = ToDoValidDBDate(COleDateTime(dt));
	if (fielddata == "")
		fielddata = "0";
	AddNULL(&fielddata);
	size_array[4] = fielddata.GetLength();
	data32_2 = size_array[4];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];
	content += fielddata;	

	// AlarmDate
	dt = (COleDateTime)rs->GetFieldValue("AlarmDate");
	fielddata = ToDoValidDBDate(COleDateTime(dt));
	if (fielddata == "")
		fielddata = "0";
	AddNULL(&fielddata);
	size_array[5] = fielddata.GetLength();
	data32_2 = size_array[5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];
	content += fielddata;	

	// VoiceID
	int da32;
	char *p = (char*) &da32;
	da32 = (rs->GetFieldValue("VoiceID")).lVal;
	fielddata = p[0];
	fielddata += p[1];
	fielddata += p[2];
	fielddata += p[3];
	size_array[6] = fielddata.GetLength();
	data32_2 = size_array[6];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 7, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;
}


BOOL ToDoGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += TODODB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}

