// VPSync.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "VPSync.h"
#include "VPSyncDlg.h"
#include "AboutDlg.h"
#include "ErrMsgDlg.h"
#include "FileMissingDlg.h"
#include "PortCtrl.h"
#include <process.h>

#include "vsyncmanager.h"
 
extern BOOL bIsSync;
extern BOOL g_AutoStart;
extern BOOL m_sound;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVPSyncApp

BEGIN_MESSAGE_MAP(CVPSyncApp, CWinApp)
	//{{AFX_MSG_MAP(CVPSyncApp)
	ON_COMMAND(IDM_EXIT, OnExit)
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_COMMAND(IDM_VIEWLOG, OnViewlog)
	ON_COMMAND(IDM_CONFIG, OnConfig)
	ON_COMMAND(IDM_SOUND, OnSound)
	//}}AFX_MSG_MAP
//	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVPSyncApp construction

CVPSyncApp::CVPSyncApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CVPSyncApp object

CVPSyncApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CVPSyncApp initialization



BOOL CVPSyncApp::InitInstance()
{
	HANDLE hMutex = NULL;
	CString cmdline = m_lpCmdLine;
	cmdline.MakeUpper();
	int retry = 2;

	if(cmdline.Find("/S") != -1)	// sync start automatically
		g_AutoStart = TRUE;
	else
		g_AutoStart = FALSE;

retry_loop:
	hMutex = CreateMutex(NULL, TRUE, "VTechPDAHelioSync1.0");
	if(GetLastError() == ERROR_ALREADY_EXISTS)
	{
#ifdef xxxxxxxxxxxxxxxxxxxxx
		if(g_AutoStart)
		{
			HWND h_wnd;
			h_wnd = ::FindWindow(NULL, "VSync");

			if(h_wnd)   // desktop not start
				::PostMessage(h_wnd, WM_QUIT, 0, 0);
			_spawnlp( _P_WAIT, "vsync.exe", "/s", "dummy1", NULL );
			_spawnlp( _P_NOWAIT, "vsync.exe", "dummy0", "dummy1", NULL );
		}
#endif
		if(retry--)
			goto retry_loop;
		return FALSE;   // prevent double entries
	}

	if(hMutex)
		ReleaseMutex(hMutex);

	AfxEnableControlContainer();
	setlocale(LC_ALL,"");

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CVPSyncDlg dlg;
	m_pMainWnd = &dlg;
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}



void CVPSyncApp::OnExit() 
{
	if(!bIsSync)
	  PostQuitMessage(0);
}

void CVPSyncApp::OnAbout() 
{
	// TODO: Add your command handler code here
	CAboutDlg dlg;
	dlg.DoModal();
	
}

void CVPSyncApp::OnViewlog() 
{
	// TODO: Add your command handler code here
//	ShowSyncLog();

  if(WinExec("viewlog.exe", SW_SHOW) <= 31)
  {
	  CFileMissingDlg dlg;
	  CString str;
	  str.LoadString(IDS_MISSVIEWLOG);
	  dlg.m_Msg = _T(str);
	  dlg.DoModal();
  }

}

void CVPSyncApp::OnConfig() 
{
//	PROCESS_INFORMATION inf;
	// TODO: Add your command handler code here
//  if( !CreateProcess("syncset.exe", NULL,NULL, NULL, FALSE, 0, NULL, NULL,  NULL ,&inf))
/*
  if(WinExec("syncset.exe", SW_SHOW) <= 31)
  {
	  CFileMissingDlg dlg;
	  dlg.m_Msg = _T("Configuration program is missing!");
	  dlg.DoModal();
  }
*/

CString szUser;
CString szDirectory;
CString szUserPath;
CDaoWorkspace wrk_space;
CDaoDatabase* dbProfile;
CDaoRecordset* rsData;
CString szSql;

GetAppPathSetting();
GetLastUserSetting();

szUser = (CString)m_pLastUser;
szDirectory = (CString)install_path;
szUserPath = szUser;
szUserPath += "\\";

wrk_space.Create(_T("Config"),_T("Admin"),_T(""));
wrk_space.SetDefaultUser(_T("admin"));
wrk_space.SetDefaultPassword(_T(""));

dbProfile = new CDaoDatabase(&wrk_space);
dbProfile->Open(szDirectory + "\\profile.mdb");
rsData = new CDaoRecordset(dbProfile);
rsData->Open(dbOpenSnapshot,"Select * from UserData",0);

SetCurrentDirectory(szDirectory);
if(rsData->GetRecordCount() == 0)
{
	if(!ShowVSyncManager (szUser,szDirectory,szUserPath))
	{
		  CFileMissingDlg dlg;
		  CString str;
		  str.LoadString(IDS_MISSDLL);
		  dlg.m_Msg = _T(str);
		  dlg.DoModal();
	}
	
}
else
{
	szSql = "UserName = '" + szUser;
	szSql += "'";
	if(rsData->FindFirst(szSql))
	{
		szUser = (CString)rsData->GetFieldValue("UserName").pbVal;
		szUserPath = (CString)rsData->GetFieldValue("Path").pbVal;
		if(!ShowVSyncManager (szUser,szDirectory,szUserPath))
		{
			  CFileMissingDlg dlg;
			  CString str;
			  str.LoadString(IDS_MISSDLL);
			  dlg.m_Msg = _T(str);
			  dlg.DoModal();
		}
	}
	else
	{
		if(!ShowVSyncManager (szUser,szDirectory,szUserPath))
		{
		  CFileMissingDlg dlg;
		  CString str;
		  str.LoadString(IDS_MISSDLL);
		  dlg.m_Msg = _T(str);
		  dlg.DoModal();
		}

	}

}

if(m_pLastUser)
	free(m_pLastUser);
m_pLastUser = NULL;

if(install_path)
	free(install_path);
install_path = NULL;

if(rsData)
	delete rsData;
if(dbProfile)
	delete dbProfile;

}

void CVPSyncApp::OnSound() 
{
	// TODO: Add your command handler code here
	if(m_sound)
		m_sound = 0;
	else
	    m_sound = 1;
}


int CVPSyncApp::GetAppPathSetting()
{
	DWORD dwType;
	DWORD dwSize;
	int result = 0;
	//char m_pLastUser[100];

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	if(RegQueryValueEx(hSubKey2, "AppPath", NULL, &dwType, NULL, &dwSize) != ERROR_SUCCESS)
		result = 1;
	else
	{
		if(install_path)
			free(install_path);
		install_path = (unsigned char *) malloc(dwSize+1);
		if(RegQueryValueEx(hSubKey2, "AppPath", NULL, &dwType, install_path, &dwSize) == ERROR_SUCCESS)
		{
			install_path[dwSize] = 0;
			result = 0;
		}
		else
		{
			result = 1;
		    free(install_path);
		    install_path = NULL;
		}
	}

	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

	return result;

}

int CVPSyncApp::GetLastUserSetting()
{
	DWORD dwType;
	DWORD dwSize;
	unsigned char *pBuffer;
	int result = 0;
	//char m_pLastUser[100];

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	if(RegQueryValueEx(hSubKey2, "LastUser", NULL, &dwType, NULL, &dwSize) != ERROR_SUCCESS)
		result = 1;
	else
	{
		pBuffer = (unsigned char *) malloc(dwSize+1);
		if(RegQueryValueEx(hSubKey2, "LastUser", NULL, &dwType, pBuffer, &dwSize) == ERROR_SUCCESS)
		{
			pBuffer[dwSize] = 0;
			m_pLastUser = (char*) pBuffer;
			if (!strcmp(m_pLastUser, ""))
			{
				return 1;
			}
			result = 0;
		}
		else
			result = 1;
//		free(pBuffer);
	}

	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

//	if(result)
//	  ShowErrDlg("Problem with registry setting, please configure the setting again.");

	return result;

}
