// VPSyncDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VPSync.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "ErrMsgDlg.h"
#include "ComErrDlg.h"
#include <winreg.h>
#include "RegErrDlg.h"
#include "WaitDTDlg.h"
#include "finduserdlg.h"
#include "SelectComDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MYWM_NOTIFYICON	WM_USER + 6

extern BOOL buffer_inuse;
extern HWND ghWnd;
BOOL bPortCaptured = FALSE;
BOOL bIsAbout = FALSE;
BOOL g_AutoStart = FALSE;
int sync_init_by;
BOOL m_sound;


int need_hb = 0;


extern CVPSyncDlg *pMainDlg;

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_STATIC_URL, m_URL);
	DDX_Control(pDX, IDOK, m_btnOK);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CVPSyncDlg dialog

CVPSyncDlg::CVPSyncDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVPSyncDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVPSyncDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVPSyncDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVPSyncDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVPSyncDlg, CDialog)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(CVPSyncDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	ON_WM_TIMER()
	ON_MESSAGE(WM_CHAR_IN, OnCommChar)
	ON_MESSAGE(WM_SYNC_START, OnSyncStart)
	ON_MESSAGE(WM_DLG_QUIT, OnRemoveDispDlg)
	ON_MESSAGE(MYWM_NOTIFYICON, OnIconClick)
	ON_MESSAGE(WM_COMM_RX_CHAR, AddComBuffer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVPSyncDlg message handlers

BOOL CVPSyncDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pWaitDTDlg = new CWaitDTDlg(this);
	if(m_pWaitDTDlg->GetSafeHwnd() == 0)
	{
		m_pWaitDTDlg->Create();
		m_pWaitDTDlg->ShowWindow(SW_HIDE);
	}

//CFindUserDlg ddl;
//ddl.DoModal();

	m_bIsHide = FALSE;
	m_bIsPortOpen = FALSE;
	m_pDispDlg = NULL;
	pCommCtrl = &m_Com;
	ghWnd = m_hWnd;
	pMainDlg = this;
	bIsSync = FALSE;
	sync_init_by = INIT_BY_PC;
	need_hb = 0;
	m_sound = 1;
	OpenComm();
	ShowWindow(SW_HIDE);
	if(g_AutoStart)			// start sync automatically
		if(bPortCaptured)
			PostMessage(WM_SYNC_START);
		else
			PostQuitMessage(0);
	m_Com.SetRxParent(this);
	WinExec("Core.exe", SW_HIDE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
 
void CVPSyncDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CVPSyncDlg::OnDestroy()
{
	delete m_pDispDlg;
	delete m_pWaitDTDlg;
	if(m_bIsHide)
		TrayMessage(m_hWnd, NIM_DELETE, 100, NULL, NULL);
	if(m_bIsPortOpen)
		m_Com.CloseConnection();
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVPSyncDlg::OnPaint() 
{
	static ti = 0;

	ShowWindow(SW_HIDE);
	OnTray((char*)"V-Sync:  Idle");
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVPSyncDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVPSyncDlg::OnCommChar(UINT wParam, LONG lParam)
{
	/*
	TRACE(" %d ", (char) wParam);
	m_ComBuffer += (char) wParam;
	if(ComFctPtr)
		(*ComFctPtr)((char) wParam);
*/
}

void CVPSyncDlg::OnRemoveDispDlg(UINT wParam, LONG lParam)
{
     if(m_pDispDlg)
	 {
		 delete m_pDispDlg;
		 m_pDispDlg = NULL;
		 need_hb = 0;
	 }
	 if(g_AutoStart)	// if auto start, quit after sync
		 PostQuitMessage(0);
}

void CVPSyncDlg::OnSyncStart(UINT wParam, LONG lParam)
{

	if(!bPortCaptured)
		if(!OpenComm())
			return;

	if(m_sound)
		Beep(500,500);
	SyncReq();
	TRACE("Start start");
	SetComHandleEvent(NULL);
	if(m_pDispDlg != NULL)
		OnRemoveDispDlg(0,0);

	m_pDispDlg = new CSyncDispDlg(this);
	if(m_pDispDlg->GetSafeHwnd() == 0)
	{
		m_pDispDlg->Create();
	//	m_pDispDlg->ShowWindow(SW_HIDE);
	}

}



int CVPSyncDlg::GetComSetting()
{

	DWORD dwType;
	DWORD dwSize;
	unsigned char *pBuffer;
	int result = 0;

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	if(RegQueryValueEx(hSubKey2, "ComSetting", NULL, &dwType, NULL, &dwSize) != ERROR_SUCCESS)
	{
		m_Speed = 57600;
		result = 1;
	}
	else
	{
		pBuffer = (unsigned char *) malloc(dwSize+1);
		if(RegQueryValueEx(hSubKey2, "ComSetting", NULL, &dwType, pBuffer, &dwSize) == ERROR_SUCCESS)
		{
			pBuffer[dwSize] = 0;
			m_Speed = atol((char*) pBuffer);
		}
		else
		{
			m_Speed = 57600;
			result = 1;
		}
		free(pBuffer);
	}

	if(RegQueryValueEx(hSubKey2, "SerialPort", NULL, &dwType, NULL, &dwSize) != ERROR_SUCCESS)
	{
//		if (result != 1) 
//			ShowErrDlg("COM Setting missing, please configure the setting again.");
		m_PortNum = 2;
		result = 1;
	}
	else
	{
		pBuffer = (unsigned char *) malloc(dwSize+1);
		if(RegQueryValueEx(hSubKey2, "SerialPort", NULL, &dwType, pBuffer, &dwSize) == ERROR_SUCCESS)
		{
			pBuffer[dwSize] = 0;
			if(dwSize > 4)
				m_PortNum = atol((char*) pBuffer + 3 );
			else
			{
				m_PortNum = 2;
				result = 1;
			}
		}
		else
		{
			m_PortNum = 2;
			result = 1;
		}
		free(pBuffer);
	}

	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

	m_Parity= 'n';
	m_DataBit = 8;
	m_StopBit = 1;

//	if(result)
//	  ShowErrDlg("Problem with registry setting, please configure the setting again.");

	return result;
}
 

BOOL CVPSyncDlg::OpenComm() 
{
	/* open the comm port */
	/* read the registry */
	CString msg;
	char tmp[5];
	int cont;
	int bSuccess = 0;

	if(GetComSetting())
	{
		//return FALSE;
		CRegErrDlg rgdlg;
		if( rgdlg.DoModal() != IDOK)
		{
			bPortCaptured = FALSE;
			PostQuitMessage(0);
			return FALSE;
		}
		m_PortNum = rgdlg.m_Sel+1;
	}

	itoa(m_PortNum, tmp, 10);

	switch(m_Speed)
	{
	case 57600:
	case 38400:
	case 28800:
	case 19200:
	case 9600:
		break;
	default:
		m_Speed = 57600;
	}


retry:
/*
	m_Com.SetCommPort(m_PortNum);
	m_Com.SetSettings(  (CString) Str_ul(m_Speed) + (CString)",n,8,1");
	m_Com.SetDTREnable(FALSE);
	m_Com.SetRTSEnable(FALSE);
*/
	m_Com.m_Port = m_PortNum; /* 1 - 4*/
	m_Com.m_Baud = m_Speed;
	m_Com.m_DataBits = 1 ; //0->7, 1->8
	m_Com.m_Parity = 0;    // 0-> no  1-> 1.5  2-> 2
	m_Com.m_StopBits = 0;
	m_Com.m_bSoftFlow = FALSE;
	m_Com.m_bHardFlow = FALSE;
	m_Com.SetupConnection();

	if(m_Com.OpenConnection() != TRUE)
	{
	    CSelectComDlg dlg;
		dlg.m_OldCom = m_PortNum;
		dlg.m_Msg = "Cannot open COM" + (CString)Str_ul(m_PortNum);
		if( dlg.DoModal() == IDOK)
		{
			if(dlg.m_Sel + 1 < m_PortNum)
			   m_PortNum = dlg.m_Sel + 1;
			else
				m_PortNum = dlg.m_Sel + 2;
			cont = 1;
		}
		else
			cont = 0;

		bSuccess = 0;
	}
	else
	{
		bSuccess = 1;
		cont = 0;
	}

	if( (cont == 1) && (bSuccess == 0))
		goto retry;

	if((cont == 0) && (bSuccess == 0))
		PostQuitMessage(0);

	if(bSuccess)
	{
//		m_Com.SetDTREnable(FALSE);
//		m_Com.SetRTSEnable(FALSE);

//	   m_Com.CloseConnection();
//	   m_Com.SetupConnection();
//	   m_Com.OpenConnection();
		UpdateRegistryCom("COM" + (CString)Str_ul(m_PortNum));
	   bPortCaptured = TRUE;
	   SetComHandleEvent(ComWaitForStart);
	   return TRUE;
	}
	else
	{
		bPortCaptured = FALSE;
		return FALSE;
	}
	
/*
	result = m_Com.Open();
	switch(result)
	{
		case 0:	m_bIsPortOpen = TRUE;
				SetComHandleEvent(ComWaitForStart);
//todo
//			    m_Com.Send(RECDATA_SEQ);
//				m_Com.Send((char*)"1234567890",10);
//				m_Com.Send('s');

//				PostMessage(WM_SYNC_START);
//				m_Com.Send(ST_ACK);
				return TRUE;
		case ERR_COMM_BUSY:
				msg ="COM";
				msg += tmp ;
				msg += " is used by other application!";
				break;
		case ERR_COMM_INVALID:
				msg = "\tCannot find COM";
				msg += tmp;
				msg += " !";
				break;
		default:
				msg = "\tProblem with COM";
				msg += tmp;
				break;
	}
	ShowErrDlg(msg);
	return FALSE;
	*/
}

void CVPSyncDlg::OnTray(char *tip) 
{
	// TODO: Add your control notification handler code here
	HWND hwndIcon;
	LPTSTR pszIDIcon;
	
	strcpy(m_szTip,tip);
	
	hwndIcon = GetWindow(GW_HWNDNEXT)->m_hWnd;
	pszIDIcon = MAKEINTRESOURCE(::GetDlgCtrlID(hwndIcon));
	TrayMessage(m_hWnd, NIM_ADD, 100,
		AfxGetApp()->LoadIcon(IDI_TRAY_IDLE), m_szTip);
	ShowWindow(SW_HIDE);
	m_bIsHide = TRUE;
}


void CVPSyncDlg::SetTrayTip(char *tip) 
{
	// TODO: Add your control notification handler code here
	HWND hwndIcon;
	LPTSTR pszIDIcon;
	
	strcpy(m_szTip,tip);
	
	hwndIcon = GetWindow(GW_HWNDNEXT)->m_hWnd;
	pszIDIcon = MAKEINTRESOURCE(::GetDlgCtrlID(hwndIcon));
	TrayMessage(m_hWnd, NIM_MODIFY , 100,
		AfxGetApp()->LoadIcon(IDI_TRAY_IDLE), m_szTip);
	ShowWindow(SW_HIDE);
	m_bIsHide = TRUE;
}


BOOL CVPSyncDlg::TrayMessage(HWND hDlg, DWORD dwMessage, UINT uID, HICON hIcon, PSTR pszTip)
{
    BOOL res;

	NOTIFYICONDATA tnd;

	tnd.cbSize		= sizeof(NOTIFYICONDATA);
	tnd.hWnd		= hDlg;
	tnd.uID			= uID;

	tnd.uFlags		= NIF_MESSAGE|NIF_ICON|NIF_TIP;
	tnd.uCallbackMessage	= MYWM_NOTIFYICON;
	tnd.hIcon		= hIcon;
	if (pszTip)
	{
		lstrcpyn(tnd.szTip, pszTip, sizeof(tnd.szTip));
	}
	else
	{
		tnd.szTip[0] = '\0';
	}

	res = Shell_NotifyIcon(dwMessage, &tnd);

	if (hIcon)
	    DestroyIcon(hIcon);

	return res;
}

long CVPSyncDlg::OnIconClick(UINT wParam, LONG lParam)
{
	CRect rect;
	CWnd* pWnd = NULL;
	switch (lParam)
	{
	case WM_LBUTTONDOWN:
//		TrayMessage(m_hWnd, NIM_DELETE, 100, NULL, NULL);		
//		ShowWindow(SW_SHOWNORMAL);
//		m_bIsHide = FALSE;
//		break;
		pWnd = FindWindow(NULL,"V-Sync");
		if(pWnd != NULL)
		{
//			pWnd->BringWindowToTop();
			pWnd->ShowWindow(SW_MINIMIZE);
			pWnd->ShowWindow(SW_RESTORE);
		}
		break;

	case WM_RBUTTONDOWN:
		CPoint x;
		GetCursorPos(&x);
		OnContextMenu(NULL, x); 
	}
	return 0L;
}



void CVPSyncDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	if (nType == SIZE_MINIMIZED)   /* min */
		OnTray(m_szTip);
}


void CVPSyncDlg::OnContextMenu(CWnd*, CPoint point)
{

	if(bIsSync || bIsAbout)
		return;

	// CG: This block was added by the Pop-up Menu component
	{
		if (point.x == -1 && point.y == -1){
			//keystroke invocation
			CRect rect;
			GetClientRect(rect);
			ClientToScreen(rect);

			point = rect.TopLeft();
			point.Offset(5, 5);
		}

		CMenu menu;
		VERIFY(menu.LoadMenu(IDM_POPUP));

		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);
		CWnd* pWndPopupOwner = this;

		while (pWndPopupOwner->GetStyle() & WS_CHILD)
			pWndPopupOwner = pWndPopupOwner->GetParent();

		if(m_sound)
		 pPopup->CheckMenuItem(IDM_SOUND, MF_CHECKED);
		else
		 pPopup->CheckMenuItem(IDM_SOUND, MF_UNCHECKED);
        SetForegroundWindow();
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,
			pWndPopupOwner);
        PostMessage(WM_NULL, 0, 0);
	}
}

void CVPSyncDlg::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == nTmrTimeOut)
	{
		KillTimer(nTmrTimeOut);
	}
	else
	{
		CDialog::OnTimer(nIDEvent);
	
	}
}
/*
void CVPSyncDlg::OnMenuSyncStart() 
{
	// TODO: Add your command handler code here
	PostMessage(WM_SYNC_START, NULL, NULL);
  	m_ComBuffer.Empty();
}
*/

DWORD WINAPI lxWriteBufferDelay(LPVOID c)
{
	while(buffer_inuse);
	buffer_inuse = TRUE;
	m_ComBuffer += (char) c;
	buffer_inuse = FALSE;
    if(ComFctPtr)
	   (*ComFctPtr)((char)c);

	return (DWORD) c;
}


BEGIN_EVENTSINK_MAP(CVPSyncDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CVPSyncDlg)
//	ON_EVENT(CVPSyncDlg, IDC_COMM_CTRL, 1 /* OnComm */, OnCommEvent, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

int len;

#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
void CVPSyncDlg::AddComBuffer(CString y)
{
//	HANDLE thread;
//	unsigned long x;
	int i;

	if(buffer_inuse)
	{
		TRACE("\nEnter delay write");
		while(buffer_inuse);
		TRACE("  Exit delay write");
	}
	
/*
	{
	   thread = CreateThread(NULL, 0,lxWriteBufferDelay, (LPDWORD)c, 0, &x);
	}
	else
*/
	{
		buffer_inuse = TRUE;
		for(i=0;i<y.GetLength();i++)
		{
			m_ComBuffer += y[i];
			len = m_ComBuffer.GetLength();
			if( ((len % 10240) == 0) && len)
				TRACE("\n%d ", len);
			if(ComFctPtr)
  			(*ComFctPtr)(y[i]);
		}
		buffer_inuse = FALSE;
	}
}
#endif

#define COM_BUF_SIZE	4096

#define ALL_CHAR

char combuf[COM_BUF_SIZE];

void CVPSyncDlg::AddComBuffer(UINT wParam, LONG lParam)
{
	int i;

	int len;

	len = m_Com.ReadStr(combuf, COM_BUF_SIZE);

//	clock_t start, finish;
//	start = clock();

	if(buffer_inuse)
	{
		TRACE("\nEnter delay write");
#ifdef DEBUG__
		CString string;
		string.LoadString(IDS_BUFFER);
		AfxMessageBox(string);
#endif
		TRACE("  Exit delay write");
	}

	buffer_inuse = TRUE;
	for(i=0;i<len;i++)
	{
#ifdef DEBUG__
	TRACE("\n:%c ", combuf[i]);
#endif


#ifdef ALL_CHAR
		m_ComBuffer += combuf[i];
		if(ComFctPtr)
			(*ComFctPtr)(combuf[i]);
		continue;
#endif


		if(need_hb == 2)
		{
			if( (char) combuf[i] == 0)
			{  /* rec: 0x7f -> 0x7f -> 0  => 0x7f*/
				m_ComBuffer += (char) 0x7f;
				if(ComFctPtr)
					(*ComFctPtr)(0x7f);
			}
			else
			{ /* rec: 0x7f -> 0x7f -> 1  => 0xff*/
				m_ComBuffer += (char) 0xff;
				if(ComFctPtr)
					(*ComFctPtr)(0xff);
			}
			need_hb = 0;
			continue;
		}
		if( (char) combuf[i] == (char)0x7f)
		{
			need_hb++;
			continue;
		}
		if(need_hb==1)
		{
			m_ComBuffer += (char)combuf[i] | (char)0x80;
			need_hb = 0;
			if(ComFctPtr)
				(*ComFctPtr)((char)combuf[i] | (char)0x80);

		}
		else
		{
			m_ComBuffer += combuf[i];
		if(ComFctPtr)
			(*ComFctPtr)(combuf[i]);

		}
		//if(m_ComBuffer.GetLength() % 1000==0)
		//	DoEvents();
	}

//	finish = clock();
//	double duaration = (double)(finish - start) / CLOCKS_PER_SEC;
//	if(duaration > 0.02)
//		TRACE("\nErr");
	
	buffer_inuse = FALSE;
}



#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxx
void CVPSyncDlg::OnCommEvent() 
{
	CString strEvent, strError;

	switch(m_Com.GetCommEvent())
	{
		case 1: // vbMSCommEvSend:
//			strEvent.LoadString(IDS_SENDING);
			break;
		case 2: // vbMSCommEvReceive:
//			strEvent.LoadString(IDS_RECEIVING);
			AddComBuffer(m_Com.GetInput());
			break;
		case 3: // vbMSCommEvCTS:
//			strEvent.LoadString(IDS_CTSCHANGE);
			break;
		case 4: // vbMSCommEvDSR:
//			strEvent.LoadString(IDS_DSRCHANGE);
			break;
		case 5: // vbMSCommEvCD:
//			strEvent.LoadString(IDS_CDCHANGE);
			break;
		case 6: // vbMSCommEvRing:
//			strEvent.LoadString(IDS_PHONERING);
			break;
		case 7: // vbMSCommEvEOF:
//			strEvent.LoadString(IDS_EOFDETECTED);
			break;

		case 1001: //  vbMSCommErBreak:
//			strError.LoadString(IDS_BREAKRECEIVED);
			break;
		case 1002: // vbMSCommErCTSTO:
//			strError.LoadString(IDS_CTSTIMEOUT);
			break;
		case 1003: // vbMSCommErDSRTO:
//			strError.LoadString(IDS_DSRTIMEOUT);
			break;
		case 1004: // vbMSCommErFrame:
//			strError.LoadString(IDS_FRAMEERROR);
			break;
		case 1006: // vbMSCommErOverrun:
//			strError.LoadString(IDS_OVERRUNERROR);
			break;
		case 1007: // vbMSCommErCDTO:
//			strError.LoadString(IDS_CDTIMEOUT);
			break;
		case 1008: // vbMSCommErRxOver:
//			strError.LoadString(IDS_RBUFFEROVERFLOW);
			break;
		case 1009: // vbMSCommErRxParity:
//			strError.LoadString(IDS_PARITYERROR);
			break;
		case 1010: // vbMSCommErTxFull:
//			strError.LoadString(IDS_TBUFFERFULL);
			break;
	}
/*
	if (!strEvent.IsEmpty())
		m_wndStatusBar.SetPaneText(0,strEvent);
	else
		if (!strError.IsEmpty())
		{
			AlertSound(MB_ICONEXCLAMATION);
			strError += _T("\nOK to ignore, Cancel to quit");
			int ret = AfxMessageBox(strError,MB_OKCANCEL|MB_ICONEXCLAMATION);
			if (ret==IDCANCEL)
				m_commctrl.SetPortOpen(FALSE);
		}
*/
}
#endif
extern BOOL bRun;
void CVPSyncDlg::DoEvents()
{
	MSG msg;

	// Process existing messages in the application's message queue.
	// When the queue is empty, do clean up and return.
	while (::PeekMessage(&msg,NULL,0,0,PM_NOREMOVE) && bRun)
	{
		if (!AfxGetThread()->PumpMessage())
			return;
	}
}

int CAboutDlg::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
	bIsAbout = TRUE;
	return CDialog::DoModal();
}

void CAboutDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	bIsAbout = FALSE;	
	// TODO: Add your message handler code here
	
}

void CVPSyncDlg::UpdateRegistryCom(CString szCom)
{
	char *value;

	value = new char[szCom.GetLength() + 1];
	
	szCom.TrimRight();

	value[0] = 0;
	for(int i=0;i<szCom.GetLength();i++)
		value[i] = szCom[i];
	value[i] = 0;

	HKEY hKey, hSubKey0, hSubKey1, hSubKey2;

	RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_READ, &hKey);
	RegOpenKeyEx(hKey, "VB and VBA Program Settings", 0, KEY_READ, &hSubKey0);

	RegOpenKeyEx(hSubKey0, "VTECH PDA", 0, KEY_READ, &hSubKey1);
	RegOpenKeyEx(hSubKey1, "HelioX", 0, KEY_READ, &hSubKey2);

	RegSetValueEx(  hSubKey2,           // handle to key to set value for
	  "SerialPort", // name of the value to set
		0,      // reserved  DWORD dwType,        // flag for value type
		REG_SZ,
		(unsigned char*)value,  // address of value data
		strlen(value));         // size of value data); 
	
	RegCloseKey(hSubKey2);
	RegCloseKey(hSubKey1);
	RegCloseKey(hSubKey0);
	RegCloseKey(hKey);

	delete []value;

}
