#include "stdafx.h"
#include "resource.h"
#include "syncdb.h"
#include "voice.h"
#include "TimeFct.h"
#include "all_db.h"
#include "longtimedlg.h"
#include "SyncDispDlg.h"

extern CSyncDispDlg *m_DispDlg;
extern int nPDA2PC;
extern int nPC2PDA;

#define SYNC_THRESHOLD_SIZE	100

//#define SetRecFrag(rec_ptr)	((rec_ptr->attribute) |= 0x20)
//#define ClrRecFrag(rec_ptr)	((rec_ptr->attribute) &= 0xDF)
 
typedef struct
{
	char	yr;
	char	mon;
	char	day;
	char	hr;
	char	min;
	char    sec;
} VOX_DATE;

CString VoxPDADate2PC(CString date)
{
	// date: BYTE 0: Year relative to DATE_OFFSET, BYTE 1: M, BYTE 2: D 
	//       BYTE 3: Hr  BYTE 4: Min
	COleDateTime dtime;
	
	if(date.GetLength() < 6)
	{
		TRACE("\nError in VoxRecord Date");
		dtime.GetCurrentTime();
		CString szDate = dtime.Format("%x");
		SqlDateHandle(szDate);
        return szDate;
//        return dtime.Format("%B %d %Y");
	}

	if(date[1] < 1) date.SetAt(1,1); //mon
	else if(date[1] > 12) date.SetAt(1,12);
	if(date[2] < 1) date.SetAt(2,1); //day
	else if(date[2] > 31) date.SetAt(2,31);
	if(date[3] > 23) date.SetAt(3,23); //hr
	if(date[4] > 59) date.SetAt(4,59);  // min
//	if(date[0] < (1970 - DATE_OFFSET))  // PC need time at least at 1970
//		date.SetAt(0, 1970 - DATE_OFFSET);
//	else if(date[0] + DATE_OFFSET > (2036))		// PC need time before 2036
//		date.SetAt(0,36);
	if((unsigned char) date[5] > 59)
		date.SetAt(5,0);

	COleDateTime time1(date[0]+DATE_OFFSET, date[1], date[2], date[3], date[4], date[5]);

	CString szDate = time1.Format("%x %X");
	SqlDateHandle(szDate);
	return szDate;
//	return time1.Format("%b %d %Y %H:%M:%S");
}

CString VoxPCDate2PDA(COleDateTime date)
{
	CString time1;
	
	time1 = (char) (date.GetYear() - 2000);
	time1 += (char) date.GetMonth();
	time1 += (char) date.GetDay();
	time1 += (char) date.GetHour();
	time1 += (char) date.GetMinute();
	time1 += (char) date.GetSecond();

	return time1;
}

CString VoxGetFilePath(CDaoDatabase *src_db)
{
	CString filename;

	filename = szUserPath;
	if((void*)src_db == (void*)dbCurrent)
		filename += "Vox\\";
	else if((void*)src_db == (void*)dbArchive)
		filename += "Vox\\";
	else if((void*)src_db == (void*)dbRecycle)
		filename += "Vox\\";
	else
		filename += "Vox\\";

	return filename;
}

CString VoxGetExternFileName(RecordID rec_id)
{
	CString name;

	name.Format("%08x.alp", rec_id);

	return name;
}

BOOL VoxDeleteExternFile(CDaoDatabase *src_db, RecordID rec_id)
{
	CString szSql, filename;
	COleVariant dbdata;
	CDaoRecordset *rs = NULL;
	BOOL ret = TRUE;

	szSql = "select FileName from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		goto skipdelfile;
	}

	if(!rs->IsBOF())     // delete the voice 
	{
		rs->MoveFirst();
		dbdata = rs->GetFieldValue(0);
		if ((LPCSTR) dbdata.bstrVal)
		{
			filename = VoxGetFilePath(src_db);
			filename += (LPCSTR) dbdata.bstrVal;
			if (DeleteFile(filename) == 0)
				TRACE("\nUnable to delete file %s ", filename);
			else
				ret = FALSE;
		}
		rs->Close();
	}
	if(rs)
		delete rs;
	ret = FALSE;
skipdelfile:
	return ret;
}

BOOL VoxCreateExternFile(CDaoDatabase *src_db, RecordID rec_id, CString *content)
{
	CString filename;
	CFileException e;
	CFile file;
	char *buffer;

	filename = VoxGetFilePath(src_db) + VoxGetExternFileName(rec_id);

	try
	{
		if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return TRUE;
	}
	
	buffer = (char*) content->GetBuffer(content->GetLength());

	try
	{
		file.WriteHuge(buffer, content->GetLength() );
	}

    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		content->ReleaseBuffer();
		return TRUE;
	}

	content->ReleaseBuffer();

	file.Close();

	return FALSE;
}


BOOL VoxMoveExternFile(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString src_pathname;
	CString dest_pathname;

	src_pathname = VoxGetFilePath(src_db) + VoxGetExternFileName(rec_id);
	dest_pathname = VoxGetFilePath(dest_db) + VoxGetExternFileName(rec_id);


	if(!MoveFile(src_pathname, dest_pathname))
	{
		TRACE("\nCannot move file form %s  to \n   %s ", src_pathname, dest_pathname);
		return TRUE;
	}
	
	return FALSE;
 
}
 

BOOL VoxDeleteRecord(CDaoDatabase *src_db, RecordID rec_id)
{
	CString szSql;

	if (!CatRec(rec_id))
		VoxDeleteExternFile(src_db, rec_id);

	szSql = "delete from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}
	return FALSE;
}


BOOL VoxChkSize(RecordID rec_id, int size)
{

	return TRUE;
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
/*
	CString szSql;
	CString fielddata;

	if(size > SYNC_THRESHOLD_SIZE)
	{
		CLongTimeDlg t_dlg;

		t_dlg.m_msg = "The following sound record \r\n\r\n[ ";
		t_dlg.m_msg += "Unkown record in PDA";
		t_dlg.m_msg += " ]\r\n\r\nestimated to take ";
		t_dlg.m_msg += Str_ul(size / 3800);
		t_dlg.m_msg += " seconds to synchronize.";
		t_dlg.m_msg += "\r\nDo you want to synchronize this record?";

		t_dlg.DoModal();

		if(t_dlg.result == 1)  // not sync
		{

		VoxDeleteRecord(dbCurrent, rec_id);

	szSql = "insert into ";
	szSql += VOXDB;
	szSql += "(RecordID, ModifyDate, Category, Secret, Lock, ";
	szSql += "RecDate, Filename, Silent, Notes) values (";

	szSql += Str_ul(rec_id + 0x80000000);

	szSql += ", ";
	szSql += "# 5 Aug 1999 12:0:0#";
	szSql += ", 0";
	szSql += ", ";
	szSql += "FALSE, ";
	szSql += "FALSE, ";
	
	szSql += "#Aug 1 1999 #";
// field 1 is the vox data, sotre in extern file
	szSql += " ,'";
	szSql += VoxGetExternFileName(rec_id);
	szSql += "','";

// field 2 is the slient data, store in extern file, skipped in this version
	szSql += "', '')";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	fielddata = "VTech Helio Voice file not sync";

	VoxCreateExternFile(dbCurrent, rec_id, &fielddata);

	return FALSE;
		}	
	}

	return TRUE;
*/
#endif
}


BOOL VoxAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{

	CString szSql;
	CString fielddata;
	COleVariant dbdata;
	CString filename;
	CString szHead;
	CString szTail;
	int is_sync = TRUE;

//	if (CatRec(rec_id))
//		return VoxAddCat(dbCurrent, rec_id, rec_header, rec_content);
	if(rec_id == 0)
		return FALSE;
	if(rec_content->IsEmpty())
		return FALSE;

	VoxDeleteRecord(src_db, rec_id);

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += VOXDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

// field 0 is date, the format is BYTE0 M, BYTE1 D, BYTE2 Year, relative to DATE_OFFSET
	PDADataGetField(0, rec_content, &fielddata);
	if(VoxPDADate2PC(fielddata) == "NULL")
		rsCurrent->SetFieldValueNull("RecDate");
	else
		rsCurrent->SetFieldValue("RecDate",(LPCTSTR)VoxPDADate2PC(fielddata));

// field 1 is the vox data, sotre in extern file
	rsCurrent->SetFieldValue("Filename",(LPCTSTR)VoxGetExternFileName(rec_id));

// field 2 is the slient data, store in extern file, skipped in this version
	rsCurrent->SetFieldValue("Silent",(LPCTSTR)"");

//notes
	SyncIdleMode(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;
	SyncReadField(dbid, rec_id, 3, &fielddata);
	CHKTERM;
	SyncIdleMode(); CHKTERM;
	SyncDBEnqMode(); CHKTERM;

	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Notes",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	PDADataGetField(1, rec_content, &fielddata);
	VoxCreateExternFile(src_db, rec_id, &fielddata);

	nPDA2PC++;
terminate:
	return FALSE;
}


BOOL VoxMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;
	int i;

	
	if (CatRec(rec_id))
		return VoxMoveCat(src_db, dest_db, rec_id);

	// delete record in dest
	VoxDeleteRecord(dest_db, rec_id);

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += VOXDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);


	fielddata = rs->GetFieldValue(5);	/* recorder date */
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue(5,(LPCTSTR)szStr);

	for(i=6;i<9;i++)
	{
		fielddata = rs->GetFieldValue(i);
		if ((LPCSTR) fielddata.bstrVal)
			szStr = ((LPCSTR) fielddata.bstrVal);
		rsCurrent->SetFieldValue(i,(LPCTSTR)szStr);
	}


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	VoxMoveExternFile(src_db, dest_db, rec_id);

	szSql = "delete from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
			delete rs;
		return TRUE;
	}

	if(rs)
		delete rs;

	return FALSE;
}

BOOL VoxAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += VOXDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Name1st",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return FALSE;
}



BOOL VoxMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;
	int i;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += VOXDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Filename");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Filename",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	szSql = "delete from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
			delete rs;
		return TRUE;
	}

	if(rs)
		delete rs;

	return FALSE;
}

BOOL VoxArchivePDAOvrPC(DatabaseID dbid)
{

	int total_rec, i, sync_rec_total;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	sync_rec_total = total_rec;

//	if(total_rec)
//		m_DispDlg->UpdateRemainDec();//(sync_rec_total);

	for(i=0;i<total_rec;i++)
	{
		if(DBCompDate(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
		{
		  SyncIdleMode(); CHKTERM;
		  SyncDBUpMode(); CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  CHKTERM;
		  SyncIdleMode(); CHKTERM;
		  SyncDBEnqMode(); CHKTERM;
		  VoxMoveRecord(dbCurrent, dbArchive,((RecordHeader)(record[i].rec_header)).rec_id);
		  m_DispDlg->UpdateRemainDec();//(--sync_rec_total);
			continue;
		}

		rec_content.Empty();
		SyncReadRecLarge(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
//		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		CHKTERM;
		m_DispDlg->UpdateRemainDec();//(--sync_rec_total);
//		if(DBIsExistRecord(dbArchive, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			PCDeleteRecord(dbRecycle, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			VoxDeleteExternFile(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		VoxAddRecord(dbArchive, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode(); CHKTERM;
		  SyncDBUpMode(); CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  CHKTERM;
		  SyncIdleMode(); CHKTERM;
		  SyncDBEnqMode(); CHKTERM;
		}
	}
terminate:
	if(record)
	   free(record);

	return 0;
}



BOOL VoxArchivePCOvrPDA(DatabaseID dbid)
{ 
	return VoxArchivePDAOvrPC(dbid);
}



BOOL PDAVoxAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{

	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[5];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;
	CString not_sync_data;

	if(rec_id <= 0 )
		return FALSE;

	szSql = "select * from ";
	szSql += VOXDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */
	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 4;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

//	if((rs->GetFieldValue(3)).boolVal)
//		SetRecSecret(((RecordHeader*)&header));
//	if((rs->GetFieldValue(4)).boolVal)
//		SetRecLock(((RecordHeader*)&header));

	fielddata = VoxPCDate2PDA(COleDateTime((rs->GetFieldValue(5))));
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	not_sync_data = content;

	CString filename;
	CFileException e;
	CFile file;
	char *buffer;

	filename = VoxGetFilePath(src_db) + VoxGetExternFileName(rec_id);

	if(!ExistFile(filename))
		return TRUE;


	try
	{
	if( !file.Open( filename, CFile::modeRead|CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		if(rs)
		{
			rs->Close();
			delete rs;
		}
		return TRUE;
	}

	file.SeekToEnd();
	file.SeekToBegin();

	int filelen = file.GetLength();
	CString voxdata;

	try
	{
	buffer = (char*) voxdata.GetBufferSetLength(filelen);
	}
	catch (CMemoryException *ee)
	{
		ee->Delete();
	}
	
	try
	{
		file.ReadHuge(buffer, file.GetLength());
	}
    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		if(rs)
		{
			rs->Close();
			delete rs;
		}

		return TRUE;
	}

	file.Close();
	voxdata.ReleaseBuffer(filelen);
//		voxdata.ReleaseBuffer(6100);

	size_array[1] = voxdata.GetLength();
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += voxdata;
	
	size_array[2] = 0;
	data32_2 = size_array[2];
	   EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

	fielddata = (LPSTR)(rs->GetFieldValue("Notes")).bstrVal;
	AddNULL(&fielddata);
	size_array[3] = fielddata.GetLength();
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	header.size = content.GetLength();

#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
/*	if(header.size > SYNC_THRESHOLD_SIZE)
	{
		CLongTimeDlg t_dlg;

		t_dlg.m_msg = "The following sound record \r\n\r\n[ ";
		t_dlg.m_msg += (LPSTR)(rs->GetFieldValue("Notes")).bstrVal;
		t_dlg.m_msg += " ]\r\n\r\nestimated to take ";
		t_dlg.m_msg += Str_ul(header.size / 4000);
		t_dlg.m_msg += " seconds to synchronize.";
		t_dlg.m_msg += "Do you want to synchronize this record?";

		t_dlg.DoModal();

		if(t_dlg.result == 1)  // not sync
		{
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			size_array[1] = 0;
			data32_2 = size_array[1];
		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  not_sync_data += ptr[j];
			size_array[2] = 0;
			data32_2 = size_array[2];
 		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  not_sync_data += ptr[j];		
			size_array[3] = 13;
			data32_2 = size_array[3];
 		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  not_sync_data += ptr[j];
			not_sync_data += "Rec not sync";
			AddNULL(&not_sync_data);
			content = not_sync_data;
			header.size = content.GetLength();
#endif

			szSql = "Update ";
			szSql += VOXDB;
			szSql += " set Lock = TRUE, Secret = FALSE where RecordID = ";
			szSql += Str_ul(rec_id);

			BOOL is_fault = FALSE;
			try
			{
				src_db->Execute(szSql);
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\ncannot exe SQL statement %s ", szSql);
				is_fault = TRUE;
			}

			if(!is_fault)
				return FALSE;
			CString string;
			string.LoadString(IDS_SKIPRECORD);
			AfxMessageBox(string);
		}
	}
*/
#endif

	if(header.size > 4080)
	{
		header.size = 4096;
		header.attribute |= 0x20;
	}

	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

//	SyncIdleMode();
//	SyncDBUpMode();
	SyncRecAddLarge(dbid, rec_id, 4, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;

}


BOOL VoxGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	// todo

	*last_pda_recid = 0;
	*last_pc_recid = 0x100000;

	return TRUE;
}

