#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "phonebk.h"
#include "voice.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"

extern BOOL bRun;
extern BOOL recycle_pda_vox;
extern int station_num;

CString VoxValidDBDate(COleDateTime *d)
{
	if (d->GetStatus() != COleDateTime::valid)
			return "";
	else
	{
		CString szDate = d->Format("%x");
		SqlDateHandle(szDate);
		return szDate;
	}
//		return d->Format("%B %d %Y");
}


CString VoxValidDBDateForDisp(COleDateTime *d)
{
	if (d->GetStatus() != COleDateTime::valid)
			return "";
	else
	{
		CString szDate = d->Format("%x %X");
		SqlDateHandle(szDate);
		return szDate;
//		return d->Format("%B %d %Y %H:%M:%S");
	}
}

int CSyncDispDlg::UpdateDatabasePDAOvrPCVox()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec, total_arc_rec = 0;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL, *arc_record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;
	int sync_rec_total = 0;

	szSql = "update ";
	szSql += VOXDB;
	szSql += " set Lock = FALSE ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *ex)
	{
		TRACE("\nCannot exe sql %s ", szSql);
		ex->Delete();
	}

	szSql = "delete * from ";
	szSql += VOXDB;
	szSql += " where RecordID < 0 ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *ex)
	{
		TRACE("\nCannot exe sql %s ", szSql);
		ex->Delete();
	}

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_VOXDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 10000)
		return 1;

	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);
	if(arc_record)
		free(arc_record);
	CHKTERM;

	sync_rec_total = total_arc_rec;

////////////////////
// find num rec to sync
	for(i=0;i<total_rec;i++)
	{
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
		sync_rec_total++;
	}

	if(sync_rec_total)
	{
		m_remain = sync_rec_total;

		UpdateRemain(sync_rec_total);
	}
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		 SyncReadRecLarge(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		 UpdateRemainDec();//(--sync_rec_total);

		DoEvents();
		if(DBIsExistRecord(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			VoxMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		DoEvents();
		VoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
		}

		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += VOXDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			VoxMoveRecord(dbCurrent, dbRecycle, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	CHKTERM;
	VoxArchivePDAOvrPC(dbid);
	UpdateLastRecID(VOXDB,1000);
	return 0;

terminate:
	if(rs)
		delete rs;

	return 1;
}

void CSyncDispDlg::UpdateRemain(int remain)
{
	if(remain <= 0)
		return;
	m_RemainRec.Format("Remain: %d rec", remain);
	UpdateData(FALSE);
//	Invalidate();
}


void CSyncDispDlg::UpdateRemainDec()
{
	if(m_remain <= 0)
		m_remain = 1;
	m_RemainRec.Format("Remain: %d rec", --m_remain);
	UpdateData(FALSE);
//	Invalidate();
}


void CSyncDispDlg::ClrRemain()
{
	m_RemainRec = "";
	UpdateData(FALSE);
//	Invalidate();
}

int CSyncDispDlg::UpdateDatabasePCOvrPDAVox()
{
	DatabaseID dbid;
	int total_rec, total_arc_rec = 0; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL, *arc_record = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
	int sync_rec_total = 0;

	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();

	CHKTERM;

/*
	if(sys_crashed == RESTORE_PC)
		VoxRecIDCrashRecover();
*/

	szSql = "update ";
	szSql += VOXDB;
	szSql += " set Lock = FALSE ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *ex)
	{
		TRACE("\nCannot exe sql %s ", szSql);
		ex->Delete();
	}


	szSql = "delete * from ";
	szSql += VOXDB;
	szSql += " where RecordID < 0 ";
//	szSql += " where RecordID >  ";
//	szSql += Str_ul(0x80000000);
	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *ex)
	{
		TRACE("\nCannot exe sql %s ", szSql);
		ex->Delete();
	}


/* send all record header data from PDA */
	if(SyncDBInfo(PDA_VOXDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;
	
	CHKTERM;

	total_rec = 0;

	CHKTERM;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record) != 0)
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;
/*
	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);
	CHKTERM;

	if(arc_record)
	{
	    SyncIdleMode(); CHKTERM;
	    SyncDBUpMode(); CHKTERM;
		for(i=0;i<total_arc_rec;i++)
		{
		  PDADeleteRecord(dbid, ((RecordHeader*)&(arc_record[i].rec_header))->rec_id);
		  CHKTERM;
		}
	}
*/
  SyncIdleMode(); CHKTERM;
  SyncDBEnqMode(); CHKTERM;

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += VOXDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat

	szSql += " order by RecordID DESC ";
	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs->Close();
	}


	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);
	if(arc_record)
		free(arc_record);
	CHKTERM;

	sync_rec_total = total_arc_rec;


///////////////////////////////////
//  count num of rec to sync
	if(total_rec != 0)
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   if(sys_crashed == RESTORE_PC)
		   {
			sync_rec_total++;
		   }
	   }
	   else
	   {
		if(DBCompDate(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
			sync_rec_total++;
	   }

	}

//	if(sync_rec_total)
	//	
//	{
//		m_remain = sync_rec_total;
//		UpdateRemain(sync_rec_total);
//	}

	if(!rs->IsBOF())
	{
		rs->MoveFirst();
		while(!rs->IsEOF())
		{
			sync_rec_total++;
			rs->MoveNext();
		}
	}

	if(sync_rec_total)
	{
		m_remain = sync_rec_total;
		UpdateRemain(sync_rec_total);
	}

	VoxArchivePCOvrPDA(dbid);
	CHKTERM;

/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	          VoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  rec_content.Empty();
			  UpdateRemainDec();//(--sync_rec_total);
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDAVoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		  UpdateRemainDec();//(--sync_rec_total);
		  UpdateLastSyncPCRecID(VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id);
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDAVoxAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			UpdateRemainDec();//(--sync_rec_total);
			UpdateLastSyncPCRecID(VOXDB, (rs->GetFieldValue(0)).lVal);
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	if(arc_record)
		free(arc_record);
	UpdateLastRecID(VOXDB, 1000);

	CHKTERM;
	return 0;

terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncVox()
{
	DatabaseID dbid;
	int total_rec, total_arc_rec = 0;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL, *arc_record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
	CDaoRecordset *rs_not_sync = NULL;
	CString rec_not_sync_string;
	CString msg;
	int sync_rec_total = 0;

   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 2;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 280;
   missrec_dlg.row_height[1] = 280;

   CString str;
   str.LoadString(IDS_MODIFYDATE);
   missrec_dlg.m_Content[0][0] = str;
   str.LoadString(IDS_NOTE);
   missrec_dlg.m_Content[1][0] = str;

   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 2;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 280;
   duprec_dlg.row_height[1] = 280;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_NOTE);
   duprec_dlg.m_ContentPC[1][0] = str;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_NOTE);
   duprec_dlg.m_ContentPDA[1][0] = str;

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_VOXDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	GetLastSyncRecID(VOXDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(VOXDB, &last_sync_date);
	
	szSql = "update ";
	szSql += VOXDB;
	szSql += " set Lock = FALSE, Secret = TRUE ";
	szSql += " where ModifyDate > ";
	szSql += _date322DB(_rtm2date32(last_sync_date));
	szSql += " and Lock = TRUE ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CException *ex)
	{
		TRACE("\nCannot exe sql %s ", szSql);
		ex->Delete();
	}

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 12000)
		return 1;

	SyncRecArcInfoReq(dbid, &total_arc_rec, (RecStruct**)&arc_record);

	CHKTERM;

	sync_rec_total = total_arc_rec;
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxx
/* find not sync record */
	szSql = "select RecordID - ";
	szSql += Str_ul(0x80000000);
	szSql += " as ID from ";
	szSql += VOXDB;
	szSql += " where RecordID < 0";
	
	rs_not_sync = new CDaoRecordset(dbCurrent);
	try
	{
		rs_not_sync->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_not_sync = NULL;
	}

	if(!rs_not_sync->IsBOF())
	{
		RecordID xrecid;
		while(!rs_not_sync->IsEOF())
		{
		  xrecid = rs_not_sync->GetFieldValue(0).lVal;
			  for(i=0;i<total_rec;i++)
				  if(((RecordHeader)(record[i].rec_header)).rec_id == xrecid)
					if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
						record[i].rec_header.rec_id = 0;
			rs_not_sync->MoveNext();
		}
	}
#endif
/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += VOXDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID > 0 ";
	}
	else
		szSql += " where RecordID > 0"; // for email msg only, not condiser cat

	if(total_arc_rec)
	{
		szSql += " and RecordID not in(";
		for(i=0;i<total_arc_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(arc_record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")";
	}

	if(arc_record)
		free(arc_record);

	szSql += " and LOCK = FALSE ";  // lock->not sync
	szSql += " order by RecordID DESC";

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += VOXDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}

////////////////////////////////////////////////
// count # of record need to update

	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   { 
			sync_rec_total++;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { 
		   }
		   else
		   {
			sync_rec_total++;
		   }
	   }
	   }
	}
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{ 
				sync_rec_total++;
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ 
			}
			else
			{
				sync_rec_total++;
			}
			rs_pc->MoveNext();
		}
		rs_pc->MoveFirst();
	}
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ 
			sync_rec_total++;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ 
			sync_rec_total++;
			}
			else
			{ 
			sync_rec_total++;
			} 
		  rs_both->MoveNext();
	  }
	} 
	  	  rs_both->MoveFirst();
	}



////////////////////////////////////////////

	if(sync_rec_total)
	{
		m_remain = sync_rec_total;
		UpdateRemain(sync_rec_total);
	}

	VoxArchivePCOvrPDA(dbid);

	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
		  TRACE("\n%d" ,((RecordHeader)(record[i].rec_header)).rec_id);
	   if(!DBIsExistRecord(dbCurrent, VOXDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  VoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  UpdateRemainDec();//(--sync_rec_total);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxx
			  if(recycle_pda_vox)
			  {
			  CHKTERM;
		      SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  VoxAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
#endif
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			   int action;

			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
				   }
 				   action = missrec_act;
			   }
			else if(DBIsExistRecord(dbCurrent, VOXDB, record[i].rec_header.rec_id  - 0x80000000))
			{
				PCDeleteRecord(dbCurrent, VOXDB, record[i].rec_header.rec_id  - 0x80000000);
				action = SYNC_REC; // record in PDA but select not sync to PC before, but now modify in PDA
			}
			   else
			   {
			   CHKTERM;
			   missrec_dlg.total_rows = 2;
			   missrec_dlg.total_cols = 2;

				CString str;
				str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;

			   rec_content.Empty();
			   missrec_dlg.m_Content[0][1] =  _date322DB((record[i].rec_header).modi_date);  // date
			   missrec_dlg.m_Content[0][1] = missrec_dlg.m_Content[0][1].Left(missrec_dlg.m_Content[0][1].GetLength()-1);
			   missrec_dlg.m_Content[0][1] = missrec_dlg.m_Content[0][1].Right(missrec_dlg.m_Content[0][1].GetLength()-1);

			   fielddata.Empty(); // Note
			   rec_content.Empty();
			   missrec_dlg.m_Content[1][1] = ""; //"Unknown";

			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					  rec_content.Empty();
			          SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 				   VoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
				   UpdateRemainDec();//(--sync_rec_total);

					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
					   UpdateRemainDec();//(--sync_rec_total);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
					   UpdateRemainDec();//(--sync_rec_total);
					   break;
				   default:
					   UpdateRemainDec();//(--sync_rec_total);
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
              CHKTERM;
		   }
	   }
}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{

			CHKTERM;
//			if((rs_pc->GetFieldValue(0)).lVal <= last_pc_recid)
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDAVoxAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
				UpdateRemainDec();//(--sync_rec_total);
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
				VoxMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */
			int action;

			if(rs_pc->GetFieldValue("Secret").boolVal)
				action = SYNC_REC;

			else if(missrec_act)
				action = missrec_act;
			else
			{
				CString str;
				str.LoadString(IDS_MISS_PDA);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PDA);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPC);
			   missrec_dlg.m_szMissLabel = str;
	   
			   //Date
			   missrec_dlg.m_Content[0][1] = VoxValidDBDateForDisp(&COleDateTime((rs_pc->GetFieldValue("ModifyDate"))));
				   
			   // Note
			   missrec_dlg.m_Content[1][1] = (LPSTR)(rs_pc->GetFieldValue("Notes")).bstrVal;;
				str.LoadString(IDS_SYNCTOPDA);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDAVoxAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
					   UpdateRemainDec();//(--sync_rec_total);
				   break;
				   case DEL_REC:
		   			   VoxMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   UpdateRemainDec();//(--sync_rec_total);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
					   UpdateRemainDec();//(--sync_rec_total);
					   break;
				   default:
					   UpdateRemainDec();//(--sync_rec_total);
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;
			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
				TRACE("nnn");
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */

			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  VoxMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  VoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  UpdateRemainDec();//(--sync_rec_total);
		      rec_content.Empty();
			  CHKTERM;

			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				CHKTERM;
				PDAVoxAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
				UpdateRemainDec();//(--sync_rec_total);
				CHKTERM;
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
			   int action;

				if (abs(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(record[i].rec_header.modi_date))) > 2)
			   {

			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 	//  	              SyncIdleMode(); CHKTERM;
      //                SyncDBEnqMode(); CHKTERM;
				   }
					action = duprec_act;
			   }
			   else
			   {
				   ///////////////// prepare PDA content
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
// 	  	              SyncIdleMode(); CHKTERM;
  //                    SyncDBEnqMode(); CHKTERM;

// RTM xx = DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate"))));
 //RTM yy = _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date);
				CString str, str1;
				str.LoadString(IDS_MODIFY);
				str1.LoadString(IDS_Q_MODIFY);

               duprec_dlg.WndTitle = str;
			   duprec_dlg.m_szDupMsg = str1;

			   rec_content.Empty();

			   duprec_dlg.m_ContentPDA[0][1] =  _date322DB((record[i].rec_header).modi_date);  // date
			   duprec_dlg.m_ContentPDA[0][1] = duprec_dlg.m_ContentPDA[0][1].Left(duprec_dlg.m_ContentPDA[0][1].GetLength()-1);
			   duprec_dlg.m_ContentPDA[0][1] = duprec_dlg.m_ContentPDA[0][1].Right(duprec_dlg.m_ContentPDA[0][1].GetLength()-1);


				   
			   fielddata.Empty(); // Note
			   rec_content.Empty();
			   duprec_dlg.m_ContentPDA[1][1] = ""; //"Unknown";

			    ///////////////////  Prepare PC content

			   //Date
			   duprec_dlg.m_ContentPC[0][1] = VoxValidDBDateForDisp(&COleDateTime((rs_both->GetFieldValue("ModifyDate"))));
				   
			   // Note
			   duprec_dlg.m_ContentPC[1][1] = (LPSTR)(rs_both->GetFieldValue("Notes")).bstrVal;;

			   duprec_dlg.DoModal();

			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDAVoxAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   UpdateRemainDec();//(--sync_rec_total);
					   break;
				   case SYNC_TO_PC:
		   			   VoxMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   rec_content.Empty();
					   SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
					   CHKTERM;
					   VoxAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   UpdateRemainDec();//(--sync_rec_total);
			           CHKTERM;

					   break;
				   case NOT_SYNC:
					   UpdateRemainDec();//(--sync_rec_total);
				   default:
					   UpdateRemainDec();//(--sync_rec_total);
					   break;
			   }
			   }
			   else
				   UpdateRemainDec();//(--sync_rec_total);

	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			} // if
		  rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 0x3fffffff)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}


	if(record)
	{
	   free(record);
	   record = NULL;
	}

	CHKTERM;
//	VoxArchivePCOvrPDA(dbid);


	UpdateLastRecID(VOXDB, last_pda_recid);
	
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}
