// commport.cpp : implementation file
//

// Standard header files
#include "stdafx.h"
//#include "adp.h"
#include "resource.h"
// Supplementary header files
#include "commport.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define Min(x, y)	x < y ? x : y

/////////////////////////////////////////////////////////////////////////////
// CCommPort data processing

CCommPort::CCommPort()
{
	m_pParent = NULL;
	m_hComDev = NULL;
	m_bConnect = FALSE;
	m_pWatchThread = NULL;

	m_osRead.Offset = 0;
	m_osRead.OffsetHigh = 0;
	m_osRead.hEvent = ::CreateEvent(NULL, TRUE, FALSE, NULL);
	m_osWrite.Offset = 0;
	m_osWrite.OffsetHigh = 0;
	m_osWrite.hEvent = ::CreateEvent(NULL, TRUE, FALSE, NULL);

}

CCommPort::~CCommPort()
{
	::CloseHandle(m_osRead.hEvent);
	::CloseHandle(m_osWrite.hEvent);
}

void CCommPort::InitPortData(LPCTSTR section)
{
	m_Section = section;

	// initialization as need for the 1st connection 
    m_PrevPort = 0;

	// get the initialize data from the .INI file
	GetPortData();

}

void CCommPort::GetPortData()
{
	int nMaxCommPort = AfxGetApp()->GetProfileInt("Setup", "MaxCommPort", 3);
	// retrieve data from .INI file
	m_Port = AfxGetApp()->GetProfileInt(m_Section, "Port", 0);
	if (m_Port < 0 || m_Port > nMaxCommPort)
		m_Port = 0;

	m_Baud = AfxGetApp()->GetProfileInt(m_Section, "BaudRate", 5);
	if (m_Baud < 0 || m_Baud > 7)
		m_Baud = 5;

	m_DataBits = AfxGetApp()->GetProfileInt(m_Section, "DataBits", 1);
	if (m_DataBits < 0 || m_DataBits > 1)
		m_DataBits = 1;

	m_StopBits = AfxGetApp()->GetProfileInt(m_Section, "StopBits", 0);
	if (m_StopBits < 0 || m_StopBits > 2)
		m_StopBits = 0;

	m_Parity = AfxGetApp()->GetProfileInt(m_Section, "Parity", 0);
	if (m_Parity < 0 || m_Parity > 2)
		m_Parity = 0;

	m_bSoftFlow = (BOOL)AfxGetApp()->GetProfileInt(m_Section, "SoftFlow", FALSE);
	m_bHardFlow = (BOOL)AfxGetApp()->GetProfileInt(m_Section, "HardFlow", FALSE);
}

void CCommPort::SetPortData()
{
	// set the changed data to the .INI file
	AfxGetApp()->WriteProfileInt(m_Section, "Port", m_Port);
	AfxGetApp()->WriteProfileInt(m_Section, "BaudRate", m_Baud);
	AfxGetApp()->WriteProfileInt(m_Section, "DataBits", m_DataBits);
	AfxGetApp()->WriteProfileInt(m_Section, "StopBits", m_StopBits);
	AfxGetApp()->WriteProfileInt(m_Section, "Parity", m_Parity);
	AfxGetApp()->WriteProfileInt(m_Section, "SoftFlow", m_bSoftFlow);
	AfxGetApp()->WriteProfileInt(m_Section, "HardFlow", m_bHardFlow);
}

void CCommPort::operator=(const CCommPort& dataSrc)
{
	m_Port = dataSrc.m_Port;
	m_Baud = dataSrc.m_Baud;
	m_DataBits = dataSrc.m_DataBits;
	m_StopBits = dataSrc.m_StopBits;
	m_Parity = dataSrc.m_Parity;
	m_bSoftFlow = dataSrc.m_bSoftFlow;
	m_bHardFlow = dataSrc.m_bHardFlow;
}

/////////////////////////////////////////////////////////////////////////////
// CCommPort Port Setup

BOOL CCommPort::OpenConnection()
{
	BOOL bResult;

	// No need to make any connection, only close the port
	if (m_Port == 0)  {
		CloseConnection();
		return TRUE;
	}

	// create I/O event used for overlapped reads / writes
	if (!m_osRead.hEvent || !m_osWrite.hEvent) 
		return FALSE;

	if (m_Port != m_PrevPort)  {
		// close the previous port for reconnection
		CloseConnection();
			
		// add the COM prefix string to the port number 
		CString strPort;
		strPort.Format("COM%d", m_Port);
		// open COMM device

		m_hComDev = ::CreateFile(strPort, 
			GENERIC_READ | GENERIC_WRITE,
			0, NULL, OPEN_EXISTING, 
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, NULL);
		if (m_hComDev == INVALID_HANDLE_VALUE)
			return FALSE;
		else  {
			// get any early notifications
			::SetCommMask(m_hComDev, 0);
			// setup device buffers
			::SetupComm(m_hComDev, 4096, 4096);
			// purge any information in the buffer 
			::PurgeComm(m_hComDev, PURGE_TXABORT | PURGE_RXABORT |
						PURGE_TXCLEAR | PURGE_RXCLEAR);   
			// setup for overlapped non-blocking I/O
			COMMTIMEOUTS CommTimeOuts;
			CommTimeOuts.ReadIntervalTimeout = MAXDWORD;
			CommTimeOuts.ReadTotalTimeoutMultiplier = 0;
			CommTimeOuts.ReadTotalTimeoutConstant = 0;
			CommTimeOuts.WriteTotalTimeoutMultiplier = 0;
			CommTimeOuts.WriteTotalTimeoutConstant = 0;
			::SetCommTimeouts(m_hComDev, &CommTimeOuts);
		}

		bResult = SetupConnection();

		if (bResult)  {
			m_bConnect = TRUE;
			// create a secondary thread to watch for an event
			m_pWatchThread = AfxBeginThread((AFX_THREADPROC)CommWatchProc,
					(LPVOID)this, THREAD_PRIORITY_BELOW_NORMAL);
			if (!(m_pWatchThread->m_hThread))  {
				m_bConnect = FALSE;
				::CloseHandle(m_hComDev);
				return FALSE;
			}
			else  {
				m_pWatchThread->ResumeThread();
				m_pWatchThread->m_bAutoDelete = FALSE;
				// assert DTR
				::EscapeCommFunction(m_hComDev, SETDTR);
			}
			m_PrevPort = m_Port;
		}
		else  {
			m_bConnect = FALSE;
			::CloseHandle(m_hComDev);
		}
	}

	Sleep(50);

	return bResult;
}

BOOL CCommPort::SetupConnection()
{
	DCB dcb;
	DWORD baudrate[] = {300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
	BYTE databits[] = {7, 8};
	BYTE stopbits[] = {ONESTOPBIT, ONE5STOPBITS, TWOSTOPBITS};
	BYTE parity[] = {NOPARITY, ODDPARITY, EVENPARITY};

	dcb.DCBlength = sizeof(DCB);
	::GetCommState(m_hComDev, &dcb);

	dcb.BaudRate = m_Baud;
	dcb.ByteSize = databits[m_DataBits];
	dcb.Parity = parity[m_Parity];
	dcb.StopBits = stopbits[m_StopBits];

	// setup software flow control
	dcb.fInX = dcb.fOutX = m_bSoftFlow;
	dcb.XonChar = ASCII_XON;
	dcb.XoffChar = ASCII_XOFF;
	dcb.XonLim = 3000;
	dcb.XoffLim = 3000;

//	dcb.XonLim = 8000;
//	dcb.XoffLim = 8000;

	// setup hardware flow control
	// by kenny
//	dcb.fOutxDsrFlow = dcb.fOutxCtsFlow = m_bHardFlow;
//	dcb.fDtrControl = m_bHardFlow ? DTR_CONTROL_HANDSHAKE : DTR_CONTROL_ENABLE;
//	dcb.fRtsControl = m_bHardFlow ? RTS_CONTROL_HANDSHAKE : RTS_CONTROL_ENABLE;

	dcb.fOutxDsrFlow = dcb.fOutxCtsFlow = FALSE;
//	dcb.fOutxDsrFlow = dcb.fOutxCtsFlow = TRUE;
//	dcb.fDtrControl =  DTR_CONTROL_HANDSHAKE ;
//	dcb.fRtsControl =  RTS_CONTROL_HANDSHAKE ;
	dcb.fDtrControl =  DTR_CONTROL_DISABLE;
	dcb.fRtsControl =  RTS_CONTROL_DISABLE;


	dcb.fDsrSensitivity = FALSE;
	dcb.fTXContinueOnXoff = FALSE;
	dcb.fOutX = FALSE;
	dcb.fInX = FALSE;
	dcb.fNull = FALSE;
	dcb.fAbortOnError = FALSE;
//	dcb.fAbortOnError = TRUE;

	// other various settings
	dcb.fBinary = TRUE;
	dcb.fParity = TRUE;
//	dcb.fParity = FALSE;

	return ::SetCommState(m_hComDev, &dcb);
}

BOOL CCommPort::CloseConnection()
{	
	if (!m_bConnect)
		return FALSE;

	// set connected flag to FALSE
	m_bConnect = FALSE;
	// disable event notification and wait for thread to halt
	::SetCommMask(m_hComDev, 0);

	// WAY TO HALT THE COMM WATCH THREAD
	DWORD ExitCode;
	BOOL bResult = TRUE;
	GetExitCodeThread(m_pWatchThread->m_hThread, &ExitCode);
	// retrive the termination status of second thread.
	if (ExitCode == STILL_ACTIVE) {
		// destroy second thread (in a dangerous way!!!!!)
		if (!TerminateThread(m_pWatchThread->m_hThread, ExitCode))  {
			CString string;
			string.LoadString(IDS_ERROR_THREAD);
			AfxMessageBox(string);
	   		bResult = FALSE;
		}
	}
	delete m_pWatchThread;
	m_pWatchThread = NULL;

	// drop	DTR
	::EscapeCommFunction(m_hComDev, CLRDTR);
	// purge any outstanding reads/writes and close device handle
	::PurgeComm(m_hComDev, PURGE_TXABORT | PURGE_RXABORT | 
					PURGE_TXCLEAR |	PURGE_RXCLEAR);
	::CloseHandle(m_hComDev);
	m_PrevPort = 0;		

	Sleep(50);
	
	return bResult;
}

/////////////////////////////////////////////////////////////////////////////
// CCommPort Signal Sending

int CCommPort::WriteStr(void* str, int length)
{
	if (!m_bConnect)
		return 0;

	DWORD dwBytesWritten;
	BOOL bWriteStat = 
		::WriteFile(m_hComDev, str, length,	&dwBytesWritten, &m_osWrite);

	// Note that normally the code will not execute the following
	// because the driver caches write operations. Small I/O requests 
	// (up to several thousand bytes) will normally be accepted 
	// immediately and WriteFile will return true even though an
	// overlapped operation was specified

	if (!bWriteStat)  {
		DWORD   dwErrorFlags;
		COMSTAT ComStat;
		DWORD dwError = ::GetLastError();
		if (dwError == ERROR_IO_PENDING)  {
			// We should wait for the completion of the write operation
			// so we know if it worked or not

			// This is only one way to do this. It might be beneficial to 
			// the to place the writing operation in a separate thread 
			// so that blocking on completion will not negatively 
			// affect the responsiveness of the UI

			// If the write takes long enough to complete, this 
			// function will timeout according to the
			// CommTimeOuts.WriteTotalTimeoutConstant variable.
			// At that time we can check for errors and then wait 
			// some more.

			while(!::GetOverlappedResult(m_hComDev, &m_osWrite,
                         &dwBytesWritten, FALSE))  {
				// normal result if not finished
				if(::GetLastError() == ERROR_IO_INCOMPLETE)
					continue;
				// an error occurred, try to recover
				else  {
                    ::ClearCommError(m_hComDev, &dwErrorFlags, &ComStat);
					break;
				}
			}
		}
		// some other error occurred
		else  ::ClearCommError(m_hComDev, &dwErrorFlags, &ComStat);
	}
	return dwBytesWritten;
}

int del_duration = 0x1fff;

void CCommPort::Send(char data)
{
 //  unsigned long  i = 0x1fff * 1000;
//   int del = del_duration;
//	int del = 0x1ff;
  // while(del--);
   Sleep(0);
   WriteStr(&data, 1);
 //  Sleep(0);
}


/////////////////////////////////////////////////////////////////////////////
// CCommPort Signal Receiving

int CCommPort::ReadStr(void* str, int length)
{
	// only try to read number of bytes in rx. queue 
	COMSTAT ComStat;
	DWORD dwErrorFlags;
	::ClearCommError(m_hComDev, &dwErrorFlags, &ComStat);
    DWORD dwLength = Min((DWORD)length, ComStat.cbInQue);

	if (dwLength > 0)  {
		BOOL bReadStat = ::ReadFile(m_hComDev, str, dwLength, &dwLength, &m_osRead);
		if (!bReadStat)  {
			if (::GetLastError() == ERROR_IO_PENDING)  {
				::OutputDebugString("\n\rIO Pending");
				// We have to wait for read to complete. 
				// This function will timeout according to the
				// CommTimeOuts.ReadTotalTimeoutConstant variable
				// Every time it times out, check for port errors

				while(!::GetOverlappedResult(m_hComDev, &m_osRead, &dwLength, TRUE))  {
					// normal result if not finished
					if(::GetLastError() == ERROR_IO_INCOMPLETE)
						continue;
					// an error occurred, try to recover
					else  {
						::ClearCommError(m_hComDev, &dwErrorFlags, &ComStat);
						break;
					}
				}
			}
			else  {
			    // some other error occurred
			    dwLength = 0 ;
				::ClearCommError(m_hComDev, &dwErrorFlags, &ComStat);
			}
		}
	}
   
	return dwLength;
} 

void CCommPort::OnPendingRead()
{
	if(m_pParent)
//		m_pParent->::PostMessage( WM_COMM_RX_CHAR, 0, 0);
::PostMessage(m_pParent->m_hWnd, WM_COMM_RX_CHAR, 0, 0);
}

void CCommPort::SetRxParent(CWnd *parent)
{
	m_pParent = parent;
}


/////////////////////////////////////////////////////////////////////////////
// controlling function for the worker thread to watch for COMM events
// monitor receive process & close connection

DWORD CommWatchProc(LPVOID pParam)
{
	CCommPort* port = (CCommPort*)pParam;
	if (!SetCommMask(port->m_hComDev, EV_RXCHAR))
		return FALSE;

	DWORD dwEvtMask;
	while (port->m_bConnect)  {
		dwEvtMask = 0;
		WaitCommEvent(port->m_hComDev, &dwEvtMask, NULL);
		if ((dwEvtMask & EV_RXCHAR) == EV_RXCHAR)
			port->OnPendingRead();
	}

	return TRUE;
}




