#include "stdafx.h"
#include "syncdb.h"
#include "phonebk.h"
#include "resource.h"
#include "MissRecDlg.h"
#include "All_DB.h"

extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

BOOL PhoneBookAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	
	if (CatRec(rec_id))
		return TRUE; //PhoneBookAddCat(dbCurrent, rec_id, rec_header, rec_content);

	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += PBDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");


	for(i=0;i<26;i++)  
	{
		PDADataGetField(i, rec_content, &fielddata);
		RemoveNULL(&fielddata);
		if(fielddata != "")
			rsCurrent->SetFieldValue(i + 5,(LPCTSTR)(fielddata));
		else
			rsCurrent->SetFieldValueNull(i + 5);
	}

//  mail cat 
	PDADataGetField(i, rec_content, &fielddata);  
	if(fielddata.GetLength())
		rsCurrent->SetFieldValue("MailCategory",(LPCTSTR)Str_ul((unsigned int) fielddata[0]));
	else
		rsCurrent->SetFieldValue("MailCategory",(LPCTSTR)"0");

// show in list
	rsCurrent->SetFieldValue("MailCategory",(LPCTSTR)"0");

// Display index
	i++;
	PDADataGetField(i, rec_content, &fielddata);
	for(int j=0;j<7;j++)
	{
		if(j >= fielddata.GetLength())
			fielddata += '0';
		else
		{
			TRACE("\n %d ", fielddata.GetAt(j));
			fielddata.SetAt(j, fielddata.GetAt(j) + '0');
			TRACE(" %c ", fielddata.GetAt(j));
		}
	}

	fielddata = fielddata.Left(7);
	rsCurrent->SetFieldValue("Display",(LPCTSTR)fielddata);

	// Default show
	i++;
	int show_value;
	PDADataGetField(i, rec_content, &fielddata);
	if(fielddata.GetLength())
	{
		show_value = atoi(fielddata);
		if(show_value < 0 || show_value > 8)
			show_value = 0;
	}
	else
		show_value = 0;

	fielddata.Format("%d", show_value);
	rsCurrent->SetFieldValue("DefaultShow",(LPCTSTR)fielddata);

// CompanyLast
	i++;
	PDADataGetField(i, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	if(fielddata != "")
		rsCurrent->SetFieldValue("CompanyLastName",(LPCTSTR)(fielddata));
	else
		rsCurrent->SetFieldValueNull("CompanyLastName");

// FirstNameLastName
	i++;
	PDADataGetField(i, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	if(fielddata != "")
		rsCurrent->SetFieldValue("FirstNameLastName",(LPCTSTR)(fielddata));
	else
		rsCurrent->SetFieldValueNull("FirstNameLastName");

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;

	return FALSE;
}


BOOL PhoneBookMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs=NULL;
	COleVariant fielddata;
	CString szStr;

	
	if (CatRec(rec_id))
		return PhoneBookMoveCat(src_db, dest_db, rec_id);

#ifdef xxxxxxxxxxxxx
/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += PBDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);


	for(i=5;i<31;i++)  //29
	{
		CString fdata;
		fdata = (LPSTR) rs->GetFieldValue(i).bstrVal;
		if ((LPCSTR) rs->GetFieldValue(i).bstrVal)
			szStr = (fdata);
		rsCurrent->SetFieldValue(i,(LPCTSTR)szStr);
		TRACE("\n %d %s ", i, szSql);
	}

	fielddata = rs->GetFieldValue("MailCategory"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("MailCategory",(LPCTSTR)szStr);

	fdata = (LPSTR) rs->GetFieldValue("ShowInList").bstrVal;
	if ((LPCSTR) rs->GetFieldValue("ShowInList").bstrVal)
		szStr = (fdata);
	rsCurrent->SetFieldValue("ShowInList,(LPCTSTR)szStr);

	fdata = (LPSTR) rs->GetFieldValue("Display").bstrVal;
	if ((LPCSTR) rs->GetFieldValue("Display").bstrVal)
		szStr = (fdata);
	rsCurrent->SetFieldValue("Display",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("DefaultShow"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("DefaultShow",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("CompanyLastName"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("CompanyLastName",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("FirstNameLastName"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("FirstNameLastName",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;
	
	rs->Close();

#endif

	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
		  delete rs;
		  rs = NULL;
		}
		return TRUE;
	}

	if(rs)
	{
	 delete rs;
	 rs = NULL;
	}

	return FALSE;
}



/* move from current to recycle */
BOOL PhoneBookMoveRecordToRecycle(RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;

/* if the record is in recycle, delete it */
	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dbRecycle->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(dbCurrent);
	szSql = "select * from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dbRecycle);

	szSql = "Select * from ";
	szSql += PBDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	CString fdata;
	for(i=5;i<31;i++)  //29
	{
		fdata = (LPSTR) rs->GetFieldValue(i).bstrVal;
		if ((LPCSTR) rs->GetFieldValue(i).bstrVal)
			szStr = (fdata);
		rsCurrent->SetFieldValue(i,(LPCTSTR)szStr);
		TRACE("\n %d %s ", i, szSql);
	}

	fielddata = rs->GetFieldValue("MailCategory"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("MailCategory",(LPCTSTR)szStr);

	fdata = (LPSTR) rs->GetFieldValue("ShowInList").bstrVal;
	if ((LPCSTR) rs->GetFieldValue("ShowInList").bstrVal)
		szStr = (fdata);
	rsCurrent->SetFieldValue("ShowInList",(LPCTSTR)szStr);

	fdata = (LPSTR) rs->GetFieldValue("Display").bstrVal;
	if ((LPCSTR) rs->GetFieldValue("Display").bstrVal)
		szStr = (fdata);
	rsCurrent->SetFieldValue("Display",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("DefaultShow"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("DefaultShow",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("CompanyLastName"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("CompanyLastName",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("FirstNameLastName"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("FirstNameLastName",(LPCTSTR)szStr);


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;
	rs->Close();

	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot delete old record in current db");
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}


BOOL PhoneBookAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += PBDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Name1st",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return FALSE;
}


BOOL PhoneBookMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += PBDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Name1st");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Name1st",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}


BOOL PhoneBookArchive(DatabaseID dbid, int mode)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	RecStruct *cat_record = NULL;
	int total_cat = 0;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	cat_record = (RecStruct*)malloc(300 * sizeof(RecStruct));

	for(i=0;i<total_rec;i++)
	{
		rec_content.Empty();
	  if(((RecordHeader*)&(record[i].rec_header))->rec_id < (RecordID) 0x80000000)
	  {
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
//		if(DBIsExistRecord(dbArchive, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
//			PhoneBookMoveRecord(dbArchive, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbRecycle, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, PBDB, ((RecordHeader)(record[i].rec_header)).rec_id);
//		}
		PhoneBookAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	  }
	  else
		  if(CatRec(record[i].rec_header.rec_id ))
//	  if(((RecordHeader*)&(record[i].rec_header))->rec_id < 0x80000100)
	  {
		//category
		   cat_record[total_cat++] = record[i];
	  }
	}

	SyncUpdateCat((CString)PBDB, (CString)PB_CAT_FIELD_NAME, dbid, cat_record, total_cat, mode);

	if(record)
	   free(record);
	if(cat_record)
		free(cat_record);

	return 0;
}

#ifdef xxxxxxxx
BOOL PhoneBookArchivePCOvrPDA(DatabaseID dbid)
{ 
	PhoneBookArchivePDAOvrPC(dbid);
//	PhoneBookResolveCat(dbid);
	return TRUE;
}
#endif

BOOL PhoneBookArchivePCOvrPDA(DatabaseID dbid)
{ 
	if(sys_crashed == RESTORE_PC)
		return PhoneBookArchive(dbid, CAT_PC_PDA_RESTORE);
	else		
		return PhoneBookArchive(dbid, CAT_PC_OVR_PDA);
}

BOOL PhoneBookArchivePDAOvrPC(DatabaseID dbid)
{ 
	return PhoneBookArchive(dbid, CAT_PDA_OVR_PC);
}

BOOL PhoneBookArchivePCPDASync(DatabaseID dbid)
{
	return PhoneBookArchive(dbid, CAT_PC_PDA_SYNC);
}

BOOL PDAPhoneBookAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[40];
	unsigned int data32, data32_2, i ,j;
	unsigned short byte_use;
	char *ptr;

	szSql = "select * from ";
	szSql += PBDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	/* PDA data structure:
	   PC Field "Name1st" - "MailCategory" is same order in PDA
	   i.e. PDA field 0 -> Name1st; field 1 -> Name2nd .... field 26 -> MailCategory
	   PC Field "ShowInList" is not used in PDA
	   field 27 -> Display
	   field 28 -> Default show
	   field 29 -> Company sort, which is missing in PC
	               Company sort = "Company" + "," + "Name2nd"
				   if either "Company" or "Name2nd" is empty, the "," is ommitted
				   if BOTH "Company" and "Name2nd" is empty, "Name1st" put into the field instead.
	*/	   

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}


	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 31;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));

	for(i=5;i<31;i++)
	{
		fielddata = (LPCSTR) (rs->GetFieldValue(i)).bstrVal;
		AddNULL(&fielddata);
		size_array[i-5] = fielddata.GetLength();
		data32_2 = size_array[i-5];
	    EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
		  content += ptr[j];
		content += fielddata;
	}


	// mail cat
	char cat = (char) (rs->GetFieldValue("MailCategory")).lVal;
	size_array[i-5] = 1;
	data32_2 = size_array[i-5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		  content += ptr[j];
	content += cat;	
	i++;

/*	//show in list (no use) not in pda database
	fielddata = (LPCSTR) (rs->GetFieldValue(i)).bstrVal;
	AddNULL(&fielddata);
	size_array[i-5] = fielddata.GetLength();
	data32_2 = size_array[i-5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;
	i++
*/	

	/* Index(PDA name) / Display (PC name)
	   PC format: 7 character to represent the display name, in the format of "0123456"
	              values within "0" - "6" are valid
	   PDA format: 7 byte values, in the format of 0x00 0x01 0x02 0x03 0x04 0x05 0x06
				  values within 0x00 - 0x06 are valid
	*/

	fielddata = (LPCSTR) (rs->GetFieldValue("Display")).bstrVal;
	AddNULL(&fielddata);
	size_array[i-5] = 7;
	data32_2 = size_array[i-5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

	if(fielddata.IsEmpty())
		content += "0120123";
	else
	{
		for(j=0;j<7;j++)
		{
			if(j>=fielddata.GetLength())
				content += '\0';
			else
			{
				if( fielddata.GetAt(j) > '4' || fielddata.GetAt(j) < '0')
					content += '\0';
			else
 				  content += (char) (fielddata.GetAt(j) - '0');
			}
		}
	}
	i++;

	// default select item
	int show_item = (char) (rs->GetFieldValue("DefaultShow")).lVal;
	size_array[i-5] = 2;
	data32_2 = size_array[i-5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		  content += ptr[j];
	ptr = (char*) &show_item;
	content += *ptr++;
	content += *ptr;
	i++;

	// Com+Name field
	CString CombineName;
	if((CString)rs->GetFieldValue("Company").bstrVal == "" && (CString)rs->GetFieldValue("Name2nd").bstrVal == "")
		fielddata = (LPCSTR) (rs->GetFieldValue("Name1st")).bstrVal;
	else
		fielddata = (LPCSTR) (rs->GetFieldValue("CompanyLastName")).bstrVal;
	CombineName = fielddata;
	AddNULL(&CombineName);

	size_array[i-5] = CombineName.GetLength();
	data32_2 = size_array[i-5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += CombineName;
	i++;

	// first+last field
	CString szFirstLast;
	if((CString)rs->GetFieldValue("Name1st").bstrVal == "" && (CString)rs->GetFieldValue("Name2nd").bstrVal == "")
		fielddata = (LPCSTR) (rs->GetFieldValue("Company")).bstrVal;
	else
		fielddata = (LPCSTR) (rs->GetFieldValue("FirstNameLastName")).bstrVal;
	szFirstLast = fielddata;
	AddNULL(&szFirstLast);

	size_array[i-5] = szFirstLast.GetLength();
	data32_2 = size_array[i-5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += szFirstLast;


	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 31, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

 
	nPC2PDA++;
	return TRUE;
}


BOOL PhoneBookGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += PBDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}


void PhoneBookDeleteInvalidRec()
{

	CString szSql;

	szSql = "delete from ";
	szSql += PBDB;
	szSql += " where Name1st ='' and Name2nd = '' ";

	try
	{
		dbCurrent->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}


	try
	{
		dbArchive->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	try
	{
		dbRecycle->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}


}