#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "Sch.h"
#include "Schvox.h"
#include "recid.h"

extern BOOL bRun;
extern BOOL recycle_pda_sch;
//extern BOOL recycle_pda_sch;
extern int station_num;

DatabaseID sch_vox_dbid;
//int sch_next_alarm_number;
extern char MonName[12][4];

BOOL SchMapPDARecToPCRecByDate(char pda_date[3], RecordID pda_recid, RecordID &pc_recid)
{
	//pda_date: 0: yr x - DATE_OFFSET format
	//          1: month 1-12
	//          2: day 1 - 31
	CString sqlst;
	CDaoRecordset *pRs = NULL;

	sqlst = "select distinct RecordID from Scheduler where SchDate = #";
	sqlst += Str_ul( (int)pda_date[2]);
	sqlst += ' ';
	if( ((int) pda_date[1] > 0) && ( (int) pda_date[1] < 13))
		sqlst += MonName[(int)pda_date[1]-1];
	else
		return FALSE;
	sqlst += (CString) ' ' + Str_ul(DATE_OFFSET + (unsigned int) pda_date[0]);

	sqlst += '#';
	sqlst += " and RecordID <> ";
	sqlst += Str_ul(pda_recid);

	pRs = new CDaoRecordset(dbCurrent);

	try
	{
		pRs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", sqlst);
	}

	if(pRs->IsBOF())
	{
		pRs->Close();
		delete pRs;
		return FALSE;
	}

	pc_recid = pRs->GetFieldValue("RecordID").lVal;
	pRs->Close();
	delete pRs;
	
	return TRUE;
}



void SchMapPCRecIDtoPDA(SchRecStruct *record, int total_rec)
{
	int i;
	RecordID pc_recid;
	CString sqlst;

	for(i=0;i<total_rec;i++)
	{
		if( SchMapPDARecToPCRecByDate(record[i].date, record[i].rec_header.rec_id, pc_recid))
		{
			sqlst = "update ";
			sqlst += SCHDB;
			sqlst += " set RecordID = ";
			sqlst += Str_ul(record[i].rec_header.rec_id);
			sqlst += " where RecordID = ";
			sqlst += Str_ul(pc_recid);

			TRY
			{
				dbCurrent->Execute(sqlst);
			}
			CATCH(CException , e);
			{
			}
			END_CATCH
		}
	}
}

int CSyncDispDlg::UpdateDatabasePDAOvrPCSch()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();
	CHKTERM;


	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_SCHDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	if (SyncDBInfo(PDA_SCHVOXDB, &sch_vox_dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;


//	SchArchivePDAOvrPC(dbid);

	total_rec = 0;

	/* get all record header in PDA */
	if(SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 10000)
		return 1;
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(SchDBCompDate(dbCurrent, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);

		DoEvents();
//		if(DBIsExistRecord(dbCurrent, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			//SchMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
//			PCDeleteRecord(dbCurrent, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id));
//		}
		PCDeleteRecord(dbRecycle, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		DoEvents();
		SchAddAbsRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += SCHDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			//SchMoveRecord(dbCurrent, dbRecycle, recid);
			PCDeleteRecord(dbCurrent, SCHDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);

	CHKTERM;

	SyncIdleMode();
	SyncSetSchAlm();
	SyncDBEnqMode();

	UpdateLastRecID(SCHDB, 1000);
	ValidSchAlmAndApptNumber();
	if(TSUpdateVox(SCHVOXDB, CAT_PDA_OVR_PC))
		return 1;
	else
		return 0;

terminate:

	SyncIdleMode();
	SyncSetSchAlm();
	SyncDBEnqMode();
	ValidSchAlmAndApptNumber();


	if(rs)
		delete rs;

	return 1;
}


int CSyncDispDlg::UpdateDatabasePCOvrPDASch()
{
	DatabaseID dbid;
	int total_rec; 
	int i, modex;
	CString dbheader;
	CString rec_content, szSql;
	SchRecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	RTM last_sync_date;
	CString a;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;

	RecordID last_pda_recid, last_pc_recid = pc_default;
	
	CHKTERM;


	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
/*
#ifndef UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
		RecIDCrashRecover(SCHDB);
#endif
*/
/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SCHDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	if (SyncDBInfo(PDA_SCHVOXDB, &sch_vox_dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;
/*
#ifdef UNIQUE_RECID	
	if(sys_crashed == RESTORE_PC)
	{
		GetLastSyncRecID(SCHDB, &last_pda_recid, &last_pc_recid);
		//RecIDCrashRecover(PBDB, 1002);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;
		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 0);
	}
#endif

*/
//	SchArchivePCOvrPDA(dbid); //no arc. for sch!
	CHKTERM;

	GetLastSyncDate(SCHDB, &last_sync_date);

	total_rec = 0;

	CHKTERM;

	record = (SchRecStruct*)malloc(10000);
	/* get all record header in PDA */
	if (SyncSchRecInfoReq(dbid, &total_rec, (SchRecStruct*)record) != 0)
		return 1;		// error


	if(total_rec > 10000)
		return 1;


	if(total_rec)
		SchMapPCRecIDtoPDA(record, total_rec);

/*

	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
*/

//	SyncReadRec(dbid, 1000, (char*) &record[0].rec_header, &rec_content);
//	PDADataGetField(0, &rec_content, &dbheader);

	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */

		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       SchAddAbsRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
   		   rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
   		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;
	    if(sys_crashed == RESTORE_PC)
		{
			// rec in pda & pc,
			// read pda->pc then pc->pda will
			// update pda & pc!
/*
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       SchAddAbsRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
   		   rec_content.Empty();
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		  PDASchAddAbsRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
*/
			SchSyncBoth(dbid, &(record[i].rec_header), last_sync_date);
		}
	    else
		{
		/* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
		   /* then add to PDA */
		  PDASchAddAbsRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
		}
	   }
	}

/* records in PC but not in PDA */
	szSql = "select distinct RecordID from ";
	szSql += SCHDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat
	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	CHKTERM;
	    SyncDBUpMode(); CHKTERM;
		while(!rs->IsEOF())
		{
			DoEvents();
			PDASchAddAbsRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			rs->MoveNext();
		}
	    SyncIdleMode();	CHKTERM;
	    SyncDBEnqMode(); CHKTERM;
	}
		rs->Close();
	CHKTERM;

	

nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

#ifdef UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
	{
	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}

	UpdateLastRecID(SCHDB, last_pda_recid);
	}
#endif

	if(record)
	   free(record);


	SyncIdleMode();
	SyncSetSchAlm();
	SyncDBEnqMode();

	UpdateLastRecID(SCHDB, 1000);
	if(sys_crashed == RESTORE_PC)
		modex = CAT_PC_PDA_RESTORE;
	else
		modex = CAT_PC_OVR_PDA;

	
	ValidSchAlmAndApptNumber();
	if(TSUpdateVox(SCHVOXDB, modex))
		return 1;
	else
		return 0;


terminate:


	SyncIdleMode();
	SyncSetSchAlm();
	SyncDBEnqMode();
	ValidSchAlmAndApptNumber();

	if(rs)
		delete rs;
	return 1;
}



int CSyncDispDlg::UpdateDatabasePCPDASyncSch()
{
	DatabaseID dbid;
	int total_rec;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	SchRecStruct *record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
	RecordID prev_recid;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SCHDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	if (SyncDBInfo(PDA_SCHVOXDB, &sch_vox_dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	GetLastSyncRecID(SCHDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(SCHDB, &last_sync_date);

//	SchArchivePCOvrPDA(dbid);
	CHKTERM;

	total_rec = 0;

	record = (SchRecStruct*)malloc(10000);
	/* get all record header in PDA */
	if (SyncSchRecInfoReq(dbid, &total_rec, (SchRecStruct*)record) != 0)
		return 1;		// error

	if (total_rec > 12000)
		return 1;

	if(total_rec)
		SchMapPCRecIDtoPDA(record, total_rec);

	/* get all record header in PDA */
//	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
//		return 1;		// error

/* find record that in PC but not in PDA */
	szSql = "select distinct RecordID, ModifyDate from ";
	szSql += SCHDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0 "; // for email msg only, not condiser cat

	szSql += " order by RecordID, ModifyDate DESC";

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select distinct RecordID, ModifyDate from ";
		szSqlBoth += SCHDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';

	szSql += " order by RecordID, ModifyDate DESC";

	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}


//goto chkboth;
	
	CHKTERM;
/* Compare all record in PC with PDA */
// Rec in PDA only:	
    for(i=0;i<total_rec;i++)
	{
	  if(!DBIsExistRecord(dbCurrent, SCHDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  SchAddModiRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
  			  PDASchAddAbsRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		      rec_content.Empty();
			  CHKTERM;
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
	   }
   }  


// Rec in PC only:
	missrec_act = 0;
	prev_recid = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			if(prev_recid == (rs_pc->GetFieldValue(0)).lVal)
				goto next_loop;

			prev_recid = (rs_pc->GetFieldValue(0)).lVal;
			SchDelUnModiRecord(rs_pc->GetFieldValue(0).lVal);
			PDASchAddAbsRecord(dbCurrent, dbid, rs_pc->GetFieldValue(0).lVal);
next_loop:
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}

// Rec in Both:

	prev_recid = 0;
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
		  if( (rs_both->GetFieldValue("RecordID")).lVal == prev_recid)
			  goto next_loop2;
		  prev_recid = (rs_both->GetFieldValue("RecordID")).lVal;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{
				SchSyncBoth(dbid, &(record[i].rec_header), last_sync_date);
				CHKTERM;
			} // if
next_loop2:
			rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */



	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 0x3fffffff)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}

	if(record)
	{
	   free(record);
	   record = NULL;
	}

	CHKTERM;

	SyncIdleMode();
	SyncSetSchAlm();
	SyncDBEnqMode();

	SchDeleteInvalidRec();


	UpdateLastRecID(SCHDB, last_pda_recid);
	ValidSchAlmAndApptNumber();
	if(TSUpdateVox(SCHVOXDB, CAT_PC_PDA_SYNC))
		return 1;
	else
		return 0;

terminate:

	SyncIdleMode();
	SyncSetSchAlm();
	SyncDBEnqMode();
	ValidSchAlmAndApptNumber();

	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}
