#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "SCHREP.h"

extern CString current_path;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

CString Str_Val(CString x)
{
	int val;
	char *ptr = (char*) &val;

	if(x.GetLength() >= 4)
	{
		for(int i=0; i < 4;i++)
			*ptr++ = x[i];
	}
	else
		val = 0;

	return Str_ul(val);
}


BOOL SchRepAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	COleDateTime date;
	int int_val;
	

// todo handle NewRecordWithID record

	szSql = "delete from ";
	szSql += SCHREPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += SCHREPDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");


	PDADataGetField(0, rec_content, &fielddata);  // repeatnumber
	rsCurrent->SetFieldValue("RepeatNumber",(LPCTSTR)Val_ul(fielddata));

	PDADataGetField(1, rec_content, &fielddata); // exception
	if(fielddata[0])
		rsCurrent->SetFieldValue("Exception",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Exception",(LPCTSTR)"FALSE");

#define SCH_REP_OFFSET	1900

	PDADataGetField(2, rec_content, &fielddata); // start date
	date.SetDate(fielddata[0] + 1900, fielddata[1], fielddata[2]);
	rsCurrent->SetFieldValue("StartDate",(LPCTSTR)date.Format("%b %d %Y"));

	PDADataGetField(3, rec_content, &fielddata); // end date
	if((fielddata[0] == -1) && (fielddata[1] == -1) && (fielddata[2] == -1))
		rsCurrent->SetFieldValueNull("EndDate");
	else
	{
		date.SetDate(fielddata[0] + 1900, fielddata[1], fielddata[2]);
		rsCurrent->SetFieldValue("EndDate",(LPCTSTR)date.Format("%b %d %Y"));
	}

	PDADataGetField(4, rec_content, &fielddata);  // method
	rsCurrent->SetFieldValue("RepeatMethod",(LPCTSTR)Str_ul(fielddata[0]));

	rsCurrent->SetFieldValue("RepeatTimes",(LPCTSTR)Str_ul(fielddata[1])); //times

	if(fielddata[2] < 0 ){
		//weekdays
		rsCurrent->SetFieldValue("RepeatWeekdays",(LPCTSTR)Str_ul(fielddata[2] + 128));
	}else{
		//weekdays
		rsCurrent->SetFieldValue("RepeatWeekdays",(LPCTSTR)Str_ul(fielddata[2]));
	}

	//weekno
	rsCurrent->SetFieldValue("RepeatWeekNo",(LPCTSTR)Str_ul(fielddata[3]));

	PDADataGetField(5, rec_content, &fielddata); // alarm flag
	if(fielddata[0])
		rsCurrent->SetFieldValue("AlarmFlag",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("AlarmFlag",(LPCTSTR)"FALSE");

	PDADataGetField(6, rec_content, &fielddata);  // alarm type
	CString alarm_type;
	if(fielddata[1] == 0x02)
		alarm_type = "1";
	else if(fielddata[1] == 0x01)
		alarm_type = "2";
	else if(fielddata[1] == 0x03)
		alarm_type = "3";
	else
		alarm_type = "0";
	rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)alarm_type);

	//alarm time
	rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)Str_ul(fielddata[0]));

	//alarm number
	CString alarm_no;
	alarm_no = fielddata.Right(4);
	if(alarm_no == "")
		rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)"0");
	else
		rsCurrent->SetFieldValue("AlarmNumber",(LPCTSTR)Val_ul(alarm_no));

	PDADataGetField(7, rec_content, &fielddata);  // voice id
	if(fielddata == "")
		rsCurrent->SetFieldValue("VoiceID","0");
	else
		rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)Val_ul(fielddata));

	PDADataGetField(8, rec_content, &fielddata);  // content
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)(fielddata));

	PDADataGetField(2, rec_content, &fielddata); // start time
	date.SetTime(fielddata[3],fielddata[4],0);
	rsCurrent->SetFieldValue("StartTime",(LPCTSTR)date.Format("%X"));

	PDADataGetField(3, rec_content, &fielddata); // end time
	date.SetTime(fielddata[3],fielddata[4],0);
	rsCurrent->SetFieldValue("EndTime",(LPCTSTR)date.Format("%X"));

	PDADataGetField(9, rec_content, &fielddata); // alarm date
	if((fielddata[0] == -1) && (fielddata[1] == -1) && (fielddata[2] == -1))
		rsCurrent->SetFieldValueNull("AlarmDate");
	else
	{
		date.SetDate(fielddata[0] + 1900, fielddata[1], fielddata[2]);
		rsCurrent->SetFieldValue("AlarmDate",(LPCTSTR)date.Format("%b %d %Y"));
	}


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;
	return FALSE;
}



BOOL SchRepMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;
	
//	if (CatRec(rec_id))
//		return SchRepMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += SCHREPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += SCHREPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += SCHREPDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Exception");	
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Exception",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Content");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Content",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("RepeatNumber"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("RepeatNumber",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("RepeatMethod"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("RepeatMethod",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("RepeatTimes"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("RepeatTimes",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("RepeatWeekdays"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("RepeatWeekdays",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("RepeatWeekNo"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("RepeatWeekNo",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AlarmType"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmType",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("AlarmTime"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("AlarmTime",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("VoiceID"); 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("VoiceID",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("StartDate");	 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("StartDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("EndDate"); 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("EndDate",(LPCTSTR)szStr);
	
	fielddata = rs->GetFieldValue("StartTime"); 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("StartTime",(LPCTSTR)szStr);
	
	fielddata = rs->GetFieldValue("EndTime");
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("EndTime",(LPCTSTR)szStr);
	
	fielddata = rs->GetFieldValue("AlarmDate"); 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("AlarmDate",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;



	rs->Close();

	szSql = "delete from ";
	szSql += SCHREPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}



BOOL SchRepArchive(DatabaseID dbid, int mode)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	RecStruct *cat_record = NULL;
	int total_cat = 0;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}

	cat_record = (RecStruct*)malloc(300 * sizeof(RecStruct));

	for(i=0;i<total_rec;i++)  // process non-category item
	{
		TRACE("\n%08x ", record[i].rec_header.rec_id );
	  if((record[i].rec_header.rec_id < (RecordID) 0x80000000))
	  {
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
		if(DBIsExistRecord(dbArchive, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
			PCDeleteRecord(dbRecycle, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
			PCDeleteRecord(dbCurrent, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		SchRepAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
	  }
	  else
		  if(CatRec(record[i].rec_header.rec_id ))
//	  if(record[i].rec_header.rec_id < (UWORD) 0x80000100)
	  {
		//category
		   cat_record[total_cat++] = record[i];
	  }
	}

	if(record)
	   free(record);
	if(cat_record)
		free(cat_record);

	return 0;
}


BOOL SchRepArchivePCOvrPDA(DatabaseID dbid)
{ 
	if(sys_crashed == RESTORE_PC)
		return SchRepArchive(dbid, CAT_PC_PDA_RESTORE);
	else		
		return SchRepArchive(dbid, CAT_PC_OVR_PDA);
}

BOOL SchRepArchivePDAOvrPC(DatabaseID dbid)
{ 
	return SchRepArchive(dbid, CAT_PDA_OVR_PC);
}

BOOL SchRepArchivePCPDASync(DatabaseID dbid)
{
	return SchRepArchive(dbid, CAT_PC_PDA_SYNC);
}


BOOL PDASchRepAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[12];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	int sket_pos;
	char *ptr;

	szSql = "select * from ";
	szSql += SCHREPDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 10;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));


	// Repeat Number
	size_array[0] = 4;
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

//	fielddata = Str_ul(rs->GetFieldValue("RepeatNumber").lVal);
//	content += fielddata;
	unsigned int repeat_number = rs->GetFieldValue("RepeatNumber").lVal;

	ptr = (char*) &repeat_number;

	content += ptr[0];
	content += ptr[1];
	content += ptr[2];
	content += ptr[3];

	TRACE("\n %d ", content.GetLength());

	// Exception flag
	size_array[1] = 1;
	data32_2 = size_array[1];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

	if(rs->GetFieldValue("Exception").boolVal)
	{
		fielddata = (char) 0x01;
	}
	else
		fielddata = (char) 0x00;
	content += fielddata;

	TRACE("\n %d ", content.GetLength());


	// start time
	size_array[2] = 7;
	data32_2 = size_array[2];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	COleDateTime start_time = (COleDateTime)rs->GetFieldValue("StartDate");
	fielddata = (char)(start_time.GetYear() - SCH_REP_OFFSET);
	fielddata += (char)start_time.GetMonth();
	fielddata += (char)start_time.GetDay();
	int dayinyear = start_time.GetDayOfYear();
	
	start_time = (COleDateTime)rs->GetFieldValue("StartTime");
	fielddata += (char)start_time.GetHour();
	if(start_time.GetMinute() % 5 != 0)
		fielddata += (char)(start_time.GetMinute() - (start_time.GetMinute() % 5));
	else
		fielddata += (char)start_time.GetMinute();
	
	ptr = (char*)&dayinyear;
	fielddata += ptr[0];
	fielddata += ptr[1];
	content += fielddata;	


	TRACE("\n %d ", content.GetLength());

	// end time
	size_array[3] = 7;
	data32_2 = size_array[3];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	start_time = (COleDateTime)rs->GetFieldValue("EndDate");
	int dayinyear1;
	if(start_time.m_status != COleDateTime::valid)
	{
		
		fielddata.Empty();
		for(int z=0;z<3;z++)
			fielddata += (char) 0xff;
		dayinyear1 = -1;
	}
	else
	{
		fielddata = (char)(start_time.GetYear() - SCH_REP_OFFSET);
		fielddata += (char)start_time.GetMonth();
		fielddata += (char)start_time.GetDay();
		dayinyear1 = start_time.GetDayOfYear();
	}
	
	start_time = (COleDateTime)rs->GetFieldValue("EndTime");

	fielddata += (char)start_time.GetHour();
	if(start_time.GetMinute() % 5 != 0)
		fielddata += (char)(start_time.GetMinute() - (start_time.GetMinute() % 5));
	else
		fielddata += (char)start_time.GetMinute();

	ptr = (char*)&dayinyear1;
	fielddata += ptr[0];
	fielddata += ptr[1];

	content += fielddata;


	// Repeat attribute
	size_array[4] = 4;
	data32_2 = size_array[4];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	fielddata = (char) rs->GetFieldValue("RepeatMethod").lVal;
	fielddata += (char) rs->GetFieldValue("RepeatTimes").lVal;
	fielddata += (char) (rs->GetFieldValue("RepeatWeekdays").lVal - 128);
	fielddata += (char) rs->GetFieldValue("RepeatWeekNo").lVal;

	content += fielddata;


	// Alarm
	size_array[5] = 1;
	data32_2 = size_array[5];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	if(rs->GetFieldValue("AlarmFlag").boolVal)
	{
		content += (char) 0x01;	
	}
	else
		content += (char) 0x00;

	// Alarm Settings
	size_array[6] = 6;
	data32_2 = size_array[6];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	content += (char) rs->GetFieldValue("AlarmTime").lVal;

	int alarm_type;
	if(rs->GetFieldValue("AlarmType").lVal == 1)
		alarm_type = 0x02;
	else if(rs->GetFieldValue("AlarmType").lVal == 2)
		alarm_type = 0x01;
	else if(rs->GetFieldValue("AlarmType").lVal == 3)
		alarm_type = 0x03;
	else 
		alarm_type = 0x00;
//	alarm_type = rs->GetFieldValue("AlarmType").lVal;

	content += (char) alarm_type;

	unsigned int alarm_no = rs->GetFieldValue("AlarmNumber").lVal;

	ptr = (char*) &alarm_no;

	content += ptr[0];
	content += ptr[1];
	content += ptr[2];
	content += ptr[3];

	//VoiceID
	size_array[7] = 4;
	data32_2 = size_array[7];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	unsigned int voice_id = rs->GetFieldValue("VoiceID").lVal;

	ptr = (char*) &voice_id;

	content += ptr[0];
	content += ptr[1];
	content += ptr[2];
	content += ptr[3];


	// Content
	fielddata = (LPSTR) rs->GetFieldValue("Content").bstrVal;
	AddNULL(&fielddata);

	size_array[8] = fielddata.GetLength();
	data32_2 = size_array[8];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
		content += ptr[j];

	content += fielddata;

	// AlarmDate

	size_array[9] = 3;
	data32_2 = size_array[9];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

	COleDateTime alarm_date = rs->GetFieldValue("AlarmDate");
	if(alarm_date.m_status != COleDateTime::valid)
	{
		
		fielddata.Empty();
		for(int z=0;z<3;z++)
			fielddata += (char) 0xff;
		content += fielddata;
	}
	else
	{
		content += (char) (alarm_date.GetYear() - SCH_REP_OFFSET);
		content += (char) alarm_date.GetMonth();
		content += (char) alarm_date.GetDay();
	}

	TRACE("\n %d ", content.GetLength());


	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAddLarge(dbid, rec_id, 10, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	nPC2PDA++;
	return FALSE;
}


BOOL SchRepGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += SCHREPDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}

