#include "stdafx.h"
#include "VPSync.h"
#include "TrackButton.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "AboutDlg.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "TimeFct.h"
#include "TimeOutDlg.h"
#include "ErrMsgDlg.h"
#include "MissRecDlg.h"
#include "DupDlg.h"
#include "NewUserDlg.h"
#include "SchRep.h"
#include "recid.h"


extern BOOL bRun;
extern BOOL recycle_pda_schrep;
extern int station_num;


int CSyncDispDlg::UpdateDatabasePDAOvrPCSchRep()
{
	DatabaseID dbid;
	RecordID recid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString szSql;

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(PDA_SCHREPDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	SchRepArchivePDAOvrPC(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	CHKTERM;

	if(total_rec > 10000)
		return 1;
	/* Compare all record in PDA with PC */
	for(i=0;i<total_rec;i++)
	{

		CHKTERM;
		// chk date, only sync rec with date not match
		if(DBCompDate(dbCurrent, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);

		DoEvents();
//		if(DBIsExistRecord(dbCurrent, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
//		{	/* record exists in PC */
//			/* Move the record to recycle database, then add the new record */
//			SchRepMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
//		}
		PCDeleteRecord(dbRecycle, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
		DoEvents();
		SchRepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		rec_content.Empty();
		CHKTERM;
	}
		/* move all record in PC but not in PDA to recycle */
		/* that is, the record is deleted from PDA, but not
		   archive */
	rs = new CDaoRecordset(dbCurrent);
	szSql = "select distinct RecordID from ";
	szSql += SCHREPDB;

	if(total_rec)
	{
		DoEvents();
	    szSql += " where RecordID not in(";		
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0";  // excl. category
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cat is not consider
		
		try
		{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			goto nextstate;
		}

		if (rs->IsBOF())
			goto nextstate;

		try
		{
			rs->MoveFirst();
		}
		catch (CDaoException *e)
		{
			e->Delete();
			TRACE("\nErr in move to first record");
			goto nextstate;
		}
		while (!rs->IsEOF())
		{
			DoEvents();
			recid = (rs->GetFieldValue(0)).lVal;
			//SchRepMoveRecord(dbCurrent, dbRecycle, recid);
			PCDeleteRecord(dbCurrent, SCHREPDB, recid);
			try
			{
				rs->MoveNext();
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\nErr in move to next record ");
				goto nextstate;
			}
		}
		DoEvents();
		rs->Close();
	
		DeferDeletePDACat(dbid);
		CHKTERM;
nextstate:
	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	if(record)
	   free(record);
UpdateLastRecID(SCHREPDB, 1000);

	return 0;

terminate:
	if(rs)
		delete rs;

	return 1;
}



int CSyncDispDlg::UpdateDatabasePCOvrPDASchRep()
{
	DatabaseID dbid;
	int total_rec; 
	int i;
	CString dbheader;
	CString rec_content, szSql;
	RecStruct *record = NULL;
	CDaoRecordset *rs = NULL;
	CString a;
//	RecordID last_pda_recid, last_pc_recid;


	CHKTERM;

	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();

	CHKTERM;
/*
#ifndef	UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
		SchRepRecIDCrashRecover();
#endif
		*/
/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SCHREPDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;
/*
#ifdef UNIQUE_RECID
	if(sys_crashed == RESTORE_PC)
	{
		GetLastSyncRecID(SCHREPDB, &last_pda_recid, &last_pc_recid);
		//RecIDCrashRecover(PBDB, 1002);
		if(last_pda_recid < 1000)
			last_pda_recid = 1000;

		PDAReasignRecID(dbid, last_pda_recid + 1 - 1000, 1000);
	}
#endif
	*/

	CHKTERM;
	SchRepArchivePCOvrPDA(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record) != 0)
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;
/* Compare all record in PC with PDA */
	if(total_rec != 0)
	/* delete PDA records that not on PC */
	{   
	  for(i=0;i<total_rec;i++)
	   if(DBIsExistRecord(dbCurrent, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id) == 0)
	   {
		   DoEvents();
/* record in PDA but not in PC */
		   /* sync the record to recycle */
		   if(sys_crashed == RESTORE_PC)
		   {
		   SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
		   CHKTERM;
		   DoEvents();
	       SchRepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  rec_content.Empty();
		   }
		   else
		   {
		   /* then delete it */
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBUpMode();
		   CHKTERM;
		   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		   CHKTERM;
		   SyncIdleMode();
		   CHKTERM;
		   SyncDBEnqMode();
		   CHKTERM;
		   }
	   }
	   else
	   {
/* record in PC and PDA */
		   /* todo: compare the date */
		if(DBCompDate(dbCurrent, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id, ((RecordHeader)(record[i].rec_header)).modi_date) == 0)
			continue;

		   /* if date not match, delete the record from PDA*/
   		  SyncIdleMode();	
		  CHKTERM;
 	      SyncDBUpMode();
		  CHKTERM;
		  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;

		   /* then add to PDA */
		  PDASchRepAddRecord(dbCurrent, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
		  CHKTERM;
 		  SyncIdleMode();	
		  CHKTERM;
		  SyncDBEnqMode();
		  CHKTERM;
	   }

	}

/* records in PC but not in PDA */
	szSql = "select RecordID from ";
	szSql += SCHREPDB;
	if(total_rec)
	{
		szSql += " where RecordID not in(";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")  and RecordID >= 0";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, cause no need to consider cat
	rs = new CDaoRecordset(dbCurrent);
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		goto nextstate;
	}
	if(!rs->IsBOF())
	{
		rs->MoveFirst();
	    SyncIdleMode();	
	    SyncDBUpMode();
		while(!rs->IsEOF())
		{
			DoEvents();
			PDASchRepAddRecord(dbCurrent, dbid, (rs->GetFieldValue(0)).lVal);
			CHKTERM;
			rs->MoveNext();
		}
	    SyncIdleMode();	
	    SyncDBEnqMode();
	}
		rs->Close();
	CHKTERM;

	DeferDeletePDACat(dbid);
	CHKTERM;

nextstate:

	if(rs)
	{
		delete rs;
		rs = NULL;
	}
//#ifdef UNIQUE_RECID
/*	if(sys_crashed == RESTORE_PC)
	{
	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}
*/
	UpdateLastRecID(SCHREPDB, 1000);
//	}
//#endif
	if(record)
	   free(record);

	CHKTERM;
	return 0;

terminate:
	if(rs)
		delete rs;
	return 1;
}

int CSyncDispDlg::UpdateDatabasePCPDASyncSchRep()
{
	DatabaseID dbid;
	int total_rec;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	RecordID last_pda_recid =0, last_pc_recid = pc_default;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
    CMissRecDlg missrec_dlg;
	CDupDlg duprec_dlg;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;


   missrec_dlg.total_cols = 2;
   missrec_dlg.total_rows = 3;
   missrec_dlg.col_width[0] = 1200;
   missrec_dlg.col_width[1] = 5000;
   missrec_dlg.row_height[0] = 280;
   missrec_dlg.row_height[1] = 1118;
   missrec_dlg.row_height[2] = 280;

   CString str;
   str.LoadString(IDS_MODIFYDATE);
   missrec_dlg.m_Content[0][0] = str;
   str.LoadString(IDS_CONTENT);
   missrec_dlg.m_Content[1][0] = str;
   str.LoadString(IDS_ALARM);
   missrec_dlg.m_Content[2][0] = str;


   duprec_dlg.total_cols = 2;
   duprec_dlg.total_rows = 3;
   duprec_dlg.col_width[0] = 1200;
   duprec_dlg.col_width[1] = 5000;
   duprec_dlg.row_height[0] = 280;
   duprec_dlg.row_height[1] = 1118;
   duprec_dlg.row_height[2] = 280;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPC[0][0] = str;
   str.LoadString(IDS_CONTENT);
   duprec_dlg.m_ContentPC[1][0] = str;
   str.LoadString(IDS_ALARM);
   duprec_dlg.m_ContentPC[2][0] = str;

   str.LoadString(IDS_MODIFYDATE);
   duprec_dlg.m_ContentPDA[0][0] = str;
   str.LoadString(IDS_CONTENT);
   duprec_dlg.m_ContentPDA[1][0] = str;
   str.LoadString(IDS_ALARM);
   duprec_dlg.m_ContentPDA[2][0] = str;

	CHKTERM;
	SyncIdleMode();	
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

/* send all record header data from PDA */
	if(SyncDBInfo(PDA_SCHREPDB, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

	GetLastSyncRecID(SCHREPDB, &last_pda_recid, &last_pc_recid);

	CHKTERM;
    GetLastSyncDate(SCHREPDB, &last_sync_date);

	SchRepArchivePCPDASync(dbid);
	CHKTERM;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 1000)
		return 1;

/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += SCHREPDB;
	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ") and RecordID >= 0 ";
	}
	else
		szSql += " where RecordID >= 0"; // for email msg only, not condiser cat

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += SCHREPDB;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}

//goto chkboth;
	
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if((((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)  && (((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  SchRepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should sync to recycle then delete from PDA */
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			  if(recycle_pda_schrep)
			  {
			  CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  SchRepAddRecord(dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  }
#endif
		   /* then delete it */
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBUpMode();
			  CHKTERM;
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
			  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else
		   {

			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			   int action;

			   if(missrec_act)	// user has define the default action
			   {
				   if (missrec_act == SYNC_REC)
				   {
					  rec_content.Empty();
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			          CHKTERM;
				   }
 				   action = missrec_act;
			   }
			   else
			   {
		      rec_content.Empty();
	          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
	          CHKTERM;
			  missrec_dlg.total_rows = 3;
			  missrec_dlg.total_cols = 2;

			  CString str;
			  str.LoadString(IDS_MISS_PC);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PC);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPDA);
			   missrec_dlg.m_szMissLabel = str;

			   // modi date
			   missrec_dlg.m_Content[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   missrec_dlg.m_Content[0][1].Remove('#');

		   
			   fielddata.Empty(); // content
			   PDADataGetField(8, &rec_content, &fielddata);
			   missrec_dlg.m_Content[1][1] = fielddata;

			   fielddata.Empty(); // alarm
			   PDADataGetField(5, &rec_content, &fielddata);
			   if(fielddata)
			   {
			   str.LoadString(IDS_YES);
				missrec_dlg.m_Content[2][1] = str;
			   }
			   else
			   {
			   str.LoadString(IDS_NO);
                missrec_dlg.m_Content[2][1] = "No";
			   }

			   str.LoadString(IDS_SYNCTOPC);
			   missrec_dlg.szBtn1Lbl = str;

			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
					   PCDeleteRecord(dbArchive, SCHREPDB,((RecordHeader)(record[i].rec_header)).rec_id);
					   PCDeleteRecord(dbRecycle, SCHREPDB, ((RecordHeader)(record[i].rec_header)).rec_id);
					   SchRepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }
}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	missrec_act = 0;
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{

			CHKTERM;
//			if((rs_pc->GetFieldValue(0)).lVal <= last_pc_recid)
			if( (rs_pc->GetFieldValue(0)).lVal < last_pc_recid  && (rs_pc->GetFieldValue(0)).lVal > last_pda_recid)
			{  /* if it is created after last sync in PC, should upload to PDA */
				PDASchRepAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);	
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
			//	SchRepMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue(0)).lVal);
				PCDeleteRecord(dbCurrent, SCHREPDB, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */		

				int action;
			if(missrec_act)
				action = missrec_act;
			else
			{

 			   CString data;
			   COleDateTime modid;
			   modid = rs_pc->GetFieldValue("ModifyDate");
			   missrec_dlg.m_Content[0][1] = ValidDBDate(&modid);

			   // content
			   missrec_dlg.m_Content[1][1] = (LPSTR)(rs_pc->GetFieldValue("Content")).bstrVal;

//			   // alarm
			   CString str;
			   if(rs_pc->GetFieldValue("AlarmFlag").boolVal)
			   {
				   str.LoadString(IDS_YES);
				   missrec_dlg.m_Content[2][1] = str;
			   }
			   else
			   {
				   str.LoadString(IDS_NO);
				   missrec_dlg.m_Content[2][1] = str;
			   }

			   missrec_dlg.total_rows = 3;
	    	   missrec_dlg.total_cols = 2;

				str.LoadString(IDS_MISS_PDA);
               missrec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_SELECTACTION_PDA);
			   missrec_dlg.m_szMissMsg = str;
			   str.LoadString(IDS_RECORDINPC);
			   missrec_dlg.m_szMissLabel = str;
			   str.LoadString(IDS_SYNCTOPDA);
			   missrec_dlg.szBtn1Lbl = str;
			   missrec_dlg.DoModal();

			   action =  missrec_dlg.Result;

			   if(missrec_dlg.m_chkAll)
				   missrec_act = missrec_dlg.Result;
			   }  // no default
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   PDASchRepAddRecord(dbCurrent, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
				   break;
				   case DEL_REC:
		   			   //SchRepMoveRecord(dbCurrent, dbRecycle, (rs_pc->GetFieldValue("RecordID")).lVal);
					   PCDeleteRecord(dbCurrent, SCHREPDB, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;

			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;
//			if(((RecordHeader)(record[i].rec_header)).rec_id < 1001)
//			{

//			}
//			else

			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  //SchRepMoveRecord(dbCurrent, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			  SchRepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				PDASchRepAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue(0)).lVal);
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
				int action;


			if(TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date)) < 0)
			 {
				 action = duprec_act = SYNC_TO_PC;
				  SyncIdleMode(); CHKTERM;
				  SyncDBEnqMode(); CHKTERM;
		         SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			 }
			 else
				 action = duprec_act = SYNC_TO_PDA;

			if (abs(TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(record[i].rec_header.modi_date))) > 2)
			  {
			   if(duprec_act)	// user has define the default action
			   {
				   if(duprec_act == SYNC_TO_PC)
				   {
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
 	//  	              SyncIdleMode(); CHKTERM;
      //                SyncDBEnqMode(); CHKTERM;
				   }
					action = duprec_act;
			   }
			   else

			   {
				   ///////////////// prepare PDA content
				      rec_content.Empty();
					  SyncIdleMode(); CHKTERM;
					  SyncDBEnqMode(); CHKTERM;
			          SyncReadRec(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
// 	  	              SyncIdleMode(); CHKTERM;
  //                    SyncDBEnqMode(); CHKTERM;

				CString str;
				str.LoadString(IDS_MODIFY);
               duprec_dlg.WndTitle = str;
			   str.LoadString(IDS_Q_MODIFY);
			   duprec_dlg.m_szDupMsg = str;

			   // modi date
			   duprec_dlg.m_ContentPDA[0][1] = (_date322DB(((RecordHeader)(record[i].rec_header)).modi_date));
			   duprec_dlg.m_ContentPDA[0][1].Remove('#');
   
			   fielddata.Empty(); // content
			   PDADataGetField(8, &rec_content, &fielddata);
			   duprec_dlg.m_ContentPDA[1][1] = fielddata;

			   fielddata.Empty();  // alarm
			   PDADataGetField(5, &rec_content, &fielddata);
			   if(fielddata)
			   {
				   str.LoadString(IDS_YES);
				   duprec_dlg.m_ContentPDA[2][1] = str;
			   }
			   else
			   {
				   str.LoadString(IDS_NO);
				   duprec_dlg.m_ContentPDA[2][1] = str;
			   }

   			   fielddata.Empty();
            
			   // date
			   CString data;
			   COleDateTime modid;
			   modid = rs_both->GetFieldValue("ModifyDate");
			   duprec_dlg.m_ContentPC[0][1] = ValidDBDate(&modid);
   
			   // content
			   duprec_dlg.m_ContentPC[1][1] = (LPSTR)(rs_both->GetFieldValue("Content")).bstrVal;

			   // alarm
			   if(rs_both->GetFieldValue("AlarmFlag").boolVal)
			   {
				   str.LoadString(IDS_YES);
				   duprec_dlg.m_ContentPC[2][1] = str;
			   }
			   else
			   {
				   str.LoadString(IDS_NO);
				   duprec_dlg.m_ContentPC[2][1] = str;
			   }

			   duprec_dlg.DoModal();

			   action =  duprec_dlg.Result;

			   if(duprec_dlg.m_chkForAll)
				   duprec_act = duprec_dlg.Result;
			   }  // no default

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			           CHKTERM;
					   PDASchRepAddRecord(dbCurrent, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   break;
				   case SYNC_TO_PC:
		   			   //SchRepMoveRecord(dbCurrent, dbRecycle, (rs_both->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   SchRepAddRecord(dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
			  }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			} // if
			rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;
	
	DeferDeletePDACat(dbid);
	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
	}

	if(record)
	{
	   free(record);
	   record = NULL;
	}

	UpdateLastRecID(SCHREPDB, last_pda_recid);
	
	return 0;
terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;
	if(record)
		free(record);

	return 1;
}
