#include "stdafx.h"
#include "syncdb.h"
#include "schvox.h"
#include "TimeFct.h"
#include "VPSync.h"
#include "all_db.h"

void TSVoxRecIDCrashRecover(CString dbname, CString voxpath, CString parentdbname, CDaoDatabase *db);
void TSVoxDelNonRefRecord(CDaoDatabase *src_db, CString &tblname, CString &voxtblname);

int TSUpdateVox(CString dbname, int mode)
{
/*
	int i;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RTM last_sync_date;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
	int dbmode;
	CString pda_name;
	DatabaseID dbid;
*/
	DatabaseID dbid;
	int total_rec;
	RecordID last_pda_recid, last_pc_recid;
	int i, missrec_act = NULL_ACT, duprec_act = NULL_ACT;
	CString dbheader;
	CString rec_content, szSql, fielddata, szSqlBoth;
	RecStruct *record = NULL;
	RTM last_sync_date;
	CDaoRecordset *rs_pc = NULL, *rs_pda=NULL, *rs_both = NULL;
	char found = 0;
	int dbmode;
	CString pda_name;
	CString par_name;


#define MODE_SCH 1
#define MODE_TODO 2

	if(dbname == SCHVOXDB)
	{
		dbmode = MODE_SCH;
		pda_name = PDA_SCHVOXDB;
		par_name = SCHDB;
	}
	else
	{
		dbmode = MODE_TODO;
		pda_name = PDA_TODOVOXDB;
		par_name = TODODB;
	}

	ValidRecordModiDate(dbCurrent, dbname);
	TSVoxDelNonRefRecord(dbCurrent, par_name, dbname);

	if(SyncDBInfo(pda_name, &dbid, &dbheader))   /* get dbid of phone book */
		return 1;

//	PhoneBookArchivePDAOvrPC(dbid);
//	CHKTERM;


	GetLastSyncRecID(dbname, &last_pda_recid, &last_pc_recid);

	CHKTERM;

	GetLastSyncDate(dbname, &last_sync_date);
	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error
	if (total_rec > 1000)
		return 1;


	/* find record that in PC but not in PDA */
	szSql = "select * from ";
	szSql += dbname;

	if(total_rec)
	{
		szSql += " where RecordID not in (";
		for(i=0;i<total_rec;i++)
		{
			szSql += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSql += ",";
		}
		szSql = szSql.Left(szSql.GetLength()-1);
		szSql += ")";
	}

	rs_pc = new CDaoRecordset(dbCurrent);
	try
	{
		rs_pc->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		rs_pc = NULL;
	}

	CHKTERM;
	
/* Record exits in both Platform */
	if(total_rec)
	{
		szSqlBoth = "select * from ";
		szSqlBoth += dbname;
		szSqlBoth += " where RecordID in(";
		for(i=0;i<total_rec;i++)
		{
			szSqlBoth += Str_ul(((RecordHeader)(record[i].rec_header)).rec_id);
			szSqlBoth += ",";
		}
		szSqlBoth = szSqlBoth.Left(szSql.GetLength()-1);
		szSqlBoth += ')';


	rs_both = new CDaoRecordset(dbCurrent);
	try
	{
			rs_both->Open(dbOpenSnapshot, szSqlBoth, dbReadOnly);
	}
	catch (CDaoException *e)
	{
			e->Delete();
			TRACE("\nErr exe statement: %s ", szSql);
			rs_both =NULL;
	}
	}

//goto chkboth;
	
	if(mode == CAT_PC_PDA_SYNC)
		goto pc_pda_sync;

	if(mode == CAT_PDA_OVR_PC)
		goto pda_ovr_pc;

	if(mode == CAT_PC_OVR_PDA)
		goto pc_ovr_pda;

////////////////////////////////////////////////////////////////////////////
//		Default:  Crash Recover
////////////////////////////////////////////////////////////////////////////
// sync PC only cat to PDA
// sync PDA only cat to PC
////////////////////////////////////////////////////////////////////////////
	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
			/* record in PDA but not in PC */
		      SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
 			  TSVoxAddRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
	   }
	  }
    }  // Rec not found in PC

// rec in PC only
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
			PDADeleteRecord(dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
			CHKTERM;
			PDATSVoxAddRecord(dbCurrent, dbname, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
			CHKTERM;
			rs_pc->MoveNext();
		}
		rs_pc->Close();
  	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}

	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}

goto vox_sync_end;

pc_ovr_pda:
///////////////////////////////////////////////////////////////////////////////////
//  PC Over PDA
///////////////////////////////////////////////////////////////////////////////////
// del PDA only rec
//////////////////////////////////////////////////////////////////////////////////
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
			/* record in PDA but not in PC */
			  PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			  CHKTERM;
	   }
	  }
    }  // Rec not found in PC

goto vox_sync_end;


//////////////////////////////////////////////////////////////////////////////
//				PC Over PDA
//////////////////////////////////////////////////////////////////////////////
//  delete PC only cat
//////////////////////////////////////////////////////////////////////////////
pda_ovr_pc:
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;
			TSVoxDeleteRecord(dbCurrent, dbname, (rs_pc->GetFieldValue("RecordID")).lVal);
			rs_pc->MoveNext();
		}
		rs_pc->Close();
  	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}

	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
goto vox_sync_end;

//////////////////////////////////////////////////////////////////////////////
//				PC PDA SYNC
//////////////////////////////////////////////////////////////////////////////
pc_pda_sync:

	CHKTERM;
/* Compare all record in PC with PDA */
	if(total_rec)
	{   
for(i=0;i<total_rec;i++)
	   {

/////////////////////////////////////////////////////////

	  for(i=0;i<total_rec;i++)
	  {
	   if(!DBIsExistRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id))
	   {
/* record in PDA but not in PC */
		   /* if the record is a new one, sync to PC */
		   if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > 0)
		   {  /* this is a new record in PDA since last sync, send it to PC */
			  CHKTERM;
		      SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  SyncIdleMode();	
			  CHKTERM;
		   	  SyncDBUpMode();
			  CHKTERM;
			  TSVoxAddRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			  CHKTERM;
		      rec_content.Empty();
		  	  SyncIdleMode();
			  CHKTERM;
	          SyncDBEnqMode();
			  CHKTERM;
		   }
		   else if (TimeDiff(_date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= 0)
		   { /* delete from PC, not modified in PDA, should
		     /*   delete it */
			   SyncIdleMode(); CHKTERM;
			   SyncDBUpMode(); CHKTERM;
			   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			   CHKTERM;
		  	   SyncIdleMode();
			   CHKTERM;
	           SyncDBEnqMode();
		       CHKTERM;
		   }
		   else
		   {
			   /* this record is modified in PDA, but delete in PC, ask User delete it from PDA or Sync to PC current db */
			   /* sync data from PDA */
			   int action = SYNC_REC;

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_REC:
//					   PCDeleteRecord(dbArchive, dbname,((RecordHeader)(record[i].rec_header)).rec_id);
//					   PCDeleteRecord(dbRecycle, dbname, ((RecordHeader)(record[i].rec_header)).rec_id);
//					   PCAddCat(dbCurrent, dbname, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   TSVoxDeleteRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id);
					   TSVoxAddRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   break;
				   case DEL_REC:
					   SyncIdleMode(); CHKTERM;
					   SyncDBUpMode(); CHKTERM;
					   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
					   SyncIdleMode(); CHKTERM;
					   SyncDBEnqMode(); CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
		   }
	   }
	}
	   }  // Rec not found in PC
	}
////////////////////////////////////////////////////////////
// rec in PC only
	CHKTERM;
	if(rs_pc)
	if(!rs_pc->IsBOF())
	{
		SyncIdleMode();	CHKTERM;
		SyncDBUpMode(); CHKTERM;
		rs_pc->MoveFirst();
		while(!rs_pc->IsEOF())
		{
			CHKTERM;

			if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) >= MODI_TIME)
			{  /* if it is created after last sync in PC, should upload to PDA */
//				PDAAddCat(dbCurrent, dbname, pc_cat_field_name, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
//				PDATSVoxAddRecord();
			PDADeleteRecord(dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
			CHKTERM;
			PDATSVoxAddRecord(dbCurrent, dbname, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
			}
			else if(TimeDiff( DBDate2RTM(COleDateTime((rs_pc->GetFieldValue(1)))), last_sync_date) <= MODI_TIME)
			{ /* the record is deleted from PDA, but not modified in PC, should delete it from PC */
				PCDeleteRecord(dbCurrent, dbname, (rs_pc->GetFieldValue(0)).lVal);
				TSVoxDeleteRecord(dbCurrent, dbname, (rs_pc->GetFieldValue(0)).lVal);
			}
			else
			{
				/* Record is modified in PC, but delete in PDA, ask user delete it from PC or sync to PDA */

			   int action = SYNC_REC;
			   switch(action)
			   {  // rec modi in pc but  del in pda
				   case SYNC_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   //PDATSVoxAddRecord(dbCurrent, dbname, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
					   /////PDAAddCat(dbCurrent, dbname,  dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
					   PDADeleteRecord(dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   PDATSVoxAddRecord(dbCurrent, dbname, dbid, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
				   break;
				   case DEL_REC:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
					   TSVoxDeleteRecord(dbCurrent, dbname, (rs_pc->GetFieldValue("RecordID")).lVal);
					   CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
			   CHKTERM;

			}
			rs_pc->MoveNext();
			CHKTERM;
		}
		rs_pc->Close();
   	    SyncIdleMode();	CHKTERM;
     	SyncDBEnqMode(); CHKTERM;
	}  // rec in PC not in PDA

	CHKTERM;
	if(rs_pc)
	{
	  delete rs_pc;
	  rs_pc = NULL;
	}
chkboth:
	if(rs_both)
	if(!rs_both->IsBOF())
	{
	  SyncIdleMode();	CHKTERM;
	  SyncDBUpMode(); CHKTERM;
	  rs_both->MoveFirst();
	  while(!rs_both->IsEOF())
		{
		  char found = 0;;
  		  for(i=0;i<total_rec;i++)
			if(((rs_both->GetFieldValue("RecordID")).lVal) == ((RecordHeader)(record[i].rec_header)).rec_id)
			{
				found = 1;
				break;
			}
			if(found)
			{

			CHKTERM;
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{
			   // not modified, do nothing
			}
			else
			if( ((TimeDiff( DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) <= MODI_TIME)
				&& TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) > MODI_TIME))
			{ /* record only modify in PDA, sync to PC */
			  SyncIdleMode(); CHKTERM;		  
			  SyncDBEnqMode(); CHKTERM;
		      SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
			  CHKTERM;
			  TSVoxAddRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		      rec_content.Empty();
			  CHKTERM;
			}
			else if( (TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), last_sync_date) > MODI_TIME)
				&& (TimeDiff( _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date), last_sync_date) <= MODI_TIME))
			{ /* record modify in PC only, sync to PDA */
				SyncIdleMode(); CHKTERM;
				SyncDBUpMode(); CHKTERM;
			    //PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
//				PDAAddCat(dbCurrent, dbname, pc_cat_field_name, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
				//PDAVoxAddRecord()
			   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			   CHKTERM;
			   PDATSVoxAddRecord(dbCurrent, dbname, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			   CHKTERM;
			}
			else
			{ /* modified on PC and PDA, very complex, see doc */
				int action;
			
			    if( TimeDiff(DBDate2RTM(COleDateTime((rs_both->GetFieldValue("ModifyDate")))), _date322rtm(((RecordHeader)(record[i].rec_header)).modi_date)) > 0)
				{
					action = SYNC_TO_PDA;
				}
				else
				{
					action = SYNC_TO_PC;
					SyncIdleMode();
					SyncDBEnqMode();
				        SyncReadRecLarge(dbid, ((RecordHeader)(record[i].rec_header)).rec_id, (char*) &record[i].rec_header, &rec_content);
				}

			   switch(action)
			   {  // rec modi in pda but not del in pc
				   case SYNC_TO_PDA:
			  		   SyncIdleMode();
			           CHKTERM;
	                   SyncDBUpMode();
			           CHKTERM;
//   		               PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
//			           CHKTERM;
					   //PDAAddCat(dbCurrent, dbname, pc_cat_field_name, dbid, (rs_both->GetFieldValue("RecordID")).lVal);
					   //PDATSVoxAddRecord()
			   PDADeleteRecord(dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
			   CHKTERM;
			   PDATSVoxAddRecord(dbCurrent, dbname, dbid, ((RecordHeader)(record[i].rec_header)).rec_id);
					   CHKTERM;
					   break;
				   case SYNC_TO_PC:
					   CHKTERM;
	//				   PCAddCat(dbCurrent, dbname, pc_cat_field_name,((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
					   TSVoxAddRecord(dbCurrent, dbname, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
			           CHKTERM;
					   break;
				   case NOT_SYNC:
				   default:
					   break;
			   }
	           SyncIdleMode();
	           CHKTERM;
               SyncDBEnqMode();
               CHKTERM;
			}
			} // if
			rs_both->MoveNext();
		  CHKTERM;
	  }  // while
	   rs_both->Close();			
	   SyncIdleMode(); CHKTERM;	
 	   SyncDBEnqMode(); CHKTERM;
	} /* Record exits in both Platform */

	CHKTERM;

	if(rs_both)
	{
		delete rs_both;
		rs_both = NULL;
	}

vox_sync_end:	

	if(total_rec)
	{
		for(i=0;i<total_rec;i++)
		{

			if ( (((RecordHeader)(record[i].rec_header)).rec_id > last_pda_recid)
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < last_pc_recid))
				&& ((((RecordHeader)(record[i].rec_header)).rec_id < 1073741823)))
				 last_pda_recid = ((RecordHeader)(record[i].rec_header)).rec_id;
		}
		UpdateLastRecID(dbname, last_pda_recid);
	}

	if(record)
	{
	   free(record);
	   record = NULL;
	}

	CHKTERM;

	UpdateLastSyncDate(dbname);


	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;


	return 0;

terminate:
	if(rs_pc)
		delete rs_pc;
	if(rs_pda)
		delete rs_pda;
	if(rs_both)
		delete rs_both;

	return 1;

}




BOOL TSVoxAddRecord(CDaoDatabase *src_db, CString &dbname, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{

	CString szSql;
	CString fielddata;
	COleVariant dbdata;
	CString filename;

	TSVoxDeleteRecord(src_db, dbname, rec_id);

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += dbname;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	rsCurrent->SetFieldValue("Filename",(LPCTSTR)TSVoxGetExternFileName(rec_id));


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	PDADataGetField(0, rec_content, &fielddata);
	TSVoxCreateExternFile(src_db, dbname, rec_id, &fielddata);

	return FALSE;
}


BOOL TSVoxDeleteRecord(CDaoDatabase *src_db, CString &dbname, RecordID rec_id)
{
	CString szSql;

	if (!CatRec(rec_id))
		TSVoxDeleteExternFile(src_db, dbname, rec_id);

	szSql = "delete from ";
	szSql += dbname;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}
	return FALSE;
}




BOOL TSVoxDeleteExternFile(CDaoDatabase *src_db, CString &dbname, RecordID rec_id)
{
	CString szSql, filename;
	COleVariant dbdata;
	CDaoRecordset *rs = NULL;
	BOOL ret = TRUE;

	szSql = "select FileName from ";
	szSql += dbname;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		goto skipdelfile;
	}

	if(!rs->IsBOF())     // delete the voice 
	{
		rs->MoveFirst();
		dbdata = rs->GetFieldValue(0);
		if ((LPCSTR) dbdata.bstrVal)
		{
			filename = TSVoxGetFilePath(dbname);
			filename += (LPCSTR) dbdata.bstrVal;
			if (DeleteFile(filename) == 0)
				TRACE("\nUnable to delete file %s ", filename);
			else
				ret = FALSE;
		}
		rs->Close();
	}
	if(rs)
		delete rs;
	ret = FALSE;
skipdelfile:
	return ret;
}


CString TSVoxGetFilePath(CString &dbname)
{
	CString filename;

	filename = szUserPath;

	if(dbname == SCHVOXDB)
	  filename += "SchVox\\";
	else
	  filename += "ToDoVox\\";

	return filename;
}

CString TSVoxGetExternFileName(RecordID rec_id)
{
	CString name;

	name.Format("%08x.alp", rec_id);

	return name;
}


BOOL TSVoxCreateExternFile(CDaoDatabase *src_db, CString &dbname, RecordID rec_id, CString *content)
{
	CString filename;
	CFileException e;
	CFile file;
	char *buffer;

	filename = TSVoxGetFilePath(dbname) + TSVoxGetExternFileName(rec_id);

	try
	{
		if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return TRUE;
	}
	
	buffer = (char*) content->GetBuffer(content->GetLength());

	try
	{
		file.WriteHuge(buffer, content->GetLength() );
	}

    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		content->ReleaseBuffer();
		return TRUE;
	}

	content->ReleaseBuffer();

	file.Close();

	return FALSE;
}


BOOL TSVoxMoveExternFile(CDaoDatabase *src_db, CDaoDatabase *dest_db, CString dbname, RecordID rec_id)
{
	CString src_pathname;
	CString dest_pathname;

	src_pathname = TSVoxGetFilePath(dbname) + TSVoxGetExternFileName(rec_id);
	dest_pathname = TSVoxGetFilePath(dbname) + TSVoxGetExternFileName(rec_id);

	if(!MoveFile(src_pathname, dest_pathname))
	{
		TRACE("\nCannot move file form %s  to \n   %s ", src_pathname, dest_pathname);
		return TRUE;
	}
	
	return FALSE;
 
}


BOOL PDATSVoxAddRecord(CDaoDatabase *src_db, CString &dbname, DatabaseID dbid, RecordID rec_id)
{

	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[5];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;
	CString not_sync_data;

	if(rec_id <= 0 )
		return FALSE;

	szSql = "select * from ";
	szSql += dbname;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */
	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	if(dbname == "SchVoice")
		header.total_field = 3;
	else
	header.total_field = 2;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

//	if((rs->GetFieldValue(3)).boolVal)
//		SetRecSecret(((RecordHeader*)&header));
//	if((rs->GetFieldValue(4)).boolVal)
//		SetRecLock(((RecordHeader*)&header));
/*
	fielddata = VoxPCDate2PDA(COleDateTime((rs->GetFieldValue(5))));
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	not_sync_data = content;
*/
	CString filename;
	CFileException e;
	CFile file;
	char *buffer;

	filename = TSVoxGetFilePath(dbname) + TSVoxGetExternFileName(rec_id);
	CString voxdata;

	if(!ExistFile(filename))
	{
//		return TRUE;
		voxdata = "";
	}
	else
	{

	try
	{
	if( !file.Open( filename, CFile::modeRead|CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		if(rs)
		{
			rs->Close();
			delete rs;
		}
		return TRUE;
	}

	file.SeekToEnd();
	file.SeekToBegin();

	int filelen = file.GetLength();

	try
	{
	buffer = (char*) voxdata.GetBufferSetLength(filelen);
	}
	catch (CMemoryException *ee)
	{
		ee->Delete();
	}
	
	try
	{
		file.ReadHuge(buffer, file.GetLength());
	}
    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		if(rs)
		{
			rs->Close();
			delete rs;
		}

		return TRUE;
	}

	file.Close();
	voxdata.ReleaseBuffer(filelen);
//		voxdata.ReleaseBuffer(6100);
	}

	size_array[0] = voxdata.GetLength();
	data32_2 = size_array[0];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += voxdata;
	
	size_array[1] = 0;
/*
	data32_2 = size_array[2];
	   EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];

	fielddata = (LPSTR)(rs->GetFieldValue("Notes")).bstrVal;
	AddNULL(&fielddata);
	size_array[3] = fielddata.GetLength();
*/
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
//	content += fielddata;
	if(dbname == "SchVoice")
	{
		//for the field data added by Michelle in Schvoice
		CDaoRecordset* rsTemp;
		CString szTemp;
		unsigned int nCount = 0;
		rsTemp = new CDaoRecordset(src_db);
		szTemp = "select * from Scheduler where VoiceID = ";
		szTemp += Str_ul(rec_id);
		rsTemp->Open(dbOpenSnapshot,szTemp,0);
		if(!rsTemp->IsEOF())
			rsTemp->MoveLast();
		nCount += rsTemp->GetRecordCount();
		rsTemp->Close();
		szTemp = "select * from SchRepeat where VoiceID = ";
		szTemp += Str_ul(rec_id);
		rsTemp->Open(dbOpenSnapshot,szTemp,0);
		if(!rsTemp->IsEOF())
			rsTemp->MoveLast();
		nCount += rsTemp->GetRecordCount();
		rsTemp->Close();
		delete rsTemp;
		rsTemp = NULL;

		if(nCount == 0)
			nCount = 1;

		size_array[2] = 4;
		data32_2 = size_array[2];
	    EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
		  content += ptr[j];
		ptr = (char*) &nCount;
		content += ptr[0];
		content += ptr[1];
		content += ptr[2];
		content += ptr[3];

	}

	header.size = content.GetLength();

#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
/*	if(header.size > SYNC_THRESHOLD_SIZE)
	{
		CLongTimeDlg t_dlg;

		t_dlg.m_msg = "The following sound record \r\n\r\n[ ";
		t_dlg.m_msg += (LPSTR)(rs->GetFieldValue("Notes")).bstrVal;
		t_dlg.m_msg += " ]\r\n\r\nestimated to take ";
		t_dlg.m_msg += Str_ul(header.size / 4000);
		t_dlg.m_msg += " seconds to synchronize.";
		t_dlg.m_msg += "Do you want to synchronize this record?";

		t_dlg.DoModal();

		if(t_dlg.result == 1)  // not sync
		{
#ifdef xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			size_array[1] = 0;
			data32_2 = size_array[1];
		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  not_sync_data += ptr[j];
			size_array[2] = 0;
			data32_2 = size_array[2];
 		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  not_sync_data += ptr[j];		
			size_array[3] = 13;
			data32_2 = size_array[3];
 		    EnFieldSize(data32, data32_2, byte_use);
			ptr = (char*) &data32;
			for(j=0;j<byte_use;j++)
			  not_sync_data += ptr[j];
			not_sync_data += "Rec not sync";
			AddNULL(&not_sync_data);
			content = not_sync_data;
			header.size = content.GetLength();
#endif

			szSql = "Update ";
			szSql += VOXDB;
			szSql += " set Lock = TRUE, Secret = FALSE where RecordID = ";
			szSql += Str_ul(rec_id);

			BOOL is_fault = FALSE;
			try
			{
				src_db->Execute(szSql);
			}
			catch (CDaoException *e)
			{
				e->Delete();
				TRACE("\ncannot exe SQL statement %s ", szSql);
				is_fault = TRUE;
			}

			if(!is_fault)
				return FALSE;
			CString string;
			string.LoadString(IDS_SKIPRECORD);
			AfxMessageBox(string);
		}
	}
*/
#endif

	if(header.size > 4080)
	{
		header.size = 4096;
		header.attribute |= 0x20;
	}

	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

//	SyncIdleMode();
//	SyncDBUpMode();
	if(dbname == "SchVoice")
		SyncRecAddLarge(dbid, rec_id, 3, size_array, &header, &content);
	else
	SyncRecAddLarge(dbid, rec_id, 2, size_array, &header, &content);
	}
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	return FALSE;

}

void TSVoxDelNonRefRecord(CDaoDatabase *src_db, CString &tblname, CString &voxtblname)
{
	CString szSql;
	CDaoRecordset *pRs=NULL;
// delete all invalid/no-reference record 
// do not del the vox file since may ref. by current/archive/recycle

	szSql = "select VoiceID from ";
	szSql += tblname;

	if(tblname == TODODB)
		szSql += " where VoiceID <> 0 and AlarmStatus <> 0 and AlarmStatus <> 1";
	else
	    szSql += " where VoiceID <> 0 and AlarmType <> 0 and AlarmType <> 2";

	pRs = new CDaoRecordset(src_db);
	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nErr exe statement: %s ", szSql);
		delete pRs;
		pRs = NULL;
	}
	
	if(pRs)
	{
		szSql = "delete * from ";
		szSql += voxtblname;
		szSql += " where RecordID not in (";
		while(!pRs->IsEOF())
		{
			szSql += Str_ul(pRs->GetFieldValue("VoiceID").lVal);
			szSql += ",";
			pRs->MoveNext();
		}

		szSql += "0)";

		try
		{
			src_db->Execute(szSql);
		}
		catch(CDaoException *e)
		{
			e->Delete();
		}
	
		delete pRs;
	}

	return;
}

