#include "stdafx.h"
#include "syncdb.h"
#include "TimeFct.h"
#include "All_DB.h"
#include "Sketch.h"
#include "resource.h"
#include "syncdispdlg.h"

extern CString current_path;
extern CSyncDispDlg *m_DispDlg;
extern int nPDA2PC;
extern int nPC2PDA;
extern int station_num;

#define COLOR_WHITE 0xFF
#define COLOR_BLACK 0x00

#define SKETCH_WIDTH	153
#define SKETCH_HEIGHT	122
#define SKETCH_REAL_WIDTH	160
#define SKETCH_HEAD_LENGTH	54
typedef struct
{
	short bfType;             /*  1 -  2 */
	int bfSize;            /*  3 -  6 */
	short bfReserved1;        /*  7 -  8 */
	short bfReserved2;        /*  9 - 10 */
	int bfOffBits;         /* 11 - 14 */
	int biSize;            /* 15 - 18 */
	int biWidth;           /* 19 - 22 */
	int biHeight;          /* 23 - 26 */
	short biPlanes;           /* 27 - 28 */
    short biBitCount;         /* 29 - 30 */
	int biCompression;     /* 31 - 34 */
	int biSizeImage;       /* 35 - 38 */
	int biXPelsPerMeter;   /* 39 - 42 */
	int biYPelsPerMeter;   /* 43 - 46 */
	int biClrUsed;         /* 47 - 50 */
	int biClrImportant;    /* 51 - 54 */
} BMP_HEADER;


#define BMP_HEADER_SIZE 54

void SketchPCToPDA(char *PC, char *PDA)
{

	int i,k;
	char *pc = PC + BMP_HEADER_SIZE;  // skip header
	int total_line = SKETCH_HEIGHT - 1;
	int total_bit = 0;
	char *pdadata;
	int shift_byte;
	int bit_bitmap;

	bit_bitmap = (*(PC + 28))/8;
	shift_byte = 3;

	for(i=0;i<SKETCH_REAL_WIDTH * SKETCH_HEIGHT / 8;)
	{
		pdadata = PDA + i + shift_byte;
		if(--shift_byte <0)
		{
			shift_byte = 3;
			i+= 4;
		}
		*pdadata = 0;
		if(total_bit != 152)
		{
			for(k=0;k<8;k++)
			{
				if (pc[total_line * (152*bit_bitmap + 4) + total_bit*(bit_bitmap)] == COLOR_BLACK)
					*pdadata |= ( 1 << (7 - k));
				total_bit++;
			}
		}
		else
		{
			if (pc[total_line * (152*bit_bitmap + 4) + total_bit*(bit_bitmap)] == COLOR_BLACK)
				*pdadata |= ( 1 << 7);
			total_bit = 0;
			total_line--;
		}
	}
}

void SetBlack(char *x)
{
	x[0] =  x[1] = x[2] = COLOR_BLACK;
}
	
void SetWhite(char *x)
{
	x[0] = COLOR_WHITE;
	x[1] = COLOR_WHITE;
	x[2] = COLOR_WHITE;
}

void SketchPDAToPC( char *PDA, char *PC)
{
	int i, k;
	char *pda = PDA;
	char *pc = PC + BMP_HEADER_SIZE;


	for(i=0;i<100;i++)
		PC[i] = 0;

	PC[0] = 0x42;
	PC[1] = 0x4D;
	PC[2] = 0x6e;
	PC[3] = 0xdb;
	PC[4] = 0x00;
	PC[5] = 0x00;
	PC[6] = 0x00;
	PC[7] = 0x00;
	PC[8] = 0x00;
	PC[9] = 0x00;
	PC[10] = 0x36;
	PC[11] = 0x00;
	PC[12] = 0x00;
	PC[13] = 0x00;
	PC[14] = 0x28;
	PC[15] = 0x00;
	PC[16] = 0x00;
	PC[17] = 0x00;
	PC[18] = 0x99;
	PC[19] = 0x00;
	PC[20] = 0x00;
	PC[21] = 0x00;
	PC[22] = 0x7a;
	PC[23] = 0x00;
	PC[24] = 0x00;
	PC[25] = 0x00;
	PC[26] = 0x01;
	PC[27] = 0x00;
	PC[28] = 0x18;
	PC[29] = 0x00;
	PC[30] = 0x00;
	PC[31] = 0x00;
	PC[32] = 0x00;
	PC[33] = 0x00;
	PC[34] = 0x38;
	PC[35] = 0xdb;
	PC[36] = 0x00;
	PC[37] = 0x00;

	int total_bit = 0;
	char cdata;
	char *pdata;
	int total_line = SKETCH_HEIGHT - 1;

	for(i=0;i<SKETCH_REAL_WIDTH * SKETCH_HEIGHT / 8;i+=4) /* total 2440 byte*/
	{
			pdata =  pda + i;
			for(int xx=0;xx<4;xx++)
			{
				cdata = *(pdata + 3- xx);
				if( ! ( (((i/4+1)%5) == 0) && (i!=0) && (xx == 3)))
				{
					for(k=0;k<8;k++)
					{
						if(cdata & ( 1 << (7 - k))) // 460 = 153 * 3 + 1
							SetBlack(pc + (total_line * 460 + total_bit));
						else
							SetWhite(pc+ (total_line * 460 + total_bit));
						total_bit += 3;
					}
				}
				else
				{
					if(cdata & ( 1 << (7 - k)))
						SetBlack(pc + (total_line * 460 + total_bit));
					else
						SetWhite(pc+ (total_line * 460 + total_bit));
					total_bit += 3;
					total_line--;
					total_bit += 1;
					total_bit = 0;
				}
			}
	}
}





CString SketchGetSketchFileName(RecordID rec_id)
{
	CString name;

	name.Format("%08x", rec_id);
	name.MakeUpper();
	name += ".skt";
	return name;
}




BOOLEAN SketchGetSketchFile(RecordID rec_id, CString &fielddata)
{
	CString filename;
	CFileException e;
	CFile file;
//	char PC[57000];
//	char PC[78000];
	char* PC;
	char *PDA;
	int size;

	PDA = (char*) fielddata.GetBuffer(2440);

	filename = szUserPath + "Sketch\\" + SketchGetSketchFileName(rec_id);

	if(!ExistFile(filename))
		return TRUE;

	try
	{
	  if(!file.Open( filename, CFile::modeRead | CFile::typeBinary, &e ))
	  {
		TRACE("\nCannot create file %s ", filename);
		fielddata.ReleaseBuffer(0);
		return TRUE;
	  } 
	}
	catch( CFileException *f)
	{
		TRACE("\nCannot create file %s ", filename);
		fielddata.ReleaseBuffer(0);
		f->Delete();
		return TRUE;
	}

	size = file.GetLength();
	PC = (char*)malloc(size);

	try
	{
		file.Read(PC, size);
//		file.Read(PC, 56174);
	}
	catch (CFileException *ee)
	{
		ee->Delete();
		fielddata.ReleaseBuffer(0);
		file.Close();
		return TRUE;
	}

	SketchPCToPDA(PC, PDA);

	free(PC);
	fielddata.ReleaseBuffer(2440);

	return FALSE;

}



BOOLEAN SketchCreateSketchFile(RecordID rec_id, CString &fielddata)
{
// return TRUE if OK, else FALSE
	// create a sketch file in dir Sketch\ with rec_id as name
	CString filename;
	CFileException e;
	CFile file;
	char PC[59000];

	filename = szUserPath + "Sketch\\" + SketchGetSketchFileName(rec_id);


	try
	{
		if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
	  {
		TRACE("\nCannot create file %s ", filename);
	  } 
	}
	catch( CFileException f )
	{
		TRACE("\nCannot create file %s ", filename);
		return TRUE;
	}


	int x = fielddata.GetLength();

	char *PDA = fielddata.GetBuffer(2440);
  
	SketchPDAToPC(PDA, PC);

	try
	{
		file.WriteHuge(PC, 56174);
	}

    catch (CFileException g )
	{
		TRACE("\nUnable to write data to %s ", filename);
		fielddata.ReleaseBuffer(2440);
		return TRUE;
	}

	file.Close();
	fielddata.ReleaseBuffer(2440);
	return FALSE;
}

BOOLEAN SketchExistFile(RecordID rec_id)
{
	CString fn;
	fn = szUserFullPath + "Sketch\\" + SketchGetSketchFileName(rec_id);
	return ExistFile(fn);
}


BOOL SketchDeleteExternFile(RecordID rec_id)
{
	CString filename;

	filename = szUserFullPath + "sketch\\";
	filename += SketchGetSketchFileName(rec_id);
	if (DeleteFile(filename) == 0)
	{
		TRACE("\nUnable to delete file %s ", filename);
		return FALSE;
	}
	else
		return TRUE;
}



BOOL SketchAddRecord(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	
	if (CatRec(rec_id))
		return SketchAddCat(dbCurrent, rec_id, rec_header, rec_content);

	szSql = "delete from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += SKTDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Notes",(LPCTSTR)(fielddata));

	PDADataGetField(1, rec_content, &fielddata);  // sketch data
	if(fielddata.GetLength() > 5)  // has data
	{
		if(!SketchCreateSketchFile(rec_id, fielddata))
		{
			rsCurrent->SetFieldValue("Filename",(LPCTSTR)SketchGetSketchFileName(rec_id));
		}
		else
			rsCurrent->SetFieldValue("Filename",(LPCTSTR)"");
	}
	else
		rsCurrent->SetFieldValue("Filename",(LPCTSTR)"");


	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	nPDA2PC++;
	return FALSE;
}


BOOL SketchMoveRecord(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs;
	COleVariant fielddata;
	CString szStr;
	int i;
	
	if (CatRec(rec_id))
		return SketchMoveCat(src_db, dest_db, rec_id);

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += SKTDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	for(i=5;i<7;i++)
	{
		fielddata = rs->GetFieldValue(i);
		if ((LPCSTR) fielddata.bstrVal)
			szStr = ((LPCSTR) fielddata.bstrVal);
		rsCurrent->SetFieldValue(i,(LPCTSTR)szStr);
	}

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;
	

	rs->Close();

	szSql = "delete from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		delete rs;
		return TRUE;
	}

	delete rs;

	return FALSE;
}


BOOL SketchAddCat(CDaoDatabase *src_db, RecordID rec_id, RecordHeader* rec_header, CString *rec_content)
{
	CString szSql;
	CString fielddata;
	int i;

	szSql = "delete from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nError exe SQl %s ", szSql);
	}


	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(src_db);

	szSql = "Select * from ";
	szSql += SKTDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();
	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)_date322DB2(rec_header->modi_date));
	rsCurrent->SetFieldValue("Category",(LPCTSTR)Str_ul( (unsigned int) (rec_header->cat)));
	if(IsRecSecret(rec_header))
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Secret",(LPCTSTR)"FALSE");

	if(IsRecLock(rec_header))
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"TRUE");
	else
		rsCurrent->SetFieldValue("Lock",(LPCTSTR)"FALSE");

	PDADataGetField(0, rec_content, &fielddata);
	RemoveNULL(&fielddata);
	rsCurrent->SetFieldValue("Notes",(LPCTSTR)(fielddata));

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;

	return FALSE;
}



BOOL SketchMoveCat(CDaoDatabase *src_db, CDaoDatabase *dest_db, RecordID rec_id)
{
	CString szSql;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	CString szStr;
	int i;

/* if the record is in dest, delete it */
	szSql = "delete from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);


	try
	{
		dest_db->Execute(szSql);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nError in SQL statement: %s", szSql);
	}

	rs = new CDaoRecordset(src_db);
	szSql = "select * from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);
	
	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		return TRUE;
	}

	CDaoRecordset* rsCurrent = NULL;
	rsCurrent = new CDaoRecordset(dest_db);

	szSql = "Select * from ";
	szSql += SKTDB;

	try
	{
		rsCurrent->Open(dbOpenDynaset, szSql , 0);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\ncannot exe SQL statement %s ", szSql);
		return TRUE;
	}

	rsCurrent->AddNew();

	rsCurrent->SetFieldValue("RecordID",(LPCTSTR)Str_ul(rec_id));

	fielddata = rs->GetFieldValue("ModifyDate");	// Modifydata 
	szStr = COleDateTime(fielddata).Format("%b %d %Y %H:%M:%S");
	rsCurrent->SetFieldValue("ModifyDate",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Category");	// category 
	szStr.Format("%d", fielddata.lVal);
	rsCurrent->SetFieldValue("Category",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Secret");	// secret 
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Secret",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Lock");	// lock
	szStr = (fielddata.boolVal == 0) ? "FALSE" : "TRUE";
	rsCurrent->SetFieldValue("Lock",(LPCTSTR)szStr);

	fielddata = rs->GetFieldValue("Notes");
	if ((LPCSTR) fielddata.bstrVal)
		szStr += ((LPCSTR) fielddata.bstrVal);
	rsCurrent->SetFieldValue("Notes",(LPCTSTR)szStr);

	rsCurrent->Update();
	rsCurrent->Close();
	delete rsCurrent;


	rs->Close();

	szSql = "delete from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	try
	{
		 src_db->Execute(szSql);
	}
	catch(CDaoException *e)
	{
		e->Delete();
		TRACE("\nerror exe %s", szSql);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

 	if(rs)
	{
		delete rs;
		rs = NULL;
	}

	return FALSE;
}

void SketchDeletePCRecord(CDaoDatabase *db, RecordID rec_id)
{
//	SketchDeleteExternFile(rec_id);
	PCDeleteRecord(db, SKTDB, rec_id);
}

void SketchDeletePCRecord(CDaoDatabase *db1, CDaoDatabase *db2, RecordID rec_id)
{
//	SketchDeleteExternFile(rec_id);
	PCDeleteRecord(db1, SKTDB, rec_id);
	PCDeleteRecord(db2, SKTDB, rec_id);
}


BOOL SketchArchivePDAOvrPC(DatabaseID dbid)
{
	int total_rec, i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;

	/* get all archive record header in PDA */
	total_rec = 0;
	SyncRecArcInfoReq(dbid, &total_rec, (RecStruct**)&record);

	if(total_rec > 10000)
		return 1;

	for(i=0;i<total_rec;i++)
	{
		rec_content.Empty();
		SyncReadRec(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id, (char*) &record[i].rec_header, &rec_content);
//		if(DBIsExistRecord(dbArchive, EMSGDB, ((RecordHeader)(record[i].rec_header)).rec_id))
		{	/* record exists in PC */
			/* Move the record to recycle database, then add the new record */
//			SketchMoveRecord(dbArchive, dbRecycle, ((RecordHeader)(record[i].rec_header)).rec_id);
			SketchDeletePCRecord(dbRecycle, dbCurrent, ((RecordHeader)(record[i].rec_header)).rec_id);
		}
		SketchAddRecord(dbArchive, ((RecordHeader)(record[i].rec_header)).rec_id, &record[i].rec_header, &rec_content);
		if( ((RecordHeader)(record[i].rec_header)).attribute & 0x04)  // arch, not cat
		{
		  SyncIdleMode();
		  SyncDBUpMode();
		  PDADeleteRecord(dbid, ((RecordHeader*)&(record[i].rec_header))->rec_id);
		  SyncIdleMode();
		  SyncDBEnqMode();
		}
		m_DispDlg->UpdateRemainDec();
	}

	if(record)
	   free(record);

	return 0;
}


BOOL SketchArchivePCOvrPDA(DatabaseID dbid)
{ 
	return SketchArchivePDAOvrPC(dbid);
}


BOOL PDASketchAddRecord(CDaoDatabase *src_db, DatabaseID dbid, RecordID rec_id)
{
	CDaoRecordset *rs = NULL;
	CString szSql;
	CString content;
	CString fielddata;
	RecordHeader header;
	unsigned int size_array[8];
	unsigned int data32, data32_2, j;
	unsigned short byte_use;
	char *ptr;

//	return FALSE;

	szSql = "select * from ";
	szSql += SKTDB;
	szSql += " where RecordID = ";
	szSql += Str_ul(rec_id);

	rs = new CDaoRecordset(src_db);

	try
	{
		rs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", szSql);
		delete rs;
		return TRUE;
	}

	if(!rs->IsBOF())
	{

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime((rs->GetFieldValue(1)))));
	header.total_field = 2;
	header.cat = (unsigned char) (rs->GetFieldValue(2)).lVal;	/* category */
    header.attribute = 0;

	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));

	// Notes
	fielddata = (LPCSTR) (rs->GetFieldValue("Notes")).bstrVal;
	AddNULL(&fielddata);
	size_array[0] = fielddata.GetLength();
	data32_2 = size_array[0];
	EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;

	// BMP
	fielddata.Empty();
	if(SketchGetSketchFile(rec_id, fielddata))
	{
		goto term;
	}
	size_array[1] = fielddata.GetLength();
	data32_2 = size_array[1];
    EnFieldSize(data32, data32_2, byte_use);
	ptr = (char*) &data32;
	for(j=0;j<byte_use;j++)
	  content += ptr[j];
	content += fielddata;
	
	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

	SyncRecAdd(dbid, rec_id, 2, size_array, &header, &content);
	}

	nPC2PDA++;
term:
	if(rs)
	{
		rs->Close();
		delete rs;
	}

	return FALSE;
}


BOOL SketchGetLastSyncRecID(RecordID *last_pda_recid, RecordID *last_pc_recid)
{
	CString sqlst;
	CDaoRecordset *rs = NULL;
	COleVariant fielddata;
	int pc_default;

	pc_default = 0x7fffffff;
	if(station_num == 2)
		pc_default = 0x5fffffff;
	
	*last_pda_recid = 0;
	*last_pc_recid = pc_default;

	sqlst = "select LastPC, LastPDA from ApplicationDB where DatabaseName = '";
	sqlst += SKTDB;
	sqlst += "'";

	rs = new CDaoRecordset(dbAppDB);

	try
	{
		rs->Open(dbOpenSnapshot, sqlst, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		TRACE("\nCannot exe statement: %s ", sqlst);
		if(rs)
		{
			delete rs;
			rs = NULL;
		}
		return TRUE;
	}

	if(!rs->IsBOF())
	{
		fielddata = rs->GetFieldValue(0);	/* Last PC */
		*last_pc_recid = fielddata.lVal;
		fielddata = rs->GetFieldValue(1);	/* Last PDA */
		*last_pda_recid = fielddata.lVal;
	}

	if(rs)
		delete rs;

	return TRUE;
}

