#include "stdafx.h"
#include "VPSync.h"
#include "SyncDispDlg.h"
#include "VPSyncDlg.h"
#include "PortCtrl.h"
#include "resource.h"
#include "SyncDB.h"
#include "SyncFx.h"
#include "All_DB.h"
#include "ErrMsgDlg.h"
#include "sysetup.h"
#include <direct.h>
#include <time.h>

extern CString szUserPath;
extern CString pda_sync_id;

CString SysetupGetFileName(RecordID rec_id)
{
	CString name;

	name.Format("%d", rec_id);
	name.MakeUpper();
	name += ".sup";
	return name;
}


int CSyncDispDlg::CountSysFileinPC()
{
	CString path = szUserPath + "Vox\\";
	char root_path[100];
	CFile file;
	CFileException e;
	CString filename;


	_getdcwd (_getdrive(), root_path, 100);
	
	if ( _chdir(path))
	{
	   return 0;
	}

	m_List.ResetContent();
	m_List.Dir(0, "*.sup");

	_chdir (root_path);

	return m_List.GetCount();

}

void SyncWriteProfile(DatabaseID dbid, RecordID rec_id, unsigned char cat, int num_field, unsigned int size_array[], CString &fielddata)
{
	CString szSql;
	CString content;
	RecordHeader header;
	unsigned int data32, data32_2, i, j, pos;
	unsigned short byte_use;
	char *ptr;

	/* encode the record into PDA data format */

	header.rec_id = rec_id;
	header.modi_date = _rtm2date32(DBDate2RTM(COleDateTime::GetCurrentTime()));
	header.total_field = num_field;
	header.cat = cat;
    header.attribute = 0;

/*
	if((rs->GetFieldValue(3)).boolVal)
		SetRecSecret(((RecordHeader*)&header));
	if((rs->GetFieldValue(4)).boolVal)
		SetRecLock(((RecordHeader*)&header));
*/
	pos = 0;
	for(i=0;i<num_field;i++)
	{
		data32_2 = size_array[i];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			content += ptr[j];
		for(j=0;j<size_array[i];j++)
			content += (char) fielddata.GetAt(pos+j);
		pos += size_array[i];
	}

	header.size = content.GetLength();
	if((header.size) % 4)
		header.size += 4 - (header.size) % 4;

//	SyncRecAddCat(dbid, rec_id, num_field, size_array, &header, &content);
	SyncRecDel(dbid, rec_id);
	SyncRecAdd(dbid, rec_id, num_field, size_array, &header, &content);

	return;
}


int PDAAddSysRecord(DatabaseID dbid, RecordID rec_id)
{
	CString filename;
	CFile file;
	int i, j;
	int datalen;
	CString path = szUserPath + "Vox\\";
	RecordHeader header, *pRecHeader;
	CString content, fielddata, filecontent;
	CFileException e;
	char data[2000];
	unsigned int size_array[30];
	unsigned int data32, data32_2;
	unsigned short byte_use;
	char *ptr;
		
  //  filename = szUserPath + "Vox\\" + SysetupGetFileName(rec_id);
	  filename = SysetupGetFileName(rec_id);
	if(ExistFile(filename))
	{
	  PDADeleteRecord(dbid, rec_id);
	  CHKTERM;
  	  try
	  {
        if( !file.Open( filename, CFile::modeRead|CFile::typeBinary, &e ) )
		{
		    TRACE("\nCannot read file %s ", filename);
			return 1;
		}  
	  }
	  catch( CFileException f )
	  {
		TRACE("\nCannot read file %s ", filename);
		return 1;
	  }

	  file.SeekToEnd();
	  file.SeekToBegin();
	  datalen = file.GetLength();
	  file.Read(data, datalen);

	  file.Close();

	  filecontent.Empty();
	  content.Empty();
	  for(j=sizeof(RecordHeader);j<datalen;j++)
		   filecontent += data[j];

	  pRecHeader = (RecordHeader*) data;

	  header = *pRecHeader;

	  for(i=0;i<pRecHeader->total_field;i++)
	  {
 	    size_array[i] = PDADataGetField(i, &filecontent, &fielddata);
		data32_2 = size_array[i];
		EnFieldSize(data32, data32_2, byte_use);
		ptr = (char*) &data32;
		for(j=0;j<byte_use;j++)
			  content += ptr[j];
		content += fielddata;
		fielddata.Empty();
	  }

		header.size = content.GetLength();
		if((header.size) % 4)
			header.size += 4 - (header.size) % 4;

		SyncRecAdd(dbid, rec_id, pRecHeader->total_field , size_array, &header, &content);
		CHKTERM
	}

	return 0;
terminate:
	return 1;

}

int CSyncDispDlg::ReadPDASysSettings()
{
	CString rec_content;
	CString dbheader;
	DatabaseID dbid;
	int total_rec;
	RecStruct *record = NULL;
	CFileException e;
	char *data;
	int len;
	int i, j;
	CString CompanyName, Tel;

	CString szSql;
	CString content;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;

	if(total_rec > 10000)
	{
		if(record)
			free(record);
		return 1;
	}


	for(i=0;i<total_rec;i++)
	{
		if(record[i].rec_header.rec_id == SYS_PASSWORD)
			continue;

		if(SyncReadRec(dbid, record[i].rec_header.rec_id, (char*) &record[i].rec_header, &rec_content) == 0)
		{
			CFile file;
			CString filename;
			
			filename = szUserPath + "Vox\\" + SysetupGetFileName(record[i].rec_header.rec_id);
			DeleteFile(filename);

			try
			{
				if( !file.Open( filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, &e ) )
				{
					TRACE("\nCannot create file %s ", filename);
				} 
			}
			catch( CFileException f )
			{
				TRACE("\nCannot create file %s ", filename);
				continue ;
			}


			for(j=sizeof(RecordHeader) -1; j>=0;j--)
				rec_content = *(char*)((char*)&(record[i].rec_header) + j) + rec_content;
			//file.WriteHuge((void*) &(record[i].rec_header), sizeof(RecordHeader));

			len = rec_content.GetLength();

			if(len <=sizeof(RecordHeader) + 1)
				continue;

			if(record[i].rec_header.rec_id == SYS_OWNINFO)
			{
				content = rec_content.Right(rec_content.GetLength() - RECHEADER_SIZE);
				PDADataGetField(3, &content, &Tel);
				RemoveNULL(&Tel);
				PDADataGetField(4, &content, &CompanyName);
				RemoveNULL(&CompanyName);
				szSql = "update UserData set Tel = '";
				szSql += ExamSql(Tel);
				szSql += "', Company = '";
				szSql += ExamSql(CompanyName);
				szSql += "' where UserName = '";
				szSql += ExamSql(m_Username);
				szSql += "'";

				try
				{
					dbProfile->Execute(szSql);
				}
				catch (CException *e)
				{
					e->Delete();
					TRACE("\nCannot exe %s ", szSql);
				}
	
			}
			
			data = rec_content.GetBuffer(len);
			file.WriteHuge(data, len);
			file.Close();
			rec_content.ReleaseBuffer(len);
		}
		CHKTERM;
	}

	if(record)
		free(record);
	return 0;
terminate:
	if(record)
		free(record);
	return 1;
}


int CSyncDispDlg::WritePDASysSettings()
{

	DatabaseID dbid;
	int total_rec;
	int i;
	CString dbheader;
	CString rec_content;
	RecStruct *record = NULL;
	CString filename;
	CString path = szUserPath + "Vox\\";
	char root_path[100];
	CString szSql;
	CDaoRecordset *pRs= NULL;
	unsigned int size_array[5];
	CString Name1st, Name2nd, ContactTel, CompanyName, content;



	_getdcwd (_getdrive(), root_path, 100);

	SyncIdleMode();

	CHKTERM;

	SyncDBEnqMode();

	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid */
		return 1;

	total_rec = 0;

	/* get all record header in PDA */
	if (SyncRecInfoReq(dbid, &total_rec, (RecStruct**)&record))
		return 1;		// error

	CHKTERM;

	if(total_rec > 10000)
		return 1;

	if(CountSysFileinPC() == 0)  /* not system info yet */
		return 0;

	
	if ( _chdir(path))
	{
	   return 1;
	}


	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	for(i=0;i<total_rec;i++)
	{
		if( (record[i].rec_header.rec_id == SYS_OWNINFO) ||
			(record[i].rec_header.rec_id == SYS_SYSINFO) ||
			(record[i].rec_header.rec_id == SYS_MODEM) 	||
			(record[i].rec_header.rec_id == SYS_PASSWORD) ||
			(record[i].rec_header.rec_id == SYS_PDA_USERID ))
			continue;

	    PDAAddSysRecord(dbid, record[i].rec_header.rec_id);
		CHKTERM;
	}
///////////////////////////////////////////////////////
	


	szSql = "select * from UserData where UserName = '";
 	szSql += ExamSql(m_Username );
	szSql += "'";

	pRs = new CDaoRecordset(dbProfile);
	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		delete pRs;
		pRs = NULL;
	}


	if(pRs)
		if(!pRs->IsBOF())
		{
			Name1st = (LPSTR) pRs->GetFieldValue("Name1st").bstrVal;
			Name2nd = (LPSTR) pRs->GetFieldValue("Name2nd").bstrVal;
			ContactTel = (LPSTR) pRs->GetFieldValue("Tel").bstrVal;
			CompanyName = (LPSTR) pRs->GetFieldValue("Company").bstrVal;
		}

	if(pRs)
	{
		delete pRs;
		pRs = NULL;
	}

	AddNULL(&Name1st);
	AddNULL(&Name2nd);
	
    AddNULL(&ContactTel);
	AddNULL(&CompanyName);

	size_array[0] = 1;
	size_array[1] = Name1st.GetLength();
	size_array[2] = Name2nd.GetLength();
	size_array[3] = ContactTel.GetLength();
	size_array[4] = CompanyName.GetLength();

	content = (CString) (char) (SYS_OWNINFO - FIRST_REC_ID) + Name1st + Name2nd + ContactTel + CompanyName;

	SyncWriteProfile(dbid, SYS_OWNINFO, 0, 5, size_array, content);


	if(record)
		free(record);
	record = NULL;

	_chdir (root_path);

	if(pRs)
		delete pRs;
	return 0;

terminate:
	_chdir (root_path);
	if(record)
		free(record);
	if(pRs)
		delete pRs;


	return 1;

}


CString SyncGetPDAID()
{
	CString rec_content;
	CString dbheader;
	CString data;
	DatabaseID dbid;
	int total_rec;
	RecordHeader rec_header;
	CFileException e;
	int len;
	int i, j;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	if(SyncReadRec(dbid, SYS_PDA_USERID, (char*) &rec_header, &rec_content) == 0)
	{
		PDADataGetField(1, &rec_content, &data);
	}

	SyncIdleMode();
terminate:
	return data;
}

CString SyncSetPDAID(CString username)
{
	CString pdaid;
	CString szSql;
	DatabaseID dbid;
	CString content;
	unsigned int size_array[5];
	CString dbheader;

	CDaoRecordset *pRs=NULL;
	pRs = new CDaoRecordset(dbProfile);

	if(pda_sync_id.IsEmpty()) // use the old syncid if there is one.
	{
		szSql = "select * from UserData where Username = '";
		szSql += ExamSql(username);
		szSql += "'";
		try
		{
			pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
		}
		catch (CDaoException *e)
		{
			e->Delete();
			delete pRs;
			pRs = NULL;
		}
		if(!pRs->IsBOF())
		{
			pda_sync_id = (CString)pRs->GetFieldValue("SyncID").pbVal;
		}
		pRs->Close();
		delete pRs;
		pRs = NULL;
	}

retry:

	if(pda_sync_id.IsEmpty())
	{
//	srand( (unsigned)time( NULL ) );
	srand( (unsigned)(COleDateTime::GetCurrentTime().GetSecond() + COleDateTime::GetCurrentTime().GetMinute()));
	pdaid.Empty();
	for(int i=0;i<20;i++)
		pdaid += (rand() % ('Z' - '1')  + '1');
	}
	else
		pdaid = pda_sync_id;

/*	pRs = new CDaoRecordset(dbProfile);
	szSql = "select 1 from UserData where SyncID = '";
	szSql += ExamSql(pdaid);
//	szSql += "' and Username = '";
//	szSql += ExamSql(username);
	szSql += "'";

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		delete pRs;
		pRs = NULL;
	}

	if(pRs)
	{
		if(!pRs->IsBOF())
		{
			delete pRs;
			pRs = NULL;
			pda_sync_id.Empty();
			goto retry;
		}
	}
	else
	{
			pda_sync_id.Empty();
			goto retry;

	}

	if(pRs)
	{
		delete pRs;
		pRs = NULL;
	}
*/
//	SyncIdleMode();
//	SyncDBEnqMode();


	size_array[0] = 1;
	size_array[1] = pdaid.GetLength();

	content = (CString) (char) (SYS_PDA_USERID - FIRST_REC_ID) + pdaid;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)
	{
		pdaid.Empty();
		return pdaid;
	}
	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	SyncWriteProfile(dbid, SYS_PDA_USERID, 0, 2, size_array, content);
	CHKTERM;


	szSql = "update UserData set SyncID = '";
	szSql += ExamSql(pdaid);
	szSql += "' where UserName = '";
	szSql += ExamSql(username);
	szSql += "'";

	try
	{
		dbProfile->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\ncannot exe %s ", szSql);
	}
	
	return pdaid;

terminate:
	pdaid.Empty();
	return pdaid;
}

CString SyncGetStationNo()
{
	CString rec_content;
	CString dbheader;
	CString data;
	DatabaseID dbid;
	int total_rec;
	RecordHeader rec_header;
	CFileException e;
	int len;
	int i, j;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;

	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)   /* get dbid of phone book */
		return 1;

	if(SyncReadRec(dbid, SYS_PC_STATION, (char*) &rec_header, &rec_content) == 0)
	{
		PDADataGetField(1, &rec_content, &data);
	}

	SyncIdleMode();
terminate:
	return data;
}

CString SyncSetStationNo(CString username,CString number)
{
	CString szSql;
	DatabaseID dbid;
	CString content;
	unsigned int size_array[5];
	CString dbheader;
	CString sznumber;

retry:

	sznumber = number;
	size_array[0] = 1;
	size_array[1] = sznumber.GetLength();

	content = (CString) (char) (SYS_PC_STATION - FIRST_REC_ID) + sznumber;

	SyncIdleMode();
	CHKTERM;
	SyncDBEnqMode();
	CHKTERM;
	/* send all record header data from PDA */
	if (SyncDBInfo(SYSDB, &dbid, &dbheader) != 0)
	{
		sznumber.Empty();
		return sznumber;
	}
	SyncIdleMode();
	CHKTERM;
	SyncDBUpMode();
	CHKTERM;
	SyncWriteProfile(dbid, SYS_PC_STATION, 0, 2, size_array, content);
	CHKTERM;


	szSql = "update UserData set StationNo = '";
	szSql += sznumber;
	szSql += "' where UserName = '";
	szSql += ExamSql(username);
	szSql += "'";

	try
	{
		dbProfile->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
		TRACE("\ncannot exe %s ", szSql);
	}
	
	return sznumber;

terminate:
	return sznumber;
}

BOOL IsUserExist(CString username, CString pdaid)
{
	CString szSql;
	CDaoRecordset *pRs = NULL;

	RemoveNULL(&pdaid);

	if(pdaid.GetLength() > 3)
	{
	szSql = "update UserData set SyncID = '";
	szSql += ExamSql(pdaid);
	szSql += "' where UserName = '";
	szSql += ExamSql(username);
	szSql += "' and (SyncID = '' or SyncID = NULL)";

	try
	{
		dbProfile->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
	}


	szSql = "select 1 from UserData where UserName = '";
	szSql += ExamSql(username);
	szSql += "' and SyncID = '";
	szSql += ExamSql(pdaid);
	szSql += "'";

	pRs = new CDaoRecordset(dbProfile);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		delete pRs;
		pRs = NULL;
		return FALSE;
	}

	if(pRs)
		if(!pRs->IsBOF())
		{
			delete pRs;
			pRs = NULL;
			return TRUE;
		}

	if(pRs)
	{
		delete pRs;
		pRs = NULL;
	}

	return FALSE;	

}

BOOL IsUserExist2(CString username, CString pdaid)
{
	CString szSql;
	CDaoRecordset *pRs = NULL;

	RemoveNULL(&pdaid);
/*
	if(pdaid.GetLength() > 3)
	{
	szSql = "update UserData set SyncID = '";
	szSql += ExamSql(pdaid);
	szSql += "' where UserName = '";
	szSql += ExamSql(username);
	szSql += "' and (SyncID = '' or SyncID = NULL)";

	try
	{
		dbProfile->Execute(szSql);
	}
	catch(CException *e)
	{
		e->Delete();
	}
	}
*/
//	szSql = "delete * from UserData";
//	szSql += " where UserName = '";
//	szSql += ExamSql(username);
//	szSql += "' and (SyncID = '' or SyncID = NULL)";
//
//	try
//	{
//		dbProfile->Execute(szSql);
//	}
//	catch(CException *e)
//	{
//		e->Delete();
//	}

	szSql = "select 1 from UserData where UserName = '";
	szSql += ExamSql(username);
	szSql += "' and SyncID = '";
	szSql += ExamSql(pdaid);
	szSql += "'";

	pRs = new CDaoRecordset(dbProfile);

	try
	{
		pRs->Open(dbOpenSnapshot, szSql, dbReadOnly);
	}
	catch (CDaoException *e)
	{
		e->Delete();
		delete pRs;
		pRs = NULL;
		return FALSE;
	}

	if(pRs)
		if(!pRs->IsBOF())
		{
			delete pRs;
			pRs = NULL;
			return TRUE;
		}

	if(pRs)
	{
		delete pRs;
		pRs = NULL;
	}

	return FALSE;	

}