/*
 * Decompiled with CFR 0.152.
 */
package jpalmdb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jpalmdb.PDBRecord;

public class PDBFile {
    private List<PDBRecord> records = new ArrayList<PDBRecord>();
    private final byte[] typeandcreator;
    private final Date created;
    private final Date modified;
    private final Date backedUp;
    private final String pdbName;
    private final short version;

    public short getVersion() {
        return this.version;
    }

    public String getPDBName() {
        return this.pdbName;
    }

    public String getTypeAndCreator() throws IOException {
        return new String(this.typeandcreator, "ISO-8859-1");
    }

    public PDBFile(String string, byte[] byArray, short s) {
        this(string, byArray, s, null, null, null);
    }

    public PDBFile(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public PDBFile(File file) throws IOException {
        this(new FileInputStream(file), (int)file.length());
    }

    public PDBFile(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[32];
        dataInputStream.readFully(byArray);
        int n4 = 32;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            if (byArray[n3] != 0) continue;
            n4 = n3;
            break;
        }
        this.pdbName = new String(byArray, 0, n4, "ISO-8859-1");
        short s = dataInputStream.readShort();
        if (s != 8) {
            throw new IOException("Unsupported DB format");
        }
        this.version = dataInputStream.readShort();
        n4 = dataInputStream.readInt();
        this.created = new Date(n4 * 1000);
        n4 = dataInputStream.readInt();
        this.modified = new Date(n4 * 1000);
        n4 = dataInputStream.readInt();
        this.backedUp = new Date(n4 * 1000);
        n4 = dataInputStream.readInt();
        if (n4 != 0) {
            throw new IOException("Unsupported DB format");
        }
        n4 = dataInputStream.readInt();
        if (n4 != 0) {
            throw new IOException("Unsupported DB format");
        }
        n4 = dataInputStream.readInt();
        if (n4 != 0) {
            throw new IOException("Unsupported DB format");
        }
        this.typeandcreator = new byte[8];
        dataInputStream.readFully(this.typeandcreator);
        n4 = dataInputStream.readInt();
        if (n4 != 0) {
            throw new IOException("Unsupported DB format");
        }
        n4 = dataInputStream.readInt();
        if (n4 != 0) {
            throw new IOException("Unsupported DB format");
        }
        n3 = dataInputStream.readShort();
        int n5 = 78;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = dataInputStream.readInt();
            n4 = dataInputStream.readInt();
            if (n4 != 0) {
                throw new IOException("Unsupported DB format");
            }
            n5 += 8;
        }
        while (n5 < nArray[0]) {
            ++n5;
            dataInputStream.readByte();
        }
        if (n5 > nArray[0]) {
            throw new IOException("Unsupported DB format");
        }
        System.out.println("Record count: " + n3);
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = n2 < n3 - 1 ? nArray[n2 + 1] : n;
            byte[] byArray2 = new byte[n6 - nArray[n2]];
            dataInputStream.readFully(byArray2);
            this.addRecord(byArray2);
            System.out.println("Loaded record of " + byArray2.length + " bytes.");
        }
        if (dataInputStream.read() != -1) {
            throw new IllegalArgumentException("Incorrect length");
        }
        dataInputStream.close();
    }

    public PDBFile(String string, byte[] byArray, short s, Date date, Date date2, Date date3) {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Invalid Type and Creator ID");
        }
        if (string.length() > 31) {
            throw new IllegalArgumentException("PDB name too long");
        }
        Date date4 = new Date();
        if (date == null) {
            date = date4;
        }
        if (date2 == null) {
            date2 = date4;
        }
        if (date3 == null) {
            date3 = new Date(0L);
        }
        this.pdbName = string;
        this.typeandcreator = byArray;
        this.version = s;
        this.created = date;
        this.modified = date2;
        this.backedUp = date3;
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public PDBRecord getRecord(int n) {
        return this.records.get(n);
    }

    public void addRecord(PDBRecord pDBRecord) {
        this.records.add(pDBRecord);
    }

    public void addRecord(byte[] byArray) {
        this.addRecord(new PDBRecord(byArray));
    }

    public void addRecords(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < byArray.length - n; n2 += n) {
            this.addRecord(new PDBRecord(byArray, n2, n));
        }
        this.addRecord(new PDBRecord(byArray, n2, byArray.length - n2));
    }

    public byte[] generate() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.generate(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void generate(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = this.pdbName.getBytes("ISO-8859-1");
        dataOutputStream.write(byArray);
        dataOutputStream.write(new byte[32 - byArray.length]);
        dataOutputStream.writeShort(8);
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeInt((int)(this.created.getTime() / 1000L));
        dataOutputStream.writeInt((int)(this.modified.getTime() / 1000L));
        dataOutputStream.writeInt((int)(this.backedUp.getTime() / 1000L));
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.write(this.typeandcreator);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeShort(this.records.size());
        int n = 78 + this.records.size() * 8;
        for (PDBRecord pDBRecord : this.records) {
            n = pDBRecord.setOffset(n);
            pDBRecord.writeHeader(dataOutputStream);
        }
        for (PDBRecord pDBRecord : this.records) {
            pDBRecord.writeData(dataOutputStream);
        }
        dataOutputStream.close();
    }
}

