/*
 * Decompiled with CFR 0.152.
 */
package jpalmdb.bitmap;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpalmdb.bitmap.BitmapFormat;

public class BitmapEncoder {
    private final BitmapFormat format;

    public BitmapEncoder(BitmapFormat bitmapFormat) {
        this.format = bitmapFormat;
    }

    public byte[] encode(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(bufferedImage, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeShort(bufferedImage.getWidth());
        dataOutputStream.writeShort(bufferedImage.getHeight());
        dataOutputStream.writeShort(this.format.getRowBytes((short)bufferedImage.getWidth()));
        dataOutputStream.writeShort(this.format.getBitmapFlags());
        dataOutputStream.writeByte(this.format.getBitDepth());
        dataOutputStream.writeByte(this.format.getVersion());
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            this.format.resetRow((short)bufferedImage.getWidth());
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                this.format.addPixel(new Color(bufferedImage.getRGB(j, i)));
            }
            byte[] byArray = this.format.getRow();
            if (byArray.length != this.format.getRowBytes((short)bufferedImage.getWidth())) {
                throw new RuntimeException();
            }
            dataOutputStream.write(byArray);
        }
        dataOutputStream.close();
    }

    public BufferedImage decode(byte[] byArray) throws IOException {
        return this.decode(new ByteArrayInputStream(byArray));
    }

    private BufferedImage decode(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readShort();
        int n2 = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        if (s != this.format.getRowBytes((short)n)) {
            throw new IOException("Unsupported format");
        }
        if (dataInputStream.readShort() != this.format.getBitmapFlags()) {
            throw new IOException("Unsupported format");
        }
        if (dataInputStream.readByte() != this.format.getBitDepth()) {
            throw new IOException("Unsupported format");
        }
        if (dataInputStream.readByte() != this.format.getVersion()) {
            throw new IOException("Unsupported format");
        }
        if (dataInputStream.readShort() != 0) {
            throw new IOException("Unsupported format");
        }
        if (dataInputStream.readShort() != 0) {
            throw new IOException("Unsupported format");
        }
        if (dataInputStream.readShort() != 0) {
            throw new IOException("Unsupported format");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        byte[] byArray = new byte[s];
        for (int i = 0; i < n2; ++i) {
            dataInputStream.readFully(byArray);
            this.format.setRow(byArray, (short)n);
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, this.format.getPixel().getRGB());
            }
        }
        if (dataInputStream.read() != -1) {
            throw new IOException("Unsupported format");
        }
        dataInputStream.close();
        return bufferedImage;
    }
}

