/*
 * Decompiled with CFR 0.152.
 */
package jpalmdb.bitmap;

import java.awt.Color;
import jpalmdb.bitmap.AbstractBitmapFormat;

public class ColorBitmapFormat
extends AbstractBitmapFormat {
    public ColorBitmapFormat() {
        super((byte)1, (byte)16);
    }

    public short getRowBytes(short s) {
        return (short)(s * 2);
    }

    public void addPixel(Color color) {
        if (this.offset >= this.rowwidth) {
            throw new IllegalStateException();
        }
        int n = this.offset * 2;
        int n2 = color.getRed() >> 3 << 11 | color.getGreen() >> 2 << 5 | color.getBlue() >> 3 << 0;
        this.row[n] = (byte)(n2 / 256);
        this.row[n + 1] = (byte)(n2 % 256);
        ++this.offset;
    }

    public Color getPixel() {
        int n = this.offset * 2;
        int n2 = (this.row[n] & 0xFF) * 256 + (this.row[n + 1] & 0xFF);
        ++this.offset;
        return new Color((n2 >> 11 & 0x1F) << 3, (n2 >> 5 & 0x3F) << 2, (n2 & 0x1F) << 3);
    }
}

